# كيفية الوصول للحلقات - How to Access Episodes

## ✅ الحلقات متوفرة الآن!
**Total Episodes Available:** 31,963+ episodes from 1,212+ series

---

## الطريقة 1: عبر الواجهة الرئيسية (Recommended)

### الخطوات:
1. افتح الواجهة: `http://15.204.231.210/VOD/`
2. اذهب إلى تبويب **"Series"** (المسلسلات)
3. اختر أي مسلسل من القائمة
4. انقر على المسلسل لفتح صفحة التفاصيل
5. ستجد قائمة **"Episodes"** مع جميع الحلقات المتاحة
6. كل حلقة لها زر **"Download"** للتحميل

### ملاحظة:
- المسلسلات التي تعرض عدد الحلقات (مثل: "135 episodes") لديها حلقات جاهزة
- المسلسلات التي تعرض "0 episodes" لا تحتوي على حلقات بعد

---

## الطريقة 2: عبر API مباشرة

### الحصول على حلقات مسلسل محدد:
```bash
# مثال: One Piece (ID: 6278)
curl "http://15.204.231.210/VOD/api/episodes?series_id=6278"

# مثال: اسمي فرح مدبلج (ID: 5281)
curl "http://15.204.231.210/VOD/api/episodes?series_id=5281"
```

### رابط التحميل المباشر:
كل حلقة لديها `stream_url` مثل:
```
http://hplayer.info:8080/series/3733676136/1519059670/359352.mp4
```

---

## أمثلة لمسلسلات مع حلقات كثيرة

### مسلسلات أنمي:
1. **One Piece** (ID: 6278) - 1,165 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6278
   ```

2. **Naruto** (ID: 6240) - 220 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6240
   ```

3. **Hunter x Hunter** (ID: 6231) - 148 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6231
   ```

### مسلسلات تركية مدبلجة:
1. **اسمي فرح مدبلج** (ID: 5281) - 135 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5281
   ```

2. **على مر الزمان مدبلج** (ID: 5604) - 311 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5604
   ```

3. **ثلاث اخوات مدبلج** (ID: 5398) - 249 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5398
   ```

4. **فاطمة غول مدبلج** (ID: 5262) - 190 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5262
   ```

### مسلسلات تركية مترجمة:
1. **زهور الدم مترجم** (ID: 5223) - 433 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5223
   ```

2. **قطاع الطرق لن يحكموا العالم مترجم** (ID: 6768) - 199 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6768
   ```

3. **قيامة ارطغرل مترجم** (ID: 5229) - 149 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5229
   ```

4. **التفاح الحرام مترجم** (ID: 5293) - 177 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5293
   ```

### مسلسلات أجنبية:
1. **Family Guy** (ID: 6323) - 438 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6323
   ```

2. **Law and Order SVU** (ID: 5190) - 577 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5190
   ```

3. **The Walking Dead** (ID: 5245) - 177 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5245
   ```

4. **Castle** (ID: 6831) - 173 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=6831
   ```

5. **The Blacklist** (ID: 5264) - 218 حلقة
   ```
   http://15.204.231.210/VOD/api/episodes?series_id=5264
   ```

---

## البحث عن مسلسل محدد

### البحث بالاسم:
```bash
# البحث عن "one piece"
curl "http://15.204.231.210/VOD/api/series?search=one+piece"

# البحث عن "فرح"
curl "http://15.204.231.210/VOD/api/series?search=فرح"

# البحث عن "naruto"
curl "http://15.204.231.210/VOD/api/series?search=naruto"
```

### الحصول على معلومات مسلسل:
```bash
# معلومات المسلسل + عدد الحلقات
curl "http://15.204.231.210/VOD/api/series/6278"
```

---

## تحميل حلقة محددة

### الخطوات:
1. احصل على قائمة الحلقات للمسلسل
2. اختر الحلقة المطلوبة
3. استخدم `stream_url` للتحميل

### مثال:
```bash
# الحصول على الحلقة الأولى من One Piece
curl "http://15.204.231.210/VOD/api/episodes?series_id=6278&limit=1"

# النتيجة ستحتوي على:
# "stream_url": "http://hplayer.info:8080/series/3733676136/1519059670/XXXXX.mp4"

# التحميل المباشر:
wget "http://hplayer.info:8080/series/3733676136/1519059670/XXXXX.mp4"
```

---

## المسلسلات التي لا تحتوي على حلقات

### النطاق المتأثر:
- المسلسلات الأحدث جداً (ID > 5700 تقريباً)
- مثال: Iljimae, When the Stars Gossip, احتمال، إلخ

### السبب:
- هذه المسلسلات **جديدة جداً**
- السيرفر المصدر (hplayer.info) لم يضف حلقاتها بعد
- السيرفر يعطي خطأ 404 عند محاولة جلب الحلقات

### الحل:
1. **اختر من المسلسلات المتوفرة** (1,212+ مسلسل متاح)
2. **أضف سيرفر مصدر آخر** قد يحتوي على هذه المسلسلات
3. **انتظر السيرفر** حتى يضيف الحلقات

---

## الإحصائيات الحالية

```
✅ إجمالي المسلسلات: 6,909
✅ مسلسلات مع حلقات: 1,212+
✅ إجمالي الحلقات: 31,963+
⏳ الاستيراد مستمر: ~60% مكتمل
```

---

## روابط مفيدة

### الواجهة الرئيسية:
```
http://15.204.231.210/VOD/
```

### APIs:
```
http://15.204.231.210/VOD/api/series
http://15.204.231.210/VOD/api/episodes
http://15.204.231.210/VOD/api/stats
http://15.204.231.210/VOD/api/categories
```

---

## ملاحظات تقنية

### صيغة الحلقات:
- جميع الحلقات بصيغة **MP4**
- روابط مباشرة للمشاهدة والتحميل
- يمكن فتحها في أي مشغل فيديو

### التحميل الجماعي:
يمكنك استخدام السكريبت التالي لتحميل موسم كامل:
```bash
# مثال: تحميل أول 10 حلقات من مسلسل
curl -s "http://15.204.231.210/VOD/api/episodes?series_id=6278&limit=10" | \
  jq -r '.[].stream_url' | \
  xargs -n 1 wget
```

---

## الدعم

للمزيد من المساعدة:
- راجع: `/var/www/html/VOD/SYSTEM_STATUS.md`
- راجع: `/var/www/html/VOD/README_EPISODES.md`
- راجع: `/var/www/html/VOD/TROUBLESHOOTING.md`
