# VOD System - Quick Start Guide 🎬

## Current Status ✅

```
✅ Movies:              17,553
✅ Series:               6,909
✅ Series with Episodes: 1,328+
✅ Total Episodes:      35,430+
✅ Categories:          78 (50 movies + 28 series)
```

**Status:** 🟢 Fully Operational | Episode import still running in background

---

## Quick Access

### Main Interface
```
http://15.204.231.210/VOD/
```

### Test Episode Access (Direct API)
```bash
# One Piece (1,165 episodes)
curl "http://15.204.231.210/VOD/api/episodes?series_id=6278&limit=5"

# اسمي فرح مدبلج (135 episodes)
curl "http://15.204.231.210/VOD/api/episodes?series_id=5281&limit=5"

# زهور الدم مترجم (433 episodes)
curl "http://15.204.231.210/VOD/api/episodes?series_id=5223&limit=5"
```

---

## Top 10 Series with Most Episodes

| # | Title | Episodes | Seasons | Rating |
|---|-------|----------|---------|--------|
| 1 | One Piece - ون بيس | 1,165 | 21 | 9.0 ⭐ |
| 2 | Law and Order SVU | 577 | 27 | 8.0 |
| 3 | Family Guy | 438 | 23 | 7.0 |
| 4 | زهور الدم مترجم | 433 | 3 | 8.0 |
| 5 | على مر الزمان مدبلج | 311 | 2 | 7.0 |
| 6 | ثلاث اخوات مدبلج | 249 | 2 | 8.0 |
| 7 | Blue Bloods | 224 | 11 | 8.0 |
| 8 | Naruto | 220 | 1 | 8.0 |
| 9 | The Blacklist | 218 | 10 | 8.0 |
| 10 | عودة مهند مدبلج | 213 | 2 | 7.0 |

---

## How to Download Episodes

### Method 1: Via Web Interface
1. Go to `http://15.204.231.210/VOD/`
2. Click on **"Series"** tab
3. Select any series with episodes
4. Click **"View Details"**
5. Browse episodes and click **"Download"**

### Method 2: Direct API Access
```bash
# Step 1: Get episode list
curl "http://15.204.231.210/VOD/api/episodes?series_id=6278" | jq '.[0]'

# Step 2: Download using stream_url
wget "http://hplayer.info:8080/series/3733676136/1519059670/XXXXX.mp4"
```

### Method 3: Bulk Download (All episodes)
```bash
# Download first 10 episodes of a series
curl -s "http://15.204.231.210/VOD/api/episodes?series_id=6278&limit=10" | \
  jq -r '.[].stream_url' | \
  xargs -n 1 wget
```

---

## Browse by Category

### Arabic Series (مسلسلات عربية)
```
http://15.204.231.210/VOD/api/series?category=63
```

### Turkish Dubbed (تركي مدبلج)
```
http://15.204.231.210/VOD/api/series?category=62
```

### Turkish Subtitled (تركي مترجم)
```
http://15.204.231.210/VOD/api/series?category=61
```

### Netflix Series
```
http://15.204.231.210/VOD/api/series?category=57
```

---

## Search Examples

```bash
# Search by title
curl "http://15.204.231.210/VOD/api/series?search=one+piece"
curl "http://15.204.231.210/VOD/api/series?search=naruto"
curl "http://15.204.231.210/VOD/api/series?search=فرح"

# Get newest series
curl "http://15.204.231.210/VOD/api/series/newest?limit=20"

# Get series by rating
curl "http://15.204.231.210/VOD/api/series?sort=rating&order=desc"
```

---

## Important Notes ⚠️

### Series WITHOUT Episodes
- **Range:** Series ID > 5700 (approximately 200 series)
- **Reason:** Not available on source server (hplayer.info returns 404)
- **Examples:** Iljimae, When the Stars Gossip, احتمال, etc.
- **Solution:** Choose from 1,328+ available series OR add another source server

### Series WITH Episodes
- **Range:** Series ID 1 - 5700
- **Count:** 1,328+ series
- **Episodes:** 35,430+ episodes
- **Status:** ✅ Ready to stream/download

---

## Documentation Files

All documentation available in `/var/www/html/VOD/`:

- **SYSTEM_STATUS.md** - Complete system overview
- **HOW_TO_ACCESS_EPISODES.md** - Detailed episode access guide
- **README_EPISODES.md** - Episode import instructions
- **TROUBLESHOOTING.md** - Common issues and solutions
- **FINAL_STATUS.md** - Previous fixes summary

---

## System Health Check

```bash
# Check if APIs are working
curl "http://15.204.231.210/VOD/api/stats"

# Check database
mysql -u root -p'Admin@123' vod_import -e "SELECT COUNT(*) FROM episodes;"

# Check import progress
tail -f /tmp/episode_import_1000.log
```

---

## Contact & Support

- Database: `vod_import`
- PHP Version: 7.4 ✅
- Source Server: hplayer.info ✅
- Remote Servers: Configured ✅

**System Status: 🟢 ONLINE AND READY**

---

*Last Updated: 2025-11-25 18:35*
