<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('log_errors', '1');

echo "Step 1: Starting script\n";

header('Content-Type: application/json; charset=utf-8');
echo "Step 2: Headers set\n";

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    echo "Step 3: OPTIONS request\n";
    http_response_code(200);
    exit();
}

echo "Step 4: Not OPTIONS, continuing\n";

try {
    echo "Step 5: Before requires\n";
    require_once __DIR__ . '/../config/config.php';
    echo "Step 6: Config loaded\n";

    $method = $_SERVER['REQUEST_METHOD'];
    echo "Step 7: Method = $method\n";

    echo json_encode(['status' => 'success', 'message' => 'Debug complete']);
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
?>
