#!/bin/bash
#############################################
#  Copy VOD System to Remote Server
#  Usage: bash copy_to_server.sh root@IP
#############################################

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

if [ -z "$1" ]; then
    echo -e "${RED}Usage: bash copy_to_server.sh user@server [port]${NC}"
    echo "Example: bash copy_to_server.sh root@192.168.1.100"
    echo "Example: bash copy_to_server.sh root@192.168.1.100 2222"
    exit 1
fi

SERVER=$1
PORT=${2:-22}
LOCAL_DIR="/var/www/html/VOD"

echo -e "${GREEN}Creating archive...${NC}"
cd /var/www/html

# Create archive
tar -czf /tmp/vod_full.tar.gz \
    --exclude='VOD/cache/*' \
    --exclude='VOD/logs/*.log' \
    --exclude='VOD/temp/*' \
    --exclude='VOD/*.tar.gz' \
    VOD/

echo -e "${GREEN}Copying to ${SERVER}...${NC}"

# Copy files
scp -P ${PORT} /tmp/vod_full.tar.gz ${SERVER}:/tmp/
scp -P ${PORT} ${LOCAL_DIR}/install_vod.sh ${SERVER}:/tmp/

# Extract on remote
echo -e "${GREEN}Extracting on remote server...${NC}"
ssh -p ${PORT} ${SERVER} << 'ENDSSH'
mkdir -p /var/www/html
cd /var/www/html
tar -xzf /tmp/vod_full.tar.gz
chown -R www-data:www-data /var/www/html/VOD 2>/dev/null || chown -R nginx:nginx /var/www/html/VOD 2>/dev/null
chmod -R 755 /var/www/html/VOD
chmod -R 777 /var/www/html/VOD/{cache,logs,media,watch,temp} 2>/dev/null
rm /tmp/vod_full.tar.gz
echo "Files extracted!"
ENDSSH

rm /tmp/vod_full.tar.gz

echo ""
echo -e "${GREEN}═══════════════════════════════════════${NC}"
echo -e "${GREEN}     Files copied successfully!${NC}"
echo -e "${GREEN}═══════════════════════════════════════${NC}"
echo ""
echo -e "${YELLOW}Now run on remote server:${NC}"
echo "  ssh -p ${PORT} ${SERVER}"
echo "  sudo bash /tmp/install_vod.sh"
echo ""
