@echo off
chcp 65001 >nul
title VOD Import System - Windows Setup
color 0A

echo.
echo ================================================
echo    VOD Import System - Windows Setup
echo ================================================
echo.

:: Check if running as admin
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo [ERROR] Please run as Administrator!
    echo Right-click and select "Run as administrator"
    pause
    exit /b 1
)

:: Configuration
set INSTALL_DIR=C:\xampp\htdocs\VOD
set XAMPP=C:\xampp
set MYSQL=%XAMPP%\mysql\bin\mysql.exe
set DB_NAME=vod_import

echo [1/5] Checking XAMPP...
if not exist "%XAMPP%" (
    echo.
    echo [ERROR] XAMPP not found!
    echo.
    echo Please install XAMPP first:
    echo   1. Download: https://www.apachefriends.org/download.html
    echo   2. Install to C:\xampp
    echo   3. Start Apache and MySQL
    echo   4. Run this script again
    echo.
    start https://www.apachefriends.org/download.html
    pause
    exit /b 1
)
echo   OK - XAMPP found

echo [2/5] Creating directories...
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"
if not exist "%INSTALL_DIR%\api" mkdir "%INSTALL_DIR%\api"
if not exist "%INSTALL_DIR%\assets\css" mkdir "%INSTALL_DIR%\assets\css"
if not exist "%INSTALL_DIR%\assets\js" mkdir "%INSTALL_DIR%\assets\js"
if not exist "%INSTALL_DIR%\classes" mkdir "%INSTALL_DIR%\classes"
if not exist "%INSTALL_DIR%\config" mkdir "%INSTALL_DIR%\config"
if not exist "%INSTALL_DIR%\cache" mkdir "%INSTALL_DIR%\cache"
if not exist "%INSTALL_DIR%\logs" mkdir "%INSTALL_DIR%\logs"
if not exist "%INSTALL_DIR%\media" mkdir "%INSTALL_DIR%\media"
if not exist "%INSTALL_DIR%\temp" mkdir "%INSTALL_DIR%\temp"
echo   OK - Directories created

echo [3/5] Creating database...
"%MYSQL%" -u root -e "CREATE DATABASE IF NOT EXISTS %DB_NAME% CHARACTER SET utf8mb4;" 2>nul
if %errorLevel% neq 0 (
    echo   [WARNING] Could not create database. Make sure MySQL is running.
) else (
    echo   OK - Database created
)

echo [4/5] Creating config file...
(
echo ^<?php
echo define('DB_HOST', 'localhost'^);
echo define('DB_NAME', '%DB_NAME%'^);
echo define('DB_USER', 'root'^);
echo define('DB_PASS', ''^);
echo define('DB_CHARSET', 'utf8mb4'^);
echo define('BASE_PATH', dirname(__DIR__^)^);
echo define('DEBUG_MODE', true^);
echo.
echo function getDB(^): PDO {
echo     static $pdo = null;
echo     if ($pdo === null^) {
echo         $dsn = sprintf('mysql:host=%%s;dbname=%%s;charset=%%s', DB_HOST, DB_NAME, DB_CHARSET^);
echo         $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE =^> PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE =^> PDO::FETCH_ASSOC]^);
echo     }
echo     return $pdo;
echo }
echo.
echo spl_autoload_register(function ($class^) { $f = BASE_PATH.'/classes/'.$class.'.php'; if(file_exists($f^)^) require_once $f; }^);
) > "%INSTALL_DIR%\config\config.php"
echo   OK - Config created

echo [5/5] Creating shortcuts...
echo start http://localhost/VOD/ > "%INSTALL_DIR%\Open Panel.bat"
echo   OK - Shortcut created

echo.
echo ================================================
echo         Installation Complete!
echo ================================================
echo.
echo URL: http://localhost/VOD/
echo.
echo Admin Login:
echo   Username: admin
echo   Password: admin123
echo.
echo Install Path: %INSTALL_DIR%
echo.
echo NEXT STEPS:
echo   1. Copy your PHP files to: %INSTALL_DIR%
echo   2. Import database schema
echo   3. Start Apache and MySQL in XAMPP
echo.
echo ================================================
echo.

set /p OPEN="Open VOD Panel in browser? (y/n): "
if /i "%OPEN%"=="y" start http://localhost/VOD/

pause
