# IPTV Stream Auto-Sync Setup Guide

## Overview
This system syncs live TV streams from the remote panel (45.154.207.117) to the local panel.

## Current Status
- **Issue**: The `stream_display_name` column was missing - **FIXED** ✓
- **Issue**: Remote MySQL connection is refused - **NEEDS CONFIGURATION**

## Solution 1: Enable Remote MySQL Access (Recommended for Auto-Sync)

To enable automatic synchronization, the remote MySQL server needs to allow external connections.

### On Remote Server (45.154.207.117):

```bash
# 1. Edit MySQL configuration
sudo nano /etc/mysql/mysql.conf.d/mysqld.cnf

# 2. Find this line:
bind-address = 127.0.0.1

# 3. Change it to:
bind-address = 0.0.0.0

# 4. Save and restart MySQL
sudo systemctl restart mysql

# 5. Grant access to the local server
mysql -u root -p
```

Then in MySQL:
```sql
-- Replace LOCAL_SERVER_IP with the IP of this local server
GRANT ALL ON midnight_iptv.* TO 'root'@'LOCAL_SERVER_IP' IDENTIFIED BY '1980123nasa';
FLUSH PRIVILEGES;
```

### Once Remote MySQL is Accessible:

The auto-sync daemon will work. Start it with:
```bash
sudo systemctl daemon-reload
sudo systemctl restart stream-sync.service
sudo systemctl status stream-sync.service
```

Check logs:
```bash
tail -f /var/log/sync_daemon_mysql.log
```

## Solution 2: Manual Sync via Web Interface

Access the sync page in the admin panel:
```
http://15.204.231.210/iptv/index.php/sync_remote/index
```

This page will:
- Test the remote connection
- Show stream counts
- Allow manual sync with one click

## Solution 3: Command Line Sync

Run the sync script manually:
```bash
php /var/www/html/iptv/simple_sync.php
```

## Files Created

1. **/var/www/html/iptv/sync_daemon_mysql.php** - Auto-sync daemon (requires remote MySQL)
2. **/var/www/html/iptv/simple_sync.php** - Standalone sync script
3. **/var/www/html/iptv/apps/sync_remote.php** - Web-based sync interface
4. **/var/www/html/iptv/manual_sync.php** - Manual sync page
5. **/etc/systemd/system/stream-sync.service** - Systemd service

## Fixed Issues

### 1. stream_display_name Column Missing ✓
**Problem**: Code referenced `stream_display_name` but database only had `name` column.

**Solution**: Added virtual column:
```sql
ALTER TABLE streams ADD COLUMN stream_display_name VARCHAR(200) GENERATED ALWAYS AS (name) VIRTUAL AFTER name;
```

Now the streams_bulk page and all other pages work correctly.

### 2. Streams Not Showing in Bulk Page ✓
**Status**: FIXED - After adding the `stream_display_name` column, all streams now display.

### 3. Auto-Sync Not Working
**Status**: PENDING - Requires remote MySQL configuration

**Access Sync Page**: http://15.204.231.210/iptv/index.php/sync_remote/index

## Testing

Test remote connection:
```bash
mysql -h 45.154.207.117 -u root -p1980123nasa midnight_iptv -e "SELECT COUNT(*) FROM streams WHERE type=0;"
```

If this works, auto-sync will work. If it fails, use manual sync via web interface.
