<?php 
$time_start = microtime(true);
error_reporting(1);
// Disable gzip compression for consistent XOR encrypted responses
// ob_start('ob_gzhandler');
ob_start();
@date_default_timezone_set('Asia/Gaza');
include('./api_cfg_v6.php');
include('./API6Core.php');
include('../includes/MacLogger.php');

// Debug logging function
function debug_log($message, $data = null) {
    global $_CFG;
    if(isset($_CFG['debug']) && $_CFG['debug']) {
        $log_message = date('[Y-m-d H:i:s] ') . $message;
        if($data !== null) {
            $log_message .= ': ' . (is_array($data) || is_object($data) ? json_encode($data) : $data);
        }
        error_log($log_message);
        @file_put_contents('./logs/debug_' . date('Y-m-d') . '.log', $log_message . "\n", FILE_APPEND | LOCK_EX);
    }
}

// Log request for debugging
if(isset($_CFG['debug']) && $_CFG['debug']) {
    $data = "------------POST-----------------\n";
    foreach($_POST as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "------------_REQUEST-----------------\n";
    foreach($_REQUEST as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= ('------------PHP/INPUT=' . file_get_contents('php://input') . "\n");
    $data .= "------------END--POST-----------------\n";
    $data .= "---------SERVER------------\n";
    foreach($_SERVER as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "========END========REQUEST========\n\n";
    @file_put_contents('./logs/' . $_SERVER['REMOTE_ADDR'] . '_.log', $data, FILE_APPEND | LOCK_EX);
}

class APIv6 extends API6Core
{
    // Flag to determine if responses should be XOR encrypted
    //private $useXorEncryption = true;
     
    public function __construct()
    {
        global $_CFG;
        
        debug_log("API Request received");
        
        // Check for the JSON data in the raw input first
        $raw_input = file_get_contents('php://input');
        debug_log("Raw input received", substr($raw_input, 0, 200));
        
        // Initialize input data
        $json = null;
        
        // Try to parse as direct JSON first
        if(!empty($raw_input)) {
            $direct_json = json_decode($raw_input, true);
            if(is_array($direct_json) && isset($direct_json['mode'])) {
                debug_log("Successfully parsed direct JSON input");
                $json = $direct_json;
                $this->useXorEncryption = false; // Response should match input format
            }
        }
        
        // If no direct JSON, check for XOR encrypted data
        if($json === null) {
            debug_log("No direct JSON found, checking for XOR encrypted data");
            
            // Check if POST data contains json parameter
            if(!isset($_POST['json'])) {
                debug_log("No 'json' parameter found in POST data");
                
                // Parse raw input for POST-like format
                if(preg_match('/json=([^&]+)/', $raw_input, $matches)) {
                    $_POST['json'] = urldecode($matches[1]);
                    debug_log("Extracted json parameter from raw input");
                } else {
                    // Fall back to checking for direct JSON again, as a last resort
                    $potentially_json = json_decode($raw_input, true);
                    if(is_array($potentially_json) && isset($potentially_json['mode'])) {
                        debug_log("Found JSON directly in raw input");
                        $json = $potentially_json;
                        $this->useXorEncryption = false;
                    } else {
                        debug_log("No valid input data found");
                        $this->_die('error: you did not send the POSTFIELDS: json=xor_encrypted_data');
                    }
                }
            }
            
            // If json parameter is found, try to decrypt it
            if(isset($_POST['json']) && $json === null) {
                debug_log("Found json parameter, trying to decrypt");

                try {
                    // PHP already URL-decodes $_POST data, so don't decode again
                    $encryptedData = $_POST['json'];

                    // Try standard XOR decryption first (URL-encoded format)
                    $jsonRow = $this->runXOR($encryptedData);
                    $json = json_decode($jsonRow, true);

                    // If that fails, try base64 decode first then XOR (base64-encoded format)
                    if(!is_array($json)) {
                        debug_log("Standard XOR failed, trying base64+XOR");
                        $base64Decoded = base64_decode($encryptedData, true);
                        if($base64Decoded !== false) {
                            $jsonRow = $this->runXOR($base64Decoded);
                            $json = json_decode($jsonRow, true);
                            if(is_array($json)) {
                                debug_log("Successfully decrypted base64+XOR data");
                            }
                        }
                    }

                    // Try to parse the decrypted data
                    if(!is_array($json)) {
                        debug_log("Failed to parse JSON after XOR decryption", substr($jsonRow, 0, 200));
                        $this->_die('error: converting json data. Data you sent is: ' . substr($jsonRow, 0, 100) . "...\n\r");
                    } else {
                        debug_log("Successfully decrypted and parsed XOR data");
                        $this->useXorEncryption = true;
                    }
                } catch(Exception $e) {
                    debug_log("Exception during XOR decryption", $e->getMessage());
                    $this->_die('error: decryption failed: ' . $e->getMessage());
                }
            }
        }
        
        // At this point, $json should contain the parsed data
        if($json === null) {
            debug_log("Failed to parse input data");
            $this->_die('error: could not parse input data');
        }
        
        // Validate required fields based on the mode
        $token_auth_modes = [
            'movies_cat', 'movies_latest', 'movies_list', 'movies_netflix',
            'movies_kids', 'movies_trends', 'movies_shaid', 'movies_top',
            'movies_shahid', 'kids', 'trends', 'shahid', 'shaid',
            'top_movies', 'topmovies', 'top_series', 'topseries',
            'series_cat', 'series_latest', 'series_list', 'series_top',
            'packages', 'channels', 'get_stream_url'
        ];
        
        debug_log("Input data", $json);
        
        // Check mode
        if(!isset($json['mode']) || trim($json['mode']) == '') {
            debug_log("No mode specified in input data");
            $this->_die('error: no mode');
        }
        
        $json['mode'] = trim($json['mode']);
        debug_log("Mode found: " . $json['mode']);
        
        // Check if we can use token authentication
        $using_token_auth = false;
        if(in_array($json['mode'], $token_auth_modes) && isset($json['token']) && !empty($json['token'])) {
            debug_log("Token authentication available for mode: " . $json['mode']);
            $using_token_auth = true;
        }

        // Login mode and API modes don't require code/mac/sn
        $login_modes = ['login', 'create_user'];
        $skip_code_check = in_array($json['mode'], $login_modes);

        // Check required fields if not using token authentication and not login mode
        if(!$using_token_auth && !$skip_code_check) {
            if(!isset($json['code'])) {
                debug_log("Missing code parameter");
                $this->_die('error: no code');
            }
            if(!isset($json['mac'])) {
                debug_log("Missing mac parameter");
                $this->_die('error: no mac');
            }
            if(!isset($json['sn'])) {
                debug_log("Missing serial parameter");
                $this->_die('error: no serial');
            }
        }
        
        // Store all JSON parameters in class properties
        foreach($json as $key => $value) {
            if(property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
        
        // Connect to database and load configuration
        $this->mac_enable = true;
        $this->connect();
        $this->config();
        
        // Capture user/pass from JSON (APK sends these fields)
        $this->user_input = isset($json['user']) ? mysqli_real_escape_string($this->link, $json['user']) : '';
        $this->pass_input = isset($json['pass']) ? mysqli_real_escape_string($this->link, $json['pass']) : '';

        // If user field is provided, use it as credentials
        if(!empty($this->user_input) && !empty($this->pass_input)) {
            $this->user = $this->user_input;
            $this->pass = $this->pass_input;
            debug_log("Using user/pass from JSON: " . $this->user);
        }

        // Validate token if using token authentication
        if($using_token_auth) {
            debug_log("Validating token authentication");
            if(!$this->validateToken($json['token'])) {
                debug_log("Token validation failed");
                $this->_die('error: invalid or expired token');
            }
        } else {
            // Traditional authentication - sanitize inputs
            $this->code = mysqli_real_escape_string($this->link, $json['code']);
            $this->mac = mysqli_real_escape_string($this->link, $json['mac']);
            $this->sn = mysqli_real_escape_string($this->link, $json['sn']);
        }
        
        $this->chipid = mysqli_real_escape_string($this->link, $this->chipid ?? '');
        $this->model = mysqli_real_escape_string($this->link, $this->model ?? '');
        $this->firmware_ver = mysqli_real_escape_string($this->link, $this->firmware_ver ?? '');
        
        // Set up other required properties
        $this->ip = $this->ip();
        $this->get_free_codes();
        $this->getMasterCodes();
        $this->capture();
        
        $this->iptv_stream_host = trim($this->conf['iptv_host']);
        if(!is_dir('./cache/')) {
            $this->cache = false;
        }
        
        // Store the data for access by other methods
        $_POST['data'] = $json;
        $_POST['mode'] = $json['mode'];
    }
    
    // Validate token authentication
    public function validateToken($token) {
        // Basic validation to make sure we have a string
        if(empty($token) || !is_string($token)) {
            return false;
        }
        
        // Escape the token for SQL query
        $token = mysqli_real_escape_string($this->link, $token);
        
        // Look up the token
        $sql = "SELECT u.id, u.username, u.password, u.exp_date, u.admin_enabled, u.enabled 
                FROM user_tokens t 
                JOIN users u ON t.user_id = u.id 
                WHERE t.token = '$token' 
                AND t.expires > " . time();
        
        debug_log("Executing token validation query", $sql);
        $result = $this->query($sql);
        
        if(mysqli_num_rows($result) === 0) {
            debug_log("Token not found or expired");
            return false;
        }
        
        $user = mysqli_fetch_assoc($result);
        
        // Check if user account is active
        if($user['enabled'] != 1 || $user['admin_enabled'] != 1) {
            debug_log("User account is disabled");
            return false;
        }
        
        // Check if account is expired (NULL exp_date means unlimited/no expiry)
        // SPECIAL: Unlimited accounts whitelist bypass expiry check
        $unlimitedUsers = ['1231231', 'zied', 'test'];
        $isUnlimited = in_array($user['username'], $unlimitedUsers) || $user['exp_date'] === null;

        debug_log("Token validation - username: " . $user['username'] . ", exp_date: " . ($user['exp_date'] ?? 'NULL') . ", isUnlimited: " . ($isUnlimited ? 'yes' : 'no'));

        if (!$isUnlimited && $user['exp_date'] !== null && $user['exp_date'] > 0 && time() > $user['exp_date']) {
            debug_log("User account is expired - exp_date: " . $user['exp_date'] . " < now: " . time());
            return false;
        }
        
        // Store the user credentials for use in other methods
        $this->user = $user['username'];
        $this->pass = $user['password'];
        
        // Update last used timestamp for the token
        $this->query("UPDATE user_tokens SET last_used = " . time() . " WHERE token = '$token'");
        
        debug_log("Token validation successful for user: " . $this->user);
        return true;
    }
    
    // Override msg method to handle both encrypted and unencrypted responses
    public function msg($array, $msg = '', $cache_file = '')
    {
        global $_CFG;
        $this->html_header();
        
        // Convert the response to JSON
        $data = json_encode($array, JSON_UNESCAPED_SLASHES);
        
        // Handle caching if requested
        if($cache_file != '' && $this->cache) {
            $this->cache_file($data, $cache_file, true);
        }
        
        // Log the message if provided
        if($msg != '') {
            $this->log($msg);
        }
        
        debug_log("Sending response", [
            'encryption' => $this->useXorEncryption ? 'XOR' : 'None',
            'response_sample' => substr($data, 0, 100) . '...'
        ]);
        
        // Send the response with or without encryption
        if($this->useXorEncryption) {
            echo $this->runXOR($data);
        } else {
            echo $data;
        }
        
        exit();
    }
    
    // Override _die to respect the encryption setting
    public function _die($msg)
    {
        debug_log("API Error: " . $msg);
        
        if($this->useXorEncryption) {
            echo $this->runXOR($msg);
        } else {
            echo json_encode(['error' => $msg, 'status' => 999]);
        }
        
        exit();
    }

    // All other methods from the original class...
    // active(), login(), series_list(), etc. 

    // Include the full active method from the original code
    public function active()
    {
        global $_CFG;
        
        debug_log("active() method called");
        
        // Get the current code, serial number, MAC address, and IP
        $code = $this->code;
        $sn = $this->sn;
        $mac = $this->mac;
        $ip = $this->ip();
        
        // Initialize the response array with all expected fields
        $response = [
            'status' => 7, // Code not found status
            'server_name' => '',
            'apk_ver_code' => '',
            'message' => 'The Code is not found',
            'osd_msg' => '',
            'osd_msg_global' => '',
            'expire' => '',
            'user_agent' => '',
            'username' => '',
            'password' => '',
            'allowed_output_formats' => [],
            'max_connections' => 0,
            'host' => '',
            'player_api' => '',
            'epg_api' => '',
            'code_id' => '',
            'force_update' => '',
            'update_url' => '',
            'apk_page' => '',
            'update_ch' => '',
            'timezone' => '',
            'server_info' => [],
            'total_streams' => 0,
            'total_movies' => 0,
            'total_series' => 0,
            'token' => '',
            'debug' => ''
        ];
        
        // Check for free codes
        if(in_array($code, $this->free_codes)) {
            debug_log("Processing free code: " . $code);
            $this->proccess_free_code($code, $sn, $mac, $ip);
            // The above function will call msg() which exits, so no need for further processing
        }

        // Try XC panel authentication if code contains password (format: username or check against XC panel)
        $pass_input = $this->pass_input ?? '';
        if(!empty($pass_input) || strlen($code) > 10) {
            $xc_result = $this->tryXCPanelAuth($code, $pass_input, $response);
            if($xc_result !== false) {
                return; // XC auth handled the response
            }
        }

        // Determine query type (code, MAC, or serial)
        $why_worng_code = '';
        $qry = $sql_grp = '';
        $txt = 'byCode';
        $codeMacQry = 'c.userid=u.id';
        
        if(isset($this->MasterCodes[$code])) {
            if($this->MasterCodes[$code] == 1) {
                $qry = ' AND mac=\'' . $this->mac . '\'';
                $txt = 'byMAC';
                $codeMacQry = 'c.userid=u.id';
            } else if($this->MasterCodes[$code] == 2) {
                $qry = ' AND serial=\'' . $this->sn . '\'';
                $txt = 'bySerial';
                $codeMacQry = 'c.userid=u.id';
            }
        }
        
        // Get group info if needed
        if(isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes') {
            $sql_grp = ',(SELECT group_id from solus_admin adm where adm.adminid=cod.adminid) AS groupID';
        }
        
        // Look up the code in the database
        $sql_code = $this->query('SELECT * ' . (' ' . $sql_grp . ' ') . ' from ' . PREFIX . ('_codes cod where cod.code=\'' . $code . '\' ' . $qry . ';'));
        if(mysqli_num_rows($sql_code) == 1) {
            $row_code = mysqli_fetch_array($sql_code);
            $code_status = $row_code['status'];
            $code_replaced = $row_code['code_replaced'];
            $groupID = intval($row_code['groupID'] ?? 0);
            
            // Check if code belongs to the right group
            if($groupID != 0 && isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes' && intval($GLOBALS['GROUP'] ?? 0) != 0 && $groupID != $GLOBALS['GROUP']) {
                $response['status'] = 119;
                $response['message'] = 'This code is not for this Brand.';
                $this->msg($response, '@CodeNotForBrand');
                return;
            }
            
            // Check MAC and SN match if code is active
            if($code_status == 1) {
                if($this->mac != $row_code['mac']) {
                    $why_worng_code = ' MAC not match ';
                }
                if($this->sn != $row_code['serial']) {
                    $why_worng_code .= ' SN not match ';
                }
            }
            
            // Handle reset_me codes and replaced codes
            if($row_code['inputBy'] == 0) {
                if($row_code['mac'] == 'reset_me' && $row_code['serial'] == 'reset_me') {
                    $this->query('update ' . PREFIX . ('_codes set mac=\'' . $mac . '\',serial=\'' . $sn . '\' where id=\'' . $row_code['id'] . '\';'));
                }
                if($code_replaced != '' && $code_status == 5) {
                    $response['status'] = 115;
                    $response['message'] = 'Code is replaced. Please use this code: ' . $code_replaced;
                    $this->msg($response, '@Replaced');
                    return;
                }
            }
            
            // Handle code based on status
            if($code_status == 0) {
                // Activate new code
                debug_log("Activating new code: " . $code);
                $this->activate_new_code_enhanced($row_code);
                return;
            } else if($code_status == 2) {
                $response['status'] = 102;
                $response['message'] = 'The Code is suspended';
                $this->msg($response, '@Suspended ' . $txt);
                return;
            } else if($code_status == 3) {
                $response['status'] = 103;
                $response['message'] = 'The Code is Deleted!';
                $this->msg($response, '@Deleted ' . $txt);
                return;
            }
        } else {
            $this->insertIP('notfound');
            $response['status'] = 7;
            $response['message'] = 'The Code is not found';
            $this->msg($response, '@Wrong ' . $txt);
            return;
        }
        
        // Get user info for this code - allow any device (no MAC/serial lock)
        $qry = 'SELECT c.id, c.code, c.userid, c.date_expire, c.status, c.osd_msg, u.* FROM solus_codes c, users u ' .
               (' WHERE c.userid=u.id AND c.code = \'' . $code . '\';');
        $result = $this->query($qry);

        if(mysqli_num_rows($result) == 0) {
            $response['status'] = 7;
            $response['message'] = 'The Code is not found';
            $this->msg($response, '@NotFound ' . $txt);
            return;
        }

        // Update MAC/serial to current device
        $row_temp = mysqli_fetch_array($result);
        $this->query('UPDATE solus_codes SET mac=\'' . $this->mac . '\', serial=\'' . $this->sn . '\' WHERE id=\'' . $row_temp['id'] . '\';');
        mysqli_data_seek($result, 0);
        
        $row = mysqli_fetch_array($result);
        $username = $row['username'];
        $password = $row['password'];
        $this->user = $username;
        $this->pass = $password;
        $this->code_id = $row['id'];
        $userid = intval($row['userid']);
        $status = intval($row['status']);
        $expire = date('Y-m-d', $row['date_expire']);

        // Log MAC address for this code
        $mac_result = logMacAddress($this->link, $this->code, $this->code_id, $this->mac, $this->sn, $_SERVER['HTTP_USER_AGENT'] ?? '', $this->ip);
        if($mac_result === 'blocked') {
            $this->reply(102, 'This MAC address has been blocked', '@MacBlocked');
        }
        
        // Check if expired
        if($expire < date('Y-m-d')) {
            $status = 4;
        }
        
        // Handle status
        switch($status) {
            case 1:
                // Code is active, update password if needed
                if(isset($_CFG['update_password']) && $_CFG['update_password'] == 'yes') {
                    $password = $this->generateRandomString(10);
                    $this->query('UPDATE `users` set `password`=\'' . $password . '\' where `id`=' . $userid . ';');
                    $this->pass = $password;
                }
                
                // Update protocol
                $this->query('UPDATE solus_codes set protocol=6 where id=' . $this->code_id . ';');
                
                // Get server info
                $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
                date_default_timezone_set($timezone);
                
                // Always use HTTPS for streaming URLs
                $server_protocol = "https";
                $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
                $port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');
                
                // Get allowed output formats
                $allowed_formats = json_decode($row['allowed_output_formats'] ?? '[]', true);
                if(!is_array($allowed_formats) || count($allowed_formats) == 0) {
                    $allowed_formats = ["m3u8", "ts"]; // Default formats
                }
                
                // Get active connections count
                $sql_connections = "SELECT COUNT(*) as active_connections FROM user_activity 
                                    WHERE user_id = {$userid} AND date_end IS NULL";
                $result_connections = $this->query($sql_connections);
                $connections = mysqli_fetch_assoc($result_connections);
                $active_connections = $connections['active_connections'] ?? 0;
                
                // Generate token
                $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(64));
                
                // Record token in database for future use
                $this->insert('user_tokens', [
                    'user_id' => $userid,
                    'token' => $token,
                    'created' => time(),
                    'expires' => time() + (86400 * 7), // 7 days
                    'ip' => $this->ip(),
                    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
                ]);
                $this->query("UPDATE users SET enabled = 1, admin_enabled = 1 WHERE id = {$userid}");

                // Build the complete response
                $response = [
                    'status' => 100,
                    'server_name' => 'V6apk',
                    'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
                    'message' => 'The Code is active',
                    'expire' => $this->expire_date($row['date_expire']),
                    'user_agent' => trim($this->conf['user_agent']),
                    'username' => $username,
                    'password' => $password,
                    'allowed_output_formats' => $allowed_formats,
                    'max_connections' => intval($row['max_connections'] ?? 1),
                    'active_connections' => intval($active_connections),
                    'host' => $server_protocol . '://' . $url . $port,
                    'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
                    'epg_api' => 'http://15.204.231.210/iptv/api/player/{user}/{pass}/epg/short/{stream_id}',
                    'code_id' => intval($this->code_id),
                    'force_update' => $this->conf['force_update'] ?? 0,
                    'update_url' => $this->conf['update_url'] ?? '',
                    'apk_page' => $this->conf['apk_page'] ?? '',
                    'update_ch' => 'true',
                    'timezone' => $timezone,
                    'server_info' => [
                        'server_protocol' => $server_protocol,
                        'url' => $url,
                        'port' => $port,
                        'https_port' => $port,
                        'timezone' => $timezone,
                        'timestamp_now' => time(),
                        'time_now' => date('Y-m-d H:i:s')
                    ],
                    'total_streams' => 0,
                    'total_movies' => 0,
                    'total_series' => 0,
                    'token' => $token
                ];
                
                debug_log("Code activated successfully", $response);
                $this->insertModel();
                $this->msg($response, 'ReActivation');
                break;
                
            case 2:
                $response['status'] = 102;
                $response['message'] = 'The Code is suspended';
                $this->msg($response, '@Suspended');
                break;
                
            case 3:
                $response['status'] = 103;
                $response['message'] = 'The Code is Deleted';
                $this->msg($response, '@Deleted Code');
                break;
                
            case 4:
                $response['status'] = 104;
                $response['message'] = 'The Code is Expired';
                $this->msg($response, '@Expired Code');
                break;
        }
    }


// Enhanced version of activate_new_code that returns detailed information
public function activate_new_code_enhanced($row)
{
    global $_CFG;
    
    // First check if we need to use multi_code functionality
    if($this->conf['multi_code'] == 1) {
        $this->activate_new_code_on_same_box($row);
        // The above function will handle messaging and exiting if successful
    }
    
    // Process the activation
    $days = intval($row['days']);
    $period = intval($row['period']);
    $free_days = intval($row['free_days']);
    $code = trim($row['code']);
    $fullname = trim($row['fullname']);
    $forced_country = trim($row['forced_country']);
    $codeID = intval($row['id']);
    
    // Calculate expiration date
    if(in_array($period, $this->free)) {
        $dd = $period - 100;
        $exp_date = strtotime('+' . $dd . ' days');
    } else {
        $exp_date = strtotime('+' . $period . ' month');
        if($free_days > 0) {
            $exp_date = strtotime('+' . $free_days . ' days', $exp_date);
        }
    }
    
    // Determine username
    if($row['inputBy'] == 0) {
        $username = $code;
    } else {
        $username = trim($row['username']);
    }
    
    // Set up user data
    $data = [];
    $data['member_id'] = 1;
    $data['username'] = $username;
    // Generate password with exact same length as username
    $code_length = strlen($username);
    $password = '';
    for($i = 0; $i < $code_length; $i++) {
        $password .= rand(0, 9);
    }
    $data['password'] = $password;
    $data['exp_date'] = $exp_date;
    $data['admin_notes'] = (string)$fullname . ((($row['inputBy'] == 1 ? ' MAC' : $row['inputBy'] == 2) ? ' SN' : ''));
    $data['admin_enabled'] = 1;
    $data['enabled'] = 1;
    $data['bouquet'] = '[' . $row['bouquets'] . ']';
    $data['max_connections'] = isset($row['max_connections']) && $row['max_connections'] > 0 ? intval($row['max_connections']) : 1;
    $data['created_at'] = time();
    $data['created_by'] = 1;
    $data['forced_country'] = $forced_country;
    if($row['allowed_uagent'] != '') {
        $data['allowed_ua'] = $row['allowed_uagent'];
    }
    
    // Check if user already exists
    $sql = $this->query('SELECT id,username from users where username = \'' . $username . '\' LIMIT 1;');
    if(mysqli_num_rows($sql) == 0) {
        // Create user
        $xtID = $this->insert('users', $data);
        $this->insert('user_output', [
            'user_id' => $xtID,
            'access_output_id' => 2
        ]);
    } else {
        $xrow = mysqli_fetch_array($sql);
        $xtID = $xrow['id'];
    }
    
    // Determine what to update based on inputBy
    if($row['inputBy'] == 0) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\',serial=\'' . $this->sn . '\'';
        $txt = 'Code';
    } else if($row['inputBy'] == 1) {
        $whatToUpdate = 'serial=\'' . $this->sn . '\'';
        $txt = 'MAC';
    } else if($row['inputBy'] == 2) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\'';
        $txt = 'Serial';
    }
    
    // Update code status
    $now = time();
    $up = $this->query('update solus_codes set ' . 
                       (' status=1,' . $whatToUpdate . ',date_start=\'' . $now . '\',date_expire=\'' . $exp_date . '\',userid=\'' . $xtID . '\',protocol=6,model=\'' . $this->model . '\' ') . 
                       (' where id=' . $codeID . ';'));
    
    if($this->link->error != '') {
        $response = [
            'status' => 112,
            'message' => 'Error With Database, Please contact admin. ' . $this->link->error,
            'server_name' => 'V6apk'
        ];
        $this->msg($response, '@Database Error = ' . $this->link->error);
        return;
    }
    
    // Log the activation
    $this->log('Activate By ' . $txt . ' |expire = ' . date('Y-m-d H:i:s', $exp_date));

    // Log MAC address on activation
    logMacAddress($this->link, $this->code, $codeID, $this->mac, $this->sn, $_SERVER['HTTP_USER_AGENT'] ?? '', $this->ip);

    // Create a new line in the IPTV panel via API
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $api_key = isset($_CFG['api_key']) ? $_CFG['api_key'] : 'eJIdy5sAgD';
    // Use max_connections from the code, not from config
    $max_connections = $data['max_connections'];
    $restreamer = isset($_CFG['restreamer']) ? intval($_CFG['restreamer']) : 0;
    $subscription_plan = isset($_CFG['subscription_plan']) ? intval($_CFG['subscription_plan']) : 1;
    
    // Prepare POST data for API
    // Get all bouquets from the code, or use all available bouquets if empty
    $code_bouquets = trim($row['bouquets']);
    if (empty($code_bouquets)) {
        // Get all bouquets from database
        $all_bouquets = $this->get_bouquets();
    } else {
        // Convert comma-separated string to array of integers
        $all_bouquets = array_map('intval', explode(',', $code_bouquets));
    }

    $post_data = [
        'api_key' => $api_key,
        'data' => [
            'username' => $username,
            'password' => $data['password'],
            'max_allowed_connections' => $max_connections,
            'allow_m3u' => 1,
            'https' => 1,
            'hls' => 1,
            'mpegts' => 1,
            'rtmp' => 1,
            'restreamer' => $restreamer,
            'expire_date' => $exp_date,
            'subscription_plan_id' => $subscription_plan,
            'bouquets' => $all_bouquets  // Add all bouquets to the new account
        ]
    ];
    
    // Prepare Stream Context
    $opts = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-type: application/x-www-form-urlencoded',
            'content' => http_build_query($post_data)
        ]
    ];
    
    // Create Stream Context
    $context = stream_context_create($opts);
    
    // Perform API Request
    try {
        $api_response = @file_get_contents(
            $panel_url . "api/line/new", 
            false, 
            $context
        );
        
        // Log the API response
        $this->log("IPTV Panel API Response: " . $api_response);
        
        // Parse the response (optional)
        $api_result = json_decode($api_response, true);
        if (isset($api_result['result']) && $api_result['result'] == 'success') {
            $this->log("IPTV Panel line created successfully for user: " . $username);
        } else {
            $this->log("IPTV Panel line creation failed: " . ($api_result['message'] ?? 'Unknown error'));
        }
    } catch (Exception $e) {
        // Log any error
        $this->log("IPTV Panel API Error: " . $e->getMessage());
    }
    
    // Get server info
    $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
    date_default_timezone_set($timezone);
    
    // Always use HTTPS for streaming URLs
    $server_protocol = "https";
    $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
    $port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');

    // Generate token
    $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(64));

    // Save token to database
    $token_expiry_days = isset($_CFG['token_expiry_days']) ? intval($_CFG['token_expiry_days']) : 7;
    $token_created = time();
    $token_expires = $token_created + (86400 * $token_expiry_days);

    $this->insert('user_tokens', [
        'user_id' => $xtID,
        'token' => $token,
        'created' => $token_created,
        'expires' => $token_expires,
        'ip' => $this->ip(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
    ]);

    debug_log("Token saved for user: " . $username . " (ID: " . $xtID . ")");

    // Default allowed formats
    $allowed_formats = ["m3u8", "ts"];
    
    // Save credentials for future reference
    $this->user = $username;
    $this->pass = $data['password'];
    $this->code_id = $codeID;

    // Create the response
    $response = [
        'status' => 100,
        'server_name' => 'V6apk',
        'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
        'message' => 'The Code has been activated successfully',
        'expire' => $this->expire_date($exp_date),
        'user_agent' => trim($this->conf['user_agent']),
        'username' => $username,
        'password' => $data['password'],
        'allowed_output_formats' => $allowed_formats,
        'max_connections' => 1,
        'active_connections' => 0,
        'host' => $server_protocol . '://' . $url . $port,
        'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
        'epg_api' => 'http://15.204.231.210/iptv/api/player/{user}/{pass}/epg/short/{stream_id}',
        'code_id' => intval($codeID),
        'force_update' => $this->conf['force_update'] ?? 0,
        'update_url' => $this->conf['update_url'] ?? '',
        'apk_page' => $this->conf['apk_page'] ?? '',
        'update_ch' => 'true',
        'timezone' => $timezone,
        'server_info' => [
            'server_protocol' => $server_protocol,
            'url' => $url,
            'port' => $port,
            'https_port' => $port,
            'timezone' => $timezone,
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s')
        ],
        'total_streams' => 0,
        'total_movies' => 0,
        'total_series' => 0,
        'token' => $token
    ];


    $this->insertModel();
    $this->msg($response, 'Success ' . $txt);
} 

	
	public function login()
{
    global $_CFG;

    // Get user credentials - check multiple sources (JSON data or POST data)
    // For JSON requests, data comes as $this->data array from parsed JSON
    $username = '';
    $password = '';

    // First check if data property exists (from JSON input)
    debug_log("Login checking credentials - this->data: " . json_encode($this->data));
    if(isset($this->data) && is_array($this->data)) {
        $username = isset($this->data['user']) ? $this->data['user'] : '';
        $password = isset($this->data['pass']) ? $this->data['pass'] : '';
        debug_log("Extracted from this->data - user: $username, pass: " . substr($password, 0, 3) . "...");
    }

    // Fallback to POST data (traditional form submission)
    if(empty($username) && isset($_POST['data']['user'])) {
        $username = $_POST['data']['user'];
    }
    if(empty($password) && isset($_POST['data']['pass'])) {
        $password = $_POST['data']['pass'];
    }

    // Escape for SQL
    $username = mysqli_real_escape_string($this->link, $username);
    $password = mysqli_real_escape_string($this->link, $password);

    $mac = $this->mac;
    $sn = $this->sn;

    // Query the database to validate the user
    $sql = "SELECT u.id, u.username, u.password, u.exp_date, u.admin_notes,
            u.enabled, u.admin_enabled, u.max_connections, u.is_trial, u.created_at,
            u.bouquet
            FROM users u
            WHERE u.username = '$username' AND u.password = '$password' LIMIT 1";

    debug_log("Login SQL: $sql");
    $result = $this->query($sql);
    $num_rows = $result ? mysqli_num_rows($result) : 0;
    debug_log("Login query result rows: $num_rows");

    // If user is not found locally, try XC panel authentication
    if ($num_rows == 0) {
        debug_log("Local auth failed for $username, trying XC panel");

        // Try XC panel authentication
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : 'https://flix-panel.xyz:2087';
        $auth_url = $panel_url . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $auth_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        ]);
        $xc_result = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $xc_data = json_decode($xc_result, true);

        if ($http_code == 200 && isset($xc_data['user_info']) && $xc_data['user_info']['auth'] == 1) {
            debug_log("XC panel auth successful for $username");

            // Auto-add user to local database
            $this->addXCUserToLocal($username, $password, $xc_data['user_info']['exp_date'] ?? null, $xc_data['user_info']['max_connections'] ?? 1);
            $this->createCodeForXCUser($username, $password);

            // Build XC response
            $user_info = $xc_data['user_info'];
            $server_info = $xc_data['server_info'] ?? [];

            $expire_timestamp = $user_info['exp_date'] ?? null;
            $expire_date = $expire_timestamp ? date('Y-m-d', $expire_timestamp) : 'Unlimited';

            $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(128));

            // Get the user ID from local database to save the token
            $user_result = $this->query("SELECT id FROM users WHERE username = '" . mysqli_real_escape_string($this->link, $username) . "' LIMIT 1");
            if ($user_result && mysqli_num_rows($user_result) > 0) {
                $user_row = mysqli_fetch_assoc($user_result);
                $user_id = $user_row['id'];

                // Save token to database
                $this->insert('user_tokens', [
                    'user_id' => $user_id,
                    'token' => $token,
                    'created' => time(),
                    'expires' => time() + (86400 * 7), // 7 days token expiry
                    'ip' => $this->ip(),
                    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
                ]);
                debug_log("Token saved for XC user: $username (user_id: $user_id)");
            }

            $response = [
                'status' => 100,
                'server_name' => 'V6apk',
                'message' => 'Login Success.',
                'osd_msg' => '',
                'osd_msg_global' => '',
                'osd' => ['enable' => 0, 'title' => '', 'img' => '', 'desc' => ''],
                'username' => $username,
                'password' => $password,
                'expire' => $expire_date,
                'max_connections' => $user_info['max_connections'] ?? '1',
                'allowed_output_formats' => $user_info['allowed_output_formats'] ?? ['m3u8', 'ts'],
                'is_trial' => $user_info['is_trial'] ?? '0',
                'active_cons' => $user_info['active_cons'] ?? '0',
                'created_at' => $user_info['created_at'] ?? time(),
                'host' => 'https://flix-panel.xyz:2087',
                'player_api' => 'https://flix-panel.xyz:2087/player_api.php',
                'xmltv_api' => 'http://15.204.231.210/iptv/xmltv.php?username={user}&password={pass}',
                'epg_api' => 'http://15.204.231.210/iptv/api/player/{user}/{pass}/epg/short/{stream_id}',
                'server_info' => [
                    'server_protocol' => 'https',
                    'url' => 'flix-panel.xyz',
                    'port' => ':2087',
                    'https_port' => ':2087',
                    'timezone' => $server_info['timezone'] ?? 'Europe/Berlin',
                    'timestamp_now' => $server_info['timestamp_now'] ?? time(),
                    'time_now' => $server_info['time_now'] ?? date('Y-m-d H:i:s')
                ],
                'total_streams' => 0,
                'total_movies' => 0,
                'total_series' => 0,
                'token' => $token
            ];

            $this->msg($response, 'XC Panel Login successful: ' . $username);
            exit();
        }

        // Both local and XC auth failed
        $response = [
            'status' => 103,
            'server_name' => '',
            'apk_ver_code' => '',
            'message' => 'Login error: Please check username/password or maybe expired.',
            'osd_msg' => '',
            'osd_msg_global' => '',
            'expire' => '',
            'user_agent' => '',
            'username' => '',
            'password' => '',
            'allowed_output_formats' => [],
            'max_connections' => 0,
            'host' => '',
            'player_api' => '',
            'epg_api' => '',
            'code_id' => '',
            'force_update' => '',
            'update_url' => '',
            'apk_page' => '',
            'update_ch' => '',
            'timezone' => '',
            'server_info' => [],
            'total_streams' => 0,
            'total_movies' => 0,
            'total_series' => 0,
            'token' => '',
            'debug' => ''
        ];
        $this->msg($response, 'Login failed: Invalid credentials');
        exit();
    }
    
    $user = mysqli_fetch_assoc($result);
    
    // Check if user account is enabled
    if ($user['enabled'] != 1 || $user['admin_enabled'] != 1) {
        $response = [
            'status' => 102,
            'message' => 'Account is disabled.',
            'server_name' => 'V6apk'
        ];
        $this->msg($response, 'Login failed: Account disabled');
        exit();
    }
    
    // Check if account is expired (NULL exp_date means unlimited/no expiry)
    // FIXED: Properly handle NULL and ensure it means unlimited
    // SPECIAL: Unlimited accounts (1231231, zied, etc.) skip expiry check
    $unlimitedUsers = ['1231231', 'zied', 'test'];
    $isUnlimited = in_array($user['username'], $unlimitedUsers) || $user['exp_date'] === null;

    debug_log("Checking expiration - username: " . $user['username'] . ", exp_date: " . ($user['exp_date'] ?? 'NULL') . ", isUnlimited: " . ($isUnlimited ? 'yes' : 'no') . ", current time: " . time());

    if (!$isUnlimited && $user['exp_date'] !== null && !empty($user['exp_date']) && is_numeric($user['exp_date']) && $user['exp_date'] > 0 && time() > $user['exp_date']) {
        $response = [
            'status' => 103,
            'message' => 'Account has expired.',
            'server_name' => 'V6apk'
        ];
        debug_log("Account expired - exp_date: " . $user['exp_date'] . " < now: " . time());
        $this->msg($response, 'Login failed: Account expired');
        exit();
    }

    debug_log("Account not expired - proceeding with login");
     
    // Get active connections count
    $sql_connections = "SELECT COUNT(*) as active_connections FROM user_activity 
                        WHERE user_id = {$user['id']} AND date_end IS NULL";
    $result_connections = $this->query($sql_connections);
    $connections = mysqli_fetch_assoc($result_connections);
    $active_connections = $connections['active_connections'];
    
    // Get allowed output formats (default since column doesn't exist in this schema)
    $allowed_formats = ["m3u8", "ts"]; // Default formats
    
    // Get server info
    $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
    date_default_timezone_set($timezone);
    
    // Always use HTTPS for streaming URLs
    $server_protocol = "https";
            $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
			$port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');

    // Log the login
    $this->insert('user_activity', [
        'user_id' => $user['id'],
        'stream_id' => 0,
        'server_id' => 0,
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'user_ip' => $this->ip(),
        'date_start' => time(),
        'date_end' => NULL,
        'action' => 'login'
    ]);
    
    // Generate token (simplified version)
    $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(128));
    
    // Record the token in the database
    $this->insert('user_tokens', [
        'user_id' => $user['id'],
        'token' => $token,
        'created' => time(),
        'expires' => time() + (86400 * 7), // 7 days token expiry
        'ip' => $this->ip(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
    
    // Check for OSD messages
    $osd_msg = "";
    $osd_global_msg = "";
    $osd = [
        'enable' => 0,
        'title' => '',
        'img' => '',
        'desc' => ''
    ];
    
    // Check for user-specific OSD
    $sql_osd = "SELECT osd_msg FROM solus_codes WHERE userid = {$user['id']} LIMIT 1";
    $result_osd = $this->query($sql_osd);
    if (mysqli_num_rows($result_osd) > 0) {
        $osd_data = mysqli_fetch_assoc($result_osd);
        $osd_msg = $osd_data['osd_msg'];
        
        if (!empty($osd_msg)) {
            $osd['enable'] = 1;
            $osd['desc'] = $osd_msg;
            $osd['title'] = 'Message';
        }
    }
    
    // Check for global OSD
    $sql_global_osd = "SELECT val FROM solus_options WHERE name = 'global_message' LIMIT 1";
    $result_global_osd = $this->query($sql_global_osd);
    if (mysqli_num_rows($result_global_osd) > 0) {
        $global_osd_data = mysqli_fetch_assoc($result_global_osd);
        $osd_global_msg = $global_osd_data['val'];
    }
    
    // Build the response
    $response = [
        'status' => 100,
        'server_name' => 'V6apk',
        'message' => 'Login Success.',
        'username' => $username,
        'password' => $password,
        'expire' => $this->expire_date($user['exp_date']),
        'is_trial' => intval($user['is_trial']),
        'max_connections' => intval($user['max_connections']),
        'active_connections' => intval($active_connections),
        'user_agent' => trim($this->conf['user_agent']),
        'created_on' => intval($user['created_at']),
        'allowed_output_formats' => $allowed_formats,
        'host' => $server_protocol . '://' . $url . $port,
        'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
        'epg_api' => 'http://15.204.231.210/iptv/api/player/{user}/{pass}/epg/short/{stream_id}',
        'code_id' => 0,
        'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
        'force_update' => $this->conf['force_update'] ?? 0,
        'update_url' => $this->conf['update_url'] ?? '',
        'apk_page' => $this->conf['apk_page'] ?? '',
        'update_ch' => 'true',
        'timezone' => $timezone,
        'server_info' => [
            'server_protocol' => $server_protocol,
            'url' => $url,
            'port' => $port,
            'https_port' => $port,
            'timezone' => $timezone,
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s')
        ],
        'total_streams' => 0,  // These could be computed with additional queries
        'total_movies' => 0,
        'total_series' => 0,
        'token' => $token
    ];
    
    // Send the response
    $this->msg($response, 'Login successful for user: ' . $username);
}

/**
 * Try to authenticate against XC panel directly
 * @param string $username XC panel username
 * @param string $password XC panel password
 * @param array $response Response template
 * @return bool|null Returns true if authenticated, false to continue with local auth, null on error
 */
public function tryXCPanelAuth($username, $password, $response) {
    global $_CFG;

    // If no password provided, check if code exists locally first
    if(empty($password)) {
        $check_local = $this->query('SELECT id FROM solus_codes WHERE code=\'' . mysqli_real_escape_string($this->link, $username) . '\' LIMIT 1');
        if(mysqli_num_rows($check_local) > 0) {
            return false; // Let local auth handle it
        }
    }

    $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : 'https://flix-panel.xyz:2087';

    // Try to authenticate against XC panel
    $auth_url = $panel_url . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);

    debug_log("Trying XC panel auth: " . $username);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $auth_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);

    $result = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($http_code != 200 || empty($result)) {
        debug_log("XC panel auth failed - HTTP: " . $http_code);
        // If password was provided, reject - don't fallback
        if(!empty($password)) {
            $response['status'] = 103;
            $response['message'] = 'Invalid username or password';
            $this->msg($response, 'XC Auth Failed - HTTP error');
            return true; // Handled (with error)
        }
        return false; // Continue with local auth
    }

    $data = json_decode($result, true);

    if(!isset($data['user_info']) || !isset($data['user_info']['auth']) || $data['user_info']['auth'] != 1) {
        debug_log("XC panel auth failed - Invalid response");
        // If password was provided, reject - don't fallback
        if(!empty($password)) {
            $response['status'] = 103;
            $response['message'] = 'Invalid username or password';
            $this->msg($response, 'XC Auth Failed - Invalid credentials');
            return true; // Handled (with error)
        }
        return false; // Continue with local auth
    }

    // XC auth successful - build response
    debug_log("XC panel auth successful for: " . $username);

    $user_info = $data['user_info'];
    $server_info = $data['server_info'] ?? [];

    $expire_timestamp = $user_info['exp_date'] ?? null;
    $expire_date = $expire_timestamp ? date('Y-m-d', $expire_timestamp) : 'Unlimited';

    // Store credentials for this session
    $this->user = $username;
    $this->pass = $password;

    // Auto-add XC user to local database if not exists
    $this->addXCUserToLocal($username, $password, $expire_timestamp, $user_info['max_connections'] ?? 1);

    // Also create a code entry for this user (DISABLED - causing expired issues)
    // $this->createCodeForXCUser($username, $password);

    $response['status'] = 100;
    $response['message'] = 'The Code is active';
    $response['expire'] = $expire_date;
    $response['username'] = $username;
    $response['password'] = $password;
    $response['allowed_output_formats'] = $user_info['allowed_output_formats'] ?? ['m3u8', 'ts'];
    $response['max_connections'] = $user_info['max_connections'] ?? '1';
    $response['host'] = 'https://flix-panel.xyz:2087';
    $response['player_api'] = 'https://flix-panel.xyz:2087/player_api.php';
    $response['xmltv_api'] = 'http://15.204.231.210/iptv/xmltv.php?username={user}&password={pass}';
    $response['epg_api'] = 'http://15.204.231.210/iptv/api/player/{user}/{pass}/epg/short/{stream_id}';
    $response['timezone'] = $server_info['timezone'] ?? 'Europe/Berlin';
    $response['server_info'] = [
        'server_protocol' => 'https',
        'url' => 'flix-panel.xyz',
        'port' => ':2087',
        'https_port' => ':2087',
        'timezone' => $server_info['timezone'] ?? 'Europe/Berlin',
        'timestamp_now' => $server_info['timestamp_now'] ?? time(),
        'time_now' => $server_info['time_now'] ?? date('Y-m-d H:i:s')
    ];

    $this->msg($response, 'XC Panel Auth successful: ' . $username);
    return true;
}


	
	
	
    /**
     * Add XC user to local users table
     */
    private function addXCUserToLocal($username, $password, $exp_date, $max_connections = 1) {
        // FIXED: Properly handle NULL exp_date (unlimited)
        // XC Panel returns null for unlimited accounts
        $exp_sql = ($exp_date !== null && $exp_date > 0) ? intval($exp_date) : "NULL";

        debug_log("addXCUserToLocal - exp_date input: " . var_export($exp_date, true) . ", SQL value: " . $exp_sql);

        // Check if user already exists
        $check = $this->query("SELECT id FROM users WHERE username = '" . mysqli_real_escape_string($this->link, $username) . "' LIMIT 1");
        if(mysqli_num_rows($check) > 0) {
            // Update existing user
            $this->query("UPDATE users SET password = '" . mysqli_real_escape_string($this->link, $password) . "',
                          exp_date = " . $exp_sql . ",
                          max_connections = " . intval($max_connections) . "
                          WHERE username = '" . mysqli_real_escape_string($this->link, $username) . "'");
            debug_log("Updated existing XC user in local DB: " . $username . " with exp_date: " . $exp_sql);
            return;
        }

        // Insert new user
        $sql = "INSERT INTO users (username, password, exp_date, admin_enabled, enabled, admin_notes, reseller_notes,
                bouquet, max_connections, is_restreamer, allowed_ips, allowed_ua, is_trial, created_at, created_by,
                is_mag, is_e2, force_server_id, is_isplock, forced_country, is_stalker, bypass_ua, play_token, pkg)
                VALUES (
                    '" . mysqli_real_escape_string($this->link, $username) . "',
                    '" . mysqli_real_escape_string($this->link, $password) . "',
                    " . $exp_sql . ",
                    1, 1, 'XC Panel User - Unlimited', '', '[]', " . intval($max_connections) . ", 0, '[]', '[]', 0, " . time() . ", 1,
                    0, 0, 0, 0, '', 0, 0, '', 0
                )";
        $this->query($sql);
        debug_log("Added XC user to local DB: " . $username . " with exp_date: " . $exp_sql);
    }

    /**
     * Create code entry for XC user
     */
    private function createCodeForXCUser($username, $password) {
        // Get user ID
        $result = $this->query("SELECT id FROM users WHERE username = '" . mysqli_real_escape_string($this->link, $username) . "' LIMIT 1");
        if(mysqli_num_rows($result) == 0) {
            return;
        }
        $user = mysqli_fetch_assoc($result);
        $userid = $user['id'];

        // Check if code already exists
        $check = $this->query("SELECT id FROM solus_codes WHERE code = '" . mysqli_real_escape_string($this->link, $username) . "' LIMIT 1");
        if(mysqli_num_rows($check) > 0) {
            // Update MAC/serial for existing code
            $this->query("UPDATE solus_codes SET mac = '" . $this->mac . "', serial = '" . $this->sn . "'
                          WHERE code = '" . mysqli_real_escape_string($this->link, $username) . "'");
            debug_log("Updated existing code for XC user: " . $username);
            return;
        }

        // Get exp_date from users table (NULL means unlimited)
        $exp_result = $this->query("SELECT exp_date FROM users WHERE id = " . $userid);
        $exp_row = mysqli_fetch_assoc($exp_result);
        $exp_date = $exp_row['exp_date']; // Keep NULL if unlimited

        // Insert new code
        $sql = "INSERT INTO solus_codes (code, userid, adminid, transid, mac, serial, status, date_expire, bouquets, output, inputBy)
                VALUES (
                    '" . mysqli_real_escape_string($this->link, $username) . "',
                    " . $userid . ",
                    1, 0,
                    '" . $this->mac . "',
                    '" . $this->sn . "',
                    1,
                    " . intval($exp_date) . ",
                    '', 'ts', 0
                )";
        $this->query($sql);
        debug_log("Created code for XC user: " . $username);
    }

    /**
     * Create user on external XC panel (flix-panel.xyz)
     * Called via API when creating users locally
     */
    public function create_user() {
        global $_CFG;

        // Get parameters from request
        $username = isset($this->data['username']) ? trim($this->data['username']) : '';
        $password = isset($this->data['password']) ? trim($this->data['password']) : '';
        $exp_date = isset($this->data['exp_date']) ? intval($this->data['exp_date']) : (time() + 30*24*60*60); // Default 30 days
        $max_connections = isset($this->data['max_connections']) ? intval($this->data['max_connections']) : 1;
        $api_key = isset($this->data['api_key']) ? trim($this->data['api_key']) : '';

        // Validate API key
        $valid_api_key = isset($_CFG['api_key']) ? $_CFG['api_key'] : 'eJIdy5sAgD';
        if($api_key !== $valid_api_key) {
            $this->msg(['status' => 401, 'message' => 'Invalid API key'], 'API key validation failed');
            return;
        }

        // Validate required fields
        if(empty($username) || empty($password)) {
            $this->msg(['status' => 400, 'message' => 'Username and password are required'], 'Missing required fields');
            return;
        }

        if(strlen($password) < 6) {
            $this->msg(['status' => 400, 'message' => 'Password must be at least 6 characters'], 'Password too short');
            return;
        }

        // Check if user already exists
        $check = $this->query("SELECT id FROM users WHERE username = '" . mysqli_real_escape_string($this->link, $username) . "' LIMIT 1");
        if($check && mysqli_num_rows($check) > 0) {
            $this->msg(['status' => 409, 'message' => 'Username already exists'], 'User exists: ' . $username);
            return;
        }

        // Create user in local database
        $sql = "INSERT INTO users (username, password, exp_date, admin_enabled, enabled, admin_notes, reseller_notes,
                bouquet, max_connections, is_restreamer, allowed_ips, allowed_ua, is_trial, created_at, created_by,
                is_mag, is_e2, force_server_id, is_isplock, forced_country, is_stalker, bypass_ua, play_token, pkg, member_id)
                VALUES (
                    '" . mysqli_real_escape_string($this->link, $username) . "',
                    '" . mysqli_real_escape_string($this->link, $password) . "',
                    " . intval($exp_date) . ",
                    1, 1, 'Created via API', '', '[]', " . intval($max_connections) . ", 0, '[]', '[]', 0, " . time() . ", 1,
                    0, 0, 0, 0, '', 0, 0, '', 0, 1
                )";

        $result = $this->query($sql);
        if(!$result) {
            $this->msg(['status' => 500, 'message' => 'Failed to create user'], 'Database error');
            return;
        }

        $user_id = mysqli_insert_id($this->link);

        // Create code entry for the user
        $code_sql = "INSERT INTO solus_codes (code, userid, status, inputBy, mac, serial, days, date_expire, bouquets, output, adminid)
                     VALUES (
                         '" . mysqli_real_escape_string($this->link, $username) . "',
                         " . $user_id . ",
                         1, 0, '', '', 30,
                         " . intval($exp_date) . ",
                         '', 'ts', 1
                     )";
        $this->query($code_sql);

        // Add user output formats
        $this->query("INSERT INTO user_output (user_id, access_output_id) VALUES ($user_id, 1)");
        $this->query("INSERT INTO user_output (user_id, access_output_id) VALUES ($user_id, 2)");
        $this->query("INSERT INTO user_output (user_id, access_output_id) VALUES ($user_id, 3)");

        debug_log("Created user via API: " . $username . " (ID: $user_id)");

        $response = [
            'status' => 200,
            'message' => 'User created successfully',
            'user' => [
                'id' => $user_id,
                'username' => $username,
                'password' => $password,
                'exp_date' => $exp_date,
                'max_connections' => $max_connections,
                'created_at' => time()
            ]
        ];

        $this->msg($response, 'User created: ' . $username);
    }

    public function boolVerifyUser($func = '')
    {
        // If user credentials are already set (via token authentication), skip the lookup
        if(!empty($this->user) && !empty($this->pass)) {
            debug_log("boolVerifyUser: Using existing credentials from token authentication for function: $func");
            return true;
        }

        // Allow any device - no MAC/serial lock
        $sql = 'SELECT c.code,c.adminid,c.transid,c.date_expire,c.status,c.bouquets,c.output,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.userid=u.id AND c.code = \'' . $this->code . '\' LIMIT 1;');
        $result = $this->query($sql);
        $num = mysqli_num_rows($result);
        if( $num == 1 )
        {
            $row = mysqli_fetch_array($result);
            $this->adminid = intval($row['adminid']);
            $this->transid = intval($row['transid']);
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = trim($row['output']);
            if( $row['bouquets'] != '' )
            {
                $this->bouquets = $row['bouquets'];
            }
            return true;
        }

        // Try XC panel authentication if local code not found
        $pass_input = $this->pass_input ?? '';
        if($this->verifyXCPanelUser($this->code, $pass_input)) {
            debug_log("boolVerifyUser: XC Panel auth successful for function: $func");
            return true;
        }

        $this->error('Error: Something Wrong with code. check MAC/Serial.', 'Code Not found in boolVerifyUser() from : ' . $func);
    }

    /**
     * Soft verify user - doesn't throw error, just returns false
     */
    public function boolVerifyUserSoft($func = '')
    {
        // If user credentials are already set, we're good
        if(!empty($this->user) && !empty($this->pass)) {
            return true;
        }

        // Try local database (regular codes)
        $sql = 'SELECT c.code,c.adminid,c.transid,c.date_expire,c.status,c.bouquets,c.output,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.userid=u.id AND c.code = \'' . $this->code . '\' LIMIT 1;');
        $result = $this->query($sql);
        $num = mysqli_num_rows($result);
        if( $num == 1 )
        {
            $row = mysqli_fetch_array($result);
            $this->adminid = intval($row['adminid']);
            $this->transid = intval($row['transid']);
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = trim($row['output']);
            if( $row['bouquets'] != '' )
            {
                $this->bouquets = $row['bouquets'];
            }
            return true;
        }

        // Try free codes database - first try exact match with serial
        $sql_free = 'SELECT c.code, c.date_expire, c.status, c.bouquets, u.username, u.password FROM solus_codes_free c, users u WHERE c.user = u.username AND c.code = \'' . $this->code . '\' AND c.serial = \'' . $this->sn . '\' LIMIT 1;';
        $result_free = $this->query($sql_free);
        if(mysqli_num_rows($result_free) == 1)
        {
            $row = mysqli_fetch_array($result_free);
            $this->adminid = 1;
            $this->transid = 0;
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = '';
            if(!empty($row['bouquets']))
            {
                $this->bouquets = $row['bouquets'];
            }
            debug_log("boolVerifyUserSoft: Free code authenticated for user: " . $this->user);
            return true;
        }

        // Try free codes database - fallback to code-only match (for cases where serial may differ)
        $sql_free_code_only = 'SELECT c.code, c.date_expire, c.status, c.bouquets, u.username, u.password FROM solus_codes_free c, users u WHERE c.user = u.username AND c.code = \'' . $this->code . '\' LIMIT 1;';
        $result_free_code_only = $this->query($sql_free_code_only);
        if(mysqli_num_rows($result_free_code_only) == 1)
        {
            $row = mysqli_fetch_array($result_free_code_only);
            $this->adminid = 1;
            $this->transid = 0;
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = '';
            if(!empty($row['bouquets']))
            {
                $this->bouquets = $row['bouquets'];
            }
            debug_log("boolVerifyUserSoft: Free code authenticated (code-only) for user: " . $this->user);
            return true;
        }

        // Free code requires registration first - each device must activate separately

        // Try XC panel auth with user_input if available
        $user_input = $this->user_input ?? $this->code;
        $pass_input = $this->pass_input ?? '';
        if(!empty($pass_input) && $this->verifyXCPanelUser($user_input, $pass_input)) {
            return true;
        }

        // Authentication failed - do NOT use master credentials as fallback
        debug_log("boolVerifyUserSoft: Authentication failed for function: $func - no valid user found");
        $this->_die('error: invalid credentials');
        return false;
    }

    /**
     * Verify user against XC panel
     */
    private function verifyXCPanelUser($username, $password) {
        global $_CFG;

        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : 'https://flix-panel.xyz:2087';
        $auth_url = $panel_url . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $auth_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        ]);

        $result = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if($http_code != 200 || empty($result)) {
            return false;
        }

        $data = json_decode($result, true);
        if(!isset($data['user_info']) || !isset($data['user_info']['auth']) || $data['user_info']['auth'] != 1) {
            return false;
        }

        // Set credentials for this session
        $this->user = $username;
        $this->pass = $password;
        return true;
    }


public function packages()
{
    global $_CFG;

    $this->boolVerifyUserSoft('packages');

    $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';

    // Use user credentials to fetch categories
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";

    $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_live_categories";

    try {
        $response = @file_get_contents($api_url);

        if ($response === false) {
            $this->log("API Request failed for packages: Unable to connect to $api_url");
            return $this->msg([]);
        }

        $streams = json_decode($response, true);
        if (!is_array($streams)) {
            $this->log("API Request failed for packages: Invalid JSON from $api_url");
            return $this->msg([]);
        }

        $categories = [];
        $view_order = 1;

        foreach ($streams as $cat) {
            $cat_id = (string)($cat['id'] ?? $cat['category_id'] ?? '0');
            $cat_name = $cat['category_name'] ?? $cat['name'] ?? "Category {$cat_id}";

            // Detect icon by category name
            $icon = $this->detect_category_icon($cat_name);

            $categories[] = [
                'id' => $cat_id,
                'category_name' => $cat_name,
                'category_type' => 0,
                'category_icon' => $icon,
                'view_order' => $view_order++,
                'ch_count' => isset($cat['stream_count']) ? intval($cat['stream_count']) : 0,
                'stream_count' => isset($cat['stream_count']) ? intval($cat['stream_count']) : 0,
                'isLocked' => isset($cat['parental_lock']) ? (bool)$cat['parental_lock'] : false,
                'parent' => isset($cat['parent_id']) ? (int)$cat['parent_id'] : 0
            ];
        }

        $this->msg($categories);

    } catch (Exception $e) {
        $this->log("Exception in packages(): " . $e->getMessage());
        $this->msg([]);
    }
}




private function detect_category_icon($cat_name)
{
    $name = mb_strtolower($cat_name);
    if (strpos($name, 'bein') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/bein/beinnews.png';
    }
    if (strpos($name, 'osn') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/osn/osn.png';
    }
    if (strpos($name, 'kuwait') !== false || strpos($name, 'alkuwait') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/kuwait.png';
    }
    return 'http://pro.netmos.ovh:6051/img/tsawer/default.png';
}

public function fallback_packages()
{
    $default = [
        [
            'id' => '0',
            'category_name' => 'Live',
            'category_type' => 0,
            'category_icon' => 'http://pro.netmos.ovh:6051/img/tsawer/default.png',
            'view_order' => 0,
            'ch_count' => 0,
            'stream_count' => 0,
            'isLocked' => false,
            'parent' => 0
        ]
    ];
    $this->msg($default);
}
	
    public function lite_packages()
    {
        $CacheFile = '';
        $this->boolVerifyUserSoft('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_pkgs_' . sha1(str_replace(',', '_', $this->bouquets)) . '.txt';
            $this->cache_display($CacheFile);
        }
        $ar = [];
        $bq = explode(',', $this->bouquets);
        if( is_array($bq) ) 
        {
            if( strlen($this->conf['exclude_movies_pkg']) > 1 ) 
            {
                $ex = explode(',', $this->conf['exclude_movies_pkg']);
                $bq = array_diff($bq, $ex);
            }
            $qry = 'SELECT * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;';
            $sql = mysqli_query($this->link, $qry);
            $i = 0;
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                $bouquet_channels = @json_decode($row['bouquet_channels'], true);
                $ch_count = @count($bouquet_channels);
                $ar[] = [
                    'pkg_id' => $row['id'], 
                    'pkg_name' => $row['bouquet_name'], 
                    'pkg_icon' => trim($row['bouquet_icon'])
                ];
            }
            $this->msg($ar, '', $CacheFile);
        }
    }
  







  public function lite_channels()
    {
        $CacheFile = '';
        $ar = [];
        $pkg_id = $this->pkg_id;
        if( $pkg_id == 0 ) 
        {
            $ar[] = [
                'stream_id' => 0, 
                'stream_name' => 'error: Package ID is 0', 
                'stream_pkg_id' => 0, 
                'stream_icon' => '', 
                'stream_order' => 0, 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        $this->boolVerifyUserSoft('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_chans_' . $pkg_id . '.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT * FROM bouquets WHERE id=' . $pkg_id . ';');
        $row = mysqli_fetch_array($sql);
        $ar = $this->channels($row['bouquet_channels'], $row['id']);
        $this->msg($ar, '', $CacheFile);
    }
    public function sat2iptv()
    {
        $ar = [];
        $qry = '';
        $this->isSatToIPTV = true;
        if( intval($this->conf['enable_sat2iptv']) == 0 ) 
        {
            exit();
        }
        $this->boolVerifyUserSoft('sat2ip');
        if( isset($this->stb_groups) && count($this->stb_groups) >= 1 ) 
        {
            $qry = ' WHERE stb_group IN (' . implode(',', $this->stb_groups) . ') ';
        }
        if( $this->cache ) 
        {
            $CacheFile = 'sat2iptv.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT * FROM ' . PREFIX . ('_stb_to_iptv stb ' . $qry . ' order by angle asc, stb_ch_name ASC;'));
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $stream = str_replace([
                '{type}', 
                '{user}', 
                '{pass}', 
                '{ch}'
            ],

			[
                'live', 
                $this->user, 
                $this->pass, 
                $row['ch_id']
            ], isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/');
            $ar[] = [
                'channel_name' => $row['stb_ch_name'], 
                'angle' => $row['angle'], 
                'tp' => $row['tp'], 
                'pol' => $row['pol'], 
                'sid' => $row['sid'], 
                'stream_url' => $stream
            ];
        }
        $this->msg($ar, '', $CacheFile);
    }
public function channels()
{
    global $_CFG;

    // Try to verify user, but don't fail - use master credentials as fallback
    $this->boolVerifyUserSoft('channels');

    $this->log("channels() called - user: " . $this->user . " pass: " . $this->pass);

    // ═══════════════════════════════════════════════════════════════════════
    // CACHE: للسرعة الفائقة - القنوات تظهر فوراً (0.01 ثانية)
    // ═══════════════════════════════════════════════════════════════════════
    $cache_dir = dirname(__FILE__) . '/cache';
    if (!file_exists($cache_dir)) {
        @mkdir($cache_dir, 0755, true);
    }

    $cache_file = $cache_dir . '/channels_cache.json';
    $cache_duration = 300; // 5 minutes

    // Check if cache exists and is fresh
    if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
        $cached_data = @file_get_contents($cache_file);
        if ($cached_data) {
            $formatted = json_decode($cached_data, true);
            if (is_array($formatted) && !empty($formatted)) {
                $this->log("⚡ Loaded from cache: " . count($formatted) . " channels (instant 0.01s)");
                return $this->msg($formatted);
            }
        }
    }
    // ═══════════════════════════════════════════════════════════════════════

    $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';

    // Use master credentials to fetch channels (all users see same channels)
    $master_user = 'zied';
    $master_pass = 'zied';

    // Use user credentials for stream URLs
    $username = !empty($this->user) ? $this->user : $master_user;
    $password = !empty($this->pass) ? $this->pass : $master_pass;

    // Use Xtream Codes API (has EPG support!)
    $api_url = $panel_url . "player_api.php?username={$master_user}&password={$master_pass}&action=get_live_streams";
    $this->log("channels() API URL: " . $api_url);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $start = microtime(true);
    $response = curl_exec($ch);
    $elapsed = microtime(true) - $start;
    $error = curl_error($ch);
    curl_close($ch);

    $this->log("API fetch time: " . round($elapsed, 2) . "s");

    if ($response === false || $error) {
        $this->log("Channels API request failed: " . $error);
        return $this->fallback_channels();
    }

    $data = json_decode($response, true);
    if (!is_array($data)) {
        $this->log("Channels API invalid JSON");
        return $this->fallback_channels();
    }

    $formatted = [];
    $order = 1;

    foreach ($data as $item) {
        $id = $item['stream_id'] ?? $item['id'] ?? null;
        $name = $item['name'] ?? null;
        $category_id = $item['category_id'] ?? 0;
        $icon = $item['stream_icon'] ?? $item['logo'] ?? $item['poster'] ?? '';
        $cmd = $item['direct_source'] ?? $item['cmd'] ?? '';
        $tv_archive = $item['tv_archive_duration'] ?? '0';
        $epg_channel_id = $item['epg_channel_id'] ?? '';

        if (empty($id) || empty($name)) {
            continue;
        }

        if (empty($icon) || !filter_var($icon, FILTER_VALIDATE_URL)) {
            $icon = 'https://cdn-icons-png.flaticon.com/512/2523/2523641.png';
        }

        // Build stream URL - always use panel URL (panel will redirect to direct source with token)
        $stream_user = !empty($this->user) ? $this->user : '1231231';
        $stream_pass = !empty($this->pass) ? $this->pass : '1231231';

        // Use panel URL - the panel handles redirect to direct source with proper token
        $stream_url = "https://flix-panel.xyz:2087/live/{$stream_user}/{$stream_pass}/{$id}.ts";

        // Store direct_source for reference
        $direct_source = $item['direct_source'] ?? '';

        $formatted[] = [
            'id' => (string)$id,
            'type' => '1',
            'stream_display_name' => (string)$name,
            'category_id' => (int)$category_id,
            'catid' => (string)$category_id,
            'catid_new' => 'x',
            'stream_icon' => $icon,
            'view_order' => $order++,
            'tv_archive' => (string)$tv_archive,
            'has_epg' => !empty($epg_channel_id) ? 1 : 0,
            'epg_channel_id' => $epg_channel_id,
            'stream_url' => $stream_url,
            'cmd' => $stream_url,
            'direct_source' => $direct_source
        ];
    }

    if (empty($formatted)) {
        $this->log("Channels API returned empty formatted data");
        return $this->fallback_channels();
    }

    // ═══════════════════════════════════════════════════════════════════════
    // Save to cache for instant loading (0.01s) on next request
    // ═══════════════════════════════════════════════════════════════════════
    @file_put_contents($cache_file, json_encode($formatted));
    $this->log("✅ Cached " . count($formatted) . " channels with EPG");
    // ═══════════════════════════════════════════════════════════════════════

    $this->msg($formatted);
}

public function fallback_channels()
{
    $this->msg([]);
}

// Get resolved stream URL with token (resolves panel redirect)
public function get_stream_url()
{
    global $_CFG;

    $this->boolVerifyUserSoft('get_stream_url');

    // Get stream_id from various sources
    $stream_id = null;
    if (!empty($this->data['stream_id'])) {
        $stream_id = $this->data['stream_id'];
    } elseif (!empty($_POST['stream_id'])) {
        $stream_id = $_POST['stream_id'];
    } elseif (!empty($_POST['data']['stream_id'])) {
        $stream_id = $_POST['data']['stream_id'];
    }

    // Also check if it was passed in the JSON root
    $raw_input = file_get_contents('php://input');
    if (empty($stream_id) && !empty($raw_input)) {
        $json_data = json_decode($raw_input, true);
        if (!empty($json_data['stream_id'])) {
            $stream_id = $json_data['stream_id'];
        }
    }

    if (empty($stream_id)) {
        return $this->_die('error: no stream_id');
    }

    $stream_user = !empty($this->user) ? $this->user : '1231231';
    $stream_pass = !empty($this->pass) ? $this->pass : '1231231';

    // Build panel URL
    $panel_url = "https://flix-panel.xyz:2087/live/{$stream_user}/{$stream_pass}/{$stream_id}.ts";

    // Make GET request (not HEAD - panel responds differently) to get redirect location
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $panel_url);
    curl_setopt($ch, CURLOPT_NOBODY, false);  // Use GET, not HEAD
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);  // Don't follow redirect
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_RANGE, '0-0');  // Only get 1 byte to avoid downloading stream

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $redirect_url = curl_getinfo($ch, CURLINFO_REDIRECT_URL);
    curl_close($ch);

    // Get redirect URL from curl info or header
    $final_url = $panel_url;
    if ($http_code == 302) {
        if (!empty($redirect_url)) {
            $final_url = $redirect_url;
        } elseif (preg_match('/Location:\s*(.+?)[\r\n]/i', $response, $matches)) {
            $final_url = trim($matches[1]);
        }
    }

    $this->msg([
        'status' => 'success',
        'stream_id' => $stream_id,
        'stream_url' => $final_url,
        'panel_url' => $panel_url
    ]);
}

public function series_cat()
{
    global $_CFG;
    
    // Log before verification
    $this->log("Starting series_cat with user: " . $this->user . " pass: " . $this->pass);
    
    // Verify the user first
    $this->boolVerifyUserSoft('series_cat');
    
    // Get data from the remote API
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";
    
    // Construct the API URL
    $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_series_categories";
    
    try {
        // Make the API request
        $response = @file_get_contents($api_url);
        
        if ($response === false) {
            // Handle error - fall back to local database
            $this->log("API Request failed for series_cat: Unable to connect to remote API");
            $this->fallback_series_cat();
            return;
        }
        
        // Parse the JSON response
        $categories = json_decode($response, true);
        
        if (!is_array($categories)) {
            // Handle error - fall back to local database
            $this->log("API Request failed for series_cat: Invalid response format");
            $this->fallback_series_cat();
            return;
        }
        
        // Transform the response to match the desired format
        $formatted_categories = [];
        
        foreach ($categories as $category) {
            $formatted_categories[] = [
                'id' => $category['category_id'] ?? $category['id'] ?? '0',
                'category_name' => $category['category_name'] ?? $category['name'] ?? 'Unknown',
                'category_type' => 'series',
                'category_icon' => $category['category_icon'] ?? '',
                'cat_order' => $category['category_order'] ?? '1',
                'isLocked' => $category['parental_lock'] ?? false,
                'stream_count' => $category['series_count'] ?? 0,
                'parent_id' => $category['parent_id'] ?? '0'
            ];
        }
        
        // Send the response
        $this->msg($formatted_categories);
        
    } catch (Exception $e) {
        $this->log("API Request exception for series_cat: " . $e->getMessage());
        $this->fallback_series_cat();
    }
}
 
 // Fallback method if the API request fails
public function fallback_series_cat()
{
    global $_CFG;
    
    if (isset($_CFG['UseIntroSeries']) && $_CFG['UseIntroSeries'] == 'Yes') {
        $this->IntroSeriesCat();
        exit();
    }
    
    if (isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1) {
        $mv = new Movies($this, 'series_cat');
        exit();
    }
    
    $this->movies_cat('series');
}
    public function movies_kids()
    {
        $this->boolVerifyUserSoft('movies_kids');
        $cat_id = trim($this->conf['vod_kids'] ?? '');
        $this->get_filtered_categories($cat_id, 'movie');
    }

    public function movies_netflix()
    {
        $this->boolVerifyUserSoft('movies_netflix');
        $cat_id = trim($this->conf['vod_netflix'] ?? '');
        $this->get_filtered_categories($cat_id, 'movie');
    }

    public function movies_trends()
    {
        $this->boolVerifyUserSoft('movies_trends');
        $cat_id = trim($this->conf['vod_trends'] ?? '');
        $this->get_filtered_categories($cat_id, 'movie');
    }

    public function movies_shaid()
    {
        $this->boolVerifyUserSoft('movies_shaid');
        $cat_id = trim($this->conf['vod_shaid'] ?? '');
        $this->get_filtered_categories($cat_id, 'movie');
    }

    public function movies_top()
    {
        $this->boolVerifyUserSoft('movies_top');
        $cat_id = trim($this->conf['vod_top_movies'] ?? '');
        $this->get_filtered_categories($cat_id, 'movie');
    }

    public function series_top()
    {
        $this->boolVerifyUserSoft('series_top');
        $cat_id = trim($this->conf['vod_top_series'] ?? '');
        $this->get_filtered_categories($cat_id, 'series');
    }

    // Helper function to get filtered categories from remote API
    public function get_filtered_categories($cat_ids, $type = 'movie')
    {
        global $_CFG;

        $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
        $username = !empty($this->user) ? $this->user : "1231231";
        $password = !empty($this->pass) ? $this->pass : "1231231";

        // Get action based on type
        $action = ($type == 'series') ? 'get_series_categories' : 'get_vod_categories';
        $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action={$action}";

        $response = @file_get_contents($api_url);
        if ($response === false) {
            $this->msg([]);
            return;
        }

        $categories = json_decode($response, true);
        if (!is_array($categories)) {
            $this->msg([]);
            return;
        }

        // Filter categories by IDs
        $allowed_ids = array_map('trim', explode(',', $cat_ids));
        $filtered = [];

        foreach ($categories as $cat) {
            $id = $cat['category_id'] ?? $cat['id'] ?? '';
            if (in_array($id, $allowed_ids)) {
                $filtered[] = [
                    'id' => $id,
                    'category_name' => $cat['category_name'] ?? $cat['name'] ?? '',
                    'category_type' => $type,
                    'category_icon' => $cat['category_icon'] ?? '',
                    'cat_order' => $cat['parent_id'] ?? '0',
                    'isLocked' => false,
                    'stream_count' => 0,
                    'parent_id' => '0'
                ];
            }
        }

        $this->msg($filtered);
    }

// Helper function to fetch movies from remote API by category IDs
public function fetch_movies_by_categories($category_ids, $type = 'movie')
{
    global $_CFG;

    debug_log("fetch_movies_by_categories called with category_ids: {$category_ids}");

    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";

    debug_log("Using credentials - user: {$username}, panel: {$panel_url}");

    $cat_array = explode(',', $category_ids);
    $all_movies = [];

    foreach ($cat_array as $cat_id) {
        $cat_id = trim($cat_id);
        if (empty($cat_id)) continue;

        $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_vod_streams&category_id={$cat_id}";
        debug_log("Fetching from URL: {$api_url}");

        try {
            $response = @file_get_contents($api_url);
            if ($response === false) {
                debug_log("Failed to fetch category {$cat_id}");
                continue;
            }

            $movies = json_decode($response, true);
            if (!is_array($movies)) {
                debug_log("Invalid response for category {$cat_id}");
                continue;
            }

            debug_log("Found " . count($movies) . " movies in category {$cat_id}");

            foreach ($movies as $movie) {
                $stream_id = $movie['stream_id'] ?? $movie['id'] ?? '';
                $container = $movie['container_extension'] ?? 'mp4';

                $all_movies[] = [
                    'id' => $stream_id,
                    'stream_display_name' => $movie['name'] ?? '',
                    'trailer' => '',
                    'category_id' => $cat_id,
                    'stream_icon' => $movie['stream_icon'] ?? $movie['cover'] ?? '',
                    'backdrop' => $movie['stream_icon'] ?? '',
                    'view_order' => count($all_movies) + 1,
                    'views' => 0,
                    'plot' => $movie['plot'] ?? '',
                    'rating' => (string)($movie['rating'] ?? '0'),
                    'genre' => $movie['genre'] ?? '',
                    'cast' => $movie['cast'] ?? '',
                    'year' => $movie['year'] ?? '',
                    'added' => $movie['added'] ?? '',
                    'stream_url' => $panel_url . "movie/{$this->user}/{$this->pass}/{$stream_id}.{$container}"
                ];
            }
        } catch (Exception $e) {
            $this->log("Error fetching movies for category {$cat_id}: " . $e->getMessage());
        }
    }

    debug_log("Total movies fetched: " . count($all_movies));
    $this->msg($all_movies);
}

// Helper function to fetch series from remote API by category IDs
public function fetch_series_by_categories($category_ids)
{
    global $_CFG;

    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";

    $cat_array = explode(',', $category_ids);
    $all_series = [];

    foreach ($cat_array as $cat_id) {
        $cat_id = trim($cat_id);
        if (empty($cat_id)) continue;

        $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_series&category_id={$cat_id}";

        try {
            $response = @file_get_contents($api_url);
            if ($response === false) continue;

            $series = json_decode($response, true);
            if (!is_array($series)) continue;

            foreach ($series as $serie) {
                $all_series[] = [
                    'id' => $serie['series_id'] ?? $serie['id'] ?? '',
                    'title' => $serie['name'] ?? '',
                    'icon' => $serie['cover'] ?? '',
                    'catid' => $cat_id,
                    'icon_big' => $serie['cover'] ?? '',
                    'backdrop' => $serie['backdrop_path'][0] ?? $serie['cover'] ?? '',
                    'genre' => $serie['genre'] ?? '',
                    'plot' => $serie['plot'] ?? '',
                    'cast' => $serie['cast'] ?? '',
                    'rating' => (string)($serie['rating'] ?? '0'),
                    'director' => $serie['director'] ?? '',
                    'releaseDate' => $serie['releaseDate'] ?? '',
                    'last_modified' => (string)($serie['last_modified'] ?? time()),
                    'youtube_trailer' => $serie['youtube_trailer'] ?? '',
                    'view_order' => count($all_series) + 1,
                    'views' => 0
                ];
            }
        } catch (Exception $e) {
            $this->log("Error fetching series for category {$cat_id}: " . $e->getMessage());
        }
    }

    $this->msg($all_series);
}

// Helper function to find categories by name pattern from remote API
public function movies_cat_by_name($pattern, $category_type = 'movie')
{
    global $_CFG;

    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";

    // Construct the API URL based on type
    if ($category_type == 'series') {
        $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_series_categories";
    } else {
        $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_vod_categories";
    }

    try {
        $response = @file_get_contents($api_url);

        if ($response === false) {
            $this->msg([]);
            return;
        }

        $categories = json_decode($response, true);

        if (!is_array($categories)) {
            $this->msg([]);
            return;
        }

        // Filter categories by name pattern
        $filtered_categories = [];
        foreach ($categories as $category) {
            $cat_name = $category['category_name'] ?? $category['name'] ?? '';
            if (stripos($cat_name, $pattern) !== false) {
                $filtered_categories[] = [
                    'id' => $category['category_id'] ?? $category['id'] ?? '0',
                    'category_name' => $cat_name,
                    'category_type' => $category_type,
                    'category_icon' => $category['category_icon'] ?? 'http://pro.netmos.ovh:6051/img/tsawer/default.png',
                    'cat_order' => $category['parent_id'] ?? '1',
                    'isLocked' => false,
                    'stream_count' => 0,
                    'parent_id' => '0'
                ];
            }
        }

        $this->msg($filtered_categories);

    } catch (Exception $e) {
        $this->log("API Request exception for movies_cat_by_name ({$pattern}): " . $e->getMessage());
        $this->msg([]);
    }
}

    public function music()
    {
        $ex1 = explode(',', $this->conf['vod_music']);
        $ids = implode(',', $ex1);
        if( $ids == '' ) 
        {
            $ids = 0;
        }
        $this->boolVerifyUserSoft('music');
        $qry = $parent = '';
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id IN (' . $ids . ') ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'music_files' => $this->getMusicFiles($row['id'], $row, $icon)
            ];
        }
        $this->msg($ar);
    }
    public function getMusicFiles($catid, $rowFather, $icon)
    {
        global $_CFG;
        $ar = [];
        $sql = $this->query('SELECT id, stream_display_name,stream_source,  stream_icon, streams.`order` as view_order,target_container FROM streams ' . (' WHERE category_id=' . $catid . ' AND status=1 AND stream_display_name NOT LIKE \'%*%\' ') . ' AND stream_display_name NOT LIKE \'%===%\' ORDER BY id DESC;');
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $target_container = preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if (empty($target_container)) $target_container = 'mp4';
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
            $stream = $panel_url . "movie/{$this->user}/{$this->pass}/{$row['id']}.{$target_container}";
            $ar[] = [
                'id' => $row['id'],
                'title' => $row['stream_display_name'],
                'catid' => (string)$catid,
                'icon' => trim($row['stream_icon']),
                'stream_url' => $stream
            ];
        }
        return $ar;
    }
    public function lite_vod_cat($category_type = 'movie')
    {
        $this->boolVerifyUserSoft('movies_cat');
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ORDER BY ' . $this->CatOrder . ' LIMIT 50');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'cat_view_order' => $i
            ];
        }
        $this->msg($ar);
    }
    public function movies_cat($category_type = 'movie', $qryVod = '')
    {
        global $_CFG;

        $this->boolVerifyUserSoft('movies_cat');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 && $category_type == 'movie' )
        {
            $mv = new Movies($this, 'movies_cat');
            exit();
        }
        $qry = $parent = '';
        if( $qryVod == '' && isset($this->conf['remote_movies_use']) && $this->conf['remote_movies_use'] == 1 )
        {
            $ex1 = explode(',', $this->conf['vod_kids'] ?? '');
            $ex2 = explode(',', $this->conf['vod_series'] ?? '');
            $ex3 = explode(',', $this->conf['vod_netflix'] ?? '');
            $excludeIds = array_merge($ex1, $ex2, $ex3);
            $excludeIds = array_filter($excludeIds); // Remove empty values
            if( count($excludeIds) >= 1 )
            {
                $ids = implode(',', $excludeIds);
                if( $ids != '' )
                {
                    $qryVod = ' AND id NOT IN (' . $ids . ')  ';
                }
            }
        }
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' )
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $catsBouqts = '';
        if( isset($_CFG['CatFromBouquets']) && $_CFG['CatFromBouquets'] == 'Yes' )
        {
            $bq = explode(',', $this->bouquets);
            $bq = array_filter(array_map('intval', $bq)); // Filter and sanitize IDs
            if (!empty($bq)) {
                $sqlB = $this->query('SELECT * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;');
                $chans = [];
                while( $rowB = mysqli_fetch_array($sqlB) )
                {
                    $bouquet_channels = @json_decode($rowB['bouquet_channels'], true);
                    if (is_array($bouquet_channels)) {
                        foreach( $bouquet_channels as $ch )
                        {
                            if (is_numeric($ch)) {
                                $chans[] = intval($ch);
                            }
                        }
                    }
                }
                if (!empty($chans)) {
                    $catsBouqts = ' AND id in (select category_id from streams where id IN(' . implode(',', $chans) . '))';
                }
            }
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ' . $qryVod . ' ' . $catsBouqts . ' ORDER BY ' . $this->CatOrder);
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $i++;
            $category_icon = isset($row['category_icon']) ? trim($row['category_icon']) : '';
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $cat_order = isset($row['cat_order']) ? intval($row['cat_order']) : 0;
            $ar[] = [
                'cat_id' => $row['id'],
                'cat_name' => $row['category_name'] ?? '',
                'cat_icon' => $icon,
                'cat_view_order' => ($cat_order == 0 ? $i : $cat_order),
                'sub_cats' => $this->subMoviesCat($row['id'], $row, $icon)
            ];
        }
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar[] = [
                'cat_id' => 0, 
                'cat_name' => 'error no-series-cat', 
                'cat_icon' => (string)$qry, 
                'cat_view_order' => 0, 
                'sub_cats' => []
            ];
        }
        $this->msg($ar);
    }
    public function subMoviesCat($parent, $rowFather, $iconFather)
    {
        $parent = intval($parent);
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id=' . $parent . ' ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $i++;
            $category_icon = isset($row['category_icon']) ? trim($row['category_icon']) : '';
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $cat_order = isset($row['cat_order']) ? intval($row['cat_order']) : 0;
            $ar[] = [
                'sub_id' => $row['id'],
                'sub_name' => $row['category_name'] ?? '',
                'sub_icon' => $icon,
                'sub_view_order' => ($cat_order == 0 ? $i : $cat_order)
            ];
        }
        if( $i == 0 )
        {
            $cat_order_father = isset($rowFather['cat_order']) ? intval($rowFather['cat_order']) : 0;
            $ar[] = [
                'sub_id' => $rowFather['id'] ?? 0,
                'sub_name' => $rowFather['category_name'] ?? '',
                'sub_icon' => $iconFather,
                'sub_view_order' => ($cat_order_father == 0 ? $i : $cat_order_father)
            ];
        }
        return $ar;
    }
    public function movies_list()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUserSoft('movies_list');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'movies_list');
            exit();
        }
        $qry = '';
        if( $this->catid == 'all' ) 
        {
        }
        else
        {
            $qry = 'AND category_id=' . intval($this->catid);
        }
        if( intval($this->catid) == 0 && $this->catid != 'all' ) 
        {
            $ar[] = [
                'id' => '', 
                'title' => 'Error: you must pass (catid) in url.', 
                'catid' => '', 
                'icon' => '', 
                'view_order' => '', 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        if( isset($this->conf['MoviesOrder']) && $this->conf['MoviesOrder'] != '' ) 
        {
            $movies_order = $this->conf['MoviesOrder'];
        }
        else
        {
            $movies_order = 'streams.`order` ASC';
        }
        $this->SetLimitForBadBox('bad_stb_tot_vod');
        $sql_ch = $this->query('SELECT id, stream_display_name,category_id,stream_source,  stream_icon, streams.`order` as view_order,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 AND status=1 ' . $qry . ' ORDER BY ' . $movies_order . ' ' . $this->limit_qry . ';'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            $i++;
            $target_container = preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if (empty($target_container)) $target_container = 'mp4';
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
            $stream = $panel_url . "movie/{$this->user}/{$this->pass}/{$row['id']}.{$target_container}";
            if( isset($_CFG['strm_url_rep']) && isset($_CFG['strm_url_with']) ) 
            {
                $stream = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $stream);
            }
            $movie_propeties = json_decode($row['movie_propeties'], true);
            if (!is_array($movie_propeties)) {
                $movie_propeties = [];
            }

            if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
            {
                $stream_icon = trim($movie_propeties['movie_image']);
            }
            else
            {
                $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
            }

            $backdrop = $movie_propeties['backdrop_path'] ?? $stream_icon;

            $ar[] = [
                'id' => $row['id'],
                'stream_display_name' => $row['stream_display_name'],
                'title' => $row['stream_display_name'],
                'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
                'category_id' => $row['category_id'] ?? '',
                'catid' => $row['category_id'] ?? '',
                'stream_icon' => $stream_icon,
                'icon' => $stream_icon,
                'icon_big' => $stream_icon,
                'backdrop' => $backdrop,
                'poster' => $stream_icon,
                'view_order' => $i + 1,
                'views' => 0,
                'plot' => $movie_propeties['plot'] ?? '',
                'rating' => (string)($movie_propeties['rating'] ?? '0'),
                'genre' => $movie_propeties['genre'] ?? '',
                'cast' => $movie_propeties['cast'] ?? '',
                'year' => $movie_propeties['releasedate'] ?? $movie_propeties['year'] ?? '',
                'added' => $movie_propeties['added'] ?? (string)time(),
                'stream_url' => $stream
            ];
        }
        if( $i == 0 ) 
        {
            $ar[] = [
                'id' => 0, 
                'title' => 'empty category: this is sample', 
                'catid' => 0, 
                'icon' => 'https://www.sample-videos.com/images/imgw.png', 
                'view_order' => 0, 
                'stream_url' => 'https://www.sample-videos.com/video/mp4/720/big_buck_bunny_720p_5mb.mp4'
            ];
        }
        $this->msg($ar);
    }
    public function series_latest()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUserSoft('series_latest');

        // Fetch from MidnightStreamer API using correct endpoint
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : 'https://flix-panel.xyz:2087';
        $master_user = 'zied';
        $master_pass = 'zied';

        // Use player_api.php endpoint for series
        $api_url = $panel_url . "/player_api.php?username={$master_user}&password={$master_pass}&action=get_series";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec($ch);
        curl_close($ch);

        if($response) {
            $data = json_decode($response, true);
            if(is_array($data)) {
                // Sort by year descending, then by rating (best first)
                usort($data, function($a, $b) {
                    $yearA = intval($a['year'] ?? 0);
                    $yearB = intval($b['year'] ?? 0);
                    if ($yearB != $yearA) {
                        return $yearB - $yearA;
                    }
                    // Same year - sort by rating (highest first)
                    $ratingA = floatval($a['rating'] ?? 0);
                    $ratingB = floatval($b['rating'] ?? 0);
                    return $ratingB <=> $ratingA;
                });
                // Limit to 50 series
                $data = array_slice($data, 0, 50);
                $i = 1;
                foreach($data as $item) {
                    $ar[] = [
                        'id' => $item['series_id'] ?? $item['id'] ?? '',
                        'title' => $item['name'] ?? $item['title'] ?? '',
                        'icon' => $item['cover'] ?? $item['logo'] ?? '',
                        'catid' => $item['category_id'] ?? '',
                        'icon_big' => $item['cover'] ?? $item['logo'] ?? '',
                        'backdrop' => $item['cover'] ?? $item['poster'] ?? '',
                        'genre' => $item['genre'] ?? '',
                        'plot' => $item['plot'] ?? '',
                        'cast' => $item['cast'] ?? '',
                        'rating' => (string)($item['rating'] ?? '0'),
                        'director' => $item['director'] ?? '',
                        'releaseDate' => $item['releaseDate'] ?? $item['year'] ?? '',
                        'last_modified' => $item['last_modified'] ?? (string)time(),
                        'view_order' => $i,
                        'views' => $item['views'] ?? 0
                    ];
                    $i++;
                }
            }
        }

        $this->msg($ar);
        exit();

        // Get latest series from local database (fallback - not reached)
        $this->SetLimitForBadBox('bad_stb_tot_series');

        // Query series table for latest series
        $sql_series = $this->query('SELECT id, title, category_id, cover, backdrop, genre, plot, cast, rating, director, releaseDate, last_modified FROM series ' .
                                    'ORDER BY last_modified DESC, id DESC ' . $this->limit_qry . ';');

        $i = 1;
        while( $row = mysqli_fetch_array($sql_series) )
        {
            $cover = isset($row['cover']) ? trim($row['cover']) : '';
            $backdrop = isset($row['backdrop']) ? trim($row['backdrop']) : $cover;

            $ar[] = [
                'id' => $row['id'],
                'title' => $row['title'],
                'icon' => $cover,
                'catid' => $row['category_id'],
                'icon_big' => $cover,
                'backdrop' => $backdrop,
                'genre' => $row['genre'] ?? '',
                'plot' => $row['plot'] ?? '',
                'cast' => $row['cast'] ?? '',
                'rating' => (string)($row['rating'] ?? '0'),
                'director' => $row['director'] ?? '',
                'releaseDate' => $row['releaseDate'] ?? '',
                'last_modified' => $row['last_modified'] ?? (string)time(),
                'view_order' => $i,
                'views' => 0
            ];
            $i++;
        }

        $this->msg($ar);
    }
    public function series_details()
    {
        $this->boolVerifyUserSoft('series_details');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'series_details');
            exit();
        }
    }
    public function episode_info()
    {
        $this->boolVerifyUserSoft('episode_info');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'episode_info');
            exit();
        }
    }
    public function movies_latest()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUserSoft('movies_latest');

        // Fetch from MidnightStreamer API using correct endpoint
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : 'https://flix-panel.xyz:2087';
        $master_user = 'zied';
        $master_pass = 'zied';

        // Use player_api.php endpoint for VOD streams (movies)
        $api_url = $panel_url . "/player_api.php?username={$master_user}&password={$master_pass}&action=get_vod_streams";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec($ch);
        curl_close($ch);

        if($response) {
            $data = json_decode($response, true);
            if(is_array($data)) {
                // Sort by year descending, then by rating (best first)
                usort($data, function($a, $b) {
                    $yearA = intval($a['year'] ?? 0);
                    $yearB = intval($b['year'] ?? 0);
                    if ($yearB != $yearA) {
                        return $yearB - $yearA;
                    }
                    // Same year - sort by rating (highest first)
                    $ratingA = floatval($a['rating'] ?? 0);
                    $ratingB = floatval($b['rating'] ?? 0);
                    return $ratingB <=> $ratingA;
                });
                // Limit to 50 movies
                $data = array_slice($data, 0, 50);
                $i = 1;
                foreach($data as $item) {
                    $icon = $item['stream_icon'] ?? $item['logo'] ?? $item['poster'] ?? '';
                    $ar[] = [
                        'id' => $item['stream_id'] ?? $item['id'] ?? '',
                        'stream_display_name' => $item['name'] ?? $item['title'] ?? '',
                        'title' => $item['name'] ?? $item['title'] ?? '',
                        'trailer' => $item['trailer'] ?? '',
                        'category_id' => $item['category_id'] ?? '',
                        'catid' => $item['category_id'] ?? '',
                        'stream_icon' => $icon,
                        'icon' => $icon,
                        'icon_big' => $icon,
                        'backdrop' => $icon,
                        'poster' => $icon,
                        'view_order' => (string)$i,
                        'views' => $item['views'] ?? 0,
                        'plot' => $item['plot'] ?? '',
                        'rating' => (string)($item['rating'] ?? '0'),
                        'genre' => $item['genre'] ?? '',
                        'cast' => $item['cast'] ?? '',
                        'year' => $item['year'] ?? '',
                        'added' => $item['added'] ?? (string)time(),
                        'container_extension' => $item['container_extension'] ?? 'mp4'
                    ];
                    $i++;
                }
            }
        }

        $this->msg($ar);
        exit();

        // Get latest movies from local database (fallback - not reached)
        if( isset($this->conf['MoviesOrder']) && $this->conf['MoviesOrder'] != '' )
        {
            $movies_order = $this->conf['MoviesOrder'];
        }
        else
        {
            $movies_order = 'streams.`id` DESC';
        }

        $this->SetLimitForBadBox('bad_stb_tot_vod');
        $sql_ch = $this->query('SELECT id, stream_display_name,category_id,stream_source, stream_icon, streams.`order` as view_order,movie_propeties,target_container FROM `streams` ' .
                               (' WHERE `type`=2 AND status=1 ORDER BY ' . $movies_order . ' ' . $this->limit_qry . ';'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) )
        {
            $i++;
            $target_container = preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if (empty($target_container)) $target_container = 'mp4';
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
            $stream = $panel_url . "movie/{$this->user}/{$this->pass}/{$row['id']}.{$target_container}";

            $movie_propeties = json_decode($row['movie_propeties'], true);
            if (!is_array($movie_propeties)) {
                $movie_propeties = [];
            }

            if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
            {
                $stream_icon = trim($movie_propeties['movie_image']);
            }
            else
            {
                $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
            }

            $backdrop = $movie_propeties['backdrop_path'] ?? $stream_icon;

            $ar[] = [
                'id' => $row['id'] ?? '',
                'stream_display_name' => $row['stream_display_name'] ?? '',
                'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
                'category_id' => $row['category_id'] ?? '',
                'stream_icon' => $stream_icon,
                'backdrop' => $backdrop,
                'view_order' => isset($row['view_order']) ? (string)intval($row['view_order']) : '0',
                'views' => 0,
                'plot' => $movie_propeties['plot'] ?? '',
                'rating' => (string)($movie_propeties['rating'] ?? '0'),
                'genre' => $movie_propeties['genre'] ?? '',
                'cast' => $movie_propeties['cast'] ?? '',
                'year' => $movie_propeties['releasedate'] ?? $movie_propeties['year'] ?? '',
                'added' => $movie_propeties['added'] ?? (string)time(),
                'stream_url' => $stream
            ];
        }
        $this->msg($ar);
    }
    public function movies_info()
    {
        $this->boolVerifyUserSoft('movies_info');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 )
        {
            $mv = new Movies($this, 'movies_info');
            exit();
        }
        global $_CFG;

        $qry = '';
        $id = intval($this->movie_id);
        $sql = $this->query('SELECT id, stream_display_name,category_id, stream_source, stream_icon,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 AND status=1 AND id=' . $id . ';'));
        $row = mysqli_fetch_array($sql);

        // Check if movie exists
        if (!$row) {
            $this->log("Movie not found with ID: " . $id);
            return $this->msg([]);
        }

        $target_container = preg_replace('/[^A-Za-z0-9]/', '', $row['target_container'] ?? 'mp4');
        if (empty($target_container)) $target_container = 'mp4';
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
        $stream = $panel_url . "movie/{$this->user}/{$this->pass}/{$row['id']}.{$target_container}";

        $movie_propeties = json_decode($row['movie_propeties'], true);
        if (!is_array($movie_propeties)) {
            $movie_propeties = [];
        }

        if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
        {
            $stream_icon = trim($movie_propeties['movie_image']);
        }
        else
        {
            $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
        }

        $backdrop_path = $movie_propeties['backdrop_path'] ?? $stream_icon;

        $ar[] = [
            'id' => $row['id'],
            'title' => $row['stream_display_name'],
            'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
            'catid' => isset($row['category_id']) ? intval($row['category_id']) : 0,
            'icon' => $stream_icon,
            'backdrop' => [$backdrop_path],
            'stream' => $stream,
            'stream_url' => [
                '480p' => '',
                '720p' => $stream,
                '1080p' => '',
                '4k' => ''
            ],
            'subtitle' => '',
            'genre' => $movie_propeties['genre'] ?? '',
            'MPAA' => 'n/a',
            'release_date' => $movie_propeties['release_date'] ?? $movie_propeties['releasedate'] ?? '',
            'plot' => $movie_propeties['plot'] ?? '',
            'cast' => $movie_propeties['cast'] ?? '',
            'cast_images' => [],
            'duration' => $movie_propeties['duration'] ?? '',
            'rating' => (string)($movie_propeties['rating'] ?? '0'),
            'director' => $movie_propeties['director'] ?? '',
            'year' => 'N/A',
            'user_rating' => 0,
            'likes' => 0,
            'dislikes' => 0,
            'tmdb_id' => (string)($movie_propeties['tmdb_id'] ?? '')
        ];
        $this->msg($ar);
    }
    public function series_netflix()
    {
        $catids = $this->conf['vod_series'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function series_cartoon()
    {
        $catids = $this->conf['vod_kids'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function SetLimitForBadBox($bad_stb_tot)
    {
        if( isset($this->conf['bad_stb_limit_trans']) && trim($this->conf['bad_stb_limit_trans']) != '' && isset($this->conf[$bad_stb_tot]) ) 
        {
            $trans = explode(',', $this->conf['bad_stb_limit_trans']);
            if( in_array($this->transid, $trans) ) 
            {
                $this->limit_qry = ' LIMIT ' . intval($this->conf[$bad_stb_tot]);
            }
        }
    }

public function series_list()
{
    global $_CFG;

    // First verify the user
    $this->boolVerifyUserSoft('series_list');

    // Log the request for debugging
    $this->log("series_list called with catid: " . $this->catid);

    // Use remote API via Movies class
    $mv = new Movies($this, 'series_list');
    exit();
    
    // Apply limit for certain set-top boxes
    $this->SetLimitForBadBox('bad_stb_tot_series');
    
    // Get server details for API connection
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
    $username = !empty($this->user) ? $this->user : "1231231";
    $password = !empty($this->pass) ? $this->pass : "1231231";
    
    // Log credentials for debugging
    $this->log("Using credentials - Username: " . $username . ", Password: " . substr($password, 0, 3) . "...");
    
    // Build API URL with proper parameters
    $api_url = rtrim($panel_url, '/') . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=get_series";
    
    // Add category ID if specified
    if ($this->catid && $this->catid != 'all' && intval($this->catid) > 0) {
        $api_url .= "&category_id=" . intval($this->catid);
    }
    
    // Log the API URL for debugging (redact password)
    $log_url = preg_replace('/password=([^&]*)/', 'password=REDACTED', $api_url);
    $this->log("Connecting to API: " . $log_url);
    
    try {
        // Make API request
        $response = @file_get_contents($api_url);
        
        // Check if request failed
        if ($response === false) {
            $this->log("API Request failed: Could not connect to " . $log_url);
            $this->fallback_series_list();
            return;
        }
        
        // Parse response
        $series_data = json_decode($response, true);
        
        // Check if response is valid
        if (!is_array($series_data)) {
            $this->log("API Request returned invalid JSON: " . substr($response, 0, 100) . "...");
            $this->fallback_series_list();
            return;
        }
        
        // Log success
        $this->log("API Request successful, found " . count($series_data) . " series items");
        
        // Format the response to match the expected format
        $formatted_series = [];
        
        foreach ($series_data as $series) {
            // Make sure we have all required fields with fallbacks
            $formatted_series[] = [
                'id' => isset($series['id']) ? $series['id'] : (isset($series['series_id']) ? $series['series_id'] : 0),
                'title' => isset($series['title']) ? $series['title'] : (isset($series['name']) ? $series['name'] : 'Unknown Title'),
                'icon' => isset($series['icon']) ? $series['icon'] : (isset($series['cover']) ? $series['cover'] : ''),
                'catid' => isset($series['catid']) ? $series['catid'] : (isset($series['category_id']) ? $series['category_id'] : $this->catid),
                'icon_big' => isset($series['icon_big']) ? $series['icon_big'] : (isset($series['cover_big']) ? $series['cover_big'] : (isset($series['icon']) ? $series['icon'] : '')),
                'backdrop' => isset($series['backdrop']) ? $series['backdrop'] : (isset($series['backdrop_path']) ? (is_array($series['backdrop_path']) ? $series['backdrop_path'][0] : $series['backdrop_path']) : ''),
                'genre' => isset($series['genre']) ? $series['genre'] : '',
                'plot' => isset($series['plot']) ? $series['plot'] : '',
                'cast' => isset($series['cast']) ? $series['cast'] : '',
                'rating' => isset($series['rating']) ? $series['rating'] : '0',
                'director' => isset($series['director']) ? $series['director'] : '',
                'releaseDate' => isset($series['releaseDate']) ? $series['releaseDate'] : '',
                'last_modified' => isset($series['last_modified']) ? $series['last_modified'] : time(),
                'youtube_trailer' => isset($series['youtube_trailer']) ? $series['youtube_trailer'] : '',
                'view_order' => isset($series['view_order']) ? $series['view_order'] : (isset($series['num']) ? $series['num'] : 0),
                'views' => isset($series['views']) ? $series['views'] : 0
            ];
        }
        
        // If no series found, return message
        if (empty($formatted_series)) {
            $formatted_series[] = [
                'id' => 0,
                'title' => 'No Series Found in This Category',
                'icon' => '',
                'catid' => $this->catid,
                'icon_big' => '',
                'backdrop' => '',
                'genre' => '',
                'plot' => '',
                'cast' => '',
                'rating' => '0',
                'director' => '',
                'releaseDate' => '',
                'last_modified' => time(),
                'youtube_trailer' => '',
                'view_order' => 0,
                'views' => 0
            ];
        }
        
        // Send the response
        $this->msg($formatted_series);
        
    } catch (Exception $e) {
        $this->log("API Request exception: " . $e->getMessage());
        $this->fallback_series_list();
    }
}

// Fallback method for when the API request fails
public function fallback_series_list()
{
    $this->log("Using fallback database query for series_list");
    
    $err = '';
    $ar = [];
    
    // Build query based on catid
    $qry = '';
    if ($this->catid == 'all') {
        $qry = '';
    } else if (intval($this->catid) > 0) {
        $catID = intval($this->catid);
        $qry = ' AND category_id=' . $catID . ' ';
    } else {
        $err = ' Error: you must pass the catid like: "catid":"xx" or "catid":"all" ';
    }
    
    // Query the local database
    $sql_ch = $this->query('SELECT * FROM `series` ' . 
                         (' WHERE TRUE ' . $qry . ' ORDER BY category_id ASC,id DESC ' . $this->limit_qry . ';'));
    
    $row_count = mysqli_num_rows($sql_ch);
    $this->log("Found {$row_count} series in local database");
    
    // Process results
    $view_order = 0;
    while ($row = mysqli_fetch_array($sql_ch)) {
        $view_order++;
        
        // Handle backdrop path
        $backdrop_path = '';
        if (isset($row['backdrop_path'])) {
            if (is_string($row['backdrop_path']) && strpos($row['backdrop_path'], '[') === 0) {
                // It's a JSON array string, try to decode it
                $backdrop_arr = json_decode($row['backdrop_path'], true);
                if (is_array($backdrop_arr) && !empty($backdrop_arr)) {
                    $backdrop_path = $backdrop_arr[0];
                }
            } else {
                $backdrop_path = $row['backdrop_path'];
            }
        }
        
        $ar[] = [
            'id' => $row['id'],
            'title' => $row['title'],
            'icon' => $row['cover'],
            'catid' => $row['category_id'],
            'icon_big' => $row['cover_big'],
            'backdrop' => $backdrop_path,
            'genre' => isset($row['genre']) ? $row['genre'] : '',
            'plot' => isset($row['plot']) ? $row['plot'] : '',
            'cast' => isset($row['cast']) ? $row['cast'] : '',
            'rating' => isset($row['rating']) ? $row['rating'] : '0',
            'director' => isset($row['director']) ? $row['director'] : '',
            'releaseDate' => isset($row['releaseDate']) ? $row['releaseDate'] : '',
            'last_modified' => isset($row['last_modified']) ? $row['last_modified'] : time(),
            'youtube_trailer' => isset($row['youtube_trailer']) ? $row['youtube_trailer'] : '',
            'view_order' => $view_order,
            'views' => 0
        ];
    }
    
    // If no series found, return error message
    if ($row_count == 0) {
        $ar[] = [
            'id' => 0,
            'title' => ($err != '' ? $err : 'No Series Found'),
            'icon' => '',
            'catid' => $this->catid,
            'icon_big' => '',
            'backdrop' => '',
            'genre' => '',
            'plot' => '',
            'cast' => '',
            'rating' => '0',
            'director' => '',
            'releaseDate' => '',
            'last_modified' => time(),
            'youtube_trailer' => '',
            'view_order' => 0,
            'views' => 0
        ];
    }
     
    // Send the response
    $this->msg($ar);
}

    public function series_info()
    {
        $this->series_episodes();
    }
    public function series_episodes()
    {
        global $_CFG;
        $this->boolVerifyUserSoft('series_episodes');

        // Use remote API via Movies class
        $mv = new Movies($this, 'series_info');
        exit();
        $err = '';
        $ar = [];
        $qry = '';
        $series_id = intval($this->series_id);
        if( $series_id == 0 ) 
        {
            $err = ' Error: you must pass the series_id=xx';
        }
        $sql_ch = $this->query('SELECT s.id, s.stream_display_name,s.stream_source,s.redirect_stream  ,s.stream_icon,s.movie_propeties,s.target_container,ep.season_num FROM `streams` s ,`series_episodes` ep WHERE s.id=ep.stream_id AND s.status=1 /*AND s.`type`=5*/ ' . (' AND  ep.series_id=' . $series_id . ' ORDER BY season_num ASC, ep.`sort` ASC;'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) )
        {
            $i++;
            $target_container = preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if (empty($target_container)) $target_container = 'mp4';
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
            $stream = $panel_url . "series/{$this->user}/{$this->pass}/{$row['id']}.{$target_container}";
            $ar[] = [
                'season_num' => $row['season_num'],
                'episode_num' => $i,
                'episode_name' => $row['stream_display_name'],
                'stream_url' => $stream,
                'stream_icon' => $row['stream_icon']
            ];
        }
        if( mysqli_num_rows($sql_ch) == 0 ) 
        {
            $ar[] = [
                'season_num' => 0, 
                'episode_num' => 0, 
                'episode_name' => ($err != '' ? $err : 'No Episodes'), 
                'stream_url' => '', 
                'stream_icon' => $row['stream_icon']
            ];
        }
        $this->msg($ar);
    }
    public function getList()
    {
        $this->boolVerifyUserSoft('getList');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'getList');
            exit();
        }
    }
    public function myQuran($for = 'Quran')
    {
        $this->boolVerifyUser($for);
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, $for);
            exit();
        }
    }
    public function myRadio()
    {
        $this->myQuran('Radio');
    }
    public function myKids()
    {
        $this->myQuran('Kids');
    }
    public function myMusic()
    {
        $this->myQuran('Music');
    }
    public function myClip()
    {
        $this->myQuran('Clip');
    }
    public function restore()
    {
        if( strtolower($this->sn) == 'null' || strtolower($this->mac) == 'null' || strtolower($this->mac) == '02:00:00:00:00:00' || strtolower($this->mac) == 'nu:ll:00:00:00:00' || strlen($this->mac) < 10 || strlen($this->sn) < 10 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2001: We can\'t restore your code. Your Device is not Readable. Please contact Reseller.', 
                'code' => ''
            ]);
            exit();
        }
        $qry = 'SELECT code FROM solus_codes WHERE serial=\'' . $this->sn . '\' AND mac=\'' . $this->mac . '\';';
        $result = $this->query($qry);
        $found = intval(mysqli_num_rows($result));
        if( $found == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $code = trim($row['code']);
            $this->msg([
                'status' => 100, 
                'message' => 'success', 
                'code' => $code
            ]);
        }
        else if( $found == 0 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2002: Your device is not found!', 
                'code' => ''
            ]);
        }
        else if( $found > 1 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2003: we found many devices like yours!', 
                'code' => ''
            ]);
        }
    }
    public function __destruct()
    {
        global $time_start;
        if( is_resource($this->link) ) 
        {
            mysqli_close($this->link);
        }
    }
    public function IntroSeriesCat()
    {
        $qry = $parent = '';
        $ar = []; 
        $sql = 'SELECT * from ' . PREFIX . '_series_cat where true order by w asc ';
        $sql = $this->query($sql);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $catimage != '' ) 
            {
                $catimage = (string)$catimage;
            }
            else
            {
                $catimage = 'http://intro.ps/uploads/logo/movie.png';
            }
            $ar[] = [
                'cat_id' => $catid, 
                'cat_name' => $catname, 
                'cat_icon' => $catimage, 
                'cat_view_order' => $w
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesList()
    {
        $qry = '';
        if( $this->catid == 'all' ) 
        {
            $qry = '';
        }
        else
        {
            $qry = ' WHERE `catid`=' . intval($this->catid);
        }
        $ar = [];
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series ' . $qry . ' order by catid asc, sid desc'));
        $genre = '';
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $s_photo != '' ) 
            {
                $s_photo = (string)$s_photo;
            }
            else
            {
                $s_photo = 'http://intro.ps/uploads/logo/movie.png';
            }
            $JSON = json_decode($s_jsondata, true);
            $plot = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
            $cast = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
            $rating = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
            $date = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
            $ar[] = [
                'id' => $sid, 
                'title' => $s_title, 
                'icon' => $s_photo, 
                'icon_big' => $s_photo, 
                'catid' => $catid, 
                'genre' => $genre, 
                'plot' => $plot, 
                'cast' => $cast, 
                'rating' => $rating, 
                'director' => 'n/a', 
                'releaseDate' => $date
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesGetDetails()
    {
        $qry = $parent = '';
        $sid = intval($this->series_id);
        $this->query('update ' . PREFIX . ('_series set hits=hits+1 where sid=' . $sid . ';'));
        $sqlSeries = $this->query('SELECT *   FROM ' . PREFIX . ('_series se where sid=' . $sid . ';'));
        $row = mysqli_fetch_array($sqlSeries);
        extract($row);
        $JSON = json_decode($s_jsondata, true);
        if( $s_photo != '' ) 
        {
            $s_photo = (string)$s_photo;
        }
        else
        {
            $s_photo = 'http://intro.ps/uploads/logo/movie.png';
        }
        $ar = [];
        $ar['id'] = $sid;
        $ar['title'] = $s_title;
        $ar['trailer'] = $trailer;
        $ar['user_rating'] = 0;
        $ar['likes'] = $likes;
        $ar['dislikes'] = $dislikes;
        $ar['icon'] = $s_photo;
        $ar['plot'] = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
        $ar['cast'] = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
        $ar['rate'] = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
        $ar['date'] = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series_seasons where seriesid=' . $sid . ' order by s_num asc;'));
        $i = 0;
        $arSeasons = [];
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
        }
        else
        {
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                extract($row);
                $arSeasons[] = [
                    'id' => $seasonid, 
                    'title' => $season_name, 
                    'episodes' => $this->IntroSeriesGetEpisodes(intval($row['seasonid']))
                ];
            }
        }
        $ar['seasons'] = $arSeasons;
        $this->msg($ar);
    }
    public function IntroSeriesGetEpisodes($seasonid)
    {
        $seasonid = intval($seasonid);
        $ar = [];
        $qry = ' SELECT * from ' . PREFIX . ('_seriesepisodes where seasonid=' . $seasonid . '  order by epnum ASC;');
        $sql = $this->query($qry);
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar = [];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            return $ar;
        }
    }
}

// Update to handle potential invalid modes and provide aliases for common typos
$class = new APIv6();
$mode = $_POST['mode'] ?? null;

// Debug the incoming data
debugLog("Received mode", $mode);
debugLog("POST data", $_POST);

// Add mode aliases - this will map truncated or alternative mode names to the correct function
$mode_aliases = [
    'series_lis' => 'series_list',     // Fix for the truncated series_list
    'serie' => 'series_list',          // Another possible variation
    'series' => 'series_list',         // Another possible variation
    'seri' => 'series_list',           // Another possible variation
    'movie_lis' => 'movies_list',
    'movi' => 'movies_list',
    'act' => 'active',
    // Kids, Trends, Shahid, Top Movies, Top Series aliases
    'kids' => 'movies_kids',
    'trends' => 'movies_trends',
    'movies_shahid' => 'movies_shaid',
    'shahid' => 'movies_shaid',
    'shaid' => 'movies_shaid',
    'top_movies' => 'movies_top',
    'topmovies' => 'movies_top',
    'top_series' => 'series_top',
    'topseries' => 'series_top'
];

// Check if we need to use an alias
if(isset($mode_aliases[$mode])) {
    debugLog("Using mode alias", "$mode -> {$mode_aliases[$mode]}");
    $mode = $mode_aliases[$mode];
}

// Further debug
debugLog("Final mode being used", $mode);

if($mode != '' && method_exists($class, $mode)) {
    $class->$mode();
} else {
    debugLog("Invalid mode", $mode);
    $class->_die('Error: mode (' . $mode . ') not defined.');
    exit();
}
 
function get_post($index = '')
{
    if(!isset($_POST[$index])) {
        return $_GET[$index] ?? null;
    } else {
        return $_POST[$index];
    }
}

// Debug logging function (global scope version)
function debugLog($message, $data = null) {
    global $_CFG;
    if(isset($_CFG['debug']) && $_CFG['debug']) {
        $logMsg = date('[Y-m-d H:i:s] ') . $message;
        if($data !== null) {
            $logMsg .= ': ' . print_r($data, true);
        }
        error_log($logMsg);
        @file_put_contents('./logs/debug_' . date('Y-m-d') . '.log', $logMsg . "\n", FILE_APPEND | LOCK_EX);
    }
}