<?php
/**
 * M3U Playlist Generator with EPG Support
 * Compatible with XCIPTV and other M3U-based IPTV players
 */

header('Content-Type: application/x-mpegurl; charset=utf-8');
header('Content-Disposition: attachment; filename="playlist.m3u8"');
header('Access-Control-Allow-Origin: *');

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$type = $_GET['type'] ?? 'm3u_plus';
$output = $_GET['output'] ?? 'ts';

if (empty($username) || empty($password)) {
    echo "#EXTM3U\n";
    echo "# Error: Username and password required\n";
    exit;
}

$external_panel_url = 'https://flix-panel.xyz:2087';
$local_protocol = 'https';
$local_host = $_SERVER['HTTP_HOST'];
$local_base_url = $local_protocol . '://' . $local_host;
$xmltv_url = $local_base_url . '/xmltv.php?username=' . urlencode($username) . '&password=' . urlencode($password);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "$external_panel_url/player_api.php?username=$username&password=$password&action=get_live_streams",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code != 200 || !$response) {
    echo "#EXTM3U\n";
    echo "# Error: Unable to fetch streams\n";
    exit;
}

$streams = json_decode($response, true);
if (!is_array($streams)) {
    echo "#EXTM3U\n";
    echo "# Error: Invalid response\n";
    exit;
}

echo "#EXTM3U x-tvg-url=\"$xmltv_url\"\n\n";

foreach ($streams as $stream) {
    if (!isset($stream['stream_id']) || !isset($stream['name'])) {
        continue;
    }

    $stream_id = $stream['stream_id'];
    $name = $stream['name'];

    if (strpos($name, '", ') !== false) {
        $parts = explode('", ', $name);
        $name = end($parts);
    }
    $name = trim($name, '"');
    if (strlen($name) > 80) {
        $name = substr($name, 0, 77) . '...';
    }

    $tvg_id = $stream['epg_channel_id'] ?? '';
    $tvg_logo = $stream['stream_icon'] ?? '';
    $group = $stream['category_name'] ?? 'Live TV';
    $stream_url = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.' . $output;

    echo '#EXTINF:-1';
    if ($tvg_id) echo ' tvg-id="' . htmlspecialchars($tvg_id, ENT_QUOTES) . '"';
    if ($name) echo ' tvg-name="' . htmlspecialchars($name, ENT_QUOTES) . '"';
    if ($tvg_logo) echo ' tvg-logo="' . htmlspecialchars($tvg_logo, ENT_QUOTES) . '"';
    if ($group) echo ' group-title="' . htmlspecialchars($group, ENT_QUOTES) . '"';
    echo ',' . htmlspecialchars($name, ENT_QUOTES) . "\n";
    echo $stream_url . "\n";
}
?>
