<?php
/**
 * XCIPTV Portal API (V6APK Edition)
 * Allows XCIPTV to authenticate users against external panel
 *
 * URL to use in XCIPTV: https://chatti.tmaxhosting.com/iptv/V6APK
 * Username: 1231231 (from external panel)
 * Password: 1231231 (from external panel)
 */

// Handle PATH_INFO (when XCIPTV adds /xmltv.php to the URL)
$path_info = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';
$request_uri = $_SERVER['REQUEST_URI'];

// If XCIPTV requests /player_api.php/xmltv.php, just redirect to external panel
if ($path_info === '/xmltv.php' || strpos($request_uri, '/xmltv.php') !== false) {
    // Direct redirect to external panel - no proxy, no download
    header('Location: https://flix-panel.xyz:2087/xmltv.php?username=1231231&password=1231231', true, 302);
    exit;
}

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Get request parameters
$username = isset($_GET['username']) ? $_GET['username'] : '';
$password = isset($_GET['password']) ? $_GET['password'] : '';
$action = isset($_GET['action']) ? $_GET['action'] : '';
$category_id = isset($_GET['category_id']) ? $_GET['category_id'] : '';

// Debug logging - log ALL requests
$log_data = [
    'time' => date('Y-m-d H:i:s'),
    'action' => $action ?: 'auth',
    'category_id' => $category_id ?: 'none',
    'url' => $_SERVER['REQUEST_URI'],
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'unknown'
];
error_log("XCIPTV_REQUEST: " . json_encode($log_data));

// External panel configuration
$external_panel_url = 'https://flix-panel.xyz:2087';
$external_host = 'flix-panel.xyz';
$external_port = '2087';

// Get local server info (for authentication response and stream URLs)
$local_protocol = 'https';  // Force HTTPS for compatibility
$local_host = $_SERVER['HTTP_HOST'];
$local_base_url = $local_protocol . '://' . $local_host;

/**
 * Make request to external panel
 */
function makeExternalRequest($url, $username, $password, $action = '') {
    $api_url = $url . '/player_api.php?username=' . urlencode($username) . '&password=' . urlencode($password);

    if ($action) {
        $api_url .= '&action=' . urlencode($action);
    }

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'XCIPTV-Portal'
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }

    return null;
}

/**
 * Convert external URLs to local proxy URLs
 * Uses local proxy to handle tokens properly
 */
function convertToLocalUrls($data, $username, $password, $local_base_url) {
    if (!$data) return $data;

    // Handle when data is a plain array (get_live_streams, get_vod_streams, get_series returns plain arrays)
    if (is_array($data) && isset($data[0])) {
        // Check if it's an array of streams
        if (isset($data[0]['stream_id'])) {
            // Live or VOD streams
            foreach ($data as &$stream) {
                if (isset($stream['stream_id'])) {
                    $stream_id = $stream['stream_id'];

                    // Use LOCAL proxy URLs
                    if (isset($stream['stream_type'])) {
                        if ($stream['stream_type'] === 'live') {
                            $stream['stream_url'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';
                        } else if ($stream['stream_type'] === 'movie') {
                            $stream['stream_url'] = $local_base_url . '/movie/' . $username . '/' . $password . '/' . $stream_id . '.mp4';
                        }
                    } else {
                        // Default to live stream format
                        $stream['stream_url'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';
                    }

                    // Convert direct_source to local proxy (same as stream_url)
                    if (isset($stream['direct_source'])) {
                        $stream['direct_source'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';
                    }
                }
            }
            unset($stream);
            return $data;
        } else if (isset($data[0]['series_id'])) {
            // Series - keep as is for now
            return $data;
        }
    }

    // Handle when data is wrapped in keys (authentication response format)
    // Convert live streams to LOCAL proxy
    if (isset($data['live_streams']) && is_array($data['live_streams'])) {
        foreach ($data['live_streams'] as &$stream) {
            if (isset($stream['stream_id'])) {
                $stream_id = $stream['stream_id'];
                // Point to local proxy
                $stream['stream_url'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';

                // Convert direct_source to local proxy (same as stream_url)
                if (isset($stream['direct_source'])) {
                    $stream['direct_source'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';
                }
            }
        }
        unset($stream);
    }

    // Convert VOD streams to LOCAL proxy
    if (isset($data['vod_streams']) && is_array($data['vod_streams'])) {
        foreach ($data['vod_streams'] as &$stream) {
            if (isset($stream['stream_id'])) {
                $stream_id = $stream['stream_id'];
                $stream['stream_url'] = $local_base_url . '/movie/' . $username . '/' . $password . '/' . $stream_id . '.mp4';

                // Convert direct_source for VOD to local proxy
                if (isset($stream['direct_source'])) {
                    $stream['direct_source'] = $local_base_url . '/movie/' . $username . '/' . $password . '/' . $stream_id . '.mp4';
                }
            }
        }
        unset($stream);
    }

    // Convert series
    if (isset($data['series']) && is_array($data['series'])) {
        foreach ($data['series'] as &$serie) {
            if (isset($serie['series_id'])) {
                $series_id = $serie['series_id'];
                // Keep series info as is
            }
        }
        unset($serie);
    }

    return $data;
}

/**
 * Filter streams by category_id
 */
function filterByCategory($data, $category_id) {
    if (!$category_id || !is_array($data)) {
        return $data;
    }

    // Filter array of streams
    if (isset($data[0]) && is_array($data[0])) {
        return array_values(array_filter($data, function($item) use ($category_id) {
            // Check both category_id (string comparison)
            if (isset($item['category_id']) && $item['category_id'] == $category_id) {
                return true;
            }

            // Check category_ids array (handle both int and string)
            if (isset($item['category_ids']) && is_array($item['category_ids'])) {
                // Check if category_id exists in array (as int or string)
                foreach ($item['category_ids'] as $cat) {
                    if ($cat == $category_id) {
                        return true;
                    }
                }
            }

            return false;
        }));
    }

    return $data;
}

// Handle different actions
$response = null;

switch ($action) {
    case 'get_live_categories':
    case 'get_vod_categories':
    case 'get_series_categories':
        // Forward request to external panel (categories don't need filtering)
        $response = makeExternalRequest($external_panel_url, $username, $password, $action);
        break;

    case 'get_live_streams':
    case 'get_vod_streams':
    case 'get_series':
        // Forward request to external panel WITH category_id if provided
        // Build full API URL with all parameters
        $api_url = $external_panel_url . '/player_api.php?username=' . urlencode($username) . '&password=' . urlencode($password) . '&action=' . urlencode($action);
        if ($category_id) {
            $api_url .= '&category_id=' . urlencode($category_id);
        }

        // Make request with full URL
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'XCIPTV-Portal'
        ]);

        $resp = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code == 200 && $resp) {
            $response = json_decode($resp, true);
        } else {
            $response = [];
        }

        // Convert URLs to use external panel directly
        $response = convertToLocalUrls($response, $username, $password, $local_base_url);
        break;

    case 'get_vod_info':
    case 'get_series_info':
    case 'get_short_epg':
    case 'get_simple_data_table':
        // Forward request to external panel with ALL query parameters
        $api_url = $external_panel_url . '/player_api.php?username=' . urlencode($username) . '&password=' . urlencode($password) . '&action=' . urlencode($action);

        // Add all other GET parameters (stream_id, limit, series_id, vod_id, etc.)
        foreach ($_GET as $key => $value) {
            if (!in_array($key, ['username', 'password', 'action'])) {
                $api_url .= '&' . urlencode($key) . '=' . urlencode($value);
            }
        }

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'XCIPTV-Portal'
        ]);

        $resp = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code == 200 && $resp) {
            $response = json_decode($resp, true);
        } else {
            $response = ['error' => 'Failed to fetch data from external panel'];
        }
        break;

    default:
        // Authentication request
        $external_response = makeExternalRequest($external_panel_url, $username, $password);

        if ($external_response && isset($external_response['user_info'])) {
            // User authenticated successfully on external panel
            $response = [
                'user_info' => [
                    'username' => $username,
                    'password' => $password,
                    'message' => '',
                    'auth' => 1,
                    'status' => $external_response['user_info']['status'] ?? 'Active',
                    'exp_date' => $external_response['user_info']['exp_date'] ?? null,
                    'is_trial' => $external_response['user_info']['is_trial'] ?? '0',
                    'active_cons' => $external_response['user_info']['active_cons'] ?? '0',
                    'created_at' => $external_response['user_info']['created_at'] ?? time(),
                    'max_connections' => $external_response['user_info']['max_connections'] ?? '1',
                    'allowed_output_formats' => ['m3u8', 'ts', 'rtmp']
                ],
                'server_info' => [
                    'url' => $local_host,
                    'port' => '443',
                    'https_port' => '443',
                    'server_protocol' => 'https',
                    'rtmp_port' => '1935',
                    'timezone' => 'UTC',
                    'timestamp_now' => time(),
                    'time_now' => date('Y-m-d H:i:s'),
                    'xmltv_url' => 'https://' . $local_host . '/xmltv.php?username={USERNAME}&password={PASSWORD}'
                ]
            ];
        } else {
            // Authentication failed
            $response = [
                'user_info' => [
                    'auth' => 0,
                    'status' => 'Disabled',
                    'message' => 'Invalid credentials or external panel is down'
                ]
            ];
        }
        break;
}

// Output response
echo json_encode($response ?? ['error' => 'No data'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>
