<?php
/**
 * XMLTV EPG Proxy
 * Accepts ANY username/password from client
 * Returns same EPG for all (channels are same for everyone)
 *
 * Usage: xmltv.php?username=ANY&password=ANY
 */

header('Content-Type: application/xml; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Cache-Control: public, max-age=1800');

// Cache file
$cache_file = __DIR__ . '/cache/epg.xml';
$cache_time = 1800; // 30 minutes

// Serve from cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_time) {
    readfile($cache_file);
    exit;
}

// Load config
require_once __DIR__ . '/includes/Config.php';

// Function to generate EPG from external panel
function generateEPG() {
    $external_url = 'https://flix-panel.xyz:2087';
    $username = '1231231';
    $password = '1231231';

    // Get streams
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => "$external_url/player_api.php?username=$username&password=$password&action=get_live_streams",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $streams_json = curl_exec($ch);
    curl_close($ch);

    $streams = json_decode($streams_json, true);
    if (!is_array($streams)) {
        return false;
    }

    // Build XML
    $xml = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
    $xml .= '<!DOCTYPE tv SYSTEM "xmltv.dtd">' . "\n";
    $xml .= '<tv generator-info-name="IPTV Panel EPG">' . "\n";

    $processed = [];

    // Add channels (limit to 50 for performance)
    $count = 0;
    foreach ($streams as $stream) {
        if ($count >= 50) break;
        if (!isset($stream['epg_channel_id']) || in_array($stream['epg_channel_id'], $processed)) continue;

        $ch_id = htmlspecialchars($stream['epg_channel_id'], ENT_XML1);
        $ch_name = htmlspecialchars($stream['name'] ?? 'Channel', ENT_XML1);

        $xml .= "  <channel id=\"$ch_id\">\n";
        $xml .= "    <display-name>$ch_name</display-name>\n";
        $xml .= "  </channel>\n";

        $processed[] = $stream['epg_channel_id'];
        $count++;
    }

    // Add EPG programs (limit to 50 channels)
    $count = 0;
    foreach ($streams as $stream) {
        if ($count >= 50) break;
        if (!isset($stream['stream_id']) || !isset($stream['epg_channel_id'])) continue;

        // Get EPG
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => "$external_url/player_api.php?username=$username&password=$password&action=get_short_epg&stream_id={$stream['stream_id']}&limit=12",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $epg_json = curl_exec($ch);
        curl_close($ch);

        $epg = json_decode($epg_json, true);
        if (isset($epg['epg_listings'])) {
            $ch_id = htmlspecialchars($stream['epg_channel_id'], ENT_XML1);

            foreach ($epg['epg_listings'] as $prog) {
                $start = date('YmdHis O', $prog['start_timestamp']);
                $stop = date('YmdHis O', $prog['stop_timestamp']);
                $title = htmlspecialchars(base64_decode($prog['title']), ENT_XML1);
                $desc = htmlspecialchars(base64_decode($prog['description']), ENT_XML1);

                $xml .= "  <programme start=\"$start\" stop=\"$stop\" channel=\"$ch_id\">\n";
                $xml .= "    <title>$title</title>\n";
                $xml .= "    <desc>$desc</desc>\n";
                $xml .= "  </programme>\n";
            }
        }

        $count++;
        usleep(20000); // 20ms delay
    }

    $xml .= '</tv>';
    return $xml;
}

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Just proxy the external panel EPG directly (faster and has all channels)
    $epg_url = 'https://flix-panel.xyz:2087/xmltv.php?username=1231231&password=1231231';

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $epg_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 120,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        // Cache it
        @mkdir(__DIR__ . '/cache', 0755, true);
        file_put_contents($cache_file, $response);
        echo $response;
    } elseif (file_exists($cache_file)) {
        // Use cached version if external panel fails
        readfile($cache_file);
    } else {
        echo '<?xml version="1.0" encoding="utf-8"?><tv></tv>';
    }

} catch (Exception $e) {
    if (file_exists($cache_file)) {
        readfile($cache_file);
    } else {
        echo '<?xml version="1.0" encoding="utf-8"?><tv></tv>';
    }
}
?>
