<?php
/**
 * MidnightStreamer EPG API with Logging
 */

// Log every request
$log = [
    'time' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'uri' => $_SERVER['REQUEST_URI'],
    'get' => $_GET,
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
];
file_put_contents('/tmp/epg_requests.log', json_encode($log) . "\n", FILE_APPEND);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$type = $_GET['type'] ?? 'short';
$stream_id = $_GET['stream_id'] ?? '';
$offset = $_GET['offset'] ?? '';
$limit = $_GET['limit'] ?? '4';
$page = $_GET['page'] ?? '';

// Load config
require_once dirname(dirname(__DIR__)) . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Get panel settings (master credentials)
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM panel_settings");
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }

    $panel_url = rtrim($settings['panel_url'] ?? '', '/');
    $source_user = $settings['panel_username'] ?? '';
    $source_pass = $settings['panel_password'] ?? '';

    // Use LOCAL player_api.php for better performance
    if ($type === 'full_all') {
        // Full EPG for all channels
        $epg_url = "http://localhost/player_api.php?username={$source_user}&password={$source_pass}&action=get_simple_data_table";
    } elseif ($type === 'full') {
        // Full EPG for specific stream
        $epg_url = "http://localhost/player_api.php?username={$source_user}&password={$source_pass}&action=get_simple_data_table&stream_id={$stream_id}";
    } else {
        // Short EPG - use local
        $epg_url = "http://localhost/player_api.php?username={$source_user}&password={$source_pass}&action=get_short_epg&stream_id={$stream_id}&limit={$limit}";
    }

    // Fetch EPG from LOCAL server
    $response = @file_get_contents($epg_url);
    $http_code = $response ? 200 : 404;

    if ($http_code == 200 && $response) {
        $data = json_decode($response, true);

        // Transform XC format to MidnightStreamer format
        if (isset($data['epg_listings']) && is_array($data['epg_listings'])) {
            $result = [];
            foreach ($data['epg_listings'] as $epg) {
                $result[] = [
                    'stream_id' => $stream_id,
                    'title' => $epg['title'] ?? '',
                    'sub_title' => '',
                    'description' => $epg['description'] ?? '',
                    'start' => $epg['start_timestamp'] ?? '',
                    'end' => $epg['stop_timestamp'] ?? '',
                    'mark_archive' => ($epg['has_archive'] ?? 0) == 1
                ];
            }
            echo json_encode($result);
        } else {
            echo json_encode([]);
        }
    } else {
        echo json_encode([]);
    }

} catch (Exception $e) {
    echo json_encode([]);
}
?>
