<?php 
class Bouquets_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $type = [
        '1' => '[live]', 
        '2' => '[movies]', 
        '3' => '[created]', 
        '4' => '[radio]', 
        '5' => '[series]'
    ];
    public $adminRow = [];
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data($this->admin['adminid']);
        if( !in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) && $this->adminRow['manage_streams'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        $intro->db->halt_on_errors = false;
        $result = $intro->db->query('SELECT * from `bouquets` WHERE bouquet_status=0;');
        $totalrows = $intro->db->returned_rows;
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"></icon>') . $intro->lang['bouquets_appname'] . "</a> \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>') . $intro->lang['bouquets_add'] . ("</a>  \t\t \t\t \r\n\t\t<a class=\"btn btn-default\" href=\"" . $this->base . '/index/?bouquet_status=0"><icon class="icon-eye"></icon>Hidden (' . $totalrows . ')</a> ');
        if( in_array($this->admin['level'], [
            1,
            5,
            8,
            9
        ]) )
        {
            echo '<a class="btn btn-warning" href="' . $this->base . "/restore_bq\"><icon class=\"icon-reload\"></icon>Backup/Restore Bouquets </a> \r\n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . '/col"><icon class="icon-bug"></icon>Stream Collison/Duplicated </a> ';
            echo '<a class="btn btn-primary" href="' . $this->base . '/RemoteBouquets"><icon class="icon-cloud"></icon> Remote Bouquets (External Panel)</a> ';
            echo '<a class="btn btn-success" href="' . $this->base . '/SyncNow"><icon class="icon-arrows-cw"></icon> Sync Now from External Panel</a> ';
        }
        echo "\r\n\t\t</div>";
        $intro->db->halt_on_errors = true;
    }
    public function Start()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));

        // Check if stream is On Demand type (type=3)
        $stream_check = $intro->db->query("SELECT type, stream_display_name FROM streams WHERE id=$id LIMIT 1");
        $stream_data = $intro->db->fetch_assoc($stream_check);

        if($stream_data && $stream_data['type'] == 3) {
            echo json_encode([
                'success' => false,
                'message' => 'On Demand streams do not need to be started. They work automatically when users request them.'
            ]);
            return;
        }

        // Call remote API to start stream
        $result = $this->remoteStreamAPI('start', $id);
        echo json_encode($result);
    }

    public function Stop()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));

        // Check if stream is On Demand type (type=3)
        $stream_check = $intro->db->query("SELECT type, stream_display_name FROM streams WHERE id=$id LIMIT 1");
        $stream_data = $intro->db->fetch_assoc($stream_check);

        if($stream_data && $stream_data['type'] == 3) {
            echo json_encode([
                'success' => false,
                'message' => 'On Demand streams are always available. No need to stop them.'
            ]);
            return;
        }

        // Call remote API to stop stream
        $result = $this->remoteStreamAPI('stop', $id);
        echo json_encode($result);
    }

    private function remoteStreamAPI($action, $stream_id)
    {
        $remote_host = '204.188.233.170';
        $remote_port = '8000';
        $api_key = 'eJIdy5sAgD';

        // Build API URL based on documentation
        $url = "http://{$remote_host}:{$remote_port}/api/streams/{$action}/{$api_key}/{$stream_id}";

        // Make the API call
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if($curl_error) {
            return [
                'success' => false,
                'message' => 'Connection error: ' . $curl_error
            ];
        }

        if($http_code != 200) {
            return [
                'success' => false,
                'message' => 'API returned HTTP ' . $http_code,
                'response' => $response
            ];
        }

        $result = json_decode($response, true);

        // Handle API response format
        if($result && isset($result['result'])) {
            return [
                'success' => $result['result'] ? true : false,
                'message' => $result['result'] ? 'Stream ' . $action . ' command sent successfully' : 'Failed to ' . $action . ' stream'
            ];
        }

        if($result && isset($result['success'])) {
            return $result;
        }

        return [
            'success' => true,
            'message' => 'Command sent successfully to remote server',
            'action' => $action,
            'stream_id' => $stream_id
        ];
    }
    public function RestartCycle()
    {
        $this->Restart();
    }

    public function Restart()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));

        // Call remote API to restart stream (stop then start)
        $result = $this->remoteStreamAPI('start', $id);
        echo json_encode($result);
    }
    public function getStreamStatus()
    {
        global $intro;
        global $array;
        $e = new StreamsEdit($this->base, $this->type);
        $e->getStreamStatus();
    }
    public function restore_bq()
    {
        global $intro;
        global $array;
        $intro->db->debug = false;
        $intro->db->halt_on_errors = false;
        $maa = '';
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'bouquet_status\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `bouquets` ADD `bouquet_icon` VARCHAR( 255 ) NOT NULL , ADD `view_order` INT NOT NULL ;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_status` TINYINT(1) NOT NULL AFTER `view_order`;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_for` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `isLocked` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            $intro->db->query('UPDATE `bouquets` SET `bouquet_status`=1;  ');
            $sql2 = $intro->db->query('SELECT data_json from ' . PREFIX . '_data ' . ' WHERE  data_type=1000 AND data_catid=1000 AND data_bqt=1000 AND data_icon=\'bouquets\';');
            if( $intro->db->returned_rows == 1 ) 
            {
                $row2 = $intro->db->fetch_assoc($sql2);
                $xdata = json_decode($row2['data_json'], true);
                foreach( $xdata as $xkey => $xorw ) 
                {
                }
            }
            $maa .= '<h1>Restore bouquet done.</h1>';
        }
        $sql2 = $intro->db->query('SHOW COLUMNS FROM `stream_categories` LIKE \'category_icon\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `stream_categories` ADD `category_icon` VARCHAR( 255 ) NOT NULL AFTER `category_name` ;  ');
            $intro->db->query(' ALTER TABLE `stream_categories` ADD `isLocked` TINYINT(1) NOT NULL AFTER `cat_order` ;  ');
            $maa .= '<h1>Restore category icon done.</h1>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `stream_categories` LIKE \'isLocked\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `stream_categories` ADD `isLocked` TINYINT(1) NOT NULL AFTER `cat_order` ;');
            echo '<br/> stream_categories isLocked added </br>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'bouquet_for\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_for` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            echo '<br/> bouquet_for added </br>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'isLocked\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `bouquets` ADD `isLocked` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            echo '<br/> isLocked added </br>';
        }
        if( $maa != '' ) 
        {
            echo $maa;
            echo '<h1>Finish.</h1>';
        }
        else
        {
            echo '<h1>No need for restore. All ok.</h1>';
            $intro->db->halt_on_errors = true;
            $ar = [];
            $result = $intro->db->query('SELECT * from bouquets ');
            while( $row = $intro->db->fetch_assoc($result) ) 
            {
                $ar[] = $row;
            }
            $data = [];
            $data['data_type'] = 1000;
            $data['data_catid'] = 1000;
            $data['data_bqt'] = 1000;
            $data['data_icon'] = 'bouquets';
            $data['data_json'] = json_encode($ar);
            $sql = $intro->db->query('SELECT data_id from ' . PREFIX . '_data ' . ' WHERE  data_type=1000 AND data_catid=1000 AND data_bqt=1000 AND data_icon=\'bouquets\';');
            if( $intro->db->returned_rows == 1 ) 
            {
                $row = $intro->db->fetch_assoc($sql);
                $intro->db->update('' . PREFIX . '_data', $data, 'data_id=' . intval($row['data_id']) . '');
                echo '<h1>Backup Done.</h1>';
            }
            else if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->insert('' . PREFIX . '_data', $data);
                echo '<h1>Backup Done.</h1>';
            }
        }
    }
    public function index()
    {
        global $intro;
        global $array;

        // Fetch bouquets directly from remote MySQL without local sync
        $bouquets_data = $this->getRemoteBouquetsDirectly();

        $qry = '';
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $bouquet_status = trim($intro->input->get_post('bouquet_status'));
        if( $bouquet_status == '' )
        {
            $bouquet_status = 1;
        }
        $this->nav();

        // Filter bouquets data based on search and status
        if( $search_txt != '' )
        {
            $bouquets_data = array_filter($bouquets_data, function($b) use ($search_txt) {
                return stripos($b['bouquet_name'], $search_txt) !== false;
            });
        }

        if( $bouquet_status != '' )
        {
            $bouquets_data = array_filter($bouquets_data, function($b) use ($bouquet_status) {
                return $b['bouquet_status'] == $bouquet_status;
            });
        }

        // Sort bouquets
        if( $order == '' )
        {
            $order = 'view_order asc';
        } else {
            $order = str_replace(':', ' ', $order);
        }

        $order_parts = explode(' ', $order);
        $order_field = $order_parts[0];
        $order_dir = isset($order_parts[1]) ? strtolower($order_parts[1]) : 'asc';

        usort($bouquets_data, function($a, $b) use ($order_field, $order_dir) {
            $val_a = isset($a[$order_field]) ? $a[$order_field] : 0;
            $val_b = isset($b[$order_field]) ? $b[$order_field] : 0;

            if($order_dir == 'desc') {
                return $val_b <=> $val_a;
            }
            return $val_a <=> $val_b;
        });

        $totalrows = count($bouquets_data);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['bouquets_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t<fieldset>\r\n\t\t\t<form action=\"\" method=\"post\">\r\n\t\t\t\t<input type=\"text\" name=\"search_txt\" value=\"" . $search_txt . '" placeholder="' . $intro->lang['search_form'] . "\" size=\"20\">\r\n\t\t\t\t<input name=\"name\" value=\"" . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t\t</form>\r\n\t\t</fieldset>\r\n\t\t\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\" id='tableBQ'>\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>" . $intro->lang['bouquets_bouquet_name'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_name', 'index') . " </th>\r\n\t\t\t<th># Channels </th>\r\n\t\t\t<th>View Order" . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('view_order', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['bouquets_bouquet_icon'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_icon', 'index') . " </th>\r\n\t\t\t<th>Status " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_status', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        foreach( $bouquets_data as $myrow )
        {
            @extract($myrow);
            $i++;

            // Use total_channels from remote query
            $tot_ch = isset($myrow['total_channels']) ? $myrow['total_channels'] : 0;
            $tot_ser = 0; // Series count not retrieved for performance

            if( $tot_ch < 600 )
            {
                $totals = '<a href="' . $this->base . '/EditChans?id=' . $id . '" class="btn btn-warning icon-edit">(' . $tot_ch . ') channels</a>';
            }
            else
            {
                $totals = '<a class="btn btn-warning icon-edit">(' . $tot_ch . ') channels</a>';
            }
            echo "\r\n\t\t\t<tr id=\"" . $id . '" class="' . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t<td class=\"center\"><input type=\"checkbox\" value=\"" . $id . "\" name=\"selected_fld[]\"></td>\r\n\t\t\t\t<td class=\"center dragHandle\">" . $id . "</td>\r\n\t\t\t\t<td>" . $bouquet_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . $totals . "</td>\r\n\t\t\t\t<td class=\"center\"><span class=\"editable\" data-type=\"text\" data-pk=\"" . $id . '" data-name="view_order">' . $view_order . "</span></td>\r\n\t\t\t\t<td class=\"center\"><img src=\"" . $bouquet_icon . "\" style=\"max-height:50px;\" alt=\"\" /></td>\r\n\t\t\t\t<td class=\"center\"><span class=\"editableVis\" data-type=\"select\" data-pk=\"" . $id . "\" data-name=\"bouquet_status\">\r\n\t\t\t\t\t") . (($bouquet_status == 1 ? '<span class=\'label label-success\'>Visible</span>' : '<span class=\'label label-default\'>Hidden</span>')) . ("\r\n\t\t\t\t</span></td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="') . $intro->lang['edit'] . '"><i class="icon-edit"></i></a>';
            if( in_array($this->admin['level'], [
                1, 
                5, 
                8, 
                9
            ]) ) 
            {
                echo '<a class="btn btn-danger p_del intro_ui_del" href="' . $this->base . '/Del?id=' . $id . '" OnClick="return false;" title="' . $intro->lang['del'] . '"><i class="icon-cancel-circled2"></i></a>';
            }
            echo "\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t</table>\r\n\t\t</div>";
        $order = str_replace(' ', ':', $order);
        if( in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) ) 
        {
            echo "<div class=center>\r\n\t\t\t<a href=\"" . $this->base . "/FixOrder\">Fix View Order</a>\r\n\t\t\t<div id=\"AjaxResult\">.....</div>\r\n\t\t</div>";
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo '</fieldset>';
        echo "<style>\r\n\t\t#table-1 tr td:first-child\r\n\t\t{\r\n\t\t\tcursor:move;\r\n\t\t}\r\n\t\t.ui-state-highlight\r\n\t\t{\r\n\t\t\tborder:1px dotted #ccc;\r\n\t\t\tcursor:move;\r\n\t\t}\r\n\t\t</style>\r\n\t\t<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$( \"#tableBQ>tbody\" ).sortable({\r\n\t\t\t\tplaceholder : \"ui-state-highlight\",\r\n\t\t\t\tupdate  : function(event, ui)\r\n\t\t\t\t{\r\n\t\t\t\t\tvar All_IDs = new Array();\r\n\t\t\t\t\t\$('#tableBQ>tbody>tr').each(function(){\r\n\t\t\t\t\t\tAll_IDs.push(\$(this).attr(\"id\"));\r\n\t\t\t\t\t});\r\n\t\t\t\t\t\$.ajax({\r\n\t\t\t\t\t\turl:\"" . $this->base . "/doSort?noHeader=1&NH=1\",\r\n\t\t\t\t\t\tmethod:\"POST\",\r\n\t\t\t\t\t\tdata:{All_IDs:All_IDs},\r\n\t\t\t\t\t\tsuccess:function(data)\r\n\t\t\t\t\t\t{\r\n\t\t\t\t\t\t\t\$('#AjaxResult').html(data);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t});\r\n\t\t\t\t}\r\n\t\t\t});\r\n\r\n\t\t});\r\n\t\t/* inline */\r\n\t\t\$.fn.editable.defaults.mode = 'inline';     \r\n\t\t\$('.editable').editable({\r\n\t\t\turl: '" . $this->base . "/EditInPlace?NH=1',\r\n\t\t\tsuccess: function(response) {\r\n\t\t\t/*alert(response);*/\r\n\t\t\t}\r\n\t\t});\r\n\t\t\$('.editableVis').editable({\r\n\t\t\t\turl: '" . $this->base . "/EditInPlace?NH=1',\r\n\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t/*alert(response);*/\r\n\t\t\t\t},\r\n\t\t\t\t/*value: 2,*/\r\n\t\t\t\tsource: [{value: '1', text: 'Visibile'},{value: '0', text: 'Hidden'}]\r\n\t\t\t});\r\n\t\t</script>";
    }
    public function EditInPlace()
    {
        global $intro;
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data = [];
        $data[$name] = $value;
        $intro->db->update('bouquets', $data, 'id=' . $id);
    }
    public function doSort()
    {
        global $intro;
        $data_id = '';
        $menu = $intro->input->get_post('All_IDs');
        $j = 0;
        for( $i = 0; $i < count($menu); $i++ ) 
        {
            $j++;
            $id = intval($menu[$i]);
            $data_id .= ($i . ' ');
            $intro->db->query('UPDATE bouquets SET view_order=' . $j . ' WHERE id=' . $id . ' ');
        }
        echo ' :: Sort Done :: ' . $data_id;
    }
    public function FixOrder()
    {
        global $intro;
        $sql = $intro->db->query('select id from bouquets order by view_order ASC');
        $w1 = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $w1++;
            $id = intval($row['id']);
            $intro->db->query('UPDATE bouquets SET view_order=' . $w1 . ' WHERE id=' . $id . ' ');
        }
        $intro->redirect($this->appname);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $bouquet_name;
        global $bouquet_icon;
        global $bouquet_status;
        global $bouquet_series;
        global $bouquet_channels;
        global $isLocked;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        echo '<script type="text/javascript" src="' . admin_path . "style/multi-select/jquery.min.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/jquery-ui.min.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/multiselect.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/multiselect_custom.js\"></script>\r\n\t\t<style>\r\n\t\t.centerButtons {\r\n\t\ttext-align:center;\r\n\t\t}\r\n\t\t.centerButtons div{\r\n\t\tmargin-top:10px;\r\n\t\t}\r\n\t\tselect#search, select#search_to\r\n\t\t{\r\n\t\tmin-height:400px;\r\n\t\twidth:100%;\r\n\t\tfont-size:14px;\r\n\t\t}\r\n\t\t#search option,#search_to option{\r\n\t\tmargin-top:5px;\r\n\t\tpadding:8px 12px;\r\n\t\tborder-radius:4px;\r\n\t\tbackground: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);\r\n\t\tborder:1px solid #ddd;\r\n\t\tcursor:pointer;\r\n\t\t}\r\n\t\t#search_to option{\r\n\t\tbackground: linear-gradient(135deg, #e0f7fa 0%, #b2ebf2 100%);\r\n\t\tborder-left:4px solid #00bcd4;\r\n\t\tfont-weight:500;\r\n\t\t}\r\n\t\t#search_to option:hover{\r\n\t\tbackground: linear-gradient(135deg, #fff9c4 0%, #fff59d 100%);\r\n\t\ttransform:translateX(5px);\r\n\t\ttransition:all 0.3s;\r\n\t\t}\r\n\t\t.ordering-controls{\r\n\t\tmargin-top:15px;\r\n\t\tpadding:15px;\r\n\t\tbackground:linear-gradient(135deg, #667eea 0%, #764ba2 100%);\r\n\t\tborder-radius:12px;\r\n\t\tbox-shadow:0 4px 15px rgba(102, 126, 234, 0.3);\r\n\t\t}\r\n\t\t.ordering-controls .btn{\r\n\t\tmargin:5px;\r\n\t\tpadding:10px 20px;\r\n\t\tfont-size:14px;\r\n\t\tfont-weight:bold;\r\n\t\tborder:2px solid white;\r\n\t\tbox-shadow:0 2px 8px rgba(0,0,0,0.2);\r\n\t\t}\r\n\t\t.ordering-controls .btn:hover{\r\n\t\ttransform:translateY(-3px);\r\n\t\tbox-shadow:0 4px 12px rgba(0,0,0,0.3);\r\n\t\ttransition:all 0.3s;\r\n\t\t}\r\n\t\t.btn-move-top{background:#4caf50 !important; color:white !important;}\r\n\t\t.btn-move-bottom{background:#f44336 !important; color:white !important;}\r\n\t\t.btn-move-up{background:#2196f3 !important; color:white !important;}\r\n\t\t.btn-move-down{background:#ff9800 !important; color:white !important;}\r\n\t\t.btn-sort-az{background:#9c27b0 !important; color:white !important;}\r\n\t\t.btn-sort-za{background:#e91e63 !important; color:white !important;}\r\n\t\t.order-number{\r\n\t\tfont-weight:bold;\r\n\t\tcolor:#00796b;\r\n\t\tbackground:#e0f2f1;\r\n\t\tpadding:2px 8px;\r\n\t\tborder-radius:12px;\r\n\t\tmargin-right:8px;\r\n\t\tfont-size:11px;\r\n\t\t}\r\n\t\t</style>";
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM bouquets where id=\'' . $id . '\'');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $bouquet_channels = $row['bouquet_channels'];
            $bouquet_series = $row['bouquet_series'];
            $btn['legend_name'] = $intro->lang['bouquets_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = 'Save Changes';
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['bouquets_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Add New';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $isLocked = ($isLocked == '' ? 0 : $isLocked);
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        $max_input_vars = @ini_get('max_input_vars');
        $max_input_vars = intval($max_input_vars);
        if( $max_input_vars < 20000 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning! You can add only (' . ($max_input_vars - 10) . ") streams to this bouquet.\r\n\t\t\t<br/> Ask you system admin to increase (max_input_vars) in php.ini file.", 'danger');
        }
        echo '<form method="POST"  action="' . $this->base . '/' . $btn['action'] . "\">\r\n\t\t\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>" . $intro->lang['bouquets_bouquet_name'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t\t\t<td><input  type=\"text\" name=\"bouquet_name\" value=\"" . $bouquet_name . '"  class="form-control"> ' . $this->error('bouquet_name') . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>") . $intro->lang['bouquets_bouquet_icon'] . ("</td>\r\n\t\t\t\t\t\t<td><input  type=\"text\" name=\"bouquet_icon\" value=\"" . $bouquet_icon . '" class="form-control"> ' . $this->error('bouquet_icon') . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Status :</td>\r\n\t\t\t\t\t\t<td>") . $this->bouquet_status($bouquet_status) . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>" . tooltip('tooltip_bouquet', 'isLocked') . " Locked :</td>\r\n\t\t\t\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('isLocked', $isLocked) . "</td>\r\n\t\t\t\t\t</tr>";
        echo "\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Streams :</td>\r\n\t\t\t\t\t\t<td>";
        $array = [];
        $optionsfisrt = $options_right = '';
        if( $t == 'edit' ) 
        {
            $chans = json_decode($bouquet_channels, true);
            if( is_array($chans) && count($chans) > 0 ) 
            {
                $array = array_map('intval', $chans);
                $array = implode(',', $array);
                $sql = $intro->db->query('SELECT id,stream_display_name,type ' . (' FROM  `streams` WHERE type!=5 AND id IN (' . $array . ')  ') . (' ORDER BY FIELD(id,' . $array . ') /*ORDER BY `order` ASC*/'));
                while( $myrowsql = $intro->db->fetch_assoc($sql) ) 
                {
                    $type = $myrowsql['type'];
                    $type_name = $this->type[$type];
                    $options_right .= ('<option value=\'' . $type . '|' . $myrowsql['id'] . '\'>' . $type_name . ' ' . $myrowsql['stream_display_name'] . '</option>');
                }
            }
            $options_right .= $this->series_right($bouquet_series);
        }
        $qq = '';
        if( $t == 'edit' && is_array($array) && count($array) > 0 ) 
        {
            $qq = ' AND id not IN (' . $array . ')';
        }
        $sql2 = $intro->db->query('SELECT id,stream_display_name,type FROM  `streams` where type!=5  ' . $qq . ' ORDER BY `type` ASC , `order` ASC');
        while( $myrowsql = $intro->db->fetch_assoc($sql2) ) 
        {
            $type = $myrowsql['type'];
            $type_name = $this->type[$type];
            $optionsfisrt .= ('<option value=\'' . $type . '|' . $myrowsql['id'] . '\'>' . $type_name . ' ' . $myrowsql['stream_display_name'] . '</option>');
        }
        $optionsfisrt .= $this->series_left($bouquet_series, $t);
        echo "\r\n\t\t\t\t<div class=\"row\">\r\n\t\t\t\t<div class=\"col-xs-5\">\r\n\t\t\t\t\t<h4 style='color:#666; margin-bottom:10px;'><i class='icon-list'></i> Available Channels</h4>\r\n\t\t\t\t\t<select name=\"\" id=\"search\" style=\"background:#f2f2f2;\" size=\"20\" multiple=\"multiple\">\r\n\t\t\t\t\t\t" . $optionsfisrt . "\r\n\t\t\t\t\t</select>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class=\"col-xs-2 centerButtons\">\r\n\t\t\t\t\t<div><a id=\"search_rightAll\" class=\"btn btn-info\" title=\"Add All\"><i class=\"glyphicon glyphicon-forward\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_rightSelected\" class=\"btn btn-info\" title=\"Add Selected\"><i class=\"glyphicon glyphicon-chevron-right\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_leftSelected\" class=\"btn btn-info\" title=\"Remove Selected\"><i class=\"glyphicon glyphicon-chevron-left\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_leftAll\" class=\"btn btn-info\" title=\"Remove All\"><i class=\"glyphicon glyphicon-backward\"></i></a></div>\r\n\t\t\t\t</div>\r\n\r\n\t\t\t\t<div class=\"col-xs-5\">\r\n\t\t\t\t\t<h4 style='color:#00796b; margin-bottom:10px;'><i class='icon-ok-circled'></i> Selected Channels <span id='channelCount' style='font-size:14px; color:#999;'>(0)</span></h4>\r\n\t\t\t\t\t<select name=\"to[]\" id=\"search_to\" style=\"background:#f2f2f2;\" size=\"20\" multiple=\"multiple\" class=\"ui-droppable\">\r\n\t\t\t\t\t" . $options_right . "\r\n\t\t\t\t\t</select>\r\n\t\t\t\t\r\n\t\t\t\t\t<div class='ordering-controls'>\r\n\t\t\t\t\t\t<div style='text-align:center; margin-bottom:10px;'>\r\n\t\t\t\t\t\t\t<strong style='color:white; font-size:16px;'><i class='icon-sort'></i> Ordering Controls</strong>\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div style='text-align:center;'>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-move-top' id='btnMoveTop' title='Move to Top'>\r\n\t\t\t\t\t\t\t\t<i class='glyphicon glyphicon-arrow-up'></i> <strong>TOP</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-move-up' id='btnMoveUp' title='Move Up'>\r\n\t\t\t\t\t\t\t\t<i class='glyphicon glyphicon-chevron-up'></i> <strong>UP</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-move-down' id='btnMoveDown' title='Move Down'>\r\n\t\t\t\t\t\t\t\t<i class='glyphicon glyphicon-chevron-down'></i> <strong>DOWN</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-move-bottom' id='btnMoveBottom' title='Move to Bottom'>\r\n\t\t\t\t\t\t\t\t<i class='glyphicon glyphicon-arrow-down'></i> <strong>BOTTOM</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div style='text-align:center; margin-top:10px;'>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-sort-az' id='btnSortAZ' title='Sort A to Z'>\r\n\t\t\t\t\t\t\t\t<i class='icon-sort-alphabet'></i> <strong>A-Z</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t\t<button type='button' class='btn btn-sort-za' id='btnSortZA' title='Sort Z to A'>\r\n\t\t\t\t\t\t\t\t<i class='icon-sort-alphabet-alt'></i> <strong>Z-A</strong>\r\n\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t\t</div>";
        echo "</td>\r\n\t\t\t</tr>";
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\" style='font-size:16px; padding:12px 30px;'>\r\n\t\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t\t</button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>\r\n\t\t\t<script>\r\n\t\t\tjQuery(document).ready(function($) {\r\n\t\t\t\t// Update channel count\r\n\t\t\t\tfunction updateChannelCount() {\r\n\t\t\t\t\tvar count = $('#search_to option').length;\r\n\t\t\t\t\t$('#channelCount').text('(' + count + ')');\r\n\t\t\t\t\tupdateOrderNumbers();\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t\t// Add order numbers to options\r\n\t\t\t\tfunction updateOrderNumbers() {\r\n\t\t\t\t\t$('#search_to option').each(function(index) {\r\n\t\t\t\t\t\tvar text = $(this).text();\r\n\t\t\t\t\t\t// Remove old order number if exists\r\n\t\t\t\t\t\ttext = text.replace(/^\\[\\d+\\]\\s*/, '');\r\n\t\t\t\t\t\t// Add new order number\r\n\t\t\t\t\t\t$(this).text('[' + (index + 1) + '] ' + text);\r\n\t\t\t\t\t});\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t\t// Move to Top\r\n\t\t\t\t$('#btnMoveTop').click(function() {\r\n\t\t\t\t\tvar selected = $('#search_to option:selected');\r\n\t\t\t\t\tif(selected.length === 0) {\r\n\t\t\t\t\t\talert('Please select a channel first');\r\n\t\t\t\t\t\treturn;\r\n\t\t\t\t\t}\r\n\t\t\t\t\t$('#search_to').prepend(selected);\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Move Up\r\n\t\t\t\t$('#btnMoveUp').click(function() {\r\n\t\t\t\t\tvar selected = $('#search_to option:selected');\r\n\t\t\t\t\tif(selected.length === 0) {\r\n\t\t\t\t\t\talert('Please select a channel first');\r\n\t\t\t\t\t\treturn;\r\n\t\t\t\t\t}\r\n\t\t\t\t\tselected.each(function() {\r\n\t\t\t\t\t\tvar prev = $(this).prev();\r\n\t\t\t\t\t\tif(prev.length > 0) {\r\n\t\t\t\t\t\t\t$(this).insertBefore(prev);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t});\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Move Down\r\n\t\t\t\t$('#btnMoveDown').click(function() {\r\n\t\t\t\t\tvar selected = $('#search_to option:selected');\r\n\t\t\t\t\tif(selected.length === 0) {\r\n\t\t\t\t\t\talert('Please select a channel first');\r\n\t\t\t\t\t\treturn;\r\n\t\t\t\t\t}\r\n\t\t\t\t\t$(selected.get().reverse()).each(function() {\r\n\t\t\t\t\t\tvar next = $(this).next();\r\n\t\t\t\t\t\tif(next.length > 0) {\r\n\t\t\t\t\t\t\t$(this).insertAfter(next);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t});\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Move to Bottom\r\n\t\t\t\t$('#btnMoveBottom').click(function() {\r\n\t\t\t\t\tvar selected = $('#search_to option:selected');\r\n\t\t\t\t\tif(selected.length === 0) {\r\n\t\t\t\t\t\talert('Please select a channel first');\r\n\t\t\t\t\t\treturn;\r\n\t\t\t\t\t}\r\n\t\t\t\t\t$('#search_to').append(selected);\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Sort A-Z\r\n\t\t\t\t$('#btnSortAZ').click(function() {\r\n\t\t\t\t\tvar options = $('#search_to option');\r\n\t\t\t\t\tvar arr = options.map(function(_, o) { return { t: $(o).text(), v: $(o).val() }; }).get();\r\n\t\t\t\t\tarr.sort(function(a, b) { return a.t.localeCompare(b.t); });\r\n\t\t\t\t\toptions.each(function(i, o) {\r\n\t\t\t\t\t\to.text = arr[i].t;\r\n\t\t\t\t\t\to.value = arr[i].v;\r\n\t\t\t\t\t});\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Sort Z-A\r\n\t\t\t\t$('#btnSortZA').click(function() {\r\n\t\t\t\t\tvar options = $('#search_to option');\r\n\t\t\t\t\tvar arr = options.map(function(_, o) { return { t: $(o).text(), v: $(o).val() }; }).get();\r\n\t\t\t\t\tarr.sort(function(a, b) { return b.t.localeCompare(a.t); });\r\n\t\t\t\t\toptions.each(function(i, o) {\r\n\t\t\t\t\t\to.text = arr[i].t;\r\n\t\t\t\t\t\to.value = arr[i].v;\r\n\t\t\t\t\t});\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t// Update count on page load and when items change\r\n\t\t\t\tupdateChannelCount();\r\n\t\t\t\t\r\n\t\t\t\t// Monitor changes to search_to\r\n\t\t\t\tvar observer = new MutationObserver(function() {\r\n\t\t\t\t\tupdateChannelCount();\r\n\t\t\t\t});\r\n\t\t\t\tvar searchTo = document.getElementById('search_to');\r\n\t\t\t\tif(searchTo) {\r\n\t\t\t\t\tobserver.observe(searchTo, { childList: true });\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t\t// Select all items before submit to ensure they're posted\r\n\t\t\t\t$('form').submit(function() {\r\n\t\t\t\t\t$('#search_to option').prop('selected', true);\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t\t</script>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function series_left($bouquet_series, $t)
    {
        global $intro;
        global $array;
        $html = '';
        $qry = '';
        if( $t == 'edit' ) 
        {
            $chans = json_decode($bouquet_series, true);
            if( is_array($chans) && count($chans) > 0 ) 
            {
                $array = array_map('intval', $chans);
                $array = implode(',', $array);
                $qry = ' WHERE id not IN (' . $array . ') ';
            }
        }
        $result = $intro->db->query('SELECT id,title FROM `series` ' . $qry . ' ORDER BY `last_modified` DESC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $html .= ('<option  value="5|' . $id . '">[series] ' . $title . ' </option>');
        }
        return $html;
    }
    public function series_right($bouquet_series)
    {
        global $intro;
        global $array;
        $html = '';
        $chans = json_decode($bouquet_series, true);
        if( is_array($chans) && count($chans) > 0 ) 
        {
            $array = array_map('intval', $chans);
            $array = implode(',', $array);
            $result = $intro->db->query('SELECT id,title FROM `series` WHERE id IN (' . $array . ') ORDER BY `last_modified` DESC');
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                @extract($myrow);
                $html .= ('<option  value="5|' . $id . '">[series]' . $title . '</option>');
            }
        }
        return $html;
    }
    public function Stream_Chanels_found($id)
    {
        global $intro;
        global $array;
        $bouquet_channels = '';
        $result = $intro->db->query('SELECT * FROM  bouquets WHERE id=\'' . $id . '\' ');
        $myrow = $intro->db->fetch_assoc($result);
        @extract($myrow);
        $bouquet_channels = json_decode($myrow['bouquet_channels']);
        return $bouquet_channels;
    }
    public function Stream_Chanels()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streams` WHERE type!=5 order by `order` ASC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<option  value="' . $id . '">' . $stream_display_name . ' </option>';
        }
    }
    public function bouquet_status($bouquet_status)
    {
        global $intro;
        global $error;
        if( $bouquet_status == '' ) 
        {
            $bouquet_status = 1;
        }
        $html = "<label class=\"radio-inline\">\r\n\t\t\t\t<input type=\"radio\" name=\"bouquet_status\" value='1' " . (($bouquet_status == 1 ? 'checked' : '')) . ">\r\n\t\t\t\t\t<span class='label label-success'>Visibile To Resellers</span>\r\n\t\t\t\t</label>\r\n\t\t\t<label class=\"radio-inline\">\r\n\t\t\t\t<input type=\"radio\" name=\"bouquet_status\" value='0' " . (($bouquet_status == 0 ? 'checked' : '')) . ">\r\n\t\t\t\t<span class='label label-default'>Hidden</span>\r\n\t\t\t</label>";
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $added_series = $intro->input->post('added_series');
        $added_streams = $intro->input->post('added_streams');
        $added_movies = $intro->input->post('added_movies');
        $bouquet_name = trim($intro->input->post('bouquet_name'));
        $bouquet_icon = trim($intro->input->post('bouquet_icon'));
        $bouquet_status = intval($intro->input->post('bouquet_status'));
        if( $bouquet_name == '' ) 
        {
            if( $bouquet_name == '' ) 
            {
                $error['bouquet_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['bouquet_name'] = $bouquet_name;
        $data['bouquet_icon'] = $bouquet_icon;
        $data['bouquet_status'] = $bouquet_status;
        $data_to = $intro->input->post('to');
        if( is_array($data_to) && count($data_to) > 0 ) 
        {
            foreach( $data_to as $id ) 
            {
                list($type, $strm_id) = explode('|', $id);
                if( $type == 5 ) 
                {
                    $ar_series[] = $strm_id;
                }
                else
                {
                    $ar_streams[] = $strm_id;
                }
            }
            if( count($ar_streams) > 0 ) 
            {
                $data['bouquet_channels'] = json_encode($ar_streams);
            }
            else
            {
                $data['bouquet_channels'] = '[]';
            }
            if( count($ar_series) > 0 ) 
            {
                $data['bouquet_series'] = json_encode($ar_series);
            }
            else
            {
                $data['bouquet_series'] = '[]';
            }
        }
        $intro->db->insert('bouquets', $data);

        // Log the add operation
        error_log("doAdd: Bouquet Name=$bouquet_name, Channels=" . (isset($ar_streams) ? count($ar_streams) : 0));

        // Sync to remote database (204.188.233.170)
        // 1. Add bouquet to remote
        $this->addBouquetToRemote($bouquet_name);

        // 2. Sync streams/channels to remote
        if(isset($ar_streams) && is_array($ar_streams) && count($ar_streams) > 0) {
            error_log("doAdd: Syncing " . count($ar_streams) . " streams to remote for new bouquet '$bouquet_name'");
            sleep(1); // Wait for remote insert to complete
            $this->syncBouquetStreamsToRemote($bouquet_name, $ar_streams);
        }

        $intro->redirect($this->appname);
    }

    private function addBouquetToRemote($name)
    {
        $sql = "INSERT INTO bouquets (name, ordering) VALUES ('" . addslashes($name) . "', 0);";
        return $this->remoteDbExecute($sql);
    }

    private function updateBouquetInRemote($old_name, $new_name)
    {
        $sql = "UPDATE bouquets SET name='" . addslashes($new_name) . "' WHERE name='" . addslashes($old_name) . "';";
        return $this->remoteDbExecute($sql);
    }

    private function deleteBouquetFromRemote($name)
    {
        // Get bouquet ID first
        $sql = "SELECT id FROM bouquets WHERE name='" . addslashes($name) . "';";
        $result = trim($this->remoteDbExecute($sql));
        if(!empty($result) && is_numeric($result)) {
            $bid = intval($result);
            // Delete stream relations
            $this->remoteDbExecute("DELETE FROM bouquets_sids WHERE bid=$bid;");
            // Delete bouquet
            $this->remoteDbExecute("DELETE FROM bouquets WHERE id=$bid;");
        }
        return true;
    }

    private function syncBouquetStreamsToRemote($bouquet_name, $stream_ids)
    {
        // Get remote bouquet ID
        $sql = "SELECT id FROM bouquets WHERE name='" . addslashes($bouquet_name) . "';";
        $result = trim($this->remoteDbExecute($sql));

        if(empty($result) || !is_numeric($result)) {
            error_log("syncBouquetStreamsToRemote: Bouquet '$bouquet_name' not found on remote");
            return false;
        }

        $bid = intval($result);
        error_log("syncBouquetStreamsToRemote: Bouquet '$bouquet_name' (bid=$bid) - syncing " . count($stream_ids) . " streams");

        // Clear existing streams for this bouquet
        $this->remoteDbExecute("DELETE FROM bouquets_sids WHERE bid=$bid;");

        // Add new streams
        if(is_array($stream_ids) && count($stream_ids) > 0) {
            $ordering = 0;
            foreach($stream_ids as $sid) {
                $sid = intval($sid);
                if($sid > 0) {
                    $sql = "INSERT INTO bouquets_sids (bid, sid, e2, ordering) VALUES ($bid, $sid, 0, $ordering);";
                    $this->remoteDbExecute($sql);
                    $ordering++;
                }
            }
            error_log("syncBouquetStreamsToRemote: Successfully synced $ordering streams to remote bouquet $bid");
        } else {
            error_log("syncBouquetStreamsToRemote: No streams to sync for bouquet $bid");
        }

        return true;
    }

    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;
        global $bouquet_channels;
        $id = intval($intro->input->post('id'));
        $data = [];
        $data['bouquet_name'] = trim($intro->input->post('bouquet_name'));
        $data['bouquet_icon'] = trim($intro->input->post('bouquet_icon'));
        $data['bouquet_status'] = intval($intro->input->post('bouquet_status'));
        $ar_streams = $ar_series = [];
        $data_to = $intro->input->post('to');
        if( is_array($data_to) && count($data_to) > 0 ) 
        {
            foreach( $data_to as $Postid ) 
            {
                list($type, $strm_id) = explode('|', $Postid);
                if( $type == 5 ) 
                {
                    $ar_series[] = $strm_id;
                }
                else
                {
                    $ar_streams[] = $strm_id;
                }
            }
            if( count($ar_streams) > 0 ) 
            {
                $data['bouquet_channels'] = json_encode($ar_streams);
            }
            else
            {
                $data['bouquet_channels'] = '[]';
            }
            if( count($ar_series) > 0 ) 
            {
                $data['bouquet_series'] = json_encode($ar_series);
            }
            else
            {
                $data['bouquet_series'] = '[]';
            }
        }
        // Get old name for remote update
        $old_row = $intro->db->query("SELECT bouquet_name FROM bouquets WHERE id=$id");
        $old_data = $intro->db->fetch_assoc($old_row);
        $old_name = $old_data['bouquet_name'];

        $intro->db->update('bouquets', $data, 'id=' . $id);
        $aff = $intro->db->affected_rows;

        // Log the edit operation
        error_log("doEdit: Bouquet ID=$id, Name={$data['bouquet_name']}, Channels=" . (isset($ar_streams) ? count($ar_streams) : 0));

        // Sync to remote database (204.188.233.170)
        // 1. Update bouquet name if changed
        if($old_name != $data['bouquet_name']) {
            error_log("doEdit: Bouquet name changed from '$old_name' to '{$data['bouquet_name']}' - updating remote");
            $this->updateBouquetInRemote($old_name, $data['bouquet_name']);
        }

        // 2. Always sync streams/channels to remote (even if name didn't change)
        if(isset($ar_streams) && is_array($ar_streams)) {
            error_log("doEdit: Syncing " . count($ar_streams) . " streams to remote for bouquet '{$data['bouquet_name']}'");
            $this->syncBouquetStreamsToRemote($data['bouquet_name'], $ar_streams);
        } else {
            error_log("doEdit: Clearing streams from remote for bouquet '{$data['bouquet_name']}'");
            $this->syncBouquetStreamsToRemote($data['bouquet_name'], []);
        }

        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        // Get bouquet name before delete for remote sync
        $row = $intro->db->query('SELECT bouquet_name FROM bouquets WHERE id=' . $id);
        $data = $intro->db->fetch_assoc($row);
        $bouquet_name = $data['bouquet_name'];

        $sql = $intro->db->query('DELETE FROM bouquets WHERE id=' . $id . ' ');

        // Sync delete to remote database (204.188.233.170)
        $this->deleteBouquetFromRemote($bouquet_name);

        $intro->redirect($this->appname);
    }
    public function EditChans()
    {
        global $intro;
        global $array;
        $qry = '';
        $edit = new StreamsEdit($this->base);
        $id = intval($intro->input->get_post('id'));
        $this->nav();
        $result = $intro->db->query('SELECT * from bouquets WHERE id=' . $id . ';');
        $myrow = $intro->db->fetch_assoc($result);
        extract($myrow);
        $chans = json_decode($bouquet_channels, true);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h3><i class="icon-edit"></i>' . $bouquet_name . '</h3>', 'info');
        $edit->TableStart();
        $i = 0;
        if( is_array($chans) && count($chans) > 0 ) 
        {
            foreach( $chans as $chID ) 
            {
                $i++;
                $sql = $intro->db->query('SELECT * ,(select count(*) from user_activity_now where stream_id=s.id) as tot  from streams s  LEFT JOIN `streams_sys` sys ON s.id=sys.stream_id where s.id=' . intval($chID));
                $row = $intro->db->fetch_assoc($sql);
                if( !$row ) 
                {
                    continue;
                }
                $edit->Row($row, $i);
            }
        }
        echo "</tbody>\r\n\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        $edit->JavaScript();
    }
    public function EditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base);
        $edit->EditChannel();
    }
    public function doEditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base);
        $edit->doEditChannel();
    }
    public function getStreams($bouquet_channels, $t)
    {
        global $intro;
        global $array;
        return '';
        $cur_chans = json_decode($bouquet_channels, true);
        echo '<select multiple="multiple" size="10" name="BqChans[]" id="sourceSelect">';
        $result = $intro->db->query('select id,stream_display_name,category_id,type from streams WHERE type IN (1,2,3,4) Order by type ASC ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $type == 1 ) 
            {
                $type = 'Live';
            }
            if( $type == 2 ) 
            {
                $type = 'Movie';
            }
            if( $type == 3 ) 
            {
                $type = 'Created';
            }
            echo '<option value="' . $id . '" ' . ((is_array($cur_chans) && in_array($id, $cur_chans) ? 'selected=\'\'' : '')) . ('>[' . $type . '] ' . $stream_display_name . '</option>');
        }
        echo '</select>';
    }
    public function getChannels($bouquet_channels, $bouquet_series)
    {
        global $intro;
        global $array;
        $chans = json_decode($bouquet_channels, true);
        $qry = implode(',', $chans);
        if( $qry == '' ) 
        {
            $qry = 0;
        }
        $result = $intro->db->query('select id,stream_display_name,category_id,type from streams WHERE id IN (' . $qry . ') ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<li>' . $category_id . ' = ' . $stream_display_name . '</li>';
        }
        echo '<ul>';
        $chans = json_decode($bouquet_series, true);
        $qry = implode(',', $chans);
        if( $qry == '' ) 
        {
            $qry = 0;
        }
        $result = $intro->db->query('select * from series WHERE id IN (' . $qry . ') ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<li>' . $category_id . ' = ' . $title . '</li>';
        }
        echo '</ul>';
    }
    public function copy_cat()
    {
        global $intro;
        $sql = $intro->db->query('select * from bouquets order by view_order ASC');
        $bq = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $ch = json_decode($row['bouquet_channels'], true);
            $ser = json_decode($row['bouquet_series'], true);
            $tot_ch = (is_array($ch) ? count($ch) : 0);
            $tot_ser = (is_array($ser) ? count($ser) : 0);
            $bq[$id] = $bouquet_name . (' (' . $tot_ch . ') ') . (($tot_ser > 0 ? ' (Series=' . $tot_ser . ')' : ''));
        }
        $sql = $intro->db->query('select * ,(select count(id) from streams where category_id=st_cat.id) as tot_streams  from stream_categories st_cat where st_cat.category_type=\'live\' order by st_cat.cat_order ASC');
        $cats = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $cats[$id] = $category_name . (' (' . $tot_streams . ')');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>Make streams of bouquet=category</h3>', 'warning');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doCopy_bq2cat\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Bouquet:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('bq', $bq, 0, 'Choose Bouquet') . "</td>\r\n\t\t\t<td>Category:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('cat', $cats, 0, 'Choose Category') . "</td>\r\n\t\t\t\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\tThis clear all streams for target (Category) and copy all streams form selected (Bouquet)\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t\tMake Channels of Bouquet = Category\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>Make streams of category=bouquet</h3>', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doCopy_cat2bq\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Category:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('cat', $cats, 0, 'Choose Category') . "</td>\r\n\t\t\t<td>Bouquet:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('bq', $bq, 0, 'Choose Bouquet') . "</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t\tMake Channels of Category = Bouquet\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\t\$( document ).ready(function() {\r\n\t\t\t\t\$('.chosen-drop').css({minWidth: '400px', width: 'auto'});\r\n\t\t\t\t\$('.chosen-select').each(function() {\r\n\t\t\t\t\tvar itm = \$(this);\r\n\t\t\t\t\titm.next().css({'width': '225px'});\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t</script>";
    }
    public function doCopy_bq2cat()
    {
        global $intro;
        $bq = intval($intro->input->post('bq'));
        $cat = intval($intro->input->post('cat'));
        $aff = $cleared_cat = 0;
        if( $cat == 0 || $bq == 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error you must chose both sides', 'danger') );
        }
        $sql = $intro->db->query('select bouquet_channels from bouquets where id=' . $bq . ';');
        $streams = [];
        $row = $intro->db->fetch_assoc($sql);
        $ch = json_decode($row['bouquet_channels'], true);
        $intro->db->query('START TRANSACTION;');
        if( is_array($ch) && count($ch) > 1 ) 
        {
            $intro->db->query('UPDATE streams SET category_id=0 where category_id=' . $cat . ';');
            $cleared_cat = $intro->db->affected_rows;
            $aff = 0;
            foreach( $ch as $id ) 
            {
                $intro->db->update('streams', ['category_id' => $cat], 'id=\'' . $id . '\'');
                $aff += $intro->db->affected_rows;
            }
        }
        $intro->db->query('COMMIT;');
        $intro->redirect($this->appname, 'copy_cat', '?affected=' . $aff . '&amp;cleared_ch_from_cat=' . $cleared_cat);
    }
    public function doCopy_cat2bq()
    {
        global $intro;
        $bq = intval($intro->input->post('bq'));
        $cat = intval($intro->input->post('cat'));
        if( $cat == 0 || $bq == 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error you must chose both sides', 'danger') );
        }
        $sql = $intro->db->query('select id from streams where category_id=' . $cat . ' order by `order` ASC');
        $streams = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $streams[] = $id;
        }
        if( count($streams) <= 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error: selected bouquet is empty', 'danger') );
        }
        $intro->db->update('bouquets', ['bouquet_channels' => json_encode($streams)], 'id=' . $bq);
        $aff = $intro->db->affected_rows;
        $intro->redirect($this->appname, 'copy_cat', '?affected=' . $aff);
    }
    public function col()
    {
        global $intro;
        $sql = $intro->db->query('CREATE  TABLE IF NOT EXISTS `solus_bq_col` (`bq` int(11) NOT NULL,`ch` int(11) NOT NULL,KEY `bq` (`bq`),KEY `ch` (`ch`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;');
        $sql = $intro->db->query('delete from solus_bq_col where true;');
        $sql = $intro->db->query('truncate solus_bq_col;');
        $sql = $intro->db->query('SELECT * from bouquets order by view_order ASC;');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Find Duplicated Streams Across Bouquets', 'danger');
        echo "<h5 class='red'>This tool helps you find duplicated streams between Bouquets.<br/>\r\n\t\tSometimes by mistake a wrong stream added to wrong Bouquet and all streams on m3u get wrong Order.</h5>";
        $all_chans = $found = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $id = $row['id'];
            $bouquet_name = $row['bouquet_name'];
            $bouquet_channels = json_decode($row['bouquet_channels'], true);
            $bouquet_series = json_decode($row['bouquet_series'], true);
            foreach( $bouquet_channels as $ch ) 
            {
                if( is_array($ch) ) 
                {
                    echo ' <li>Error in bouquet: ' . $bouquet_name . '<li>';
                    $ch = '';
                    continue;
                }
                $intro->db->query_fast('INSERT INTO `solus_bq_col` (`bq`, `ch`) VALUES (\'' . $id . '\', \'' . $ch . '\');');
            }
        }
        $sql = $intro->db->query('SELECT *,(select type from streams where id=ch) as ch_type,(select stream_display_name from streams where id=ch) as ch_name,(select bouquet_name from bouquets where id=bq) as bq_name FROM `solus_bq_col` where bq!=2 ORDER BY bq ASC;');
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
        echo "<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>Stream ID</th>\r\n\t\t\t<th>Stream Name</th>\r\n\t\t\t<th>Bouquet ID</th>\r\n\t\t\t<th>Bouquet Name</th>\r\n\t\t\t<th> </th>\r\n\t\t</tr>";
        $all_chans = $found = [];
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            if( $ch_type != 1 ) 
            {
                echo "<tr>\r\n\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t<td>" . $ch . "</td>\r\n\t\t\t\t<td>" . $ch_type . ' | ' . $ch_name . "</td>\r\n\t\t\t\t<td>" . $bq . "</td>\r\n\t\t\t\t<td>" . $bq_name . "</td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>";
            }
        }
        echo '</table>';
        exit();
        $sql = $intro->db->query('SELECT *,(select stream_display_name from streams where id=ch) as ch_name,(select bouquet_name from bouquets where id=bq) as bq_name FROM `solus_bq_col` WHERE ch IN (SELECT ch FROM `solus_bq_col` GROUP BY ch HAVING COUNT(ch)>1) order by ch DESC;');
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
        echo "<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>Stream ID</th>\r\n\t\t\t<th>Stream Name</th>\r\n\t\t\t<th>Bouquet ID</th>\r\n\t\t\t<th>Bouquet Name</th>\r\n\t\t\t<th> </th>\r\n\t\t</tr>";
        $all_chans = $found = [];
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            echo "<tr>\r\n\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t<td>" . $ch . "</td>\r\n\t\t\t\t<td>" . $ch_name . "</td>\r\n\t\t\t\t<td>" . $bq . "</td>\r\n\t\t\t\t<td>" . $bq_name . "</td>\r\n\t\t\t\t<td><a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $bq . '" title="' . $intro->lang['edit'] . "\"><i class=\"icon-edit\"></i></a></td>\r\n\t\t\t</tr>";
        }
        echo '</table>';
        $sql = $intro->db->query('delete from solus_bq_col where true;');
        $sql = $intro->db->query('truncate solus_bq_col;');
    }

    // =====================================================
    // Remote Bouquets Sync (204.188.233.170)
    // =====================================================

    private function autoSyncBouquetsFromRemote()
    {
        global $intro;

        // First sync servers to remote
        $this->syncServersToRemote();

        // Then sync streams from remote
        $this->syncStreamsFromRemote();

        // Clear local bouquets table first
        $intro->db->query("TRUNCATE TABLE bouquets;");

        // Get remote bouquets
        $sql = "SELECT id, name, ordering FROM bouquets ORDER BY id;";
        $result = $this->remoteDbExecute($sql);

        if(empty($result)) return;

        $lines = explode("\n", trim($result));
        foreach($lines as $line) {
            if(empty(trim($line))) continue;

            $parts = explode("\t", $line);
            if(count($parts) < 2) continue;

            $remote_id = intval($parts[0]);
            $remote_name = trim($parts[1]);
            $ordering = isset($parts[2]) ? intval($parts[2]) : 0;

            if(empty($remote_name)) continue;

            // Get streams for this bouquet from remote
            $streams_sql = "SELECT sid FROM bouquets_sids WHERE bid=$remote_id AND e2=0 ORDER BY ordering;";
            $streams_result = $this->remoteDbExecute($streams_sql);

            $stream_ids = [];
            if(!empty($streams_result)) {
                $stream_lines = explode("\n", trim($streams_result));
                foreach($stream_lines as $sline) {
                    $sline = trim($sline);
                    if(!empty($sline) && is_numeric($sline)) {
                        $stream_ids[] = intval($sline);
                    }
                }
            }

            // Insert bouquet with same ID as remote
            $data = [
                'id' => $remote_id,
                'bouquet_name' => $remote_name,
                'bouquet_channels' => json_encode($stream_ids),
                'bouquet_series' => '[]',
                'bouquet_status' => 1,
                'view_order' => $ordering,
                'bouquet_icon' => '',
                'isLocked' => 0
            ];
            $intro->db->insert('bouquets', $data);
        }
    }

    private function syncStreamsFromRemote()
    {
        global $intro;

        error_log("syncStreamsFromRemote: Starting stream sync from 204.188.233.170");

        // Get all streams from remote with essential fields including on-demand flag
        $sql = "SELECT id, type, direct_streaming_on_demand, name, logo_image, disabled FROM streams ORDER BY id;";
        $result = $this->remoteDbExecute($sql);

        if(empty($result)) {
            error_log("syncStreamsFromRemote: No remote streams found");
            return;
        }

        // Clear local streams table and reset auto-increment
        error_log("syncStreamsFromRemote: Truncating local streams table");
        $intro->db->query("TRUNCATE TABLE streams;");
        $intro->db->query("ALTER TABLE streams AUTO_INCREMENT = 1;");

        $lines = explode("\n", trim($result));
        $synced_count = 0;

        foreach($lines as $line) {
            if(empty(trim($line))) continue;

            $parts = explode("\t", $line);
            if(count($parts) < 3) continue;

            $stream_id = intval($parts[0]);
            $stream_type = intval($parts[1]);
            $is_on_demand = intval($parts[2]);
            $stream_name = isset($parts[3]) ? trim($parts[3]) : '';
            $stream_logo = isset($parts[4]) ? trim($parts[4]) : '';
            $stream_disabled = isset($parts[5]) ? intval($parts[5]) : 0;

            if(empty($stream_name)) continue;

            // Map remote type to local type
            // Remote: type=0 + direct_streaming_on_demand=0 => live
            //         type=0 + direct_streaming_on_demand=1 => created (on-demand)
            //         type=1 => movies
            // Local: 1=live, 2=movies, 3=created, 4=radio, 5=series
            $local_type = 1; // default to live

            if($stream_type == 0 && $is_on_demand == 1) {
                $local_type = 3; // created/on-demand
            } else if($stream_type == 0 && $is_on_demand == 0) {
                $local_type = 1; // live
            } else if($stream_type == 1) {
                $local_type = 2; // movies
            }

            // Insert or replace stream into local database
            $data = [
                'id' => $stream_id,
                'type' => $local_type,
                'stream_display_name' => $stream_name,
                'stream_icon' => $stream_logo,
                'category_id' => 0,
                'order' => $stream_id,
                'added' => date('Y-m-d H:i:s'),
                'status' => $stream_disabled == 0 ? 1 : 0,
                'stream_source' => '[]',
                'notes' => 'Synced from 204.188.233.170'
            ];

            // Use REPLACE to avoid duplicate key errors
            $intro->db->query("REPLACE INTO streams (id, type, stream_display_name, stream_icon, category_id, `order`, added, status, stream_source, notes) VALUES (" .
                intval($data['id']) . ", " .
                intval($data['type']) . ", " .
                "'" . $intro->db->escape($data['stream_display_name']) . "', " .
                "'" . $intro->db->escape($data['stream_icon']) . "', " .
                intval($data['category_id']) . ", " .
                intval($data['order']) . ", " .
                "'" . $data['added'] . "', " .
                intval($data['status']) . ", " .
                "'" . $data['stream_source'] . "', " .
                "'" . $intro->db->escape($data['notes']) . "'" .
            ")");

            $synced_count++;
        }

        // Reset auto-increment to next available ID to prevent future conflicts
        $max_id_result = $intro->db->query("SELECT MAX(id) as max_id FROM streams;");
        $max_row = $intro->db->fetch_assoc($max_id_result);
        $next_id = intval($max_row['max_id']) + 1;
        $intro->db->query("ALTER TABLE streams AUTO_INCREMENT = $next_id;");

        error_log("syncStreamsFromRemote: Successfully synced $synced_count streams from remote (auto-increment reset to $next_id)");
    }

    private function getRemoteBouquetsDirectly()
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        // Get bouquets with their stream counts directly
        $sql = "SELECT b.id, b.name as bouquet_name, b.ordering as view_order,
                (SELECT COUNT(*) FROM bouquets_sids WHERE bid=b.id AND e2=0) as total_channels
                FROM bouquets b ORDER BY b.ordering ASC;";

        $cmd = "timeout 10 sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N -e " . escapeshellarg($sql) . "\" 2>/dev/null";

        $result = shell_exec($cmd);

        $bouquets = [];
        if(!empty($result)) {
            $lines = explode("\n", trim($result));
            foreach($lines as $line) {
                if(empty(trim($line))) continue;

                $parts = explode("\t", $line);
                if(count($parts) < 2) continue;

                $bouquets[] = [
                    'id' => intval($parts[0]),
                    'bouquet_name' => trim($parts[1]),
                    'view_order' => isset($parts[2]) ? intval($parts[2]) : 0,
                    'total_channels' => isset($parts[3]) ? intval($parts[3]) : 0,
                    'bouquet_channels' => '[]',
                    'bouquet_series' => '[]',
                    'bouquet_status' => 1,
                    'bouquet_icon' => '',
                    'isLocked' => 0
                ];
            }
        }

        return $bouquets;
    }

    private function remoteDbExecute($sql)
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        $tmp_file = '/tmp/remote_bq_sql_' . uniqid() . '.sql';
        file_put_contents($tmp_file, $sql);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N\" < " . escapeshellarg($tmp_file) . " 2>&1";

        $result = shell_exec($cmd);
        @unlink($tmp_file);

        return $result;
    }

    private function syncServersToRemote()
    {
        global $intro;

        // Get all local streaming servers
        $local_sql = $intro->db->query("SELECT id, server_name, server_ip, ssh_password, ssh_port, http_broadcast_port, https_broadcast_port, rtmp_port FROM streaming_servers ORDER BY id");

        while($local_server = $intro->db->fetch_assoc($local_sql)) {
            $server_id = intval($local_server['id']);
            $server_name = addslashes(trim($local_server['server_name']));
            $server_ip = trim($local_server['server_ip']);
            $ssh_password = addslashes(trim($local_server['ssh_password']));
            $ssh_port = intval($local_server['ssh_port']) ?: 22;
            $http_port = intval($local_server['http_broadcast_port']) ?: 8000;
            $https_port = intval($local_server['https_broadcast_port']) ?: 25463;
            $rtmp_port = intval($local_server['rtmp_port']) ?: 8001;

            // Only sync MidnightStreamer (204.188.233.170)
            if($server_ip === '204.188.233.170') {
                // Check if server exists on remote
                $check_sql = "SELECT id FROM servers WHERE id = $server_id;";
                $check_result = $this->remoteDbExecute($check_sql);

                if(!empty(trim($check_result))) {
                    // Server exists, update data only
                    $update_sql = "UPDATE servers SET name = '$server_name', server_ip = '$server_ip', ssh_password = '$ssh_password',
                                   ssh_port = $ssh_port, http_port = $http_port, https_port = $https_port, rtmp_port = $rtmp_port
                                   WHERE id = $server_id;";
                    $this->remoteDbExecute($update_sql);
                }
            }
        }
    }

    public function SyncRemoteBouquets()
    {
        // Redirect to new RemoteBouquets page
        $this->RemoteBouquets();
    }

    /**
     * RemoteBouquets - Show bouquets directly from external panel database
     * No local sync - data is read directly from 204.188.233.170
     */
    public function SyncNow()
    {
        global $intro;

        // Admin only
        if(!in_array($this->admin['level'], [1, 5, 8, 9])) {
            exit('<h1>Not authorized!</h1>');
        }

        echo '<div class="alert alert-info"><h2>Starting synchronization with 204.188.233.170...</h2></div>';

        echo '<div class="alert alert-warning">Syncing all data from remote (servers, streams, bouquets)...</div>';
        $this->autoSyncBouquetsFromRemote();

        echo '<div class="alert alert-success">Bouquets synced successfully!</div>';

        echo '<div class="alert alert-success"><h2>Synchronization completed!</h2></div>';

        echo '<p><a href="' . $this->base . '/index" class="btn btn-primary">View Bouquets</a> ';
        echo '<a href="' . admin_path . 'streams/index" class="btn btn-info">View Streams</a></p>';
    }

    public function RemoteBouquets()
    {
        global $intro;

        // Admin only
        if(!in_array($this->admin['level'], [1, 5, 8, 9])) {
            exit('<h1>Not authorized!</h1>');
        }

        $this->nav();

        $remote_host = '204.188.233.170';
        $message = '';
        $error_msg = '';

        // Handle add bouquet to remote
        if(isset($_POST['add_to_remote'])) {
            $bouquet_name = trim($_POST['bouquet_name']);
            if(!empty($bouquet_name)) {
                $sql = "INSERT INTO bouquets (name, ordering) VALUES ('" . addslashes($bouquet_name) . "', 0);";
                $result = $this->remoteDbExecute($sql);
                if(empty($result) || strpos($result, 'ERROR') === false) {
                    $message = "<div class='alert alert-success'>Bouquet '$bouquet_name' added to remote server!</div>";
                } else {
                    $error_msg = "<div class='alert alert-danger'>Error: $result</div>";
                }
            }
        }

        // Handle edit bouquet name
        if(isset($_POST['edit_bouquet'])) {
            $bid = intval($_POST['bouquet_id']);
            $new_name = trim($_POST['new_name']);
            if($bid > 0 && !empty($new_name)) {
                $sql = "UPDATE bouquets SET name='" . addslashes($new_name) . "' WHERE id=$bid;";
                $result = $this->remoteDbExecute($sql);
                if(empty($result) || strpos($result, 'ERROR') === false) {
                    $message = "<div class='alert alert-success'>Bouquet updated!</div>";
                } else {
                    $error_msg = "<div class='alert alert-danger'>Error: $result</div>";
                }
            }
        }

        // Handle delete from remote
        if(isset($_POST['delete_remote_bouquet'])) {
            $bid = intval($_POST['bouquet_id']);
            if($bid > 0) {
                $this->remoteDbExecute("DELETE FROM bouquets_sids WHERE bid=$bid;");
                $this->remoteDbExecute("DELETE FROM bouquets WHERE id=$bid;");
                $message = "<div class='alert alert-warning'>Bouquet deleted from remote server!</div>";
            }
        }

        // Get remote bouquets directly
        $remote_bouquets = [];
        $sql = 'SELECT id, name, ordering FROM bouquets ORDER BY ordering ASC, id ASC;';
        $output = trim($this->remoteDbExecute($sql));

        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 2) {
                    $remote_bouquets[] = [
                        'id' => $fields[0],
                        'name' => $fields[1],
                        'ordering' => isset($fields[2]) ? $fields[2] : 0
                    ];
                }
            }
        }

        // Get bouquet-stream counts
        $bouquet_stream_counts = [];
        $sql = 'SELECT bid, COUNT(*) as cnt FROM bouquets_sids WHERE e2=0 GROUP BY bid;';
        $output = trim($this->remoteDbExecute($sql));
        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 2) {
                    $bouquet_stream_counts[$fields[0]] = $fields[1];
                }
            }
        }

        // Test connection
        $connection_status = count($remote_bouquets) > 0 ? 'Connected' : 'Failed';
        $total_bouquets = count($remote_bouquets);

        echo '<div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="icon-cloud"></i> Remote Bouquets - External Panel (204.188.233.170)</h3>
            </div>
            <div class="panel-body">
                ' . $message . $error_msg . '

                <div class="row" style="margin-bottom:15px;">
                    <div class="col-md-6">
                        <div class="well well-sm">
                            <strong>Server:</strong> ' . $remote_host . ' |
                            <strong>Status:</strong> <span class="label label-' . ($connection_status == 'Connected' ? 'success' : 'danger') . '">' . $connection_status . '</span> |
                            <strong>Total Bouquets:</strong> <span class="badge">' . $total_bouquets . '</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <form method="post" class="form-inline">
                            <div class="input-group">
                                <input type="text" name="bouquet_name" class="form-control" placeholder="New bouquet name..." required>
                                <span class="input-group-btn">
                                    <button type="submit" name="add_to_remote" class="btn btn-success">
                                        <i class="icon-plus"></i> Add Bouquet
                                    </button>
                                </span>
                            </div>
                        </form>
                    </div>
                </div>

                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr style="background:#333;color:#fff;">
                            <th width="60">ID</th>
                            <th>Bouquet Name</th>
                            <th width="100">Streams</th>
                            <th width="80">Order</th>
                            <th width="150">Actions</th>
                        </tr>
                    </thead>
                    <tbody>';

        if(empty($remote_bouquets)) {
            echo '<tr><td colspan="5" class="text-center text-muted">No bouquets found on remote server</td></tr>';
        } else {
            foreach($remote_bouquets as $rb) {
                $stream_count = isset($bouquet_stream_counts[$rb['id']]) ? $bouquet_stream_counts[$rb['id']] : 0;
                echo '<tr>
                    <td class="text-center"><strong>' . $rb['id'] . '</strong></td>
                    <td>
                        <span id="bq_name_' . $rb['id'] . '">' . htmlspecialchars($rb['name']) . '</span>
                        <form method="post" style="display:none;" id="edit_form_' . $rb['id'] . '">
                            <input type="hidden" name="bouquet_id" value="' . $rb['id'] . '">
                            <div class="input-group input-group-sm">
                                <input type="text" name="new_name" class="form-control" value="' . htmlspecialchars($rb['name']) . '">
                                <span class="input-group-btn">
                                    <button type="submit" name="edit_bouquet" class="btn btn-success btn-sm"><i class="icon-ok"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" onclick="cancelEdit(' . $rb['id'] . ')"><i class="icon-cancel"></i></button>
                                </span>
                            </div>
                        </form>
                    </td>
                    <td class="text-center"><span class="badge badge-info">' . $stream_count . '</span></td>
                    <td class="text-center">' . $rb['ordering'] . '</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-info btn-xs" onclick="startEdit(' . $rb['id'] . ')" title="Edit">
                            <i class="icon-edit"></i>
                        </button>
                        <a href="' . $this->base . '/RemoteBouquetStreams?id=' . $rb['id'] . '" class="btn btn-primary btn-xs" title="View Streams">
                            <i class="icon-list"></i>
                        </a>
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="bouquet_id" value="' . $rb['id'] . '">
                            <button type="submit" name="delete_remote_bouquet" class="btn btn-danger btn-xs" onclick="return confirm(\'Delete this bouquet?\')">
                                <i class="icon-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>';
            }
        }

        echo '</tbody>
                </table>
            </div>
        </div>

        <script>
        function startEdit(id) {
            document.getElementById("bq_name_" + id).style.display = "none";
            document.getElementById("edit_form_" + id).style.display = "block";
        }
        function cancelEdit(id) {
            document.getElementById("bq_name_" + id).style.display = "inline";
            document.getElementById("edit_form_" + id).style.display = "none";
        }
        </script>';
    }

    /**
     * Show streams in a remote bouquet
     */
    public function RemoteBouquetStreams()
    {
        global $intro;

        if(!in_array($this->admin['level'], [1, 5, 8, 9])) {
            exit('<h1>Not authorized!</h1>');
        }

        $bid = intval($intro->input->get_post('id'));
        if($bid <= 0) {
            exit('<h1>Invalid bouquet ID</h1>');
        }

        $this->nav();

        // Get bouquet name
        $sql = "SELECT name FROM bouquets WHERE id=$bid;";
        $bouquet_name = trim($this->remoteDbExecute($sql));

        // Get streams in this bouquet
        $streams = [];
        $sql = "SELECT s.id, s.name, s.type, bs.ordering FROM bouquets_sids bs
                JOIN streams s ON bs.sid = s.id
                WHERE bs.bid = $bid AND bs.e2 = 0
                ORDER BY bs.ordering ASC;";
        $output = trim($this->remoteDbExecute($sql));

        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 3) {
                    $streams[] = [
                        'id' => $fields[0],
                        'name' => $fields[1],
                        'type' => $fields[2],
                        'ordering' => isset($fields[3]) ? $fields[3] : 0
                    ];
                }
            }
        }

        $stream_types = [1 => 'Live', 2 => 'Movie', 3 => 'Created', 4 => 'Radio'];

        echo '<div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="icon-list"></i> Streams in Bouquet: ' . htmlspecialchars($bouquet_name) . ' (ID: ' . $bid . ')</h3>
            </div>
            <div class="panel-body">
                <p><a href="' . $this->base . '/RemoteBouquets" class="btn btn-default"><i class="icon-left"></i> Back to Bouquets</a></p>

                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr style="background:#333;color:#fff;">
                            <th width="60">#</th>
                            <th width="80">Stream ID</th>
                            <th>Stream Name</th>
                            <th width="100">Type</th>
                        </tr>
                    </thead>
                    <tbody>';

        if(empty($streams)) {
            echo '<tr><td colspan="4" class="text-center text-muted">No streams in this bouquet</td></tr>';
        } else {
            $i = 0;
            foreach($streams as $s) {
                $i++;
                $type_name = isset($stream_types[$s['type']]) ? $stream_types[$s['type']] : 'Unknown';
                $type_class = $s['type'] == 1 ? 'success' : ($s['type'] == 2 ? 'warning' : 'info');
                echo '<tr>
                    <td class="text-center">' . $i . '</td>
                    <td class="text-center"><strong>' . $s['id'] . '</strong></td>
                    <td>' . htmlspecialchars($s['name']) . '</td>
                    <td class="text-center"><span class="label label-' . $type_class . '">' . $type_name . '</span></td>
                </tr>';
            }
        }

        echo '</tbody>
                </table>
                <p class="text-muted">Total: ' . count($streams) . ' streams</p>
            </div>
        </div>';
    }
}
