<?php 
class Categories_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $error = '';
    public $array_category_type = [
        'live' => 'live', 
        'movie' => 'movie', 
        'series' => 'series'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( !in_array($this->admin['level'], [
            1, 
            9
        ]) ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $category_type = trim($intro->input->get_post('category_type'));
        $this->category_type = ($category_type == '' ? 'live' : $category_type);
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        $sql3 = $intro->db->query('SELECT id from stream_categories where category_type=\'live\' AND parent_id=0;');
        $tot_live = $intro->db->returned_rows;
        $sql4 = $intro->db->query('SELECT id from stream_categories where category_type=\'movie\' AND parent_id=0;');
        $tot_movie = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where category_type=\'series\' AND parent_id=0;');
        $tot_series = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where parent_id > 0 AND parent_id NOT IN (SELECT id from stream_categories);');
        $tot_parent_not_found = $intro->db->returned_rows;
        $sql5 = $intro->db->query('SELECT id from stream_categories where id=parent_id;');
        $tot_parent_same_id = $intro->db->returned_rows;
        echo "<div class=\"app_nav\">\r\n\t\t\r\n\t\t\t<a class=\"btn btn-success\" href=\"" . $this->base . '/index?category_type=live"><icon class="icon-list"> Live Categories (' . $tot_live . ")</icon></a> \r\n\t\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?category_type=movie"><icon class="icon-list"> Movie Categories (' . $tot_movie . ")</icon></a> \r\n\t\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?category_type=series"><icon class="icon-list"> Series Categories (' . $tot_series . ")</icon></a> \r\n\t\t\r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add&amp;category_type=' . $this->category_type . '"><icon class="icon-plus-squared"> ') . $intro->lang['stream_categories_add'] . "</icon></a>  \t\t \t\t \r\n\t\t\t\t";
        // Remote Categories button
        echo '<a class="btn btn-primary" href="' . $this->base . '/RemoteCategories"><icon class="icon-cloud"> Remote Categories (External Panel)</icon></a> ';
        if( $tot_parent_not_found > 0 )
        {
            echo '<a class="btn btn-danger btn-lg" href="' . $this->base . '/index?fix=1"><icon class="icon-list"> Error: Categories that parents Are Deleted (' . $tot_parent_not_found . ' ).</icon></a>';
        }
        if( $tot_parent_same_id > 0 )
        {
            echo '<a class="btn btn-danger btn-lg" href="' . $this->base . '/index?fix=2"><icon class="icon-list"> Error: Parent ID = Category ID (' . $tot_parent_same_id . ' ).</icon></a>';
        }
        echo "\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        global $options;

        // Auto-sync categories from remote MySQL server
        $this->syncCategoriesFromRemote();

        $qry = '';
        $parent_id = intval($intro->input->get_post('parent_id'));
        $fix = intval($intro->input->get_post('fix'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $category_type = trim($intro->db->escape($intro->input->get_post('category_type')));
        $category_type = ($category_type == '' ? 'live' : $category_type);
        $params = '&category_type=' . $category_type;
        $this->nav();
        $cat_type_txt = [
            'live' => 'Streams', 
            'movie' => 'Movies', 
            'series' => 'Series'
        ];
        if( $search_txt != '' ) 
        {
            $qry .= (' and category_name  LIKE \'%' . $search_txt . '%\' ');
        }
        if( $parent_id != 0 ) 
        {
        }
        if( $order == '' ) 
        {
            $order = 'cat_order:asc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 200;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        if( $fix == 1 ) 
        {
            $result = $intro->db->query('SELECT * from stream_categories where parent_id > 0 AND parent_id NOT IN (SELECT id from stream_categories);');
        }
        else if( $fix == 2 ) 
        {
            $result = $intro->db->query('SELECT * from stream_categories where id=parent_id;');
        }
        else
        {
            $result = $intro->db->query('SELECT * ,(SELECT count(id) FROM stream_categories where parent_id=cat.id) as tot_child  ,(SELECT count(id) FROM streams where category_id=cat.id) as tot_streams  ,(SELECT count(id) FROM series where category_id=cat.id) as tot_series ' . (' FROM `stream_categories` cat where cat.parent_id=' . $parent_id . ' AND cat.category_type=\'' . $category_type . '\' ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
            $totrows = $intro->db->returned_rows;
            $sql_all_rows = $intro->db->query('SELECT id from stream_categories where parent_id=0 AND category_type=\'' . $category_type . '\' ' . $qry . ' ');
        }
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' [ ' . $category_type . ' ] ' . $intro->lang['stream_categories_cur'] . (' (' . $totalrows . ')'), ($category_type == 'live' ? 'success' : 'warning'));
        echo "\r\n\t\t\r\n\t\t<form action=\"\" method=\"post\">\r\n\t\t" . $intro->lang['search_form'] . (': <input type="text" name="search_txt" value="' . $search_txt . "\" size=\"10\">\r\n\t\t<input type=\"hidden\" name=\"maa\" value=\"Main\">\r\n\t\t<input name=\"name\" value=\"") . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t</form>\r\n\t\t<!--<div class='pull-right'>Categories Icon Must be: width=214px height=118px</div>-->\r\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table-1\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_type'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_type', 'index', $params) . " </th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_name'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_name', 'index', $params) . " </th>\r\n\t\t\t<th>Child Cat. " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('tot_child', 'index', $params) . ' </th>';
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            echo '<th>For ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('cat_for', 'index', $params) . '</th>';
        }
        echo "\r\n\t\t\t<th>" . $intro->lang['stream_categories_view_order'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('cat_order', 'index', $params) . " </th>\r\n\t\t\t<th>" . $intro->lang['stream_categories_category_icon'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_icon', 'index', $params) . " </th>\r\n\t\t\t<th>" . $cat_type_txt[$category_type] . "</th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = $tot_child = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr id=\"" . $id . '" class="' . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t\r\n\t\t\t\t<td class=\"dragHandle center\">" . $id . "</td>\r\n\t\t\t\t<td class='center'><span class=\"label label-") . (($category_type == 'live' ? 'success' : 'warning')) . ('">' . $category_type . "</span> </td>\r\n\t\t\t\t<td class=\"dragHandle\">") . $this->get_parent($parent_id) . (' ' . $category_name . "</td>\r\n\t\t\t\t<td class=\"center\">") . (($tot_child > 0 ? '<a class=\'btn btn-default\' href="' . $this->base . '/index?category_type=' . $category_type . '&parent_id=' . $id . '">Manage Child (' . $tot_child . ')</a>' : '')) . '</td>';
            if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
            {
                echo '<td>' . $array['cat_for'][$cat_for] . '</td>';
            }
            echo "\r\n\t\t\t\t\r\n\t\t\t\t<td class='center'>" . $cat_order . "</td>\r\n\t\t\t\t\r\n\t\t\t\t<td class='center'><img src=\"" . $category_icon . '" width=\'50\' height=\'50\' alt=\'\' /></td>';
            if( $category_type == 'movie' ) 
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('movies', 'index') . ('?category_id=' . $id . '">' . $tot_streams . '</a></td>');
            }
            else if( $category_type == 'series' ) 
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('series', 'index') . ('?category_id_s=' . $id . '">' . $tot_series . '</a></td>');
            }
            else
            {
                echo '<td class=\'center\'><a class="btn btn-default" href="' . $intro->app_url('streams', 'index') . '?category_id=' . $id . '">' . $tot_streams . '</a></td>';
            }
            echo "\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '&amp;category_type=' . $category_type . '" title="' . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?id=' . $id . '&amp;category_type=' . $category_type . '" OnClick="return false;" title="') . $intro->lang['del'] . "\"><i class=\"icon-trash\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        $order = str_replace(' ', ':', $order);
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?search_txt=' . $search_txt . '&amp;order=' . $order . '&category_type=' . $category_type, $totalrows, $rows_per_page, $page) . '</center>';
        echo "<div class=center>\r\n\t\t\t<a href=\"" . $this->base . '/FixOrder?category_type=' . $category_type . "\">Fix View Order</a>\r\n\t\t\t<div id=\"AjaxResult\"></div>\r\n\t\t</div>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script>\r\n\t\t\$('#table-1').tableDnD({\r\n            hierarchyLevel: 4,\r\n            onDragStart: function(table, row) {\r\n                \$('#AjaxResult').html('');\r\n            },\r\n            onDrop: function(table, row) {\r\n\t\t\t\t\$('#AjaxResult').load(\"";
        echo $this->base;
        echo '/doSort?category_type=';
        echo $category_type;
        echo "&NH=1&\"+\$.tableDnD.serialize());\r\n            }\r\n        });\r\n\t\t</script>\r\n\t\t";
    }
    public function doSort()
    {
        global $intro;
        $data_id = '';
        $menu = $_GET['table-1'];
        for( $i = 0; $i < count($menu); $i++ ) 
        {
            $id = intval($menu[$i]);
            $a = $i + 1;
            $intro->db->query('UPDATE stream_categories SET cat_order=' . $a . ' WHERE id=' . $id . ' ');
        }
        echo ' :: Order Done:: ' . $data_id;
    }
    public function FixOrder()
    {
        global $intro;
        $category_type = trim($intro->input->get('category_type'));
        $sql = $intro->db->query('select id from stream_categories where category_type=\'' . $category_type . '\' order by cat_order ASC');
        $w1 = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $w1++;
            $id = intval($row['id']);
            $intro->db->query('UPDATE stream_categories SET cat_order=' . $w1 . ' WHERE id=' . $id . ' ');
        }
        $intro->redirect($this->appname, 'index', '?category_type=' . $category_type);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $options;
        global $category_type;
        global $category_name;
        global $cat_order;
        global $parent_id;
        global $category_icon;
        global $data_type;
        global $series_plot;
        global $series_cast;
        global $series_rate;
        global $series_year;
        global $data_parent;
        global $series_type;
        global $cat_for;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        $icon = '';
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM stream_categories where id=\'' . $id . '\'');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $icon = '<img src="' . $category_icon . '" style="max-height:100px;float:right;position:absolute;right:0;top:-50px;">';
            $btn['legend_name'] = $intro->lang['stream_categories_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = 'Save Changes';
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $btn['copy'] = ' ';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['stream_categories_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Save';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $btn['copy'] = '';
            $category_type = ($category_type == '' ? $intro->input->get_post('category_type') : $category_type);
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo $this->error . "\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Stream Type :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D3114132D0E1B5C14292309230C3F01222903383B2811('category_type', $this->array_category_type, $category_type, $txt = '') . (' ' . $this->error('category_type') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_parent'] . " : </td>\r\n\t\t\t\t<td>" . $this->form_parent($parent_id, $category_type) . ($this->error('parent_id') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_category_name'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td><input class='form-control' type=\"text\" name=\"category_name\" value=\"" . $category_name . '"> ' . $this->error('category_name') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_view_order'] . (" : </td>\r\n\t\t\t\t<td><input  type=\"text\" name=\"cat_order\" value=\"" . $cat_order . '" size="5"> ' . $this->error('cat_order') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td>") . $intro->lang['stream_categories_category_icon'] . (" : </td>\r\n\t\t\t\t<td style=\"position:relative;\"><input class='form-control' type=\"text\" name=\"category_icon\" value=\"" . $category_icon . '"> ' . $this->error('category_icon') . ' ' . $icon . "</td>\r\n\t\t\t</tr>");
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>For : </td>\r\n\t\t\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('cat_for', $array['cat_for'], $cat_for, '', 0) . (' ' . $this->error('cat_for') . "</td>\r\n\t\t\t\t</tr>");
        }
        echo "<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"get_category_type\"  value=\"" . trim($intro->input->get_post('category_type')) . ("\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " </button>\r\n\t\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\r\n\t\t<script>\r\n\t\t\r\n\t\t\$(document).ready(function () {\r\n\r\n\t\t\t\$(\"#data_type\").change(function(){\r\n\t\t\t\tvar val = \$(this).val();\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function form_parent($comp = 0, $category_type)
    {
        global $intro;
        global $error;
        $qry = '';
        $category_type = trim($intro->input->get_post('category_type'));
        if( $category_type != '' ) 
        {
            $qry = ' AND category_type=\'' . $category_type . '\' ';
        }
        $id = intval($intro->input->get_post('id'));
        if( $id != 0 ) 
        {
            $qry .= (' AND id!=' . $id . ' ');
        }
        $result = $intro->db->query('SELECT * from stream_categories where ' . (' parent_id=0 ' . $qry . ' order by category_name asc;'));
        $html = "<select name='parent_id' id='parent_id'>\r\n\t\t<option value=\"0\"> No Parent </option>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $html .= ('<option value="' . $id . '" ' . (($id == $comp ? 'selected="selected"' : '')) . ('>[' . $category_type . '] ' . $category_name . ' </option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function get_parent($id = 0)
    {
        global $intro;
        global $error;
        $category_name = '';
        $result = $intro->db->query('SELECT * from stream_categories where id=' . $id . ';');
        $myrow = $intro->db->fetch_assoc($result);
        @extract($myrow);
        return ($myrow['category_name'] != '' ? $myrow['category_name'] . ' > ' : '');
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $options;
        $get_category_type = trim($intro->input->post('get_category_type'));
        $category_type = trim($intro->input->post('category_type'));
        $category_name = trim($intro->input->post('category_name'));
        $cat_order = intval($intro->input->post('cat_order'));
        $parent_id = intval($intro->input->post('parent_id'));
        if( $category_type == '' || $category_name == '' ) 
        {
            if( $category_type == '' ) 
            {
                $error['category_type'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $category_name == '' ) 
            {
                $error['category_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['category_type'] = $intro->input->post('category_type');
        $data['category_name'] = $intro->input->post('category_name');
        $data['cat_order'] = $intro->input->post('cat_order');
        $data['parent_id'] = $intro->input->post('parent_id');
        $data['category_icon'] = $intro->input->post('category_icon');
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            $data['cat_for'] = intval($intro->input->post('cat_for'));
        }
        $intro->db->insert('stream_categories', $data);
        $id = intval($intro->db->insert_id());
        if( $id == 0 )
        {
            exit( '<h1>Error adding category . Zero value. error in database.</h1>' );
        }

        // Auto-sync to remote panel
        $this->syncCategoryToRemote($id, $data);

        $intro->redirect($this->appname, 'index', '?category_type=' . $get_category_type);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $options;
        $get_category_type = trim($intro->input->post('get_category_type'));
        $data_type = intval($intro->input->post('data_type'));
        $series_type = trim($intro->input->post('series_type'));
        $data = [];
        $data['category_type'] = $intro->input->post('category_type');
        $data['category_name'] = $intro->input->post('category_name');
        $data['cat_order'] = $intro->input->post('cat_order');
        $data['parent_id'] = intval($intro->input->post('parent_id'));
        $data['category_icon'] = $intro->input->post('category_icon');
        if( isset($options['opt_cat_for']) && $options['opt_cat_for'] == 'yes' ) 
        {
            $data['cat_for'] = intval($intro->input->post('cat_for'));
        }
        $id = intval($intro->input->post('id'));
        if( intval($intro->input->post('id')) == intval($intro->input->post('parent_id')) ) 
        {
            $this->error = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error: category cannot be parent of itself.', 'danger');
            $this->Form('edit');
            exit();
        }
        $intro->db->update('stream_categories', $data, 'id=' . $id);

        // Auto-sync to remote panel
        $this->syncCategoryToRemote($id, $data);

        $intro->redirect($this->appname, 'index', '?category_type=' . $get_category_type);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('DELETE FROM stream_categories WHERE id=' . $id . ' ');

        // Auto-sync deletion to remote panel
        $this->deleteCategoryFromRemote($id);

        $intro->redirect($this->appname);
    }
    public function ViewSeries()
    {
        global $intro;
        global $array;
        $category_id = trim($intro->input->get_post('category_id'));
        $this->nav();
        $result = $intro->db->query('SELECT * from series where category_id=' . $category_id . ' order by id asc;');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Series for category id (' . $category_id . ') (' . $totalrows . ')', 'info');
        echo "\r\n\t\t<table class=\"table table-hover table-striped table-bordered\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>Title " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('title', 'index') . "</th>\r\n\t\t\t<th>Cover</th>\r\n\t\t\t\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = $tot_child = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td class=\"\">" . $title . "</td>\r\n\t\t\t\t<td class=\"center\"><img src=\"" . $cover . "\" width='50' height='50' alt='' /></td>\r\n\t\t\t\t\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
    }

    // =====================================================
    // Remote Categories - Direct from External Panel (204.188.233.170)
    // =====================================================

    private function remoteDbExecute($sql)
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        $tmp_file = '/tmp/remote_cat_sql_' . uniqid() . '.sql';
        file_put_contents($tmp_file, $sql);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N\" < " . escapeshellarg($tmp_file) . " 2>&1";

        $result = shell_exec($cmd);
        @unlink($tmp_file);

        return $result;
    }

    /**
     * Sync single category to remote panel (add or update)
     */
    private function syncCategoryToRemote($id, $data)
    {
        $cat_name = addslashes($data['category_name']);
        $cat_type_local = trim($data['category_type']);
        $parent_id = intval($data['parent_id']);
        $ordering = intval($data['cat_order']);

        // Convert local category type to remote type (0=Live, 1=Movie, 2=Series)
        $cat_type_remote = 0;
        if($cat_type_local == 'movie') $cat_type_remote = 1;
        elseif($cat_type_local == 'series') $cat_type_remote = 2;

        // Check if category exists on remote
        $check_sql = "SELECT id FROM categories WHERE id = $id;";
        $check_result = $this->remoteDbExecute($check_sql);

        if(empty(trim($check_result))) {
            // Insert new category to remote
            $insert_sql = "INSERT INTO categories (id, name, type, parent, parental_lock, ordering)
                           VALUES ($id, '$cat_name', $cat_type_remote, $parent_id, 0, $ordering);";
            $this->remoteDbExecute($insert_sql);
        } else {
            // Update existing category on remote
            $update_sql = "UPDATE categories SET name='$cat_name', type=$cat_type_remote,
                           parent=$parent_id, ordering=$ordering WHERE id=$id;";
            $this->remoteDbExecute($update_sql);
        }
    }

    /**
     * Delete category from remote panel
     */
    private function deleteCategoryFromRemote($id)
    {
        // First update streams to remove category reference
        $this->remoteDbExecute("UPDATE streams SET category_id=0 WHERE category_id=$id;");

        // Delete category
        $this->remoteDbExecute("DELETE FROM categories WHERE id=$id;");
    }

    /**
     * Auto-sync categories silently in background
     */
    private function autoSyncCategories()
    {
        global $intro;

        // Get all existing remote categories IDs
        $remote_ids_sql = "SELECT id FROM categories;";
        $remote_ids_result = $this->remoteDbExecute($remote_ids_sql);

        $remote_ids = [];
        if(!empty($remote_ids_result)) {
            $lines = explode("\n", trim($remote_ids_result));
            foreach($lines as $line) {
                $id = intval(trim($line));
                if($id > 0) $remote_ids[] = $id;
            }
        }

        // Loop through remote categories and sync from local
        foreach($remote_ids as $cat_id) {
            // Get local category data
            $local_cat_sql = "SELECT category_name, category_type, parent_id, cat_order
                              FROM stream_categories WHERE id = $cat_id LIMIT 1;";
            $local_result = $intro->db->query($local_cat_sql);

            if($intro->db->returned_rows > 0) {
                $cat = $intro->db->get_row($local_result);
                $cat_name = addslashes($cat['category_name']);
                $cat_type_local = trim($cat['category_type']);
                $parent_id = intval($cat['parent_id']);
                $ordering = intval($cat['cat_order']);

                // Convert local category type to remote type (0=Live, 1=Movie, 2=Series)
                $cat_type_remote = 0;
                if($cat_type_local == 'movie') $cat_type_remote = 1;
                elseif($cat_type_local == 'series') $cat_type_remote = 2;

                // Update remote category silently
                $update_sql = "UPDATE categories SET name='$cat_name', type=$cat_type_remote,
                               parent=$parent_id, ordering=$ordering WHERE id=$cat_id;";
                $this->remoteDbExecute($update_sql);
            }
        }
    }

    /**
     * RemoteCategories - Show categories directly from external panel database
     * Data is read directly from 204.188.233.170 (no local sync)
     */
    public function RemoteCategories()
    {
        global $intro;

        // Admin only
        if(!in_array($this->admin['level'], [1, 9])) {
            exit('<h1>Not authorized!</h1>');
        }

        $this->nav();

        $remote_host = '204.188.233.170';
        $message = '';
        $error_msg = '';

        // Handle sync categories - only update existing ones in remote panel
        if(isset($_POST['sync_all_categories'])) {
            echo '<div class="alert alert-info"><h3>Starting automatic sync (update existing categories only)...</h3></div>';

            // Get all existing remote categories IDs
            $remote_ids_sql = "SELECT id FROM categories;";
            $remote_ids_result = $this->remoteDbExecute($remote_ids_sql);

            $remote_ids = [];
            if(!empty($remote_ids_result)) {
                $lines = explode("\n", trim($remote_ids_result));
                foreach($lines as $line) {
                    $id = intval(trim($line));
                    if($id > 0) $remote_ids[] = $id;
                }
            }

            echo "<div class='alert alert-info'>Found " . count($remote_ids) . " categories in remote panel.</div>";

            $synced = 0;
            $skipped = 0;
            $errors = 0;

            // Loop through remote categories and sync from local
            foreach($remote_ids as $cat_id) {
                // Get local category data
                $local_cat_sql = "SELECT category_name, category_type, parent_id, cat_order
                                  FROM stream_categories WHERE id = $cat_id LIMIT 1;";
                $local_result = $intro->db->query($local_cat_sql);

                if($intro->db->returned_rows > 0) {
                    $cat = $intro->db->get_row($local_result);
                    $cat_name = addslashes($cat['category_name']);
                    $cat_type_local = trim($cat['category_type']);
                    $parent_id = intval($cat['parent_id']);
                    $ordering = intval($cat['cat_order']);

                    // Convert local category type to remote type (0=Live, 1=Movie, 2=Series)
                    $cat_type_remote = 0;
                    if($cat_type_local == 'movie') $cat_type_remote = 1;
                    elseif($cat_type_local == 'series') $cat_type_remote = 2;

                    // Update remote category
                    $update_sql = "UPDATE categories SET name='$cat_name', type=$cat_type_remote,
                                   parent=$parent_id, ordering=$ordering WHERE id=$cat_id;";
                    $result = $this->remoteDbExecute($update_sql);

                    if(empty($result) || strpos($result, 'ERROR') === false) {
                        echo "<div class='alert alert-success'>✓ Synced: $cat_name (ID: $cat_id)</div>";
                        $synced++;
                    } else {
                        echo "<div class='alert alert-danger'>✗ Error syncing ID $cat_id: $result</div>";
                        $errors++;
                    }
                } else {
                    echo "<div class='alert alert-warning'>⊘ Category ID $cat_id not found in local panel - skipped</div>";
                    $skipped++;
                }
            }

            echo "<div class='alert alert-success'><h2>✓ Sync completed!</h2>";
            echo "<strong>Synced:</strong> $synced | <strong>Skipped:</strong> $skipped | <strong>Errors:</strong> $errors</div>";
            echo '<p><a href="' . $this->base . '/RemoteCategories" class="btn btn-primary">View Remote Categories</a></p>';
            return;
        }

        // Handle add category to remote
        if(isset($_POST['add_to_remote'])) {
            $cat_name = trim($_POST['category_name']);
            $cat_type = intval($_POST['category_type']);
            if(!empty($cat_name)) {
                $sql = "INSERT INTO categories (name, type, parent, parental_lock, ordering) VALUES ('" . addslashes($cat_name) . "', $cat_type, 0, 0, 0);";
                $result = $this->remoteDbExecute($sql);
                if(empty($result) || strpos($result, 'ERROR') === false) {
                    $message = "<div class='alert alert-success'>Category '$cat_name' added to remote server!</div>";
                } else {
                    $error_msg = "<div class='alert alert-danger'>Error: $result</div>";
                }
            }
        }

        // Handle edit category
        if(isset($_POST['edit_category'])) {
            $cid = intval($_POST['category_id']);
            $new_name = trim($_POST['new_name']);
            if($cid > 0 && !empty($new_name)) {
                $sql = "UPDATE categories SET name='" . addslashes($new_name) . "' WHERE id=$cid;";
                $result = $this->remoteDbExecute($sql);
                if(empty($result) || strpos($result, 'ERROR') === false) {
                    $message = "<div class='alert alert-success'>Category updated!</div>";
                } else {
                    $error_msg = "<div class='alert alert-danger'>Error: $result</div>";
                }
            }
        }

        // Handle delete from remote
        if(isset($_POST['delete_remote_category'])) {
            $cid = intval($_POST['category_id']);
            if($cid > 0) {
                // Update streams to remove category reference
                $this->remoteDbExecute("UPDATE streams SET category_id=0 WHERE category_id=$cid;");
                // Delete category
                $this->remoteDbExecute("DELETE FROM categories WHERE id=$cid;");
                $message = "<div class='alert alert-warning'>Category deleted from remote server!</div>";
            }
        }

        // Get remote categories directly
        $remote_categories = [];
        $sql = 'SELECT id, name, type, parent, ordering FROM categories ORDER BY type ASC, ordering ASC, id ASC;';
        $output = trim($this->remoteDbExecute($sql));

        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 3) {
                    $remote_categories[] = [
                        'id' => $fields[0],
                        'name' => $fields[1],
                        'type' => $fields[2],
                        'parent' => isset($fields[3]) ? $fields[3] : 0,
                        'ordering' => isset($fields[4]) ? $fields[4] : 0
                    ];
                }
            }
        }

        // Get stream counts per category
        $category_stream_counts = [];
        $sql = 'SELECT category_id, COUNT(*) as cnt FROM streams WHERE category_id > 0 GROUP BY category_id;';
        $output = trim($this->remoteDbExecute($sql));
        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 2) {
                    $category_stream_counts[$fields[0]] = $fields[1];
                }
            }
        }

        // Category types: 0=Live, 1=Movie, 2=Series
        $type_names = [0 => 'Live', 1 => 'Movie', 2 => 'Series'];
        $type_classes = [0 => 'success', 1 => 'warning', 2 => 'info'];

        // Separate by type
        $live_cats = array_filter($remote_categories, function($c) { return $c['type'] == 0; });
        $movie_cats = array_filter($remote_categories, function($c) { return $c['type'] == 1; });
        $series_cats = array_filter($remote_categories, function($c) { return $c['type'] == 2; });

        $connection_status = count($remote_categories) > 0 ? 'Connected' : 'Failed';

        echo '<div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="icon-cloud"></i> Remote Categories - External Panel (204.188.233.170)</h3>
            </div>
            <div class="panel-body">
                ' . $message . $error_msg . '

                <div class="row" style="margin-bottom:15px;">
                    <div class="col-md-6">
                        <div class="well well-sm">
                            <strong>Server:</strong> ' . $remote_host . ' |
                            <strong>Status:</strong> <span class="label label-' . ($connection_status == 'Connected' ? 'success' : 'danger') . '">' . $connection_status . '</span> |
                            <strong>Live:</strong> <span class="badge badge-success">' . count($live_cats) . '</span> |
                            <strong>Movie:</strong> <span class="badge badge-warning">' . count($movie_cats) . '</span> |
                            <strong>Series:</strong> <span class="badge badge-info">' . count($series_cats) . '</span>
                        </div>
                        <form method="post" style="margin-top:10px;">
                            <button type="submit" name="sync_all_categories" class="btn btn-primary btn-lg" onclick="return confirm(\'Sync existing categories from local to remote?\');">
                                <i class="icon-arrows-cw"></i> Auto Sync (Update Existing Only)
                            </button>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <form method="post" class="form-inline">
                            <div class="input-group">
                                <input type="text" name="category_name" class="form-control" placeholder="New category name..." required>
                                <select name="category_type" class="form-control" style="width:100px;">
                                    <option value="0">Live</option>
                                    <option value="1">Movie</option>
                                    <option value="2">Series</option>
                                </select>
                                <span class="input-group-btn">
                                    <button type="submit" name="add_to_remote" class="btn btn-success">
                                        <i class="icon-plus"></i> Add
                                    </button>
                                </span>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Tabs for category types -->
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#live_tab" data-toggle="tab"><span class="label label-success">Live</span> (' . count($live_cats) . ')</a></li>
                    <li role="presentation"><a href="#movie_tab" data-toggle="tab"><span class="label label-warning">Movie</span> (' . count($movie_cats) . ')</a></li>
                    <li role="presentation"><a href="#series_tab" data-toggle="tab"><span class="label label-info">Series</span> (' . count($series_cats) . ')</a></li>
                </ul>

                <div class="tab-content" style="padding-top:15px;">
                    <!-- Live Categories Tab -->
                    <div role="tabpanel" class="tab-pane active" id="live_tab">
                        ' . $this->renderCategoryTable($live_cats, $category_stream_counts, $type_names, $type_classes) . '
                    </div>

                    <!-- Movie Categories Tab -->
                    <div role="tabpanel" class="tab-pane" id="movie_tab">
                        ' . $this->renderCategoryTable($movie_cats, $category_stream_counts, $type_names, $type_classes) . '
                    </div>

                    <!-- Series Categories Tab -->
                    <div role="tabpanel" class="tab-pane" id="series_tab">
                        ' . $this->renderCategoryTable($series_cats, $category_stream_counts, $type_names, $type_classes) . '
                    </div>
                </div>
            </div>
        </div>

        <script>
        function startEditCat(id) {
            document.getElementById("cat_name_" + id).style.display = "none";
            document.getElementById("edit_cat_form_" + id).style.display = "block";
        }
        function cancelEditCat(id) {
            document.getElementById("cat_name_" + id).style.display = "inline";
            document.getElementById("edit_cat_form_" + id).style.display = "none";
        }
        </script>';
    }

    private function renderCategoryTable($categories, $stream_counts, $type_names, $type_classes)
    {
        $html = '<table class="table table-striped table-bordered table-hover">
            <thead>
                <tr style="background:#333;color:#fff;">
                    <th width="60">ID</th>
                    <th>Category Name</th>
                    <th width="80">Type</th>
                    <th width="80">Streams</th>
                    <th width="80">Order</th>
                    <th width="150">Actions</th>
                </tr>
            </thead>
            <tbody>';

        if(empty($categories)) {
            $html .= '<tr><td colspan="6" class="text-center text-muted">No categories found</td></tr>';
        } else {
            foreach($categories as $cat) {
                $stream_count = isset($stream_counts[$cat['id']]) ? $stream_counts[$cat['id']] : 0;
                $type_name = isset($type_names[$cat['type']]) ? $type_names[$cat['type']] : 'Unknown';
                $type_class = isset($type_classes[$cat['type']]) ? $type_classes[$cat['type']] : 'default';

                $html .= '<tr>
                    <td class="text-center"><strong>' . $cat['id'] . '</strong></td>
                    <td>
                        <span id="cat_name_' . $cat['id'] . '">' . htmlspecialchars($cat['name']) . '</span>
                        <form method="post" style="display:none;" id="edit_cat_form_' . $cat['id'] . '">
                            <input type="hidden" name="category_id" value="' . $cat['id'] . '">
                            <div class="input-group input-group-sm">
                                <input type="text" name="new_name" class="form-control" value="' . htmlspecialchars($cat['name']) . '">
                                <span class="input-group-btn">
                                    <button type="submit" name="edit_category" class="btn btn-success btn-sm"><i class="icon-ok"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" onclick="cancelEditCat(' . $cat['id'] . ')"><i class="icon-cancel"></i></button>
                                </span>
                            </div>
                        </form>
                    </td>
                    <td class="text-center"><span class="label label-' . $type_class . '">' . $type_name . '</span></td>
                    <td class="text-center"><span class="badge">' . $stream_count . '</span></td>
                    <td class="text-center">' . $cat['ordering'] . '</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-info btn-xs" onclick="startEditCat(' . $cat['id'] . ')" title="Edit">
                            <i class="icon-edit"></i>
                        </button>
                        <a href="' . $this->base . '/RemoteCategoryStreams?id=' . $cat['id'] . '" class="btn btn-primary btn-xs" title="View Streams">
                            <i class="icon-list"></i>
                        </a>
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="category_id" value="' . $cat['id'] . '">
                            <button type="submit" name="delete_remote_category" class="btn btn-danger btn-xs" onclick="return confirm(\'Delete this category? Streams will be moved to uncategorized.\')">
                                <i class="icon-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>';
            }
        }

        $html .= '</tbody></table>';
        return $html;
    }

    /**
     * Show streams in a remote category
     */
    public function RemoteCategoryStreams()
    {
        global $intro;

        if(!in_array($this->admin['level'], [1, 9])) {
            exit('<h1>Not authorized!</h1>');
        }

        $cid = intval($intro->input->get_post('id'));
        if($cid <= 0) {
            exit('<h1>Invalid category ID</h1>');
        }

        $this->nav();

        // Get category name
        $sql = "SELECT name, type FROM categories WHERE id=$cid;";
        $output = trim($this->remoteDbExecute($sql));
        $cat_name = 'Unknown';
        $cat_type = 0;
        if(!empty($output)) {
            $parts = explode("\t", $output);
            $cat_name = $parts[0];
            $cat_type = isset($parts[1]) ? $parts[1] : 0;
        }

        // Get streams in this category
        $streams = [];
        $sql = "SELECT id, name, type FROM streams WHERE category_id = $cid ORDER BY name ASC;";
        $output = trim($this->remoteDbExecute($sql));

        if(!empty($output) && strpos($output, 'ERROR') === false) {
            $lines = explode("\n", $output);
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 2) {
                    $streams[] = [
                        'id' => $fields[0],
                        'name' => $fields[1],
                        'type' => isset($fields[2]) ? $fields[2] : 0
                    ];
                }
            }
        }

        $type_names = [0 => 'Live', 1 => 'Movie', 2 => 'Series'];
        $type_classes = [0 => 'success', 1 => 'warning', 2 => 'info'];
        $cat_type_name = isset($type_names[$cat_type]) ? $type_names[$cat_type] : 'Unknown';
        $cat_type_class = isset($type_classes[$cat_type]) ? $type_classes[$cat_type] : 'default';

        echo '<div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="icon-list"></i> Streams in Category: ' . htmlspecialchars($cat_name) . ' <span class="label label-' . $cat_type_class . '">' . $cat_type_name . '</span> (ID: ' . $cid . ')</h3>
            </div>
            <div class="panel-body">
                <p><a href="' . $this->base . '/RemoteCategories" class="btn btn-default"><i class="icon-left"></i> Back to Categories</a></p>

                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr style="background:#333;color:#fff;">
                            <th width="60">#</th>
                            <th width="80">Stream ID</th>
                            <th>Stream Name</th>
                        </tr>
                    </thead>
                    <tbody>';

        if(empty($streams)) {
            echo '<tr><td colspan="3" class="text-center text-muted">No streams in this category</td></tr>';
        } else {
            $i = 0;
            foreach($streams as $s) {
                $i++;
                echo '<tr>
                    <td class="text-center">' . $i . '</td>
                    <td class="text-center"><strong>' . $s['id'] . '</strong></td>
                    <td>' . htmlspecialchars($s['name']) . '</td>
                </tr>';
            }
        }

        echo '</tbody>
                </table>
                <p class="text-muted">Total: ' . count($streams) . ' streams</p>
            </div>
        </div>';
    }

    /**
     * Auto-sync categories FROM remote MySQL server (204.188.233.170)
     * Called automatically on page load
     */
    private function syncCategoriesFromRemote()
    {
        global $intro;

        error_log("syncCategoriesFromRemote: Starting category sync from remote");

        // Get all categories from remote server (using correct column names)
        $sql = "SELECT id, name, type, parent, ordering FROM categories ORDER BY id;";
        $result = $this->remoteDbExecute($sql);

        if(empty($result)) {
            error_log("syncCategoriesFromRemote: No remote categories found");
            return;
        }

        $lines = explode("\n", trim($result));
        $synced_count = 0;
        $remote_ids = [];

        foreach($lines as $line) {
            if(empty(trim($line))) continue;

            $parts = explode("\t", $line);
            if(count($parts) < 3) continue;

            $cat_id = intval($parts[0]);
            $cat_name = isset($parts[1]) ? trim($parts[1]) : '';
            $cat_type = isset($parts[2]) ? trim($parts[2]) : '';
            $parent_id = isset($parts[3]) ? intval($parts[3]) : 0;
            $cat_order = isset($parts[4]) ? intval($parts[4]) : 0;

            if(empty($cat_name)) continue;

            // Track remote IDs
            $remote_ids[] = $cat_id;

            // Map remote type (0=live, 1=movie, 2=series) to local type
            $category_type_map = ['0' => 'live', '1' => 'movie', '2' => 'series'];
            $local_cat_type = isset($category_type_map[$cat_type]) ? $category_type_map[$cat_type] : 'live';

            // Fix NULL parent
            if(is_null($parent_id) || $parent_id < 0) {
                $parent_id = 0;
            }

            // Check if category exists locally
            $check = $intro->db->query("SELECT id FROM stream_categories WHERE id=$cat_id LIMIT 1");

            if($intro->db->returned_rows > 0) {
                // Update existing category
                $intro->db->query("UPDATE stream_categories SET
                    category_name='" . $intro->db->escape($cat_name) . "',
                    category_type='" . $local_cat_type . "',
                    parent_id=" . $parent_id . ",
                    cat_order=" . ($cat_order > 0 ? $cat_order : $cat_id) . "
                    WHERE id=$cat_id");
            } else {
                // Insert new category
                $data = [
                    'id' => $cat_id,
                    'category_name' => $cat_name,
                    'category_type' => $local_cat_type,
                    'parent_id' => $parent_id,
                    'cat_order' => ($cat_order > 0 ? $cat_order : $cat_id),
                    'category_icon' => ''
                ];
                $intro->db->insert('stream_categories', $data);
            }

            $synced_count++;
        }

        // Delete local categories that don't exist in remote
        if(!empty($remote_ids)) {
            $remote_ids_str = implode(',', $remote_ids);
            $delete_result = $intro->db->query("DELETE FROM stream_categories WHERE id NOT IN ($remote_ids_str)");
            $deleted_count = $intro->db->affected_rows;
            if($deleted_count > 0) {
                error_log("syncCategoriesFromRemote: Deleted $deleted_count local categories not in remote");
            }
        }

        error_log("syncCategoriesFromRemote: Synced $synced_count categories from remote");
    }
}
