<?php 
class Codes_master_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public $adminRow = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $free = [
        101, 
        103, 
        107, 
        110
    ];
    public $master_by = [
        '1' => 'MAC', 
        '2' => 'Serial'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data(intval($this->admin['adminid']));
        if( isset($intro->option['SuperResellSeeAllCodes']) && intval($intro->option['SuperResellSeeAllCodes']) == 1 && $this->admin['level'] == 2 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        else
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
        if( $this->admin['level'] == 1 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        $this->time = time();
        $this->free = $array['free'];
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"> Master Codes </icon> </a>  ');
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-' . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"> Add New Master Code</icon></a> ');
            echo '<a class="btn btn-' . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('master') . (' p_add" href="' . $this->base . '/master"><icon class="icon-history"> Update</icon></a> ');
        }
        echo "\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $sql = $intro->db->query('SELECT *  ,(SELECT count(id) from ' . PREFIX . '_codes WHERE code=master_code) as tot ' . ' from ' . PREFIX . '_codes_master ORDER BY master_by ASC');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Master Codes (' . $totalrows . ') ', 'info');
        echo "\r\n\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>Master Code</th>\r\n\t\t\t<th>Length</th>\r\n\t\t\t<th>Total</th>\r\n\t\t\t<th>Input By</th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($myrow);
            $i++;
            $name = '';
            $color = '';
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='c'>" . $i . "</td>\r\n\t\t\t\t<td class='c'>" . $master_code . "</td>\r\n\t\t\t\t<td class='c'>" . strlen($master_code) . "</td>\r\n\t\t\t\t<td class='c'>" . number_format($tot) . "</td>\r\n\t\t\t\t<td class='c'>" . $this->inputBy[$master_by] . "</td>\r\n\t\t\t\t<td class='c'>";
            if( $master_by == 1 ) 
            {
                $name = 'MACs';
                $color = 'success';
                echo '<a class="btn btn-success" href="' . $intro->app_url('codes', 'FormSerialMac') . ('/?t=mac&code_for_all=' . $master_code . '"><i class="icon-plus"></i> Add MACs</a>');
            }
            else if( $master_by == 2 ) 
            {
                $name = 'Serials';
                $color = 'warning';
                echo '<a class="btn btn-warning" href="' . $intro->app_url('codes', 'FormSerialMac') . ('/?t=serial&code_for_all=' . $master_code . '"><i class="icon-plus"></i> Add Serials</a>');
            }
            else
            {
                echo 'Error: Unknow MAC/Serial';
            }
            echo "\r\n\t\t\t\t\t<a class=\"btn btn-" . $color . '" href="' . $this->base . '/Export/?id=' . $master_code . '&by=' . $master_by . '" title="Export ' . $name . " \"><i class=\"icon-export\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-info\" href=\"" . $this->base . '/WrongActivated/?id=' . $master_code . '&by=' . $master_by . "\" title=\"View Wrong Activated\"><i class=\"icon-bug\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-primary\" href=\"" . $this->base . '/Report/?id=' . $master_code . '&by=' . $master_by . "\" title=\"Report\"><i class=\"icon-list-alt\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-default\" href=\"" . $this->base . '/Form/?id=' . $master_code . '&by=' . $master_by . "&t=edit\" title=\"Report\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $master_code;
        global $master_by;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $master_code = intval($intro->input->get_post('master_code'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        $btn = [];
        $old_code = 0;
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_codes_master WHERE master_code=' . $master_code . ';'));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = 'Edit Master Code: <b>' . $master_code . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $old_code = $master_by;
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Master Code :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><input  type=\"text\" name=\"master_code\" value=\"" . $master_code . '" size="30"> ' . $this->error('master_code') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>For : </td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('master_by', $this->master_by, $master_by) . (' ' . $this->error('master_by') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"old_code\"  value=\"" . $old_code . "\">\r\n\t\t\t\t<button type=\"submit\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $master_code = trim($intro->input->post('master_code'));
        $master_by = trim($intro->input->post('master_by'));
        if( $master_code == '' || $master_by == '' ) 
        {
            if( $master_code == '' ) 
            {
                $error['master_code'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $master_by == '' ) 
            {
                $error['master_by'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['master_code'] = $master_code;
        $data['master_by'] = $master_by;
        $intro->db->insert(PREFIX . '_codes_master', $data);
        $id = $intro->db->insert_id();
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        $master_code = trim($intro->input->post('master_code'));
        $master_by = trim($intro->input->post('master_by'));
        if( $master_code == '' || $master_by == '' ) 
        {
            if( $master_code == '' ) 
            {
                $error['master_code'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $master_by == '' ) 
            {
                $error['master_by'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('edit');
            exit();
        }
        $intro->redirect($this->appname);
    }
    public function Report()
    {
        global $intro;
        global $array;
        $this->nav();
        $id = trim($intro->input->get_post('id'));
        $master_by = intval($intro->input->get_post('by'));
        if( $master_by == 1 ) 
        {
            $name = 'MACs';
            $color = 'success';
            $qry = ' AND serial =\'\' ';
        }
        else if( $master_by == 2 ) 
        {
            $name = 'Serials';
            $color = 'warning';
            $qry = ' AND mac =\'\' ';
        }
        else
        {
            $name = 'Error: Unknow MAC/Serial';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <icon class="icon-list-alt"></icon> Report for ' . $name . ' On Master code: ' . $id . ' ', (string)$color);
        echo "<style>td,th{text-align:center;}</style>\r\n\t\t<table align=\"center\" border=\"1\" width=\"100%\" id=\"table1\" cellpadding=\"2\" bordercolor=\"#C0C0C0\" class=\"table table-striped table-hover table-bordered\">\r\n\t\t<thead>\r\n\t\t<tr>\r\n\t\t\t <th>Period</th>\r\n\t\t\t <th>New</th>\r\n\t\t\t <th>Active</th>\r\n\t\t\t <th>Suspended</th>\r\n\t\t\t <th>Deleted</th>\r\n\t\t\t <th>Expired</th>\r\n\t\t\t <th>Sub Total</th>\r\n\t\t </tr>\r\n\t\t </thead>\r\n\t\t <tbody>";
        $tot = [];
        $tot['tot_row'] = 0;
        $tot['row'] = $tot['tot_row'];
        $tot['tot4'] = $tot['row'];
        $tot['tot3'] = $tot['tot4'];
        $tot['tot2'] = $tot['tot3'];
        $tot['tot1'] = $tot['tot2'];
        $tot['tot0'] = $tot['tot1'];
        foreach( $array['period'] as $key => $val ) 
        {
            $period = intval($key);
            if( in_array($period, $array['free']) ) 
            {
                $pp = ($period - 100) . ' Free Day(s)';
            }
            else
            {
                $pp = $period . ' Month(s)';
            }
            $sql = $intro->db->query_fast('SELECT (SELECT count(id) FROM ' . PREFIX . ('_codes WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' AND `period`=' . $period . ' AND `status`=0 ' . $this->qry_admin . ') as tot0') . ',(SELECT count(id) FROM ' . PREFIX . ('_codes WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' AND `period`=' . $period . ' AND `status`=1 ' . $this->qry_admin . ') as tot1') . ',(SELECT count(id) FROM ' . PREFIX . ('_codes WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' AND `period`=' . $period . ' AND `status`=2 ' . $this->qry_admin . ') as tot2') . ',(SELECT count(id) FROM ' . PREFIX . ('_codes WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' AND `period`=' . $period . ' AND `status`=3 ' . $this->qry_admin . ') as tot3') . ',(SELECT count(id) FROM ' . PREFIX . ('_codes WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' AND `period`=' . $period . ' AND `status`=4 ' . $this->qry_admin . ') as tot4'));
            $row = $intro->db->fetch_assoc($sql);
            extract($row);
            $tot['row'] = $tot0 + $tot1 + $tot2 + $tot3 + $tot4;
            $tot['tot_row'] += $tot['row'];
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t <td>" . $pp . "</td>\r\n\t\t\t\t <td>" . money($tot0) . "</td>\r\n\t\t\t\t <td>" . money($tot1) . "</td>\r\n\t\t\t\t <td>" . money($tot2) . "</td>\r\n\t\t\t\t <td>" . money($tot3) . "</td>\r\n\t\t\t\t <td>" . money($tot4) . "</td>\r\n\t\t\t\t <th>" . money($tot['row']) . "</th>\r\n\t\t\t </tr>";
            $tot['tot0'] += $tot0;
            $tot['tot1'] += $tot1;
            $tot['tot2'] += $tot2;
            $tot['tot3'] += $tot3;
            $tot['tot4'] += $tot4;
        }
        echo "\r\n\t\t </tbody>\t\r\n\t\t <tfooter>\r\n\t\t\t<tr>\r\n\t\t\t\t <th> Total: </td>\r\n\t\t\t\t <th>" . money($tot['tot0']) . "</th>\r\n\t\t\t\t <th>" . money($tot['tot1']) . "</th>\r\n\t\t\t\t <th>" . money($tot['tot2']) . "</th>\r\n\t\t\t\t <th>" . money($tot['tot3']) . "</th>\r\n\t\t\t\t <th>" . money($tot['tot4']) . "</th>\r\n\t\t\t\t <td style='color:#fff;background:#ff0000'>" . money($tot['tot_row']) . "</td>\r\n\t\t\t </tr>\r\n\t\t </tfooter>\r\n\t\t </table>";
    }
    public function WrongActivated()
    {
        global $intro;
        global $array;
        $id = trim($intro->input->get_post('id'));
        $do = trim($intro->input->get_post('do'));
        $master_by = intval($intro->input->get_post('by'));
        if( $master_by == 1 ) 
        {
            $name = 'MACs';
            $color = 'success';
            $qry = ' AND serial =\'\' ';
        }
        else if( $master_by == 2 ) 
        {
            $name = 'Serials';
            $color = 'warning';
            $qry = ' AND mac =\'\' ';
        }
        else
        {
            $name = 'Error: Unknow MAC/Serial';
        }
        $this->nav();
        $qry_online = ',IF(status=1,(select online.activity_id from user_activity_now online   where online.user_id=codes.userid ORDER BY activity_id DESC LIMIT 1),\'\') as activity_id';
        $sql = $intro->db->query_fast('select * ' . $qry_online . ' from ' . PREFIX . '_codes codes ' . (' WHERE `status`=1 AND code=\'' . $id . '\' AND inputBy=' . $master_by . ' ' . $qry . ' order by id asc;'));
        $Total = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Wrong Activated ' . $name . ' Total (' . $Total . ') ', (string)$color);
        if( $Total > 0 ) 
        {
            echo "\r\n\t\t\t<a OnClick=\"return confirm('Are you Sure???');\" class=\"btn btn-danger\" href=\"" . $this->base . '/WrongActivated/?id=' . $id . '&by=' . $master_by . "&do=delete\" title=\"Delete ALL codes\"><i class=\"icon-trash\"></i> Delete All</a>\r\n\t\t\t<a OnClick=\"return confirm('Are you Sure???');\" class=\"btn btn-success\" href=\"" . $this->base . '/WrongActivated/?id=' . $id . '&by=' . $master_by . '&do=new" title="set the code back to new status"><i class="icon-checked"></i> Change status to New </a>';
        }
        echo "\r\n\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>Reseller</th>\r\n\t\t\t<th>Code</th>\r\n\t\t\t<th>Status</th>\r\n\t\t\t<th>MAC</th>\r\n\t\t\t<th>Serial</th>\r\n\t\t\t<th>Start</th>\r\n\t\t\t<th>End</th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            if( $activity_id != '' ) 
            {
                $online = '<icon class="icon-globe" style=\'color:green;\'></icon>';
            }
            else
            {
                $online = '<icon class="icon-globe" style=\'color:red;\'></icon>';
            }
            if( $do == 'delete' ) 
            {
                $intro->db->query_fast('DELETE FROM ' . PREFIX . ('_codes where id=' . $id));
                $intro->db->query_fast('DELETE FROM users where id=' . $userid);
            }
            if( $do == 'new' ) 
            {
                $sql33 = 'UPDATE ' . PREFIX . '_codes set status=0,date_start=NULL,date_expire=NULL';
                if( $master_by == 1 ) 
                {
                    $sql33 .= ',serial=\'\'';
                }
                if( $master_by == 2 ) 
                {
                    $sql33 .= ',mac=\'\'';
                }
                $sql33 .= (' where id=' . $id);
                $intro->db->query_fast($sql33);
                $intro->db->query_fast('DELETE FROM users where id=' . $userid);
            }
            if( $status == 0 ) 
            {
                $label = 'default';
            }
            else if( $status == 1 ) 
            {
                $label = 'success';
            }
            else if( $status == 2 ) 
            {
                $label = 'info';
            }
            else if( $status == 3 ) 
            {
                $label = 'danger';
            }
            else if( $status == 4 ) 
            {
                $label = 'warning';
            }
            else if( $status == 5 ) 
            {
                $label = 'danger';
            }
            else
            {
                $label = 'danger';
            }
            $date_expire = ($date_expire != '' ? @date('Y-m-d', $date_expire) : '-');
            $date_start = ($date_start != '' && $date_start != 0 ? @date('Y-m-d', $date_start) : '-');
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='c'>" . $i . "</td>\r\n\t\t\t\t<td class='c'>" . $online . "</td>\r\n\t\t\t\t<td class='c'>" . $array['admins'][$adminid] . ("</td>\r\n\t\t\t\t<td class='c'>" . $code . "</td>\r\n\t\t\t\t<td class='c'><span class='label label-" . $label . '\'>' . $intro->status[$status] . "</span></td>\r\n\t\t\t\t<td class='c'>" . $mac . "</td>\r\n\t\t\t\t<td class='c'>" . $serial . "</td>\r\n\t\t\t\t<td class='c'>" . $date_start . "</td>\r\n\t\t\t\t<td class='c'>" . $date_expire . "</td>\r\n\t\t\t\t\r\n\t\t\t\t<td class='c'></td>\r\n\t\t\t</tr>");
        }
        echo "</tbody>\r\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Export()
    {
        global $intro;
        $id = trim($intro->input->get_post('id'));
        $master_by = intval($intro->input->get_post('by'));
        if( $master_by == 1 ) 
        {
            $name = 'MACs';
            $color = 'success';
        }
        else if( $master_by == 2 ) 
        {
            $name = 'Serials';
            $color = 'warning';
        }
        else
        {
            $name = 'Error: Unknow MAC/Serial';
        }
        $this->nav();
        $sql = $intro->db->query_fast('select DISTINCT(mac) from ' . PREFIX . '_codes ' . (' WHERE code=\'' . $id . '\' AND inputBy=' . $master_by . ' order by id asc;'));
        $Total = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Expoprt ' . $name . ' Total (' . $Total . ') ', (string)$color);
        echo '<textarea style=\'width:100%;height:400px;\'>';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            echo $row['mac'] . "\n";
        }
        echo '</textarea>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function master()
    {
        global $intro;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Updating Master codes', 'primary');
        echo '<ul>';
        $sql = $intro->db->query('SELECT DISTINCT(code) FROM ' . PREFIX . '_codes where inputBy=1;');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $data = [];
            $data['master_code'] = trim($row['code']);
            $data['master_by'] = 1;
            $intro->db->insert('' . PREFIX . '_codes_master', $data, true);
            echo '<li>for MAC = ' . trim($row['code']) . '</li>';
        }
        $sql = $intro->db->query('SELECT DISTINCT(code) FROM ' . PREFIX . '_codes where inputBy=2;');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $data = [];
            $data['master_code'] = trim($row['code']);
            $data['master_by'] = 2;
            $intro->db->insert('' . PREFIX . '_codes_master', $data, true);
            echo '<li>for SN = ' . trim($row['code']) . '</li>';
        }
        echo '</ul>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
