<?php 
class Commands_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $max_input_vars = 0;
    public $admin = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Sorry: no access!!!', 'danger') );
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\n\t\t<div class=\"app_nav\">\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $intro->app_url('commands', 'index') . "\">\n\t\t\t\t<icon class=\"icon-code\"></icon>\n\t\t\t\tBulk Commands for Codes\n\t\t\t</a>\n\t\t\t\n\t\t\t<a class=\"btn btn-default\" href=\"" . $intro->app_url('commands_users', 'index') . "\">\n\t\t\t\t<icon class=\"icon-list\"></icon>\n\t\t\t\tBulk Commands for Users\n\t\t\t</a>\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        $this->nav();
        echo '<div class=\'ltr\' dir=\'ltr\'>';
        $this->search_form();
        echo '</div>';
    }
    public function form_resellers($html_name, $txt = 'Reseller')
    {
        global $intro;
        $html = '<select name="' . $html_name . "\"  style='min-width:500px'>\n\n\t\t<option value='0' selected>" . $txt . "</option>\n";
        $sql_q = $intro->db->query('select * from ' . PREFIX . '_admin order by admin_name ASC');
        while( $row = $intro->db->fetch_assoc($sql_q) ) 
        {
            $db_adminid = $row['adminid'];
            $db_modname = $row['admin_name'];
            $html .= ('<option value="' . $db_adminid . '">' . $db_modname . " </option>\n");
            $sql2 = $intro->db->query('select * from ' . PREFIX . ('_admin where father=' . $db_adminid . ' order by admin_name ASC'));
            if( $intro->db->returned_rows > 0 ) 
            {
                while( $row2 = $intro->db->fetch_assoc($sql2) ) 
                {
                    $db2_adminid = $row2['adminid'];
                    $db2_modname = $row2['admin_name'];
                    $html .= ('<option value="' . $db2_adminid . '">' . $db_modname . ' -> ' . $db2_modname . " </option>\n");
                }
            }
        }
        $html .= "</select>\n\n\n";
        return $html;
    }
    public function search_form()
    {
        global $intro;
        global $array;
        $max_input_vars = @ini_get('max_input_vars');
        $max_input_vars = intval($max_input_vars);
        if( $max_input_vars == 0 ) 
        {
            $max_input_vars = 1000;
        }
        else
        {
            $max_input_vars = $max_input_vars - 100;
        }
        $this->max_input_vars = $max_input_vars;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Codes Oprations', 'danger');
        echo "\n\t\t<form id=\"form_add\" action=\"\" method=\"post\">\n\t\t<table class='table table-bordered' style='max-width:600px'>\n\t\t<tr>\n\t\t\t\t<td>Code</td>\n\t\t\t\t<td><input type='hidden' name='code_op' value='='></td>\n\t\t\t\t<td><input type=\"text\" name=\"code\" value=\"\" id=\"code\" /></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td>Bulk Codes</td>\n\t\t\t\t<td><input type='hidden' name='bulk_codes_op' value='='></td>\n\t\t\t\t<td><textarea style=\"width:500px;height:50px\" name=\"bulk_codes\" value=\"\" id=\"bulk_codes\"></textarea>\n\t\t\t\t<br/>Put each code in separate line.\n\t\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td>Fullname</td>\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='fullname_op' value='LIKE'></td>\n\t\t\t\t<td><input type=\"text\" name=\"fullname\" value=\"\" id=\"fullname\" /> exaple: jhon* or *hon* </td>\n\t\t</tr> \n\t\t<tr>\n\t\t\t\t<td>TransID</td>\n\t\t\t\t<td>" . $this->operator('transid') . "</td>\n\t\t\t\t<td><input type=\"text\" name=\"transid\" value=\"\" id=\"transid\" /></td>\n\t\t</tr> \n\t\t<tr>\n\t\t\t\t<td>Reseller ID</td>\n\t\t\t\t<td>" . $this->operator('adminid') . "</td>\n\t\t\t\t<td>" . $this->form_resellers('adminid', 'ALL ...') . "</td>\n\t\t</tr> \n\t\t<tr>\n\t\t\t\t<td>Days (Months)</td>\n\t\t\t\t<td>" . $this->operator('period') . "</td>\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', $array['period'], '', 'ALL ...') . "</td>\n\t\t</tr> \n\t\t<tr>\n\t\t\t\t<td>Username</td>\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='username_op' value='LIKE'></td>\n\t\t\t\t<td><input type=\"text\" name=\"username\" value=\"\" id=\"username\" /></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td>Status</td>\n\t\t\t\t<td>" . $this->operator('status') . "</td>\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('status', $intro->status, '', 'ALL ...') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td>Input By:</td>\n\t\t\t\t<td><input type='hidden' name='inputBy_op' value='='></td>\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('inputBy', [
            'code', 
            'MAC', 
            'Serial'
        ], '', 'ALL ...') . ("</td>\n\t\t</tr> \n\t\t\n\t\t<tr>\n\t\t\t\t<td>MAC:</td>\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='mac_op' value='LIKE'></td>\n\t\t\t\t<td><input type=\"text\" name=\"mac\" value=\"\" id=\"mac\" /></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td>Serial:</td>\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='serial_op' value='LIKE'></td>\n\t\t\t\t<td><input type=\"text\" name=\"serial\" value=\"\" id=\"serial\" /></td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t\t<td>Bulk MACs:</td>\n\t\t\t\t<td><input type='hidden' name='bulkCMD' value='mac'></td>\n\t\t\t\t<td><textarea style=\"width:500px;height:80px\" name=\"bulk_mac\" value=\"\" id=\"bulk_mac\"></textarea></td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t\t<td>Row Limit : " . $max_input_vars . "</td>\n\t\t\t\t<td> Example:</td>\n\t\t\t\t<td><input type=\"text\" name=\"limit\" value=\"0\" id=\"limit\" size=\"10\" /> 0= unlimited\n\t\t\t\t<li>0,1000</li>\n\t\t\t\t<li>1000,1000</li>\n\t\t\t\t<li>2000,1000</li>\n\t\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td> </td>\n\t\t\t\t<td> </td>\n\t\t\t\t<td><input name=\"name\" value=\" Search Codes\" type=\"submit\"></td>\n\t\t</tr>\t\t\n\t\t</table>\n\t\t<input type=\"hidden\" name=\"max_input_vars\" value=\"" . $max_input_vars . "\" />\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script type=\"text/javascript\">\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#form_add\").submit( function () {   \n\t\t\t\t\$('#result').html('loading...');\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doSearch?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\$(\"#result\").html(data)\n\t\t\t\t}\n\t\t\t  );\n\t\t\t  return false;   \n\t\t\t});   \n\t\t});\n\t\t</script>\n\t\t<div id=\"result\"></div>\n\t\t";
    }
    public function operator($fld)
    {
        return '<select name="' . $fld . "_op\">\n\t\t<option value=\"=\">=</option>\n\t\t<option value=\">\">&gt;</option>\n\t\t<option value=\">=\">&gt;=</option>\n\t\t<option value=\"<\">&lt;</option>\n\t\t<option value=\"<=\">&lt;=</option>\n\t\t<option value=\"!=\">!=</option>\n\t\t<option value=\"LIKE\">LIKE * *</option>\n\t\t<option value=\"NOT LIKE\">NOT LIKE</option>\n\t\t<option value=\"IN (...)\">IN (...)</option>\n\t\t<option value=\"NOT IN (...)\">NOT IN (...)</option>\n\t\t<option value=\"IS NULL\">IS NULL</option>\n\t\t<option value=\"IS NOT NULL\">IS NOT NULL</option>\n\t\t</select>";
    }
    public function _getWhereClause($post)
    {
        $where = '';
        if( isset($_POST['bulk_mac']) && $_POST['bulk_mac'] != '' ) 
        {
            $data = explode("\n", $_POST['bulk_mac']);
            $code = trim($_POST['code']);
            if( strlen($code) < 8 ) 
            {
                exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please input Code.', 'danger') );
            }
            if( count($data) > 1 ) 
            {
                $ar = [];
                foreach( $data as $mac ) 
                {
                    $mac = trim($mac);
                    $ar[] = '\'' . $mac . '\'';
                }
                return 'AND code=\'' . $code . '\' AND mac IN (' . implode(',', $ar) . ') AND inputBy=1 ';
            }
            else
            {
                return '';
            }
        }
        if( isset($_POST['bulk_codes']) && $_POST['bulk_codes'] != '' ) 
        {
            $data = explode("\n", $_POST['bulk_codes']);
            if( count($data) > 1 ) 
            {
                $ar = [];
                foreach( $data as $mac ) 
                {
                    $mac = trim($mac);
                    $ar[] = '\'' . $mac . '\'';
                }
                return 'AND code IN (' . implode(',', $ar) . ') AND inputBy=0 ';
            }
            else
            {
                return '';
            }
        }
        foreach( $post as $key => $val ) 
        {
            $op = $key . '_op';
            if( isset($post[$op]) ) 
            {
                if( $op == 'adminid_op' && $val == 0 ) 
                {
                    $val = '';
                }
                if( $post[$op] == '=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' = \'' . $val . '\' ');
                }
                if( $post[$op] == '>' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' > \'' . $val . '\' ');
                }
                if( $post[$op] == '<' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' < \'' . $val . '\' ');
                }
                if( $post[$op] == '!=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' != \'' . $val . '\'');
                }
                if( $post[$op] == '>=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' >= \'' . $val . '\' ');
                }
                if( $post[$op] == '<=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' <= \'' . $val . '\' ');
                }
                if( $post[$op] == 'LIKE' && $val != '' ) 
                {
                    $val = str_replace('*', '%', $val);
                    $where .= ('AND ' . $key . ' LIKE \'' . $val . '\' ');
                }
                if( $post[$op] == 'IN (...)' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' IN (' . $val . ') ');
                }
                if( $post[$op] == 'NOT IN (...)' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' NOT IN (' . $val . ') ');
                }
            }
        }
        return $where;
    }
    public function doSearch()
    {
        global $intro;
        global $array;
        $limit = intval($intro->input->post('limit'));
        $inputBy = intval($intro->input->post('inputBy'));
        $max_input_vars = intval($intro->input->post('max_input_vars'));
        if( $limit != 0 ) 
        {
            $limit = 'LIMIT ' . $limit;
        }
        else
        {
            $limit = '';
        }
        $qry = $this->_getWhereClause($_POST);
        if( $qry == '' ) 
        {
            exit( '<fieldset><span class=\'red big\'>Please put anything to search for.</span></fieldset>' );
        }
        $result = $intro->db->query('SELECT * from ' . PREFIX . '_codes ' . (' where true ' . $qry . ' order by date_expire ASC ' . $limit));
        $totalrows = $intro->db->returned_rows;
        if( $max_input_vars < $totalrows ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>We found: ' . number_format($totalrows) . (" codes.\n\t\t\t<br/>Codes are more than " . $max_input_vars . ", please narrow your search.<br/>\n\t\t\tYou can run the following commands on the (") . number_format($totalrows) . ' rows) at once.</h4>', 'info');
            $this->sqlCMD($qry, $totalrows);
            exit();
        }
        if( $totalrows > 0 ) 
        {
            echo '<form action="' . $this->base . '/doCMD" method="post" name="fieldsForm"  id="fieldsForm">';
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found Codes (' . $totalrows . ') ', 'info');
            echo "\t\t\t\n\t\t\t<table class=\"table table-bordered\" id='CodesTable'>\n\t\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<th> </th>\n\t\t\t\t<th>" . $intro->lang['codes_fullname'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('fullname', 'index') . " </th>\n\t\t\t\t<th>" . $intro->lang['codes_code'] . '  </th>';
            if( $intro->input->post('username') != '' ) 
            {
                echo '<th>Username </th>';
            }
            echo "\n\t\t\t\t<th>" . $intro->lang['codes_days'] . " </th>\n\t\t\t\t<th>Rseller  </th>\n\t\t\t\t<th>" . $intro->lang['codes_transid'] . " </th>\n\t\t\t\t<th>" . $intro->lang['codes_status'] . "  </th>\n\t\t\t\t<th>MAC </th>\n\t\t\t\t<th>Serial</th>\n\t\t\t\t<th>Start</th>\n\t\t\t\t<th>Expire</th>\n\t\t\t\t<th>Input</th>\n\t\t\t\t<th>Options</th>\n\t\t\t</tr>\n\t\t\t</thead>\n\t\t\t\n\t\t\t<tbody>";
            $i = 0;
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                @extract($myrow);
                $i++;
                $code_replaced = $myrow['code_replaced'];
                if( $status == 0 ) 
                {
                    $label = 'default';
                }
                else if( $status == 1 ) 
                {
                    $label = 'success';
                }
                else if( $status == 2 ) 
                {
                    $label = 'info';
                }
                else if( $status == 3 ) 
                {
                    $label = 'danger';
                }
                else if( $status == 4 ) 
                {
                    $label = 'default';
                }
                else if( $status == 5 ) 
                {
                    $label = 'warning';
                }
                else
                {
                    $label = 'danger';
                }
                $date_expire = ($date_expire != '' ? @date('Y-m-d', $date_expire) : '-');
                $date_start = ($date_start != '' ? @date('Y-m-d', $date_start) : '-');
                echo "\n\t\t\t\t<tr>\n\t\t\t\t\t<td><input type=\"checkbox\" id=\"checkbox_row_" . $id . ('" value="' . $id . "\" name=\"selected_fld[]\"></td>\n\t\t\t\t\t<td>" . $fullname . "</td>\n\t\t\t\t\t<td>" . $code . '</td>');
                if( $intro->input->post('username') != '' ) 
                {
                    echo '<td>' . $username . '</td>';
                }
                echo "\n\t\t\t\t\t<td>" . period($period, $free_days) . ("</td>\n\t\t\t\t\t<td>" . $adminid . "</td>\n\t\t\t\t\t<td>" . $transid . "</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<span class='label label-" . $label . '\'>' . $intro->status[$status] . ' ') . (($code_replaced != '' ? '<br/>' . $code_replaced : '')) . '</span>';
                if( $status != 3 ) 
                {
                }
                echo "\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>" . $mac . "</td>\n\t\t\t\t\t<td>" . $serial . "</td>\n\t\t\t\t\t<td>" . $date_start . "</td>\n\t\t\t\t\t<td>" . $date_expire . "</td>\n\t\t\t\t\t<td>" . $this->inputBy[$inputBy] . "</td>\n\t\t\t\t\t<td class=\"center\"> \n\t\t\t\t\t</td>\n\t\t\t\t</tr>";
            }
            echo "</tbody>\n\t\t\t\t</table>";
            $this->optionCMD();
            echo '</fieldset>';
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            echo "\n\t\t\t<input type='hidden' name='status' value='" . intval($intro->input->post('status')) . ("'>\n\t\t\t<input type='hidden' name='totalrows' value='" . $totalrows . "'>\n\t\t\t<input type='hidden' name='inputBy' value='" . $inputBy . "'>\n\t\t\t</form>");
            echo '<div id="resultCMD"></div>';
            echo $this->base;
            echo "/doCMD?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\t\n\t\t\t\t\t\t\$(\"#resultCMD\").html(data)\n\t\t\t\t\t}\n\t\t\t\t  );\n\t\t\t\t  return false;   \n\t\t\t\t});\n\t\t\t\t\n\t\t\t\tvar \$checkboxes = \$('#CodesTable input[type=\"checkbox\"]');\n\t\t\t\t\n\t\t\t\t\$(\"#checkAllCodes\").change(function () {\n\t\t\t\t\t\$(\"#CodesTable input:checkbox\").prop('checked', \$(this).prop(\"checked\"));\n\t\t\t\t\tvar countCheckedCheckboxes = \$checkboxes.filter(':checked').length;\n\t\t\t\t\t\$('#checked_count').html(countCheckedCheckboxes);\n\t\t\t\t});\n\n\t\t\t\t\$checkboxes.change(function()\n\t\t\t\t{\n\t\t\t\t\tvar countCheckedCheckboxes = \$checkboxes.filter(':checked').length;\n\t\t\t\t\t\$('#checked_count').html(countCheckedCheckboxes);\n\t\t\t\t\t\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\t\$(\"#forced_country,#renew_val,#period_val\").addClass('chosen').chosen({search_contains: true});\n\t\t\t\t\$(\"select[name='member_id_val']\").addClass('chosen').chosen({search_contains: true});\n\t\t\t\n\t\t\t});\n\t\t\t</script>\n\t\t\t";
        }
        else
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Nothing found.', 'danger');
        }
    }
    public function doCMD()
    {
        global $intro;
        $selected_fld = $intro->input->post('selected_fld');
        $status = intval($intro->input->post('status'));
        $totalrows = intval($intro->input->post('totalrows'));
        if( !is_array($selected_fld) || count($selected_fld) <= 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please select codes', 'danger') );
        }
        $IDs = implode(',', $selected_fld);
        $qry = ' WHERE id IN (' . $IDs . ')';
        $_POST['qry'] = $qry;
        $_POST['status'] = $status;
        $_POST['inputBy'] = intval($intro->input->post('inputBy'));
        $this->doCMDsql();
    }
    public function optionCMD($totalrows = 0)
    {
        global $intro;
        global $array;
        global $adminid;
        global $type;
        global $status;
        $adminid = 0;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning: Warning: Warning: Backup your data first!!! ', 'danger');
        $i = 1;
        echo " \n\t\t<table class=\"table table-bordered\" id=\"TableCMD\">\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"delete\"/>\n\t\t\t<td style=\"width:250px\">" . $i++ . "- Delete Codes from Database.</td>\n\t\t\t<td> </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"renew\"/></td>\n\t\t\t<td>" . $i++ . "- Renew For: </td>\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('renew_val', $array['period'], '') . " this will renew all and extend expire date. </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"fix_expire\"/></td>\n\t\t\t<td>" . $i++ . "- Fix expire date: </td>\n\t\t\t<td> it will calculate from start date. </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"date_expire\"/></td>\n\t\t\t<td>" . $i++ . "- Update Expire Date (End Date): </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"date_expire_val\" value=\"\" maxlength=\"10\" placeholder=\"yyyy-mm-dd\" /></td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"change_master\"/></td>\n\t\t\t<td>" . $i++ . "- Change Master Code: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"master_code\" value=\"\" maxlength=\"30\" placeholder=\"\" /> for MAC and Serials Only</td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"adminid\"/></td>\n\t\t\t<td>" . $i++ . "- Change (Reseller): </td>\n\t\t\t<td> " . form_resellers('adminid_val', $adminid) . " </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"status\"/></td>\n\t\t\t<td>" . $i++ . "- Change Status: </td>\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('status_val', $intro->status, $status) . "</td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"unsuspend\"/></td>\n\t\t\t<td>" . $i++ . "- Unsuspend </td>\n\t\t\t<td> This will unsuspend all suspended codes.</td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"period\"/></td>\n\t\t\t<td>" . $i++ . "- Change Days (Months): </td>\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period_val', $array['period'], '') . " this will change the Period only and will not change expire date. </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"transid\"/></td>\n\t\t\t<td>" . $i++ . "- Change TransID: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"transid_val\" value=\"\" maxlength=\"10\" /></td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"forced_country\"/></td>\n\t\t\t<td>" . $i++ . "- Override General Country Restriction : </td>\n\t\t\t<td>" . forced_country('') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"bouquets\"/></td>\n\t\t\t<td>" . $i++ . "- Change Bouquets:\n\t\t\t\t<div>\n\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\n\t\t\t\t</div>\n\t\t\t\t<h3>Choose from the following:</h3>\n\t\t\t\t<div style='color:red;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"all\"/>\n\t\t\t\t\t(Replace ALL) This will override all Bouquets for all selected codes.\n\t\t\t\t</div>\n\t\t\t\t<div style='color:green;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"add\"/>\n\t\t\t\t\t(Add Selected) Select the Bouquets to add to codes , this option will keep all packages and add the new ones you select.\n\t\t\t\t</div>\n\t\t\t\t<div style='color:blue;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"remove\"/>\n\t\t\t\t\t(Remove Selected) Remove selected Bouquets, this option will keep all packages and remove the new ones you select.\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t\t<td id=\"BQ_CHECK_BOXES\">" . bouquets([]) . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"changeUser\"/></td>\n\t\t\t<td>" . $i++ . "- Change MAC/Serial Username: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"username_val\" value=\"\" maxlength=\"15\" /> \n\t\t\t\tStarting From: <input dir=ltr type=\"text\" name=\"startNumber\" value=\"1\" size='10' maxlength=\"10\" /> </td>\n\t\t</tr>\n\t\t\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"fullname\"/></td>\n\t\t\t<td>" . $i++ . "- Change Fullname: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"fullname_val\" value=\"\" maxlength=\"50\" size='40' /></td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"useragent\"/></td>\n\t\t\t<td>" . $i++ . "- Change Useragent: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"useragent_val\" value=\"\" maxlength=\"150\" size='40' placeholder='Useragent' /></td>\n\t\t</tr>";
        echo "\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"free_days\"/></td>\n\t\t\t<td>" . $i++ . " - Add Free Days: </td>\n\t\t\t<td><input type=\"text\" name=\"free_days_val\" value=\"\" maxlength=\"10\" size='15' /></td>\n\t\t</tr>";
        echo "\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"reset_mac_sn\"/></td>\n\t\t\t<td>" . $i++ . " - Reset MAC and Serial : </td>\n\t\t\t<td>for Normal codes only. (Input by MACs and Serials are not reset.)</td>\n\t\t</tr>";
        echo "\n\t\t<tr>\t\n\t\t\t<td> </td>\n\t\t\t<td> <input class=\"btn btn-danger\" name=\"namesubbtn\" \n\t\t\t\t\tvalue=\"  " . (($totalrows > 0 ? ' Update All (' . number_format($totalrows) . ') rows Now!' : '  GO  ')) . " \" \n\t\t\t\t\ttype=\"submit\" OnClick=\"return confirm('Are you sure? this is final.');\"></td>\n\t\t\t<td> </td>\n\t\t</tr>\n\t\t</table>";
        echo "\n\t\t<style>\n\t\t\t#TableCMD tr{cursor:pointer}\n\t\t</style>\n\t\t<script>\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#TableCMD input[type='radio']\").on( \"click\", function() {\n\t\t\t\t\n\t\t\t\t\$(\"#TableCMD tr\").removeClass('info');\n\t\t\t\t\$(this).closest('tr').addClass('info');\n\t\t\t});\n\t\t\t\$('#TableCMD tr').click(function() {\n\t\t\t\t\n\t\t\t\t\$(\"#TableCMD tr\").removeClass('info');\n\t\t\t\t\$(this).addClass('info');\n\t\t\t\t\$(this).find('td:first-child input:radio').prop('checked', true);\n\t\t\t});\n\t\t\t\n\t\t\t\$(\"#checkAll\").change(function () {\n\t\t\t\t\$(\"#BQ_CHECK_BOXES input:checkbox\").prop('checked', \$(this).prop(\"checked\"));\n\t\t\t});\n\t\t});\n\t\t</script>";
    }
    public function sqlCMD($qry, $totalrows = 0)
    {
        global $intro;
        $status = intval($intro->input->post('status'));
        $inputBy = intval($intro->input->post('inputBy'));
        echo "\n\t\t<form action=\"" . $this->base . '/doCMDsql" method="post" name="fieldsForm"  id="fieldsForm">';
        echo '<fieldset>';
        $this->optionCMD($totalrows);
        echo '</fieldset>';
        echo "\n\t\t\t<input type=\"hidden\" name=\"qry\" value=\"" . $qry . "\" />\n\t\t\t<input type=\"hidden\" name=\"status\" value=\"" . $status . "\" />\n\t\t\t<input type=\"hidden\" name=\"inputBy\" value=\"" . $inputBy . "\" />\n\t\t\t</form>";
        echo "\t\t<script>\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#fieldsForm\").submit( function () {   \n\t\t\t\t\$('#resultCMD').html('<span style=\"background:#fff\">loading... this could take serveral minutes</span>');\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doCMDsql?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\n\t\t\t\t\t\$(\"#resultCMD\").html(data)\n\t\t\t\t}\n\t\t\t  );\n\t\t\t  return false;   \n\t\t\t});   \n\t\t});\n\t\t</script>\n\t\t<div id=\"resultCMD\"></div>\n\t\t";
    }
    public function doCMDsql()
    {
        global $intro;
        global $array;
        $xtream = '';
        $status = intval($intro->input->post('status'));
        $maa = trim($intro->input->post('maa'));
        $bouquetsOptions = trim($intro->input->post('bouquetsOptions'));
        $bouquets_post_array = $intro->input->post('bouquets');
        if( is_array($bouquets_post_array) ) 
        {
            $bouquets_str = implode(',', $bouquets_post_array);
        }
        if( $maa == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please choose command. ', 'danger');
            exit();
        }
        $qry = $_POST['qry'];
        if( $qry == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Unknown Query !!! ', 'danger');
            exit();
        }
        $qry = preg_replace('/AND/', 'WHERE', $qry, 1);
        if( $qry == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please choose command. ', 'danger');
            exit();
        }
        $num = $num2 = 0;
        if( $maa == 'delete' ) 
        {
            $sql = $intro->db->query_fast('select userid from ' . PREFIX . ('_codes ' . $qry . ';'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $userid = intval($row['userid']);
                $intro->db->query_fast('DELETE from users where id=' . $userid . ';');
                $num2 = $intro->db->affected_rows;
            }
            $intro->db->query('DELETE from ' . PREFIX . ('_codes ' . $qry . ';'));
            $num = $intro->db->affected_rows;
        }
        else if( $maa == 'fix_expire' ) 
        {
            $sql = $intro->db->query_fast('select id,period,status,date_start,date_expire,userid from ' . PREFIX . ('_codes ' . $qry . ';'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $id = intval($row['id']);
                $userid = intval($row['userid']);
                $status = intval($row['status']);
                $period = intval($row['period']);
                if( $status != 0 ) 
                {
                    $expire = $this->fix_expire_date($period, trim($row['date_start']), $status);
                    if( $expire != 0 ) 
                    {
                        $intro->db->query_fast('UPDATE ' . PREFIX . ('_codes set date_expire=\'' . $expire . '\' where id=' . $id . ';'));
                        $num += $intro->db->affected_rows;
                        $intro->db->query_fast('UPDATE users SET exp_date=\'' . $expire . '\' where id=' . $userid . ';');
                        $num2 += $intro->db->affected_rows;
                    }
                }
            }
        }
        else if( $maa == 'renew' ) 
        {
            $period = intval($_POST['renew_val']);
            if( $period > 0 ) 
            {
                $sql = $intro->db->query_fast('select id,status,date_expire,userid from ' . PREFIX . ('_codes ' . $qry . ';'));
                while( $row = $intro->db->fetch_assoc($sql) ) 
                {
                    $id = intval($row['id']);
                    $userid = intval($row['userid']);
                    $status = intval($row['status']);
                    if( $status != 0 ) 
                    {
                        $date_expire = trim($row['date_expire']);
                        $expire = $this->calcPeriod($period, $date_expire, $status);
                        if( $expire != 0 ) 
                        {
                            $intro->db->query_fast('UPDATE ' . PREFIX . ('_codes set date_expire=\'' . $expire . '\',status=1 where id=' . $id . ';'));
                            $num += $intro->db->affected_rows;
                            $intro->db->query_fast('UPDATE users SET exp_date=\'' . $expire . '\',enabled=1 where id=' . $userid . ';');
                            $num2 += $intro->db->affected_rows;
                        }
                    }
                }
            }
            else
            {
                exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('ERROR: choose the period : 1 or 3 or 6 or 16 months etc... ', 'danger') );
            }
        }
        else if( $maa == 'change_master' ) 
        {
            $value = trim($_POST['master_code']);
            $inputBy = intval($_POST['inputBy']);
            if( $inputBy == 0 ) 
            {
                exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: master code change is for MACs and Serials only.', 'danger') );
            }
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set code=\'' . $value . '\' ' . $qry . ' AND inputBy!=0;'));
            $num = $intro->db->affected_rows;
        }
        else if( $maa == 'date_expire' ) 
        {
            $value = strtotime($_POST['date_expire_val']);
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set date_expire=\'' . $value . '\' ' . $qry . ';'));
            $num = $intro->db->affected_rows;
        }
        else if( $maa == 'unsuspend' ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set status=1 ' . $qry . ' AND date_expire!=\'\';'));
            $num = $intro->db->affected_rows;
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set status=0 ' . $qry . ' AND date_expire=\'\';'));
            $num += $intro->db->affected_rows;
            $sql = $intro->db->query_fast('select id,userid from ' . PREFIX . ('_codes ' . $qry . ';'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $id = intval($row['id']);
                $userid = intval($row['userid']);
                $intro->db->query_fast('UPDATE users SET enabled=1,admin_enabled=1 WHERE id=' . $userid . ';');
                $num2 += $intro->db->affected_rows;
            }
        }
        else if( $maa == 'bouquets' ) 
        {
            $sql = $intro->db->query_fast('select id,userid,bouquets from ' . PREFIX . '_codes ' . (' ' . $qry . ';'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $id = intval($row['id']);
                $userid = intval($row['userid']);
                $db_bq = explode(',', $row['bouquets']);
                if( $bouquetsOptions == 'add' ) 
                {
                    $merge = array_merge($db_bq, $bouquets_post_array);
                    $unique = array_unique($merge);
                    $bouquets_str = implode(',', $unique);
                }
                if( $bouquetsOptions == 'remove' ) 
                {
                    $diff = array_diff($db_bq, $bouquets_post_array);
                    $bouquets_str = implode(',', $diff);
                }
                $intro->db->query_fast('UPDATE ' . PREFIX . ('_codes set bouquets=\'' . $bouquets_str . '\' where id=' . $id . ';'));
                $num += $intro->db->affected_rows;
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where id=' . $userid . ';');
                $num2 += $intro->db->affected_rows;
            }
        }
        else if( $maa == 'forced_country' ) 
        {
            $sql = $intro->db->query_fast('select id,userid from ' . PREFIX . '_codes ' . (' ' . $qry . ';'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $id = intval($row['id']);
                $userid = intval($row['userid']);
                $forced_country = $intro->input->post('forced_country');
                $intro->db->query_fast('UPDATE ' . PREFIX . ('_codes set forced_country=\'' . $forced_country . '\' where id=' . $id . ';'));
                $num += $intro->db->affected_rows;
                $intro->db->query_fast('UPDATE users SET forced_country=\'' . $forced_country . '\' where id=' . $userid . ';');
                $num2 += $intro->db->affected_rows;
            }
        }
        else if( $maa == 'changeUser' ) 
        {
            exit( 'Not WORKING YET!!!!!!!!!!!!!!!!!!' );
        }
        else if( $maa == 'useragent' ) 
        {
            $useragent = trim($intro->input->post('useragent_val'));
            if( $useragent != '' ) 
            {
                $ex = explode(',', $useragent);
                $agnet = json_encode($ex);
            }
            else
            {
                $agnet = '';
            }
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set allowed_uagent=\'' . $agnet . '\' ' . $qry . ';'));
            $num += $intro->db->affected_rows;
            $sql = $intro->db->query('select userid from ' . PREFIX . ('_codes ' . $qry . ' AND `status`!=0;'));
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $userid = intval($row['userid']);
                $intro->db->query_fast('UPDATE users SET allowed_ua=\'' . $agnet . '\' where id=' . $userid . ';');
                $num2 += $intro->db->affected_rows;
            }
        }
        else if( $maa == 'free_days' ) 
        {
            $free_days = intval($intro->input->post('free_days_val'));
            if( $free_days > 0 ) 
            {
                $sql = $intro->db->query('select id,userid,date_expire  from ' . PREFIX . ('_codes ' . $qry . ';'));
                while( $row = $intro->db->fetch_assoc($sql) ) 
                {
                    if( $row['date_expire'] != '' && $row['date_expire'] != 0 ) 
                    {
                        $id = intval($row['id']);
                        $userid = intval($row['userid']);
                        $date_expire = trim($row['date_expire']);
                        $date_expire = strtotime('+' . $free_days . ' days', $date_expire);
                        $intro->db->query_fast('UPDATE ' . PREFIX . ('_codes SET date_expire=\'' . $date_expire . '\' where id=' . $id . ';'));
                        $num += $intro->db->affected_rows;
                        if( $userid > 0 ) 
                        {
                            $intro->db->query_fast('UPDATE users SET exp_date=\'' . $date_expire . '\' where id=' . $userid . ';');
                            $num2 += $intro->db->affected_rows;
                        }
                    }
                }
            }
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set free_days=\'' . $free_days . '\' ' . $qry . ';'));
            $num += $intro->db->affected_rows;
        }
        else if( $maa == 'reset_mac_sn' ) 
        {
            if( $status != 1 ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Error, you can reset Active Codes only. set (status=1).', 'danger');
                exit( '' );
            }
            $intro->db->query('UPDATE ' . PREFIX . '_codes set ' . (' mac=\'reset_me\',mac2=\'\',serial=\'reset_me\' ' . $qry . ' AND inputBy=0 AND is_mag=0;'));
            $num += $intro->db->affected_rows;
        }
        else
        {
            $field = $maa;
            $value = $_POST[$maa . '_val'];
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set ' . $field . '=\'' . $value . '\' ' . $qry . ';'));
            $num = $intro->db->affected_rows;
        }
        if( $num2 > 0 ) 
        {
            $xtream = ' Xtream Affected rows (' . $num2 . ') ';
        }
        else
        {
            $xtream = '';
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Affected Code Rows = (' . $num . ') ' . $xtream . ' ', 'success');
    }
    public function fix_expire_date($period, $expire, $status)
    {
        global $array;
        if( $status == 0 || $period == 0 ) 
        {
            return 0;
        }
        $exp_date = '';
        if( in_array($period, $array['free']) ) 
        {
            $dd = $period - 100;
            $exp_date = strtotime('+' . $dd . ' days', $expire);
        }
        else
        {
            $exp_date = strtotime('+' . $period . ' month', $expire);
        }
        if( $exp_date != '' ) 
        {
            return $exp_date;
        }
        else
        {
            return 0;
        }
    }
    public function calcPeriod($period, $expire, $status)
    {
        global $array;
        if( $status == 0 || $period == 0 ) 
        {
            return 0;
        }
        $exp_date = '';
        if( $expire < time() ) 
        {
            $expire = time();
        }
        if( in_array($period, $array['free']) ) 
        {
            $dd = $period - 100;
            $exp_date = strtotime('+' . $dd . ' days', $expire);
        }
        else
        {
            $exp_date = strtotime('+' . $period . ' month', $expire);
        }
        if( $exp_date != '' ) 
        {
            return $exp_date;
        }
        else
        {
            return 0;
        }
    }
    public function delMAC()
    {
        global $intro;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete MACs', 'danger');
        echo "\n\t\t<form id=\"form_add\" action=\"" . $this->base . "/doDelMACs\" method=\"post\">\n\t\t<table class='table table-bordered' style='max-width:800px'>\n\t\t<tr>\n\t\t\t\t<td>MACs</td>\n\t\t\t\t<td><textarea name=\"all_macs\" style='width:90%;height:250px;'></textarea></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t\t<td> </td>\n\t\t\t\t<td><input name=\"name\" value=\" Delete MACs \" type=\"submit\"></td>\n\t\t</tr>\t\t\n\t\t</table>\n\t\t\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doDelMACs()
    {
        global $intro;
        $not_found = '';
        $all_macs = $intro->input->post('all_macs');
        $data = explode("\n", $all_macs);
        $numCode = $numX = $notFoundNum = 0;
        for( $i = 0; $i < count($data); $i++ ) 
        {
            $mac = trim($data[$i]);
            $sql = $intro->db->query_fast('select id,userid from ' . PREFIX . '_codes ' . (' where inputBy=1 AND mac=\'' . $mac . '\';'));
            $row = $intro->db->fetch_assoc($sql);
            $userid = intval($row['userid']);
            $id = intval($row['id']);
            if( $id == 0 ) 
            {
                $not_found .= ($mac . '<br/>');
                $notFoundNum++;
            }
            $intro->db->query_fast('DELETE from users where id=' . $userid . ';');
            $numX += $intro->db->affected_rows;
            $intro->db->query('DELETE from ' . PREFIX . ('_codes where id=' . $id . ';'));
            $numCode += $intro->db->affected_rows;
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete MACs', 'danger');
        echo ' <h3>deleted codes = ' . $numCode . '</h3>';
        echo ' <h3>deleted xtrea users = ' . $numX . '</h3>';
        if( $notFoundNum > 0 ) 
        {
            echo ' <h3>Not Found MACS = ' . $notFoundNum . '</h3>';
            echo $not_found;
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
