<?php 
echo '﻿';
class Epg_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $intro->lang['epg_appname'] = 'EPG Source';
        $intro->lang['epg_add'] = 'Add New EPG Source';
        $intro->lang['epg_edit'] = 'Edit EPG Source';
        $intro->lang['epg_cur'] = 'Current EPG Source';
        $intro->lang['epg_id'] = 'ID';
        $intro->lang['epg_epg_name'] = 'EPG Name';
        $intro->lang['epg_epg_file'] = ' EPG Source File';
        $intro->lang['epg_integrity'] = 'Integrity';
        $intro->lang['epg_last_updated'] = 'Last updated';
        $intro->lang['epg_days_keep'] = ' Keep old EPG data for X Days';
        $intro->lang['epg_data'] = 'Total EPG Data';
        $array['stream_categories'][0] = '';
        $result = $intro->db->query('SELECT id,category_name from stream_categories WHERE category_type=\'live\' order by category_name ASC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            $array['stream_categories'][$myrow['id']] = $myrow['category_name'];
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"></icon>') . $intro->lang['epg_appname'] . "</a> \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>') . $intro->lang['epg_add'] . "</a>  \t\t \t\t \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Set_Streams') . (' p_add" href="' . $this->base . "/Set_Streams\"><icon class=\"icon-podcast\"></icon>Set EPG for Streams</a>  \t\r\n\t\t<a class=\"btn btn-danger p_add\" href=\"" . $this->base . "/index/?action=Flush\" OnClick=\"return confirm('This will delete all EPG Data. You must do Reload EPG to update all sources.');\"><icon class=\"icon-X\"></icon>Flush EPG</a>  \t\t \t\t \t\t\r\n\t\t<a class=\"btn btn-danger p_add\" href=\"" . $this->base . "/index/?action=Reload\"><icon class=\"icon-X\"></icon>Reload EPG</a>  \t\t \t\t \t\t\r\n\t\t</div>");
    }
    public function gz_get_contents($path)
    {
        $file = @gzopen($path, 'rb', false);
        if( $file ) 
        {
            for( $data = ''; !gzeof($file); $data .= gzread($file, 1024) ) 
            {
            }
            gzclose($file);
        }
        return $data;
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = '';
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $action = trim($intro->input->get_post('action'));
        $this->nav();
        if( $action == 'Flush' ) 
        {
            $intro->db->query('TRUNCATE `epg_data`;');
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('All EPG Data has been deleted. You must do Reload EPG to update all sources.');
        }
        if( $action == 'Reload' ) 
        {
            $rep = _obf_0D3015381834391534383C26052A360C113F3E3D383B32([
                'for' => 'reload_epg', 
                'server_id' => 1
            ]);
            if( $rep == 'success' ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Reload success. Please wait for 10 minutes for new data to update.');
            }
            else
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: ' . $rep, 'danger');
            }
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("If Reload not working properly you can login to Main server ssh and run this command:\r\n\t\t\t\t<pre>/home/xtreamcodes/iptv_xtream_codes/php/bin/php /home/xtreamcodes/iptv_xtream_codes/crons/epg.php</pre>", 'info');
        }
        if( $search_txt != '' ) 
        {
            $qry = ' where epg_name LIKE \'%' . $search_txt . '%\' ';
        }
        if( $order == '' ) 
        {
            $order = 'id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 50;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT * from epg ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page);
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from epg ' . $qry . ' ');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['epg_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t<fieldset>\r\n\t\t\t<form action=\"\" method=\"post\">\r\n\t\t\t\t<input type=\"text\" name=\"search_txt\" value=\"" . $search_txt . '" placeholder="' . $intro->lang['search_form'] . "\" size=\"20\">\r\n\t\t\t\t<input name=\"name\" value=\"" . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t\t</form>\r\n\t\t</fieldset>\r\n\t\t\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>" . $intro->lang['epg_id'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['epg_epg_name'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('epg_name', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['epg_epg_file'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('epg_file', 'index') . " </th>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>" . $intro->lang['epg_last_updated'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('last_updated', 'index') . " </th>\r\n\t\t\t<th>Days " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('days_keep', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t<td class=\"center\">" . $i . "</td>\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td>" . $epg_name . "</td>\r\n\t\t\t\t<td style='font-size:11px;'>" . $epg_file . "</td>\r\n\t\t\t\t<td>");
            if( $action == 'ReloadXX' ) 
            {
                $this->EpgReload($id, $epg_file);
            }
            echo "</td>\r\n\t\t\t\t<td>" . (($last_updated != '' ? _obf_0D10361F073B102D294032060E21400727331210083132($last_updated) : 'Never')) . ("</td>\r\n\t\t\t\t<td>" . $days_keep . "</td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="') . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?id=' . $id . '" OnClick="return false;" title="') . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t</table>\r\n\t\t</div>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?search_txt=' . $search_txt . '&amp;order=' . $order, $totalrows, $rows_per_page, $page) . '</div>');
    }
    public function EpgReload($epg_id, $url)
    {
        global $intro;
        $epg_id = intval($epg_id);
        $data = file_get_contents($url);
        $xml = simplexml_load_string($data);
        if( $xml === false ) 
        {
            echo '<span class=\'label label-danger\'>Failed loading XML: ';
            foreach( libxml_get_errors() as $error ) 
            {
                echo $error->message;
            }
            echo '</span>';
        }
        else
        {
            $channels = [];
            foreach( $xml->channel as $c ) 
            {
                $langs = [];
                $id = $c['id']->__toString();
                $name = $c->display_name->__toString();
                $lang = $c->display_name['lang'];
                $channels[$id] = [
                    'display_name' => $name, 
                    'langs' => (array)$lang
                ];
            }
            if( is_array($channels) && count($channels) > 5 ) 
            {
                $data = [];
                $data['data'] = json_encode($channels);
                $intro->db->update('epg', $data, 'id=' . $epg_id);
                echo '<span class=\'label label-success\'>Success</span>';
            }
            else
            {
                echo '<span class=\'label label-danger\'>Error: unable to read xml data.</span>';
            }
        }
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $id;
        global $epg_name;
        global $epg_file;
        global $integrity;
        global $last_updated;
        global $days_keep;
        global $data;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM epg WHERE id=' . $id . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = $intro->lang['epg_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['epg_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>" . $intro->lang['epg_epg_name'] . (" : </td>\r\n\t\t\t<td><input  type=\"text\" name=\"epg_name\" class='form-control' value=\"" . $epg_name . '" size="30"> ' . $this->error('epg_name') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['epg_epg_file'] . (" : </td>\r\n\t\t\t<td><input  type=\"text\" name=\"epg_file\" class='form-control' value=\"" . $epg_file . '" size="30" placeholder="Example: http://epg-site.com/the-epg-source.xml"> ' . $this->error('epg_file') . "</td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['epg_days_keep'] . (" : </td>\r\n\t\t\t<td><input type=\"number\" min='0' max='7' name=\"days_keep\" class='form-control' value=\"" . $days_keep . '" size="30"> ' . $this->error('days_keep') . "</td>\r\n\t\t</tr>\r\n\t\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t<button type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</div>\r\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $epg_name = trim($intro->input->post('epg_name'));
        $epg_file = trim($intro->input->post('epg_file'));
        $integrity = trim($intro->input->post('integrity'));
        $days_keep = intval($intro->input->post('days_keep'));
        if( $epg_name == '' || $epg_file == '' ) 
        {
            if( $epg_name == '' ) 
            {
                $error['epg_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $epg_file == '' ) 
            {
                $error['epg_file'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['epg_name'] = $epg_name;
        $data['epg_file'] = $epg_file;
        $data['days_keep'] = $days_keep;
        $intro->db->insert('epg', $data);
        $id = $intro->db->insert_id();
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        $epg_name = trim($intro->input->post('epg_name'));
        $epg_file = trim($intro->input->post('epg_file'));
        $integrity = trim($intro->input->post('integrity'));
        $days_keep = intval($intro->input->post('days_keep'));
        if( $epg_name == '' || $epg_file == '' ) 
        {
            if( $epg_name == '' ) 
            {
                $error['epg_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $epg_file == '' ) 
            {
                $error['epg_file'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['epg_name'] = $epg_name;
        $data['epg_file'] = $epg_file;
        $data['days_keep'] = $days_keep;
        $id = intval($intro->input->post('id'));
        $intro->db->update('epg', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('SELECT * FROM epg WHERE id=' . $id . ';');
        $row = $intro->db->fetch_assoc($sql);
        $sql = $intro->db->query('DELETE FROM epg WHERE id=' . $id . '; ');
        $intro->redirect($this->appname);
    }
    public function Set_Streams()
    {
        global $intro;
        global $array;
        global $admin_path;
        $qry = $params = '';
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $cat_id = intval($intro->input->get_post('cat_id'));
        $stream_display_name = trim($intro->input->get_post('stream_display_name'));
        $this->nav();
        if( $stream_display_name != '' ) 
        {
            $qry .= (' and stream_display_name  LIKE \'%' . $stream_display_name . '%\' ');
            $params .= ('&stream_display_name=' . $stream_display_name);
        }
        if( $cat_id != 0 ) 
        {
            $qry .= (' and category_id =\'' . $cat_id . '\' ');
            $params .= ('&cat_id=' . $cat_id);
        }
        if( $order == '' ) 
        {
            $order = 'id:desc';
        }
        $params .= ('&order=' . $order);
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 30;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT *,(select epg_name from epg where epg.id=streams.epg_id) as epgname' . (' from streams  where type=1 ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from streams where type=1 ' . $qry . ' ');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['epg_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t\t<form action=\"\" method=\"post\" class=\"form-row align-items-center\">\r\n\t\t\t\t <div class=\"col-sm-3 my-1\">\r\n\t\t\t\t  <input type=\"text\" name=\"stream_display_name\" class=\"form-control\"  value=\"" . $stream_display_name . "\" placeholder=\"Type Text\">\r\n\t\t\t\t</div>\r\n\t\t\t\t <div class=\"col-sm-3 my-1\">\r\n\t\t\t\t" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('cat_id', 'All Categories', 'stream_categories', $cat_id, 'id', 'category_name', 'WHERE category_type=\'live\'', $order = '') . "\r\n\t\t\t\t</div>\r\n\t\t\t <div class=\"col-auto my-1\">\r\n\t\t\t <input class=\"btn btn-primary\" name=\"name\" value=\"" . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t\t \r\n\t\t\t</div>\r\n\t\t\t\r\n\t\t\t</form>\r\n\t\r\n\t\t\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>ID</th>\r\n\t\t\t<th>Category</th>\r\n\t\t\t<th>Streams</th>\r\n\t\t\t<th>EPG Source</th>\r\n\t\t\t<th>Channel ID</th>\r\n\t\t\t<th>Lang</th>\r\n\t\t\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        $cur_host = [];
        $cur_host['host'] = '-';
        $elapsed_time = $cur_host['host'];
        $txt_status = '<icon class="icon-cancel-circled" style=\'color:red;\'></icon>';
        $current_source = $stream_info = '';
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            @extract($row);
            $i++;
            echo "\r\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ('" id="ChannelDataRow' . $id . "\">\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td>") . $array['stream_categories'][$category_id] . ("</td>\r\n\t\t\t\t<td id='StrmName_" . $id . '\'>' . $stream_display_name . "</td>\r\n\t\t\t\t<td class=\"center\" id=\"epgnameX_" . $id . '">' . $epgname . "</td>\r\n\t\t\t\t<td class=\"center\" id=\"channelX_" . $id . '">' . $channel_id . "</td>\r\n\t\t\t\t<td class=\"center\" id=\"epg_langX_" . $id . '">' . $epg_lang . "</td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info EditStreamRow\"  href=\"" . $this->base . '/EditStream?NH=1&id=' . $id . '" data-id="' . $id . '" title="') . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td colspan=\"5\" id='chRow" . $id . "'></td>\r\n\t\t\t</tr>\r\n\t\t\t");
        }
        echo "</tbody>\r\n\t\t</table>\r\n\t\t</div>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/Set_Streams?' . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "\t\t<script>\r\n\t\tvar spin = \"<span class='icon-spin5 animate-spin'></span>\";\r\n\t\t\$(document).on('click', '.EditStreamRow', function(e){\r\n            e.preventDefault();\r\n\t\t\t\r\n\t\t\t\r\n\t\t\tvar id = \$(this).data('id');\r\n\t\t\tvar url = \$(this).attr('href');\r\n\t\t\tvar resultDiv = \$(\"#chRow\" + id);\r\n\t\t\t\r\n\t\t\tresultDiv.html(spin);\r\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\r\n\t\t\t\t\r\n\t\t\t\tresultDiv.html(data);\r\n\t\t\t});\r\n\t\t\r\n        });\r\n\t\t\r\n\t\t\$(document).on('click', '.btnCloseFrmChEdit', function(e){\r\n\t\t\t\$(\"#\"+\$(this).data('id')).html('');\r\n\t\t});\r\n\t\t\r\n\t\t\$(document).on(\"submit\", \".frmSaveStream\", function (e) {\r\n\t\t\t\r\n\t\t\tvar chID = \$(this).data('id');\r\n\t\t\t//alert(\$(this).data('id') +' '+ \$(this).attr('action'));\r\n\t\t\t\r\n\t\t\tvar chName = \$(\"#stream_name_\" + chID).val();\r\n\t\t\tif(chName != \"\"){\r\n\t\t\t\t\$(\"#StrmName_\" + chID).html(chName);\r\n\t\t\t}\r\n\t\t\tvar spnResult = \$(\"#frmSpanResult\" + chID);\r\n\t\t\tspnResult.html(spin);\r\n\t\t\t\$.post( \$(this).attr('action')  ,\$(this).serialize(),\r\n\t\t\t\tfunction(data){\r\n\t\t\t\t\tspnResult.html(data);\r\n\t\t\t\t\t//\$(this).style(\"background-color: #5cb85c;border-color: #4cae4c;\");\r\n\t\t\t\t\t\r\n\t\t\t\t\t\t\$(\"#epgnameX_\"+ chID).html(\$(\"#dropdown_epg_id\" + chID + \" option:selected\").text());\r\n\t\t\t\t\t\t\$(\"#channelX_\"+ chID).html(\$(\"#dropdown_epg_chanel\" + chID + \" option:selected\").text());\r\n\t\t\t\t\t\t\$(\"#epg_langX_\"+ chID).html(\$(\"#dropdown_epg_lang\" + chID + \" option:selected\").text());\r\n\t\t\t\t\t\r\n\t\t\t\t\t\$(\"#ChannelDataRow\" + chID).css(\"background-color\", \"#5cb85c\");\r\n\t\t\t\t}\r\n\t\t\t);\r\n\t\t\treturn false;\r\n\t\t});\r\n\t\t\r\n\t\t\$(document).on('change', '.select_epg_source', function(e){\r\n            e.preventDefault();\r\n\t\t\tvar epgval=\$(this).val();\r\n\t\t\tvar stream_id=\$(this).data('stream_id');\r\n\t\t\t\r\n\t\t\t//alert(epgval);\r\n\t\t\tvar url = '";
        echo $this->base;
        echo "/get_chanel/?_=' + new Date().getTime() + '&NH=1&streamid='+stream_id+'&epg_id='+epgval;\r\n\t\t\tvar resultDiv = \$(\"#result_epg_channel_\" + stream_id);\r\n\t\t\tresultDiv.html(spin);\r\n\t\t\t\$.get( url, function( data ) {\r\n\t\t\t\tresultDiv.html(data);\t\r\n\t\t\t});\r\n\r\n\t\t\t\r\n        });\r\n\t\t\r\n\t\t\$(document).on('change', '.select_epg_chanel', function(e){\r\n            e.preventDefault();\r\n\t\t\tvar channel_id = \$(this).val();\r\n\t\t\tvar stream_id = \$(this).data('stream_id');\r\n\t\t\tvar epg_id = \$('#dropdown_epg_id'+stream_id).val();\r\n\r\n\t\t\tvar url = '";
        echo $this->base;
        echo "/get_langs/?_=' + new Date().getTime() + '&NH=1&streamid='+stream_id+'&epg_id='+epg_id+'&channel_id='+channel_id;\r\n\t\t\tvar resultDiv = \$(\"#result_epg_lang_\" + stream_id );\r\n\t\t\tresultDiv.html(spin);\r\n\t\t\t\$.get( url, function( data ) {\r\n\t\t\t\tresultDiv.html(data);\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select\").addClass('chosen').chosen({search_contains: true});\r\n\t\t\t\$(\"select\").trigger(\"chosen:updated\");\r\n\t\t\t\r\n        });\r\n\t</script>\r\n\t";
    }
    public function EditStream()
    {
        global $intro;
        global $array;
        global $epg_id;
        $qry = '';
        $epg_chanel = $epg_lang = 0;
        $id = $stream_id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * from streams where id=' . $id);
        $row = $intro->db->fetch_assoc($sql);
        $stream_display_name = $row['stream_display_name'];
        $epg_id = $row['epg_id'];
        $channel_id = $row['channel_id'];
        $epg_lang = $row['epg_lang'];
        $sel = new FormsSelect();
        $sel->set('html_name', 'epg_id');
        $sel->set('html_id', 'dropdown_epg_id' . $id);
        $sel->set('html_title', 'Choose EPG Source');
        $sel->set('compair', $epg_id);
        $sel->set('table', 'epg');
        $sel->set('the_id', 'id');
        $sel->set('the_name', 'epg_name');
        $sel->set('where', '');
        $sel->set('order', 'order by epg_name asc');
        $sel->set('css_class', 'searchable select_epg_source');
        $sel->set('arrib', 'data-stream_id=\'' . $id . '\'');
        echo "\r\n\t\t<fieldset style='width:700px;margin:auto;'>\r\n\t\t<form action=\"" . $this->base . '/doEditEditStream?NH=1" data-id="' . $id . "\" class=\"frmSaveStream\" method=\"post\">\r\n\t\t\t<br><center>Select EPG Data for " . $stream_display_name . " </center>\r\n\t\t\t<table class='table table=striped table-condensed' id=\"tblStream" . $id . "\">\r\n\t\t\t<thead>\r\n\t\t\t<tr>\r\n\t\t\t\t<td ><br></td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td style='width:150px;' >EPG Source:</td>\r\n\t\t\t\t<td>" . $sel->db_table() . ("</td>\r\n\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t<td >EPG Channel:</td>\r\n\t\t\t\t<td id='result_epg_channel_" . $stream_id . '\'> ');
        $this->get_chanel($id, $epg_id, $channel_id);
        echo "</td>\r\n\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t<td >EPG Lang:</td>\r\n\t\t\t\t<td  id='result_epg_lang_" . $stream_id . '\'>';
        $this->get_langs($id, $epg_id, $channel_id, $epg_lang);
        echo "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td ><br></td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>\r\n\t\t\t</thead>\r\n\t\t\t<tbody>";
        echo "\r\n\t\t\t\t</tbody>\r\n\t\t\t\t<tfooter>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td>\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<input name=\"chID\" value=\"" . $id . "\" type=\"hidden\">\r\n\t\t\t\t\t\t<button type=\"submit\" class='btn btn-success'><span class='icon-floppy'></span>Save</button>\r\n\t\t\t\t\t\t<button data-id=\"chRow" . $id . "\" type=\"button\" class='btn btn-default btnCloseFrmChEdit'><span class='icon-cancel-circled'></span>Close</button>\r\n\t\t\t\t\t\t<span id=\"frmSpanResult" . $id . "\"></span>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t</tfooter>\r\n\t\t\t</table>\r\n\t\t\t</form>\r\n\t\t\r\n\t\t</fieldset>\r\n\t\t<script>\r\n\t\t\$( document ).ready(function() {\r\n\t\t\t\$(\"select\").addClass('chosen').chosen({search_contains: true});\r\n\t\t\t\$(\"select\").trigger(\"chosen:updated\");\r\n\t\t});\r\n\t\t</script>";
    }
    public function get_chanel($streamid = 0, $epg_id = 0, $channel_id = '')
    {
        global $intro;
        global $epg_id;
        $html = '';
        if( $epg_id == 0 ) 
        {
            $epg_id = intval($intro->input->get_post('epg_id'));
        }
        if( $streamid == 0 ) 
        {
            $streamid = intval($intro->input->get_post('streamid'));
        }
        if( $channel_id == '' ) 
        {
            $channel_id = trim($intro->input->get_post('channel_id'));
        }
        $sql = $intro->db->query('SELECT * from epg where id=' . $epg_id);
        $row = $intro->db->fetch_assoc($sql);
        $data = $row['data'];
        $array = json_decode($data, true);
        if( is_array($array) ) 
        {
            $html .= ('<select name="epg_chanel" id="dropdown_epg_chanel' . $streamid . '" class=\'select_epg_chanel form-control searchable\' data-stream_id=\'' . $streamid . '\'>');
            foreach( $array as $key_channel_id => $row ) 
            {
                $html .= ('<option value="' . $key_channel_id . '" ' . (($key_channel_id == $channel_id ? 'selected' : '')) . ('>' . $row['display_name'] . '</option>'));
            }
            $html .= '</select>';
        }
        echo $html;
    }
    public function get_langs($streamid = 0, $epg_id = 0, $channel_id = '', $epg_lang = '')
    {
        global $intro;
        global $epg_id;
        $html = '';
        if( $streamid == 0 ) 
        {
            $streamid = intval($intro->input->get_post('streamid'));
        }
        if( $epg_id == 0 ) 
        {
            $epg_id = intval($intro->input->get_post('epg_id'));
        }
        if( $channel_id == '' ) 
        {
            $channel_id = trim($intro->input->get_post('channel_id'));
        }
        if( $epg_lang == '' ) 
        {
            $epg_lang = trim($intro->input->get_post('epg_lang'));
        }
        $sql = $intro->db->query('SELECT data from epg where id=' . $epg_id);
        $row = $intro->db->fetch_assoc($sql);
        $data = $row['data'];
        $array = json_decode($data, true);
        $found = false;
        if( is_array($array) ) 
        {
            $html = '<select name=\'epg_lang\' id=\'dropdown_epg_lang' . $streamid . '\' class=\'form-control\'>';
            foreach( $array as $key_channel_id => $row ) 
            {
                if( $key_channel_id == $channel_id ) 
                {
                    $langs = $row['langs'];
                    if( is_array($langs) ) 
                    {
                        foreach( $langs as $key => $lang_name ) 
                        {
                            $html .= ('<option value="' . $lang_name . '" ' . (($lang_name == $epg_lang ? 'selected' : '')) . ('>' . $lang_name . '</option>'));
                            $found = true;
                        }
                    }
                    break;
                }
            }
            $html .= '</select>';
        }
        if( $found ) 
        {
            echo $html;
        }
        else
        {
            echo 'None';
        }
    }
    public function doEditEditStream()
    {
        global $intro;
        global $array;
        global $epg_id;
        $epg_id = intval($intro->input->get_post('epg_id'));
        $chID = intval($intro->input->get_post('chID'));
        $epg_chanel = trim($intro->input->get_post('epg_chanel'));
        $epg_lang = trim($intro->input->get_post('epg_lang'));
        if( $epg_id != 0 ) 
        {
            $intro->db->query('update streams set epg_id=\'' . $epg_id . '\',epg_lang=\'' . $epg_lang . '\',channel_id=\'' . $epg_chanel . '\' WHERE id=' . $chID);
            echo '<span class=\'label label-success\'>Update Success!</span>';
        }
        else
        {
            echo '<span class=\'label label-danger\'>Choose EPG !</span>';
        }
    }
}
