<?php 
class Epg_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\n\t\t<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\">\n\t\t\t<icon class=\"icon-list\">EPG</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/Form?t=add\">Add New Channel</a>\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . "/Import\"><i class='icon-up'></i> Import New EPG file</a>\n\t\t<br/>\n\t\t<a target='_blanck' class=\"btn btn-danger\" href=\"http://ipsat2017.com/movie/epg/epg.php\"><i class='icon-eye'></i>View EPG</a>\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $fixall = trim($intro->input->get_post('fixall'));
        $result = $intro->db->query('SELECT *, (SELECT chName from ' . PREFIX . '_epg_ch WHERE chID=epg.ch_remote) as chNameRem, ' . ' (SELECT stream_display_name from `streams` WHERE streams.id=epg.ch_local) as chNameLoc ' . ' FROM ' . PREFIX . '_epg epg;');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Current EPG (' . $totrows . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered table-hover\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>#</th>\n\t\t\t<th> Local Channel </th>\n\t\t\t<th> Remote Channel </th>\n\t\t\n\t\t\t<th> Options </th>\n\t\t\t\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $chNameLoc . "</td>\n\t\t\t\t<td class=\"center\">" . $chNameRem . "</td>\n\t\t\t\t\n\t\t\t\t<td class=\"center\">");
            echo '<a class="btn btn-danger EPGDel" id="' . $id . '" href="' . $this->base . '/Del?NH=1&id=' . $id . "\" OnClick=\"return false;\">\n\t\t\t\t\t<icon class=\"icon-trash\"></icon>\n\t\t\t\t\t</a>";
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\n\t\t\t\$('.EPGDel').click(function(e){\n\t\t\t\te.preventDefaults;\n\t\t\t\t\n\t\t\t\tif(!confirm('Are you sure you want to Delete?')) return false;\n\t\t\t\t\n\t\t\t\tvar link_tr = \$(this).closest('tr');\n\t\t\t\t\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\n\t\t\t\t\t\n\t\t\t\t\tlink_tr.fadeOut();\n\t\t\t\t});\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t\t\$(\".FixAll\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\tvar id = \$(this).attr('id');\n\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#RES\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function EditStbCh()
    {
        global $intro;
        $data = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data[$name] = $value;
        if( $this->admin['level'] == 1 ) 
        {
            $intro->db->update('' . PREFIX . '_epg', $data, 'id=' . $id);
        }
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $intro->db->query('delete from ' . PREFIX . ('_epg WHERE id=' . $id . ' '));
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $ch_local;
        global $ch_remote;
        if( $_GET != null ) 
        {
            @extract($_GET);
        }
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $btn = [];
        $qryLoc = $qryRem = '';
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_epg where id=' . $id . ';'));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = ' Edit <b>' . $id . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $date = $dateadded;
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add New EPG channel';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Add New';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $qryLoc = ' AND `id` NOT IN (SELECT ch_local FROM ' . PREFIX . '_epg) ';
            $qryRem = ' WHERE `chID` NOT IN (SELECT ch_remote FROM ' . PREFIX . '_epg) ';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'primary');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\n\t\t<table class=\"table table-bordered\">\n\t\t\n\t\t<tr>\n\t\t\t<td class=\"success\">Local Channel : </td>\n\t\t\t<td class=\"warning\">Remote EPG Channel : </td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"success\">" . $this->ch_local($ch_local, $qryLoc) . ('  ' . $this->error('ch_local') . "</td>\n\t\t\t<td class=\"warning\">") . $this->ch_remote($ch_remote, $qryRem) . ('  ' . $this->error('ch_remote') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td colspan=\"3\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\n\t\t\t\t<span class=\"" . $btn['img_icon'] . '"></span> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</form>");
    }
    public function ch_local($ch_local, $qry = '')
    {
        global $intro;
        $html = '<select name="ch_local">';
        $sql = $intro->db->query('SELECT id,stream_display_name from `streams` WHERE type=1 ' . $qry . ' ORDER BY stream_display_name ASC;');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $id = $row['id'];
            $stream_display_name = $row['stream_display_name'];
            $html .= ('<option value="' . $id . '" ' . (($ch_local == $id ? 'selected="selected"' : '')) . ('>' . $stream_display_name . '</option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function ch_remote($ch_remote, $qry = '')
    {
        global $intro;
        $html = '<select name="ch_remote">';
        $sql = $intro->db->query('SELECT chID,chName,chTitle from ' . PREFIX . ('_epg_ch ' . $qry . ' ORDER BY chName ASC;'));
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $chID = $row['chID'];
            $chName = $row['chName'];
            $html .= ('<option value="' . $chID . '" ' . (($ch_remote == $chID ? 'selected="selected"' : '')) . ('>' . $chName . '</option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $ch_local = intval($intro->input->post('ch_local'));
        $ch_remote = intval($intro->input->post('ch_remote'));
        if( $ch_local == 0 || $ch_remote == 0 ) 
        {
            if( $ch_local == 0 ) 
            {
                $error['ch_local'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $ch_remote == 0 ) 
            {
                $error['ch_remote'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['ch_local'] = $ch_local;
        $data['ch_remote'] = $ch_remote;
        $intro->db->insert(PREFIX . '_epg', $data);
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $error;
        $ch_local = intval($intro->input->post('ch_local'));
        $ch_remote = intval($intro->input->post('ch_remote'));
        $id = intval($intro->input->post('id'));
        if( $ch_local == 0 || $ch_remote == 0 || $id == 0 ) 
        {
            if( $ch_local == 0 ) 
            {
                $error['ch_local'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $ch_remote == 0 ) 
            {
                $error['ch_remote'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $id == 0 ) 
            {
                $error['ch_local'] = '<span class=error>Error with ID!!!</span>';
                $error['ch_remote'] = '<span class=error>Error with ID!!!</span>';
            }
            $this->Form('edit');
            exit();
        }
        $data = [];
        $data['ch_local'] = $ch_local;
        $data['ch_remote'] = $ch_remote;
        $intro->db->update(PREFIX . '_epg', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
    public function Import()
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        $this->nav();
        if( isset($error['msg']) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232($error['msg'], 'danger');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-plus-squared"></i> Upload new EPG xml file ', 'primary');
        echo "\n\t\t<div id=\"frmEpgDiv\">\n\t\t<form method=\"POST\" id=\"frmImportEPG\"  action=\"" . $this->base . "/doImport?NH=1\" enctype=\"multipart/form-data\">\n\t\t<table class=\"table table-bordered\">\n\t\t\n\t\t<tr>\n\t\t\t<td class=\"success\">Source File : </td>\n\t\t\t<td class=\"warning\"><input type='file' name='epg' accept=\".xml,.zip,.gz\" /></td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td colspan=\"2\">\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\n\t\t\t\t\t<span class=\"icon-plus-squared\"></span> Import\n\t\t\t\t</button> \n\t\t\t\t\n\t\t\t\t<style>\n\t\t\t\t.progress { position:relative; width:400px; border: 1px solid #ddd; padding: 1px; border-radius: 3px; }\n\t\t\t\t.bar { background-color: #B4F5B4; width:0%; height:20px; border-radius: 3px; }\n\t\t\t\t.percent { position:absolute; display:inline-block; top:3px; left:48%; }\n\t\t\t\t</style>\n\t\t\t\t\n\t\t\t\t<div id=\"status\"></div>\n\t\t\t\t\n\t\t\t\t<div class=\"progress\" style='margin:auto;display:none;'>\n\t\t\t\t\t<div class=\"bar\"></div >\n\t\t\t\t\t<div class=\"percent\">0%</div >\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</form>\n\t\t</div>";
        echo "<script>\n\t\t(function() {\n\t\t\t\n\t\t\tvar bar = \$('.bar');\n\t\t\tvar percent = \$('.percent');\n\t\t\tvar status = \$('#status');\n\t\t\tvar frmEpgDiv = \$('#frmEpgDiv');\n\t\t\t   \n\t\t\t\$(\"#frmImportEPG\").ajaxForm({\n\t\t\t\tbeforeSend: function() {\n\t\t\t\t\t\$(\".progress\").show();\n\t\t\t\t\tstatus.html('<h1><span class=\"icon-spin5 animate-spin\"></span>Please wait Uploading and Updating Channels EPG ... <br> *** Don\\'t hit Refresh of Back button.</h1>');\n\t\t\t\t\tvar percentVal = '0%';\n\t\t\t\t\tbar.width(percentVal)\n\t\t\t\t\tpercent.html(percentVal);\n\t\t\t\t},\n\t\t\t\tuploadProgress: function(event, position, total, percentComplete) {\n\t\t\t\t\tvar percentVal = percentComplete + '%';\n\t\t\t\t\tbar.width(percentVal)\n\t\t\t\t\tpercent.html(percentVal);\n\t\t\t\t\t/*console.log(percentVal, position, total);*/\n\t\t\t\t},\n\t\t\t\tsuccess: function() {\n\t\t\t\t\tvar percentVal = '100%';\n\t\t\t\t\tbar.width(percentVal)\n\t\t\t\t\tpercent.html(percentVal);\n\t\t\t\t},\n\t\t\t\tcomplete: function(xhr) {\n\t\t\t\t\tstatus.html(xhr.responseText);\n\t\t\t\t\tfrmEpgDiv.html(xhr.responseText);\n\t\t\t\t\t\$(\".progress\").hide();\n\t\t\t\t}\n\t\t\t});\n\t\t})();\n\t\t</script>";
    }
    public function doIMport()
    {
        global $intro;
        global $error;
        if( !is_uploaded_file($_FILES['epg']['tmp_name']) ) 
        {
            $error['msg'] = 'Error: please upload file.';
            $this->Import();
            exit();
        }
        if( $xml = simplexml_load_file($_FILES['epg']['tmp_name']) ) 
        {
            $intro->db->query_fast('TRUNCATE ' . PREFIX . '_epg_prog;');
        }
        $ch = 0;
        foreach( $xml->channel as $key => $channel ) 
        {
            $ch++;
            $chName = $channel['id'];
            $chTitle = $channel->display-name;
            $chTitle = str_replace(' AE', '', $chTitle);
            $data = [];
            $data['chName'] = $chName;
            $data['chTitle'] = $chTitle;
            $x = $intro->db->insert_update('' . PREFIX . '_epg_ch', $data, ['chTitle' => $chTitle]);
        }
        $prog = 0;
        foreach( $xml->programme as $key => $programme ) 
        {
            $prog++;
            $start = $programme['start'];
            $stop = $programme['stop'];
            $channel = $programme['channel'];
            $start = date('Y-m-d H:i:s', strtotime($start));
            $stop = date('Y-m-d G:i:s', strtotime($stop));
            $title = $programme->title;
            $desc = $programme->desc;
            $category = $programme->category;
            $icon = $programme->icon['src'];
            $episode_num = $programme->episode-num;
            $sql = $intro->db->query('SELECT chID from ' . PREFIX . ('_epg_ch WHERE chName=\'' . $channel . '\''));
            $row = $intro->db->fetch_assoc($sql);
            $chID = intval($row['chID']);
            $data = [];
            $data['progChID'] = $chID;
            $data['progStart'] = $start;
            $data['progStop'] = $stop;
            $data['progTitle'] = $title;
            $data['progDesc'] = $desc;
            $data['progCat'] = $category;
            $data['progIcon'] = $icon;
            $data['progEpisode_num'] = $episode_num;
            $intro->db->insert('' . PREFIX . '_epg_prog', $data, true);
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h1>Success! Total Channels: ' . $ch . ' , Total Programms: ' . $prog . '</h1>', 'success');
    }
}
