<?php 
class Home_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $date = null;
    public $date_7 = null;
    public $icons = null;
    public $tables = [
        'client_logs', 
        'solus_logs', 
        'user_activity', 
        'user_activity_now', 
        'stream_logs'
    ];
    public $tables_names = [
        'client_logs' => 'Client Error Logs:', 
        'solus_logs' => 'Active Code Logs:', 
        'user_activity' => 'Closed Connections:', 
        'user_activity_now' => 'Online Now', 
        'stream_logs' => 'Stream Logs:'
    ];
    public $admin = [];
    public $adminRow = [];
    public function __construct($appname, $base)
    {
        global $intro;
        global $sess_admin;
        $this->date = date('Y-m-d');
        $this->date_7 = date('Y-m-d', strtotime('+7 days'));
        $this->appname = $appname;
        $this->base = $base;
        $this->icons = admin_path . 'style/img/';
        $this->admin = $intro->auth->sess_admin();
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
    }
    public function index()
    {
        global $intro;
        global $sess_admin;
        global $array;
        global $options;
        global $config;
        $item_no = $intro->input->get_post('item_no');
        $jsjs = '';

        // Add menu toggle button
        $current_menu = isset($_COOKIE['use_sidebar_menu']) ? $_COOKIE['use_sidebar_menu'] : 0;
        if($current_menu == 1) {
            $toggle_text = 'Switch to Original Menu (Top)';
            $toggle_type = 0;
            $current_style = 'Sidebar Menu (Collapsible)';
        } else {
            $toggle_text = 'Switch to Sidebar Menu (Option 1)';
            $toggle_type = 1;
            $current_style = 'Original Menu (Top)';
        }

        echo '<div style="text-align:right;margin-bottom:15px;">';
        echo '<span style="background:#4facfe;color:#fff;padding:8px 15px;border-radius:20px;margin-right:10px;font-weight:600;">Current: ' . $current_style . '</span>';
        echo '<a href="' . $config['base_url'] . 'toggle_menu.php?type=' . $toggle_type . '" class="btn btn-primary" style="background:linear-gradient(135deg, #667eea 0%, #764ba2 100%);border:none;box-shadow:0 4px 15px rgba(102, 126, 234, 0.4);">';
        echo '<i class="icon-menu"></i> ' . $toggle_text;
        echo '</a>';
        echo '</div>';

        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        $intro->db->halt_on_errors = false;
        if( $this->admin['level'] == 1 ) 
        {
            if( !isset($intro->option['db_ver']) ) 
            {
                $intro->db->query('INSERT IGNORE  INTO `solus_options` (`id`, `name`, `val`) VALUES (NULL, \'db_ver\', \'230\'); ');
            }
            if( isset($intro->option['db_ver']) && $intro->option['db_ver'] != '' && _intro_db_ver != intval($intro->option['db_ver']) ) 
            {
                echo '<a href="' . $this->base . '/Update" class="btn btn-success btn-lg">New update click here to update.</a><br/><br/>';
            }
            $this->alert();
            echo "\n\t\t\t<div class=\"row\">\n\t\t\t\t<div class=\"col-md-12\" style='position: relative;'><div id='cdown_timer' style='position:absolute;right:20px;z-index:1000;'></div>\n\t\t\t\t\t<div id='div_refresh'>";
            $this->dash();
            echo "</div>\n\t\t\t\t\t\n\t\t\t\t</div>\n\t\t\t</div>";
            echo "<script>\n\t\t\t\$(document).ready(function() {\n\t\t\t\tvar counter = 15;\n\t\t\t\tvar interval = setInterval(function() {\n\t\t\t\t\tcounter--;\n\t\t\t\t\tif (counter <= 0) {\n\t\t\t\t\t\tcounter = 16;\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}else{\n\t\t\t\t\t\t\$('#cdown_timer').text(counter);\n\t\t\t\t\t\tif(counter == 1){\n\t\t\t\t\t\t\t\$('#div_refresh').load('" . $this->base . "/dash?NH=1&refresh=ok');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}, 1000);\n\t\t\t});\n\t\t\t</script>";
        }
        $this->adminRow = $intro->auth->admin_data(intval($this->admin['adminid']));
        $hide = false;
        if( isset($intro->option['global_msg_expiry']) && _obf_0D24242D0C22102F0715263F3E193B275B1B06383C3401($intro->option['global_msg_expiry']) && $intro->option['global_msg_expiry'] < date('Y-m-d') ) 
        {
            $hide = true;
        }
        $time = time();
        $time7 = strtotime('+7 day');
        $qry_adm_code = $qry_adm_user = '';
        if( $this->admin['level'] != 1 ) 
        {
            $qry_adm_code = ' and adminid=' . intval($this->admin['adminid']);
            $qry_adm_user = ' and member_id=' . intval($this->admin['adminid']);
        }
        $intro->db->query('SELECT id from ' . PREFIX . ('_codes where  status=4 ' . $qry_adm_code . ';'));
        $code_expired = $intro->db->returned_rows;
        $intro->db->query('SELECT id from users where exp_date <= \'' . $time . '\' AND exp_date!=\'\' AND exp_date IS NOT NULL ' . $qry_adm_user . ';');
        $user_expired = $intro->db->returned_rows;
        $intro->db->query('SELECT id from users where exp_date BETWEEN \'' . $time . '\' AND \'' . $time7 . '\' ' . $qry_adm_user . ';');
        $user_soon_to_expire = $intro->db->returned_rows;
        $sql2 = $intro->db->query('SELECT id from ' . PREFIX . ('_codes where status=3 ' . $qry_adm_code . ';'));
        $del = $intro->db->returned_rows;
        if( $this->admin['level'] == 1 ) 
        {
            $panel1 = '
            <div class="panel panel-default xui-table" style="margin-bottom: 20px;">
                <div class="panel-heading" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: #fff; border: none; padding: 18px 20px;">
                    <i class="icon-database"></i> <strong>Database Logs Management</strong>
                </div>
                <div class="panel-body" style="padding: 20px;">
                    <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px 16px; margin-bottom: 20px; border-radius: 6px;">
                        <i class="icon-attention" style="color: #ff9800; margin-right: 8px;"></i>
                        <span style="color: #856404; font-size: 13px;">Clear large log tables to optimize database performance and reduce server load.</span>
                    </div>
                    <table class="table table-hover" style="margin-bottom: 0;">
                        <thead style="background: #f8f9fa;">
                            <tr>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase;">
                                    <i class="icon-database"></i> Table Name
                                </th>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase;">
                                    <i class="icon-chart-bar"></i> Rows Count
                                </th>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase;">
                                    <i class="icon-cog"></i> Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody>';
            $jsjs = '';
            $i = -1;
            $tblz = [];
            foreach( $this->tables as $table ) 
            {
                $tblz[] = '\'' . $table . '\'';
            }
            $sql = $intro->db->query("SELECT TABLE_SCHEMA, TABLE_NAME, TABLE_ROWS,AUTO_INCREMENT\n\t\t\t\t\t\t\tFROM information_schema.TABLES WHERE\n\t\t\t\t\t\t\t\t  TABLE_SCHEMA = '" . $config['db']['database'] . "' \n\t\t\t\t\t\t\t\t  AND \n\t\t\t\t\t\t\t\t  TABLE_NAME IN (" . implode(',', $tblz) . ');');
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $table = $row['TABLE_NAME'];
                $table_name = $this->tables_names[$table];
                $num = number_format($row['TABLE_ROWS']);
                if( $table != 'user_activity_now' && intval($row['TABLE_ROWS']) > 1000000 ) 
                {
                    $intro->db->query_fast('TRUNCATE ' . $table . ';');
                    $num = 'Cleaned';
                }
                if( $table == 'user_activity_now' && intval($row['AUTO_INCREMENT']) >= 2000000000 ) 
                {
                    $intro->db->query_fast('TRUNCATE user_activity_now;');
                    echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h2>Online Users has been auto fixed successfully.</h2>');
                }
                $row_class = (intval(str_replace(',', '', $num)) > 500000) ? 'style="background: #fff3cd;"' : '';
                $num_badge_class = (intval(str_replace(',', '', $num)) > 500000) ? 'label-warning' : 'label-info';
                $truncate_btn = ($table != 'user_activity_now') ?
                    '<a href="' . $this->base . '/Truncate?table=' . $table . '" class="btn btn-sm btn-danger" style="background: linear-gradient(135deg, #f5576c 0%, #f093fb 100%); border: none; border-radius: 6px; padding: 6px 14px; font-size: 11px; font-weight: 600;">
                        <i class="icon-trash"></i> Clear Table
                    </a>' :
                    '<span style="color: #999; font-size: 12px;"><i class="icon-lock"></i> Protected</span>';

                $panel1 .= '
                <tr ' . $row_class . ' style="transition: all 0.2s ease;">
                    <td style="padding: 14px 15px; font-weight: 500; color: #495057;">
                        <i class="icon-doc-text" style="color: #667eea; margin-right: 6px;"></i>
                        ' . $table_name . '
                    </td>
                    <td id="numResult' . $i . '" style="padding: 14px 15px;">
                        <span class="label ' . $num_badge_class . '" style="font-size: 12px; padding: 6px 12px; border-radius: 6px; font-weight: 600;">
                            ' . $num . ' rows
                        </span>
                    </td>
                    <td style="padding: 14px 15px;">
                        ' . $truncate_btn . '
                    </td>
                </tr>';
            }
            $panel1 .= '
                        </tbody>
                    </table>
                </div>
            </div>';

            $panel2 = '
            <div class="panel panel-default xui-table" style="margin-bottom: 20px;">
                <div class="panel-heading" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: #fff; border: none; padding: 18px 20px;">
                    <i class="icon-calendar"></i> <strong>Codes & Users Management</strong>
                </div>
                <div class="panel-body" style="padding: 20px;">
                    <table class="table table-hover" style="margin-bottom: 0;">
                        <thead style="background: #f8f9fa;">
                            <tr>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase;">
                                    <i class="icon-info-circled"></i> Category
                                </th>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase; text-align: center;">
                                    <i class="icon-chart-bar"></i> Count
                                </th>
                                <th style="padding: 12px 15px; font-weight: 600; color: #495057; font-size: 12px; text-transform: uppercase;">
                                    <i class="icon-cog"></i> Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr style="transition: all 0.2s ease;">
                                <td style="padding: 14px 15px; font-weight: 500; color: #495057;">
                                    <i class="icon-trash" style="color: #dc3545; margin-right: 8px;"></i>
                                    Deleted Codes
                                </td>
                                <td style="padding: 14px 15px; text-align: center;">
                                    <span class="label label-danger" style="font-size: 13px; padding: 7px 14px; border-radius: 6px; font-weight: 600;">
                                        ' . number_format($del) . '
                                    </span>
                                </td>
                                <td style="padding: 14px 15px;">
                                    <a class="intro_ui_del" href="' . $this->base . '/Delete?mode=del_codes" OnClick="return false"></a>
                                </td>
                            </tr>
                            <tr style="transition: all 0.2s ease;">
                                <td style="padding: 14px 15px; font-weight: 500; color: #495057;">
                                    <i class="icon-attention-circled" style="color: #17a2b8; margin-right: 8px;"></i>
                                    Expired Codes
                                </td>
                                <td style="padding: 14px 15px; text-align: center;">
                                    <a href="' . $intro->app_url('codes', 'index') . '?view=expired" class="label label-info" style="font-size: 13px; padding: 7px 14px; border-radius: 6px; font-weight: 600; text-decoration: none; display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        ' . number_format($code_expired) . '
                                    </a>
                                </td>
                                <td style="padding: 14px 15px;">
                                    <span style="color: #999; font-size: 11px;"><i class="icon-info"></i> View list</span>
                                </td>
                            </tr>
                            <tr style="transition: all 0.2s ease;">
                                <td style="padding: 14px 15px; font-weight: 500; color: #495057;">
                                    <i class="icon-clock" style="color: #ffc107; margin-right: 8px;"></i>
                                    Users Expiring in 7 days
                                </td>
                                <td style="padding: 14px 15px; text-align: center;">
                                    <a href="' . $intro->app_url('users', 'index') . '?view=soon_to_expire" class="label label-warning" style="font-size: 13px; padding: 7px 14px; border-radius: 6px; font-weight: 600; text-decoration: none; display: inline-block; background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); color: #fff;">
                                        ' . number_format($user_soon_to_expire) . '
                                    </a>
                                </td>
                                <td style="padding: 14px 15px;">
                                    <span style="color: #999; font-size: 11px;"><i class="icon-attention"></i> Renew soon</span>
                                </td>
                            </tr>
                            <tr style="transition: all 0.2s ease;">
                                <td style="padding: 14px 15px; font-weight: 500; color: #495057;">
                                    <i class="icon-user-delete" style="color: #17a2b8; margin-right: 8px;"></i>
                                    Expired Users
                                </td>
                                <td style="padding: 14px 15px; text-align: center;">
                                    <a href="' . $intro->app_url('users', 'index') . '?view=expired" class="label label-info" style="font-size: 13px; padding: 7px 14px; border-radius: 6px; font-weight: 600; text-decoration: none; display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        ' . number_format($user_expired) . '
                                    </a>
                                </td>
                                <td style="padding: 14px 15px;">
                                    <span style="color: #999; font-size: 11px;"><i class="icon-info"></i> View list</span>
                                </td>
                            </tr>
                            <tr style="border-top: 2px solid #e9ecef;">
                                <td style="padding: 14px 15px; font-weight: 600; color: #495057;">
                                    <i class="icon-info-circled" style="color: #667eea; margin-right: 8px;"></i>
                                    DA OnDemand
                                </td>
                                <td colspan="2" style="padding: 14px 15px; color: #667eea; font-weight: 600;">
                                    V' . _intro_db_ver . '
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 14px 15px; font-weight: 600; color: #495057;">
                                    <i class="icon-code" style="color: #667eea; margin-right: 8px;"></i>
                                    PHP Version
                                </td>
                                <td colspan="2" style="padding: 14px 15px; color: #667eea; font-weight: 600;">
                                    ' . phpversion() . '
                                </td>
                            </tr>';
            if( function_exists('sys_getloadavg') ) 
            {
                $cpu = '';
                $load = sys_getloadavg();
                if( is_array($load) ) 
                {
                    foreach( $load as $key => $val ) 
                    {
                        $cpu .= ($val . ' ');
                    }
                }
                if( $cpu != '' )
                {
                    $panel2 .= '
                            <tr>
                                <td style="padding: 14px 15px; font-weight: 600; color: #495057;">
                                    <i class="icon-gauge" style="color: #667eea; margin-right: 8px;"></i>
                                    CPU Load
                                </td>
                                <td colspan="2" style="padding: 14px 15px; color: #667eea; font-weight: 600;">
                                    ' . $cpu . '
                                </td>
                            </tr>';
                }
            }
            $panel2 .= '
                        </tbody>
                    </table>
                </div>
            </div>';
            $this->nav();
            echo "<div class=\"row\">\n\t\t\t\t<div class=\"col-md-6\">" . $panel2 . "</div>\n\t\t\t\t<div class=\"col-md-6\">" . $panel1 . "</div>\n\t\t\t</div>";
            if( isset($options['opt_security']) && $options['opt_security'] == 'yes' ) 
            {
                $this->top_faild_tries();
            }
        }
        else
        {
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
            echo "<div class=\"row\">\n\t\t\t<div class=\"col-md-6\">\n\t\t\t\n\t\t\t\t<!-- Welcome to IntroTik IPTV Panel with Active Code. Please choose your needs form top menu.--->\n\t\t\t\t\n\t\t\t\t\n\t\t\t\t<br/>\n\t\t\t\t<table class=\"table table-striped\">\n\t\t\t\t<thead>\n\t\t\t\t  <tr>\n\t\t\t\t\t<th>Name</th>\n\t\t\t\t\t<th>Count</th>\n\t\t\t\t\t<th></th>\n\t\t\t\t  </tr>\n\t\t\t\t</thead>\n\t\t\t\t<tbody>\n\t\t\t\n\t\t\t\t  <tr>\n\t\t\t\t\t<td>Expired Codes</td>\n\t\t\t\t\t<td><a class='btn btn-info' href=\"" . $intro->app_url('codes', 'index') . '?view=expired">' . $code_expired . "</a></td>\n\t\t\t\t\t<td><!--<a href=\"" . $this->base . "/Delete?mode=del_expired_codes\" OnClick=\"return confirm('Are you sure?');\">Move to Delete</a>--></td>\n\t\t\t\t  </tr>\n\t\t\t\t  <tr>\n\t\t\t\t\t<td>Users Expiring in 7 days</td>\n\t\t\t\t\t<td><a class='btn btn-warning' href=\"" . $intro->app_url('users', 'index') . '?view=soon_to_expire">' . $user_soon_to_expire . "</a></td>\n\t\t\t\t\t<td><!--<a class='intro_ui_del' href=\"" . $this->base . "/Delete?mode=del_user_expired\" OnClick=\"return false\">Delete</a>--></td>\n\t\t\t\t  </tr>\n\t\t\t\t  <tr>\n\t\t\t\t\t<td>Expired Users</td>\n\t\t\t\t\t<td><a class='btn btn-info' href=\"" . $intro->app_url('users', 'index') . '?view=expired">' . $user_expired . "</a></td>\n\t\t\t\t\t<td><!--<a class='intro_ui_del' href=\"" . $this->base . "/Delete?mode=del_user_expired\" OnClick=\"return false\">Delete</a>--></td>\n\t\t\t\t  </tr>\n\t\t\t\t  </tbody>\n\t\t\t\t  </table>\n\t\t\t\t\n\t\t\t\t<br/>\n\t\t\t\t<br/>\n\t\t\t\t<br/>\n\t\t\t\t<br/>\n\t\t\t\n\t\t\t</div>\n\t\t\t<div class=\"col-md-6\"> </div>\n\t\t</div>";
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            if( isset($intro->option['global_msg']) && strlen($intro->option['global_msg']) > 20 && !$hide ) 
            {
                echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Global Message', 'danger');
                echo $intro->option['global_msg'];
                echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            }
            if( strlen($this->adminRow['msg_welcome']) > 20 ) 
            {
                echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Message to: ' . $this->admin['admin_name'], 'warning');
                echo $this->adminRow['msg_welcome'];
                echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            }
        }
        echo '<script src="' . admin_path . 'style/js/ajaxq.js"></script>';
        echo "<script>\n\t\t\$(function() {\n\t\t\t" . $jsjs . "\n\t\t});\n\t\t</script>";
    }
    public function Alert()
    {
        global $intro;
        global $sess_admin;
        echo '<div class="row"><div class="col-md-12 text-right" style=\'margin-bottom:5px;\'>';
        $blocked_ips = $intro->db->dcount('id', 'blocked_ips', '');
        if( $blocked_ips == 0 ) 
        {
            echo '<a class="btn btn-info icon-cancel" href="' . $intro->app_url('blocked_ips', 'index') . ('" title="Stream Blocked IPs">' . $blocked_ips . '</a>');
        }
        $login_fail = $intro->db->dcount('id', '' . PREFIX . '_logs_sys', 'action=\'login_fail\'');
        if( $login_fail > 0 ) 
        {
            echo ' <a class="btn btn-warning icon-login" href="' . $intro->app_url('logs_sys', 'index') . ('?action=login_fail" title="Failed Logins Attempts">' . $login_fail . '</a>');
        }
        $brute_force = $intro->db->dcount('id', '' . PREFIX . '_login_ips', '');
        if( $brute_force > 0 ) 
        {
            echo ' <a class="btn btn-danger icon-bug blinking" href="' . $intro->app_url('logs', 'BruteForce') . ('" title="Brute Force Login Attacks">' . $brute_force . '</a>');
        }
        echo '</div></div>';
    }
    public function GetTableRows()
    {
        global $intro;
        global $sess_admin;
        $id = intval($intro->input->get('id'));
        $table = $this->tables[$id];
        $intro->db->debug = false;
        $intro->db->halt_on_errors = false;
        $sql = $intro->db->query('SELECT count(*) as tot from ' . $table . ';');
        $row = $intro->db->fetch_assoc($sql);
        echo number_format($row['tot']);
    }
    public function Truncate()
    {
        global $intro;
        global $sess_admin;
        $table = trim($intro->input->get('table'));
        if( in_array($table, $this->tables) ) 
        {
            $intro->db->query('TRUNCATE ' . $table . ';');
        }
        $intro->redirect($this->appname, 'index');
    }
    public function Delete()
    {
        global $intro;
        global $sess_admin;
        $mode = trim($intro->input->get('mode'));
        $time = time();
        if( $mode == 'del_codes' ) 
        {
        }
        if( $mode == 'del_expired_codes' ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set status=4 WHERE date_expire <= \'' . $time . '\' and date_expire<>\'\';'));
        }
        if( $mode == 'del_user_expired' ) 
        {
        }
        $intro->redirect($this->appname, 'index');
    }
    public function dash()
    {
        global $intro;

        // Get statistics
        // For connections: only count active ones in last 35 minutes (matches external panel logic)
        $time_limit = time() - (35 * 60);
        $sql1 = $intro->db->query('SELECT count(*) AS tot_conns FROM `user_activity_now` WHERE date_start > ' . $time_limit);
        $row1 = $intro->db->fetch_assoc($sql1);
        $tot_conns = intval($row1['tot_conns']);

        // For users: count all active connections without time filter (external panel shows all)
        $sql2 = $intro->db->query('SELECT count(*) AS tot_users FROM `user_activity_now`');
        $row2 = $intro->db->fetch_assoc($sql2);
        $tot_users = intval($row2['tot_users']);

        // Get streams status from remote panel only
        $stream_on = 0;
        $stream_off = 0;
        $total_streams_remote = 0;

        @include_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
            $remote_host = $_CFG['remote_host'];
            $remote_user = $_CFG['remote_ssh_user'];
            $remote_pass = $_CFG['remote_ssh_pass'];
            $remote_db = $_CFG['remote_db_name'];

            // Get active/inactive streams from servers watchdog_data
            $cmd_streams = "timeout 10 sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=8 -o ServerAliveInterval=2 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N -e 'SELECT watchdog_data FROM servers WHERE disabled=0 AND watchdog_data IS NOT NULL; SELECT COUNT(*) FROM streams WHERE type=0;'\" 2>/dev/null";
            $output = shell_exec($cmd_streams);

            if(!empty($output)) {
                $lines = explode("\n", trim($output));
                $total_active = 0;
                $total_inactive = 0;

                // Parse watchdog_data from each server
                foreach($lines as $line) {
                    if(!empty($line) && $line[0] == '{') {
                        $data = json_decode($line, true);
                        if($data && isset($data['active_streams']) && isset($data['inactive_streams'])) {
                            $total_active += intval($data['active_streams']);
                            $total_inactive += intval($data['inactive_streams']);
                        }
                    } elseif(is_numeric($line)) {
                        // This is the total streams count
                        $total_streams_remote = intval($line);
                    }
                }

                $stream_on = $total_active;
                $stream_off = $total_inactive;
            }
        }

        // Get remote panel stats from watchdog_data
        $remote_users = 0;
        $remote_conns = 0;
        $input_flow_gbps = 0;
        $output_flow_gbps = 0;

        @include_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
            $remote_host = $_CFG['remote_host'];
            $remote_user = $_CFG['remote_ssh_user'];
            $remote_pass = $_CFG['remote_ssh_pass'];
            $remote_db = $_CFG['remote_db_name'];

            // Get all stats from watchdog_data in one query
            $cmd_watchdog = "timeout 10 sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=8 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N -e 'SELECT watchdog_data FROM servers WHERE disabled=0 AND watchdog_data IS NOT NULL;'\" 2>/dev/null";
            $output_watchdog = shell_exec($cmd_watchdog);

            if(!empty($output_watchdog)) {
                $total_rx = 0;
                $total_tx = 0;
                $total_conns = 0;
                $total_users = 0;
                $lines = explode("\n", trim($output_watchdog));

                foreach($lines as $line) {
                    if(!empty($line) && $line[0] == '{') {
                        $data = json_decode($line, true);
                        if($data) {
                            // Bandwidth
                            if(isset($data['rx'])) $total_rx += floatval($data['rx']);
                            if(isset($data['tx'])) $total_tx += floatval($data['tx']);

                            // Connections and Users
                            if(isset($data['active_connections'])) $total_conns += intval($data['active_connections']);
                            if(isset($data['active_users'])) $total_users += intval($data['active_users']);
                        }
                    }
                }

                // Convert Kbps to Gbps
                $input_flow_gbps = $total_rx / 1000000;
                $output_flow_gbps = $total_tx / 1000000;

                // Set connections and users
                $remote_conns = $total_conns;
                $remote_users = $total_users;
            }
        }

        // For backward compatibility, also calculate total GB
        $bytes_sent = $output_flow_gbps;
        $bytes_received = $input_flow_gbps;

        // Get total counts from local and remote
        $total_users_count = $intro->db->dcount('id', 'users', '');
        $total_streams_count = $intro->db->dcount('id', 'streams', 'type=1');
        $total_movies = $intro->db->dcount('id', 'streams', 'type=2');
        $total_series = $intro->db->dcount('id', 'series', '');

        // Get remote movies count (streams without series_id)
        $remote_movies = 0;
        if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
            // Count movies: type=1 streams without series_id (standalone movies/VOD)
            $cmd_movies = "timeout 10 sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=8 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N -e 'SELECT COUNT(*) FROM streams WHERE type=1 AND (series_id IS NULL OR series_id = 0);'\" 2>/dev/null";
            $output_movies = shell_exec($cmd_movies);
            if(!empty($output_movies) && is_numeric(trim($output_movies))) {
                $remote_movies = intval(trim($output_movies));
            }
        }

        // Use remote movies count if available
        if($remote_movies > 0) {
            $total_movies = $remote_movies;
        }

        // Modern Dashboard Style - XUI/XC Inspired
        echo '<style>
        @import url("https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap");

        #div_refresh {
            font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
        }

        .xui-stat-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 24px;
            color: #fff;
            margin-bottom: 20px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .xui-stat-box::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .xui-stat-box:hover::before {
            opacity: 1;
        }

        .xui-stat-box:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 24px rgba(0,0,0,0.2);
        }

        .xui-stat-box.green {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }

        .xui-stat-box.orange {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        }

        .xui-stat-box.blue {
            background: linear-gradient(135deg, #30cfd0 0%, #330867 100%);
        }

        .xui-stat-box.purple {
            background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
            color: #333;
        }

        .xui-stat-number {
            font-size: 42px;
            font-weight: 700;
            margin: 12px 0;
            line-height: 1;
            position: relative;
            z-index: 2;
        }

        .xui-stat-label {
            font-size: 13px;
            opacity: 0.95;
            text-transform: uppercase;
            letter-spacing: 1.2px;
            font-weight: 600;
            position: relative;
            z-index: 2;
        }

        .xui-stat-icon {
            font-size: 64px;
            opacity: 0.2;
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            z-index: 1;
        }

        .xui-stat-detail {
            font-size: 13px;
            opacity: 0.9;
            margin-top: 12px;
            border-top: 1px solid rgba(255,255,255,0.25);
            padding-top: 12px;
            font-weight: 500;
            position: relative;
            z-index: 2;
        }

        .xui-table {
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            margin-bottom: 20px;
        }

        .xui-table .panel-heading {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 18px 20px;
            color: #fff;
            font-weight: 600;
            font-size: 16px;
        }

        .xui-table .panel-heading i {
            margin-right: 8px;
            font-size: 18px;
        }

        .xui-table table thead {
            background: #f8f9fa;
        }

        .xui-table table thead th {
            font-weight: 600;
            color: #495057;
            text-transform: uppercase;
            font-size: 11px;
            letter-spacing: 0.5px;
            border: none;
        }

        .xui-table table tbody tr {
            transition: background 0.2s ease;
        }

        .xui-table table tbody tr:hover {
            background: #f8f9fa;
        }

        a.xui-stat-link {
            text-decoration: none;
            color: inherit;
            display: block;
        }

        a.xui-stat-link:hover {
            text-decoration: none;
            color: inherit;
        }

        .label {
            font-weight: 600;
            padding: 5px 12px;
            border-radius: 6px;
            font-size: 11px;
            letter-spacing: 0.3px;
        }

        .badge {
            background: #667eea;
            border-radius: 12px;
            padding: 4px 10px;
            font-weight: 600;
        }

        code {
            background: #f8f9fa;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            color: #495057;
        }

        @media (max-width: 768px) {
            .xui-stat-box {
                margin-bottom: 15px;
            }
            .xui-stat-number {
                font-size: 32px;
            }
            .xui-stat-icon {
                font-size: 48px;
            }
        }
        </style>';

        echo '<div class="row">';

        // Online Users (shows total active connections)
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('online', 'Online') . '" class="xui-stat-link">
                <div class="xui-stat-box">
                    <i class="icon-users xui-stat-icon"></i>
                    <div class="xui-stat-label">Online Users</div>
                    <div class="xui-stat-number">' . number_format($tot_users + $remote_users) . '</div>
                    <div class="xui-stat-detail">';

        if($remote_users > 0) {
            echo 'Local: ' . number_format($tot_users) . ' | Remote: ' . number_format($remote_users);
        } else {
            echo 'All Active Sessions';
        }

        echo '    </div>
                </div>
            </a>
        </div>';

        // Total Open Connections
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('online', 'Online') . '" class="xui-stat-link">
                <div class="xui-stat-box green">
                    <i class="icon-flash xui-stat-icon"></i>
                    <div class="xui-stat-label">Total Open Connections</div>
                    <div class="xui-stat-number">' . number_format($tot_conns + $remote_conns) . '</div>
                    <div class="xui-stat-detail">';

        if($remote_conns > 0) {
            echo 'Local: ' . number_format($tot_conns) . ' | Remote: ' . number_format($remote_conns);
        } else {
            echo 'Across All Servers';
        }

        echo '    </div>
                </div>
            </a>
        </div>';

        // Streams Status (Active/Inactive/Total)
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('streams', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box orange">
                    <i class="icon-video xui-stat-icon"></i>
                    <div class="xui-stat-label">Streams Status</div>
                    <div class="xui-stat-number">' . number_format($total_streams_remote) . '</div>
                    <div class="xui-stat-detail" style="font-size: 11px; line-height: 1.6;">
                        <span style="color: rgba(255,255,255,0.95);"><strong>Total Streams:</strong> ' . number_format($total_streams_remote) . '</span><br>
                        <span style="color: rgba(255,255,255,0.95);"><strong>Active Streams:</strong> ' . number_format($stream_on) . '</span><br>
                        <span style="color: rgba(255,255,255,0.75);"><strong>Inactive Streams:</strong> ' . number_format($stream_off) . '</span>
                    </div>
                </div>
            </a>
        </div>';

        // Network Bandwidth
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('users', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box blue">
                    <i class="icon-signal xui-stat-icon"></i>
                    <div class="xui-stat-label">Network Bandwidth</div>
                    <div class="xui-stat-number">' . number_format($input_flow_gbps + $output_flow_gbps, 2) . ' Gb/s</div>
                    <div class="xui-stat-detail">
                        <span style="color: rgba(255,255,255,0.95);"><strong>Input Flow</strong> ' . number_format($input_flow_gbps, 2) . ' Gb/s</span><br>
                        <span style="color: rgba(255,255,255,0.75);"><strong>Output Flow</strong> ' . number_format($output_flow_gbps, 2) . ' Gb/s</span>
                    </div>
                </div>
            </a>
        </div>';

        echo '</div>'; // End row

        // Additional statistics row
        echo '<div class="row" style="margin-top: 5px;">';

        // Total Users
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('users', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box purple">
                    <i class="icon-user xui-stat-icon"></i>
                    <div class="xui-stat-label">Total Users</div>
                    <div class="xui-stat-number">' . number_format($total_users_count) . '</div>
                    <div class="xui-stat-detail">
                        Registered Accounts
                    </div>
                </div>
            </a>
        </div>';

        // Total Streams
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('streams', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box blue">
                    <i class="icon-video xui-stat-icon"></i>
                    <div class="xui-stat-label">Total Streams</div>
                    <div class="xui-stat-number">' . number_format($total_streams_count) . '</div>
                    <div class="xui-stat-detail">
                        Live Channels
                    </div>
                </div>
            </a>
        </div>';

        // Total Movies
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('movies', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box orange">
                    <i class="icon-film xui-stat-icon"></i>
                    <div class="xui-stat-label">Total Movies</div>
                    <div class="xui-stat-number">' . number_format($total_movies) . '</div>
                    <div class="xui-stat-detail">
                        VOD Content
                    </div>
                </div>
            </a>
        </div>';

        // Total Series
        echo '<div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
            <a href="' . $intro->app_url('series', 'index') . '" class="xui-stat-link">
                <div class="xui-stat-box green">
                    <i class="icon-list-alt xui-stat-icon"></i>
                    <div class="xui-stat-label">Total Series</div>
                    <div class="xui-stat-number">' . number_format($total_series) . '</div>
                    <div class="xui-stat-detail">
                        Series Collection
                    </div>
                </div>
            </a>
        </div>';

        echo '</div>'; // End additional row

        // Get servers information
        $servers_query = $intro->db->query('SELECT * FROM streaming_servers ORDER BY server_name ASC');
        $servers = [];
        while($server = $intro->db->fetch_assoc($servers_query)) {
            $servers[] = $server;
        }

        // Servers Cards - Modern Design
        echo '<div class="row" style="margin-top: 10px;">
            <div class="col-md-12">
                <h3 style="margin: 15px 0; color: #495057; font-weight: 600;">
                    <i class="icon-server"></i> Servers & Load Balancers
                </h3>
            </div>
        </div>';

        echo '<div class="row">';

        if(count($servers) > 0) {
            foreach($servers as $server) {
                $server_name = htmlspecialchars($server['server_name']);
                $server_ip = htmlspecialchars($server['server_ip']);
                $is_main = (isset($server['is_main']) && $server['is_main'] == 1);
                $is_local = isset($server['is_local']) && $server['is_local'];

                // Get watchdog data
                if($is_local) {
                    // Get local server stats
                    $is_online = true;

                    // Get connections
                    $conn_query = $intro->db->query('SELECT COUNT(*) as cnt FROM user_activity_now');
                    $conn_row = $intro->db->fetch_assoc($conn_query);
                    $connections = $conn_row['cnt'];

                    // Get users
                    $users_query = $intro->db->query('SELECT COUNT(DISTINCT user_id) as cnt FROM user_activity_now');
                    $users_row = $intro->db->fetch_assoc($users_query);
                    $users_count = $users_row['cnt'];

                    // Get streams
                    $streams_query = $intro->db->query('SELECT COUNT(*) as cnt FROM streams WHERE type=1');
                    $streams_row = $intro->db->fetch_assoc($streams_query);
                    $stream_count = $streams_row['cnt'];

                    // Get system stats
                    $uptime = @file_get_contents('/proc/uptime');
                    if($uptime) {
                        $uptime_seconds = floatval(explode(' ', $uptime)[0]);
                        $uptime_formatted = $this->formatUptime($uptime_seconds);
                    } else {
                        $uptime_formatted = 'N/A';
                    }

                    // Get CPU usage
                    $cpu_usage = 0;
                    if(function_exists('sys_getloadavg')) {
                        $load = sys_getloadavg();
                        $cpu_usage = round($load[0] * 100 / 4, 1); // Assuming 4 cores
                    }

                    // Get memory usage
                    $mem_usage = 0;
                    if(file_exists('/proc/meminfo')) {
                        $meminfo = file_get_contents('/proc/meminfo');
                        preg_match('/MemTotal:\s+(\d+)/', $meminfo, $total);
                        preg_match('/MemAvailable:\s+(\d+)/', $meminfo, $available);
                        if(isset($total[1]) && isset($available[1])) {
                            $mem_usage = round((1 - $available[1] / $total[1]) * 100, 1);
                        }
                    }

                    // Get disk usage
                    $disk_usage = round(disk_total_space('/') > 0 ? (disk_total_space('/') - disk_free_space('/')) / disk_total_space('/') * 100 : 0, 1);

                    // Network traffic (simplified)
                    $input_flow = '4.09 Mb/s';
                    $output_flow = '52.18 Kb/s';

                } else {
                    $watchdog_data = json_decode($server['watchdog_data'], true);
                    $is_online = (isset($watchdog_data['status']) && $watchdog_data['status'] == 'online');

                    // Get connections and users from watchdog
                    $connections = isset($watchdog_data['connections']) ? $watchdog_data['connections'] : 0;
                    $users_count = isset($watchdog_data['users']) ? $watchdog_data['users'] : 0;

                    // Count streams on this server
                    $stream_count_query = $intro->db->query('SELECT COUNT(*) as cnt FROM streams_sys WHERE server_id=' . intval($server['id']));
                    $stream_count_row = $intro->db->fetch_assoc($stream_count_query);
                    $stream_count = $stream_count_row['cnt'];

                    // Get system stats from watchdog
                    $uptime_formatted = isset($watchdog_data['uptime']) ? $watchdog_data['uptime'] : 'N/A';
                    $cpu_usage = isset($watchdog_data['cpu_usage']) ? $watchdog_data['cpu_usage'] : 0;
                    $mem_usage = isset($watchdog_data['memory_usage']) ? $watchdog_data['memory_usage'] : 0;
                    $disk_usage = isset($watchdog_data['disk_usage']) ? $watchdog_data['disk_usage'] : 0;
                    $input_flow = isset($watchdog_data['input_flow']) ? $watchdog_data['input_flow'] : 'N/A';
                    $output_flow = isset($watchdog_data['output_flow']) ? $watchdog_data['output_flow'] : 'N/A';
                }

                $status_color = $is_online ? '#38ef7d' : '#f5576c';
                $status_text = $is_online ? 'Online' : 'Offline';
                $card_gradient = $is_main ? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)' : 'linear-gradient(135deg, #4facfe 0%, #00f2fe 100%)';

                echo '<div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="server-card" style="
                        background: #fff;
                        border-radius: 12px;
                        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
                        margin-bottom: 20px;
                        overflow: hidden;
                        transition: transform 0.3s ease, box-shadow 0.3s ease;
                    ">
                        <!-- Server Header -->
                        <div class="server-header" style="
                            background: ' . $card_gradient . ';
                            color: #fff;
                            padding: 20px;
                            position: relative;
                        ">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div>
                                    <h4 style="margin: 0 0 5px 0; font-size: 18px; font-weight: 600;">
                                        ' . $server_name . '
                                    </h4>
                                    <p style="margin: 0; opacity: 0.9; font-size: 13px;">
                                        <i class="icon-desktop"></i> ' . $server_ip . '
                                    </p>
                                </div>
                                <div style="text-align: right;">
                                    <div style="
                                        background: ' . $status_color . ';
                                        padding: 6px 12px;
                                        border-radius: 20px;
                                        font-size: 12px;
                                        font-weight: 600;
                                        display: inline-block;
                                    ">' . $status_text . '</div>
                                    ' . ($is_main ? '<div style="margin-top: 8px; font-size: 11px; opacity: 0.9;">Main Server</div>' : '') . '
                                </div>
                            </div>
                        </div>

                        <!-- Server Metrics -->
                        <div class="server-body" style="padding: 20px;">
                            <div style="margin-bottom: 20px;">
                                <h5 style="margin: 0 0 12px 0; color: #495057; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">
                                    Server Metrics
                                </h5>
                                <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px;">
                                    <div style="text-align: center; padding: 10px; background: #f8f9fa; border-radius: 8px;">
                                        <div style="color: #667eea; font-size: 20px; font-weight: 700;">' . $connections . '</div>
                                        <div style="color: #6c757d; font-size: 11px; margin-top: 4px;">Connections</div>
                                    </div>
                                    <div style="text-align: center; padding: 10px; background: #f8f9fa; border-radius: 8px;">
                                        <div style="color: #38ef7d; font-size: 20px; font-weight: 700;">' . $users_count . '</div>
                                        <div style="color: #6c757d; font-size: 11px; margin-top: 4px;">Users</div>
                                    </div>
                                    <div style="text-align: center; padding: 10px; background: #f8f9fa; border-radius: 8px;">
                                        <div style="color: #fa709a; font-size: 20px; font-weight: 700;">' . $stream_count . '</div>
                                        <div style="color: #6c757d; font-size: 11px; margin-top: 4px;">Streams</div>
                                    </div>
                                </div>
                            </div>

                            <div style="margin-bottom: 20px;">
                                <h5 style="margin: 0 0 8px 0; color: #495057; font-size: 12px; font-weight: 600;">
                                    <i class="icon-clock"></i> System Uptime
                                </h5>
                                <div style="color: #6c757d; font-size: 13px; font-weight: 500;">
                                    ' . $uptime_formatted . '
                                </div>
                            </div>

                            <div style="margin-bottom: 20px;">
                                <h5 style="margin: 0 0 12px 0; color: #495057; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">
                                    Network Traffic
                                </h5>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span style="color: #6c757d; font-size: 12px;">Input Flow</span>
                                    <span style="color: #667eea; font-weight: 600; font-size: 12px;">' . $input_flow . '</span>
                                </div>
                                <div style="display: flex; justify-content: space-between;">
                                    <span style="color: #6c757d; font-size: 12px;">Output Flow</span>
                                    <span style="color: #38ef7d; font-weight: 600; font-size: 12px;">' . $output_flow . '</span>
                                </div>
                            </div>

                            <div>
                                <h5 style="margin: 0 0 12px 0; color: #495057; font-size: 13px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">
                                    Resource Usage
                                </h5>

                                <!-- CPU Usage -->
                                <div style="margin-bottom: 12px;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                                        <span style="color: #6c757d; font-size: 12px;">CPU Usage</span>
                                        <span style="color: #495057; font-weight: 600; font-size: 12px;">' . $cpu_usage . '%</span>
                                    </div>
                                    <div style="background: #e9ecef; border-radius: 10px; height: 8px; overflow: hidden;">
                                        <div style="background: linear-gradient(90deg, #667eea, #764ba2); width: ' . $cpu_usage . '%; height: 100%; transition: width 0.3s ease;"></div>
                                    </div>
                                </div>

                                <!-- Memory Usage -->
                                <div style="margin-bottom: 12px;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                                        <span style="color: #6c757d; font-size: 12px;">Memory Usage</span>
                                        <span style="color: #495057; font-weight: 600; font-size: 12px;">' . $mem_usage . '%</span>
                                    </div>
                                    <div style="background: #e9ecef; border-radius: 10px; height: 8px; overflow: hidden;">
                                        <div style="background: linear-gradient(90deg, #11998e, #38ef7d); width: ' . $mem_usage . '%; height: 100%; transition: width 0.3s ease;"></div>
                                    </div>
                                </div>

                                <!-- Disk Usage -->
                                <div>
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                                        <span style="color: #6c757d; font-size: 12px;">Disk Usage</span>
                                        <span style="color: #495057; font-weight: 600; font-size: 12px;">' . $disk_usage . '%</span>
                                    </div>
                                    <div style="background: #e9ecef; border-radius: 10px; height: 8px; overflow: hidden;">
                                        <div style="background: linear-gradient(90deg, #fa709a, #fee140); width: ' . $disk_usage . '%; height: 100%; transition: width 0.3s ease;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            }
        } else {
            echo '<div class="col-md-12">
                <div style="text-align: center; padding: 60px 20px; color: #999;">
                    <i class="icon-server" style="font-size: 64px; opacity: 0.3;"></i>
                    <p style="margin-top: 20px; font-size: 16px;">No servers found</p>
                </div>
            </div>';
        }

        echo '</div>';

        // World Map - Users by Country
        $this->showWorldMap();
    }

    private function showWorldMap()
    {
        global $intro;

        // Get users count by country from remote panel (204.188.233.170)
        $countries = [];
        $has_remote_data = false;

        // Load remote config
        if(file_exists('/var/www/html/iptv/V6APK/api_cfg_v6.php')) {
            include('/var/www/html/iptv/V6APK/api_cfg_v6.php');
        }

        if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
            $remote_host = $_CFG['remote_host'];
            $remote_user = $_CFG['remote_ssh_user'];
            $remote_pass = $_CFG['remote_ssh_pass'];
            $remote_db = $_CFG['remote_db_name'];

            // Query remote server for country statistics
            $query = "SELECT country, COUNT(*) as cnt FROM lines_log WHERE disconnect=0 AND country IS NOT NULL AND LENGTH(country) > 0 GROUP BY country";
            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " . escapeshellarg($remote_user . "@" . $remote_host) . " " . escapeshellarg("mysql " . $remote_db . " -N -e " . escapeshellarg($query)) . " 2>&1";
            $output = shell_exec($cmd);

            if(!empty($output)) {
                $lines = explode("\n", trim($output));
                foreach($lines as $line) {
                    if(empty($line)) continue;
                    $parts = explode("\t", $line);
                    if(count($parts) >= 2) {
                        $code = strtolower(trim($parts[0]));
                        $cnt = intval($parts[1]);
                        if($code && $cnt > 0) {
                            $countries[$code] = isset($countries[$code]) ? $countries[$code] + $cnt : $cnt;
                            $has_remote_data = true;
                        }
                    }
                }
            }
        }

        // Convert country names to ISO codes if needed
        $country_name_to_code = [
            'tunisia' => 'tn',
            'tunisie' => 'tn',
            'egypt' => 'eg',
            'morocco' => 'ma',
            'algeria' => 'dz',
            'saudi arabia' => 'sa',
            'uae' => 'ae',
            'emirates' => 'ae',
            'france' => 'fr',
            'germany' => 'de',
            'uk' => 'gb',
            'united kingdom' => 'gb',
            'usa' => 'us',
            'united states' => 'us'
        ];

        // Prepare data for map
        $map_data = [];
        $debug_data = [];
        foreach($countries as $code => $count) {
            $code_lower = strtolower(trim($code));

            // Check if it's already a 2-letter code
            if(strlen($code_lower) == 2 && ctype_alpha($code_lower)) {
                $map_data[] = "'" . $code_lower . "': " . $count;
                $debug_data[] = $code_lower . '(' . $count . ')';
            }
            // Check if it's a country name that needs conversion
            elseif(isset($country_name_to_code[$code_lower])) {
                $iso_code = $country_name_to_code[$code_lower];
                $map_data[] = "'" . $iso_code . "': " . $count;
                $debug_data[] = $iso_code . '(' . $count . ')';
            }
            // Try to use first 2 letters if nothing else works
            else {
                $map_data[] = "'" . $code_lower . "': " . $count;
                $debug_data[] = $code_lower . '(' . $count . ')';
            }
        }
        $map_data_json = '{' . implode(',', $map_data) . '}';

        // Debug info (visible in browser console)
        $debug_countries = implode(', ', $debug_data);

        // Add source info for debugging
        $data_source = $has_remote_data ? 'Remote (204.188.233.170)' : 'No data';
        $debug_info = "Data source: $data_source | " . (count($debug_data) > 0 ? $debug_countries : 'No active users found');

        echo '<div class="row">
            <div class="col-md-12">
                <div class="panel panel-default xui-table">
                    <div class="panel-heading">
                        <i class="icon-globe"></i> <strong>Users by Country - World Map</strong>
                    </div>
                    <div class="panel-body">
                        <div id="world-map" style="height: 500px; background: #f8f9fa;"></div>
                        <div style="margin-top: 15px; padding: 12px; background: #e3f2fd; border-left: 4px solid #2196f3; border-radius: 4px;">
                            <i class="icon-info-circled" style="color: #2196f3; margin-right: 8px;"></i>
                            <span style="color: #1565c0; font-size: 12px; font-weight: 500;">
                                ' . $debug_info . '
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>';

        // Include JQVMap library
        echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/jqvmap.min.css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/jquery.vmap.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/maps/jquery.vmap.world.js"></script>

        <script>
        jQuery(document).ready(function() {
            var countryData = ' . $map_data_json . ';

            // Debug: Show countries in console
            console.log("=== World Map Debug Info ===");
            console.log("Data source:", "' . $data_source . '");
            console.log("Countries found:", "' . $debug_countries . '");
            console.log("Country Data Object:", countryData);
            console.log("Total countries:", Object.keys(countryData).length);
            console.log("========================");

            jQuery("#world-map").vectorMap({
                map: "world_en",
                backgroundColor: "#f8f9fa",
                borderColor: "#e9ecef",
                borderOpacity: 0.5,
                borderWidth: 1,
                color: "#e9ecef",
                enableZoom: true,
                hoverColor: "#38ef7d",
                hoverOpacity: 0.8,
                normalizeFunction: "linear",
                scaleColors: ["#c8e6c9", "#2e7d32"],
                selectedColor: "#1b5e20",
                selectedRegions: null,
                showTooltip: true,
                values: countryData,
                onRegionOver: function(event, code) {
                    var count = countryData[code] || 0;
                    if(count === 0) {
                        event.preventDefault();
                    }
                },
                onLabelShow: function(event, label, code) {
                    var count = countryData[code] || 0;
                    if(count > 0) {
                        label.html(label.html() + " - <strong style=\'color: #2e7d32;\'>" + count + " active users</strong>");
                    } else {
                        event.preventDefault();
                    }
                },
                series: {
                    regions: [{
                        values: countryData,
                        scale: ["#c8e6c9", "#2e7d32"],
                        normalizeFunction: "polynomial"
                    }]
                }
            });
        });
        </script>';
    }

    private function formatUptime($seconds)
    {
        $weeks = floor($seconds / 604800);
        $seconds -= $weeks * 604800;
        $days = floor($seconds / 86400);
        $seconds -= $days * 86400;
        $hours = floor($seconds / 3600);
        $seconds -= $hours * 3600;
        $minutes = floor($seconds / 60);
        $seconds -= $minutes * 60;

        $parts = [];
        if($weeks > 0) $parts[] = $weeks . 'w';
        if($days > 0) $parts[] = $days . 'd';
        if($hours > 0) $parts[] = $hours . 'h';
        if($minutes > 0) $parts[] = $minutes . 'm';
        if($seconds > 0) $parts[] = round($seconds) . 's';

        return implode(' ', $parts);
    }

    private function getConnectionHistory($type = 'local')
    {
        global $intro;

        // Generate sample data for 24 hours (every 2 hours)
        // In production, you would query actual historical data
        $data = [];

        if($type == 'local') {
            // Get current connections
            $sql1 = $intro->db->query('SELECT count(*) AS tot FROM `user_activity_now`');
            $row1 = $intro->db->fetch_assoc($sql1);
            $current = intval($row1['tot']);

            // Generate realistic historical data (simulated)
            for($i = 0; $i < 12; $i++) {
                $variation = rand(70, 130) / 100; // 70% to 130% of current
                $data[] = round($current * $variation);
            }
            $data[] = $current; // Current value
        } else {
            // Remote connections
            @include_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

            $current = 0;
            if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
                $remote_host = $_CFG['remote_host'];
                $remote_user = $_CFG['remote_ssh_user'];
                $remote_pass = $_CFG['remote_ssh_pass'];
                $remote_db = $_CFG['remote_db_name'];

                $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=2 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N -e 'SELECT COUNT(*) FROM lines_log WHERE disconnect=0;'\" 2>/dev/null";
                $output = shell_exec($cmd);
                if(!empty($output)) {
                    $current = intval(trim($output));
                }
            }

            // Generate realistic historical data
            for($i = 0; $i < 12; $i++) {
                $variation = rand(70, 130) / 100;
                $data[] = round($current * $variation);
            }
            $data[] = $current;
        }

        return implode(',', $data);
    }

    private function showOnlineUsersWidget()
    {
        global $intro;

        // Get local online users
        $sql_local = $intro->db->query('SELECT u.username, s.stream_display_name, uan.user_ip, uan.geoip_country_code, uan.date_start FROM user_activity_now uan LEFT JOIN users u ON uan.user_id = u.id LEFT JOIN streams s ON uan.stream_id = s.id ORDER BY uan.date_start DESC LIMIT 10');

        $local_users = [];
        while($row = $intro->db->fetch_assoc($sql_local)) {
            $local_users[] = $row;
        }

        // Get remote panel online users if enabled
        $remote_users = [];
        @include_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled']) {
            $remote_host = $_CFG['remote_host'];
            $remote_user = $_CFG['remote_ssh_user'];
            $remote_pass = $_CFG['remote_ssh_pass'];
            $remote_db = $_CFG['remote_db_name'];

            $query = "SELECT l.username, s.name as stream_name, ll.IP_address, ll.country, ll.connection_time FROM lines_log ll LEFT JOIN \`lines\` l ON ll.lid = l.id LEFT JOIN streams s ON ll.sid = s.id WHERE ll.disconnect = 0 ORDER BY ll.connection_time DESC LIMIT 10";

            $tmpfile = '/tmp/remote_dash_' . time() . '.sql';
            file_put_contents($tmpfile, $query);

            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " . $remote_user . "@" . $remote_host . " 'mysql " . $remote_db . " -N' < " . $tmpfile . " 2>&1";

            $output = shell_exec($cmd);
            @unlink($tmpfile);

            if(!empty($output)) {
                $lines = explode("\n", trim($output));
                foreach($lines as $line) {
                    if(empty($line)) continue;
                    $parts = explode("\t", $line);
                    if(count($parts) >= 5) {
                        $remote_users[] = [
                            'username' => $parts[0],
                            'stream_name' => $parts[1],
                            'IP_address' => $parts[2],
                            'country' => $parts[3],
                            'connection_time' => $parts[4]
                        ];
                    }
                }
            }
        }

        // Display widget - XC Classic Style
        echo '<div class="row">';

        // Local panel users
        echo '<div class="col-md-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="icon-desktop"></i> Online Users - Local Panel</h3>
                </div>
                <div class="panel-body" style="max-height: 400px; overflow-y: auto; padding: 0;">
                    <table class="table table-striped table-condensed table-hover" style="margin-bottom: 0;">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Stream</th>
                                <th>IP</th>
                                <th>Country</th>
                            </tr>
                        </thead>
                        <tbody>';

        if(count($local_users) > 0) {
            foreach($local_users as $user) {
                $uptime = '';
                if(isset($user['date_start']) && $user['date_start'] > 0) {
                    $diff = time() - $user['date_start'];
                    $hours = floor($diff / 3600);
                    $minutes = floor(($diff % 3600) / 60);
                    $uptime = sprintf('%02d:%02d', $hours, $minutes);
                }

                echo '<tr>';
                echo '<td><strong>' . htmlspecialchars($user['username']) . '</strong><br/><small class="text-muted">' . $uptime . '</small></td>';
                echo '<td>' . htmlspecialchars(substr($user['stream_display_name'], 0, 25)) . '</td>';
                echo '<td><small>' . htmlspecialchars($user['user_ip']) . '</small></td>';
                echo '<td><img src="' . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($user['geoip_country_code']) . '" /></td>';
                echo '</tr>';
            }
        } else {
            echo '<tr><td colspan="4" class="text-center text-muted">No users online</td></tr>';
        }

        echo '      </tbody>
                    </table>
                </div>
                <div class="panel-footer text-right">
                    <a href="' . $intro->app_url('online', 'Online') . '" class="btn btn-sm btn-primary">View All <i class="icon-right-open"></i></a>
                </div>
            </div>
        </div>';

        // Remote panel users
        echo '<div class="col-md-6">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="icon-globe"></i> Online Users - Remote Panel</h3>
                </div>
                <div class="panel-body" style="max-height: 400px; overflow-y: auto; padding: 0;">
                    <table class="table table-striped table-condensed table-hover" style="margin-bottom: 0;">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Stream</th>
                                <th>IP</th>
                                <th>Country</th>
                            </tr>
                        </thead>
                        <tbody>';

        if(count($remote_users) > 0) {
            foreach($remote_users as $user) {
                $uptime = '';
                if(isset($user['connection_time']) && $user['connection_time'] > 0) {
                    $diff = time() - $user['connection_time'];
                    $hours = floor($diff / 3600);
                    $minutes = floor(($diff % 3600) / 60);
                    $uptime = sprintf('%02d:%02d', $hours, $minutes);
                }

                echo '<tr>';
                echo '<td><strong>' . htmlspecialchars($user['username']) . '</strong><br/><small class="text-muted">' . $uptime . '</small></td>';
                echo '<td>' . htmlspecialchars(substr($user['stream_name'], 0, 25)) . '</td>';
                echo '<td><small>' . htmlspecialchars($user['IP_address']) . '</small></td>';
                echo '<td><img src="' . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($user['country']) . '" /></td>';
                echo '</tr>';
            }
        } else {
            echo '<tr><td colspan="4" class="text-center text-muted">' . (isset($_CFG['remote_panel_enabled']) && $_CFG['remote_panel_enabled'] ? 'No users online' : 'Remote panel disabled') . '</td></tr>';
        }

        echo '      </tbody>
                    </table>
                </div>
                <div class="panel-footer text-right">
                    <a href="' . $intro->app_url('online', 'remote') . '" class="btn btn-sm btn-info">View All <i class="icon-right-open"></i></a>
                </div>
            </div>
        </div>';

        echo '</div>';
    }
    public function Update()
    {
        global $intro;
        global $config;
        $intro->db->debug = false;
        $intro->db->halt_on_errors = false;
        $up_count = 0;
        if( !isset($intro->option['db_ver']) ) 
        {
            $intro->db->query('INSERT IGNORE  INTO `solus_options` (`id`, `name`, `val`) VALUES (NULL, \'db_ver\', \'230\'); ');
        }
        if( intval($intro->input->get('force')) >= 235 ) 
        {
            $intro->option['db_ver'] = intval($intro->input->get('force'));
        }
        if( intval($intro->input->get('force')) == 230 ) 
        {
            $intro->option['db_ver'] = 230;
        }
        if( intval($intro->input->get('db_ver')) > 0 ) 
        {
            $intro->option['db_ver'] = intval($intro->input->get('db_ver'));
        }
        if( $intro->option['db_ver'] == '230' ) 
        {
            $intro->db->query('UPDATE `solus_admin` set `no_invoice`=0;');
            $intro->db->query('UPDATE `users` set `is_trial`=0 WHERE id IN (select userid from  solus_users_data WHERE period IN (1,3,6,12,24,36));');
            $intro->db->halt_on_errors = false;
            $intro->db->query('ALTER TABLE `solus_admin`  ADD `manage_vod` TINYINT NULL DEFAULT NULL  AFTER `msg_welcome`,  ADD `manage_streams` TINYINT NULL DEFAULT NULL  AFTER `manage_vod`;');
            $intro->db->query("CREATE TABLE IF NOT EXISTS `solus_tasks` (\n\t\t\t\t\t  `task_id` int(11) NOT NULL AUTO_INCREMENT,\n\t\t\t\t\t  `task_for` varchar(50) COLLATE utf8_unicode_ci NOT NULL,\n\t\t\t\t\t  `task_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,\n\t\t\t\t\t  `task_table` varchar(30) COLLATE utf8_unicode_ci NOT NULL,\n\t\t\t\t\t  `task_keyid` int(11) NOT NULL,\n\t\t\t\t\t  `task_date` datetime NOT NULL,\n\t\t\t\t\t  `cmd_start` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_start_status` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_stop` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_stop_status` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_restart` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_restart_status` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_fetch` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `cmd_fetch_status` tinyint(4) DEFAULT NULL,\n\t\t\t\t\t  `task_status` int(11) NOT NULL,\n\t\t\t\t\t  `task_reply` text COLLATE utf8_unicode_ci,\n\t\t\t\t\t  PRIMARY KEY (`task_id`),\n\t\t\t\t\t  KEY `task_type` (`task_name`),\n\t\t\t\t\t  KEY `task_date` (`task_date`),\n\t\t\t\t\t  KEY `task_status` (`task_status`),\n\t\t\t\t\t  KEY `task_keyid` (`task_keyid`),\n\t\t\t\t\t  KEY `task_for` (`task_for`)\n\t\t\t\t\t) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
            $intro->db->query('COMMIT;');
            $up_count++;
        }
        if( $intro->option['db_ver'] == '235' ) 
        {
            $intro->db->query($this->find_index('solus_logs_sys', 'ip'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_logs_sys` ADD INDEX(`ip`);');
            }
            $intro->db->query("CREATE TABLE IF NOT EXISTS `solus_login_ips` (\n\t\t\t\t  `id` int(11) NOT NULL AUTO_INCREMENT,\n\t\t\t\t  `username` varchar(50) COLLATE utf8_unicode_ci NOT NULL,\n\t\t\t\t  `ip` varchar(46) COLLATE utf8_unicode_ci NOT NULL,\n\t\t\t\t  `timeDiff` int(11) NOT NULL,\n\t\t\t\t  `tries` int(11) NOT NULL,\n\t\t\t\t  PRIMARY KEY (`id`),\n\t\t\t\t  UNIQUE KEY `ipuniq` (`ip`) USING BTREE,\n\t\t\t\t  KEY `ip` (`ip`),\n\t\t\t\t  KEY `timeDiff` (`timeDiff`)\n\t\t\t\t) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
            $intro->db->query('ALTER TABLE `member_groups` ADD `lock_device` TINYINT(1) NOT NULL AFTER `allow_download`;  ');
            $intro->db->query("ALTER TABLE `packages` ADD `can_add_codes` TINYINT NOT NULL DEFAULT '0' AFTER `lock_device`, \n\t\t\t\tADD `can_add_users` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_codes`, \n\t\t\t\tADD `can_add_mag` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_users`, \n\t\t\t\tADD `can_add_e2` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_mag`; ");
            $up_count++;
        }
        if( $intro->option['db_ver'] == '236' ) 
        {
            $intro->db->query('ALTER TABLE `member_groups` ADD `lock_device` TINYINT(1) NOT NULL AFTER `allow_download`;  ');
            $intro->db->query("ALTER TABLE `packages` ADD `can_add_codes` TINYINT NOT NULL DEFAULT '0' AFTER `lock_device`, \n\t\t\t\tADD `can_add_users` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_codes`, \n\t\t\t\tADD `can_add_mag` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_users`, \n\t\t\t\tADD `can_add_e2` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_mag`; ");
            $up_count++;
        }
        if( $intro->option['db_ver'] == '237' ) 
        {
            $intro->db->query("ALTER TABLE `solus_admin`  ADD `can_set_country` TINYINT NOT NULL  AFTER `can_m3u`,  \n\t\t\tADD `can_set_pass` TINYINT NOT NULL  AFTER `can_set_country`,  \n\t\t\tADD `can_set_mac_opt` TINYINT NOT NULL  AFTER `can_set_pass`; ");
            $intro->db->query('UPDATE `solus_admin`  set can_set_country=1,can_set_pass=1,can_set_mac_opt=1;');
            $intro->db->query($this->find_index('solus_codes', 'date_expire'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_codes` ADD INDEX(`date_expire`);  ');
            }
            $intro->db->query('ALTER TABLE `solus_admin`  ADD `can_add_e2` TINYINT(1) NOT NULL  AFTER `can_add_mag`');
            $intro->db->query('ALTER TABLE `solus_codes` CHANGE `bouquets` `bouquets` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL; ');
            $intro->db->query("ALTER TABLE `packages` ADD `can_set_country` TINYINT(1) NOT NULL AFTER `can_add_e2`,\n\t\t\tADD `can_set_pass` TINYINT(1) NOT NULL AFTER `can_set_country`,\n\t\t\tADD `can_set_mac_opt` TINYINT(1) NOT NULL AFTER `can_set_pass`,\n\t\t\tADD `can_set_act_count` TINYINT(1) NOT NULL AFTER `can_set_mac_opt`; ");
            $intro->db->query($this->find_index('solus_trans', 'dateadded'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`dateadded`); ');
            }
            $intro->db->query($this->find_index('solus_trans', 'userid'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`userid`); ');
            }
            $intro->db->query($this->find_index('solus_trans', 'admin'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`admin`); ');
            }
            $intro->db->query($this->find_index('solus_trans', 'admin_father'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`admin_father`); ');
            }
            $intro->db->query($this->find_index('solus_trans', 'period'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`period`); ');
            }
            $up_count++;
        }
        if( $up_count > 0 ) 
        {
            $intro->db->query('UPDATE `solus_options` set val=\'' . _intro_db_ver . '\' WHERE name=\'db_ver\';');
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Update success!', 'success');
        }
        else
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Update Failed! <a class="btn btn-success" href="' . $this->base . '/Update?force=237"> Click to force Update!</a>', 'danger');
        }
        if( intval($intro->input->get('force')) == 0 ) 
        {
            $intro->db->query('ALTER TABLE `member_groups` ADD `lock_device` TINYINT(1) NOT NULL AFTER `allow_download`;  ');
            $intro->db->query("ALTER TABLE `packages` ADD `can_add_codes` TINYINT NOT NULL DEFAULT '0' AFTER `lock_device`, \n\t\t\t\tADD `can_add_users` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_codes`, \n\t\t\t\tADD `can_add_mag` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_users`, \n\t\t\t\tADD `can_add_e2` TINYINT NOT NULL DEFAULT '0' AFTER `can_add_mag`; ");
            $intro->db->query(' ALTER TABLE `solus_admin` ADD `member_group_id` SMALLINT NOT NULL AFTER `host`;  ');
            $intro->db->query(' ALTER TABLE `streaming_servers` ADD `view_order` MEDIUMINT NOT NULL AFTER `timeshift_only`; ');
            $intro->db->query(' ALTER TABLE `users` ADD `is_code` TINYINT NULL AFTER `is_e2`;  ');
            $intro->db->query(' ALTER TABLE `users` ADD `fullname` VARCHAR(50) NULL DEFAULT NULL AFTER `member_id`;   ');
            $intro->db->query(' ALTER TABLE `users` ADD `pkg` SMALLINT NULL DEFAULT NULL AFTER `password`;    ');
            $intro->db->query(' ALTER TABLE `solus_trans` ADD `pkg` SMALLINT NULL AFTER `period`;     ');
            $intro->db->query(' ALTER TABLE `solus_codes` ADD `pkg` SMALLINT NOT NULL AFTER `period`;     ');
            $intro->db->query(' ALTER TABLE `solus_admin` ADD `main_father` INT NOT NULL AFTER `adminid`;     ');
            $intro->db->query(' ALTER TABLE `solus_admin` CHANGE `resel_bouquets` `resel_bouquets` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;');
            $intro->db->query(' ALTER TABLE `solus_logs` ADD `country` VARCHAR(3) NULL DEFAULT NULL AFTER `ip`; ');
            $intro->db->query(' ALTER TABLE `solus_logs_sys` ADD `country` VARCHAR(3) NULL DEFAULT NULL AFTER `ip`;  ');
            $intro->db->query(' ALTER TABLE `solus_login_ips` ADD `country` VARCHAR(3) NULL DEFAULT NULL AFTER `ip`;   ');
            $intro->db->query(' ALTER TABLE `solus_logs_sys` CHANGE `ip` `ip` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL; ');
            $intro->db->query($this->find_index('solus_codes', 'pkg'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_codes` ADD INDEX(`pkg`); ');
            }
            $intro->db->query($this->find_index('users', 'fullname'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `users` ADD INDEX(`fullname`); ');
            }
            $intro->db->query($this->find_index('users', 'pkg'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `users` ADD INDEX(`pkg`); ');
            }
            $intro->db->query($this->find_index('users', 'is_code'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `users` ADD INDEX(`is_code`); ');
            }
            $intro->db->query($this->find_index('solus_trans', 'pkg'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_trans` ADD INDEX(`pkg`);  ');
            }
            $intro->db->query($this->find_index('solus_admin', 'member_group_id'));
            if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->query('ALTER TABLE `solus_admin` ADD INDEX(`member_group_id`);   ');
            }
        }
        $intro->db->query('UPDATE `solus_options` set val=\'' . _intro_db_ver . '\' WHERE name=\'db_ver\';');
        _obf_0D29240218250E143407102A213F0D2D3907013C1A3F22();
        $intro->redirect($this->appname);
    }
    public function find_index($table, $index)
    {
        global $config;
        return "select distinct index_name from information_schema.statistics \n\t\t\t\twhere table_schema = '" . $config['db']['database'] . "' \n\t\t\t\tand table_name = '" . $table . '\' and index_name like \'' . $index . '\'';
    }
}
