<?php 
class Model_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $options;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this page.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function nav()
    {
        global $cur_file;
        echo "<div class=\"app_nav\">\t \t\t \n\t\t<a href=\"" . $this->base . '/index" class="btn btn-' . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . (" icon-list-alt\">STB Models</a> &nbsp;&nbsp;\n\t\t<a href=\"" . $this->base . "/Protocols\" class=\"btn btn-primary icon-list-alt\">By Protocol</a> &nbsp;&nbsp; \n\t\t\n\t\t\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $qry = '';
        $m_name = trim($intro->input->get_post('m_name'));
        $m_ver = trim($intro->input->get_post('m_ver'));
        $order = trim($intro->input->get_post('order'));
        $page = intval($intro->input->get_post('page'));
        if( $m_name != '' ) 
        {
            $qry .= (' AND m_name  LIKE \'%' . $m_name . '%\'');
        }
        if( $m_ver != '' ) 
        {
            $qry .= (' AND m_ver  LIKE \'%' . $m_ver . '%\'');
        }
        if( $qry != '' ) 
        {
            $qry = ' WHERE true ' . $qry . ' ';
        }
        if( $order == '' ) 
        {
            $order = 'm_id_desc';
        }
        $order = str_replace('_desc', ' desc', $order);
        $order = str_replace('_asc', ' asc', $order);
        $rows_per_page = '50';
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT *  ,(SELECT code from ' . PREFIX . '_codes where id=codeid) as code ' . 'from ' . PREFIX . ('_model  ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
        $resultnumm = $intro->db->query('SELECT m_id from ' . PREFIX . ('_model  ' . $qry));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<span class=\'icon-list\'></span> STB Models (' . $totalrows . ')', 'primary');
        echo "\n\t\t<form action=\"\" method=\"post\" class=''>\n\t\t\t<input type=\"text\" name=\"m_name\" value=\"" . $m_name . "\" size=\"25\" placeholder=\"Model Name\">\n\t\t\t<input type=\"text\" name=\"m_ver\" value=\"" . $m_ver . "\" size=\"25\" placeholder=\"Version\">\n\t\t\t\n\t\t\t<input  name=\"name\" value=\" Search \" type=\"submit\">\n\t\t</form><hr>";
        echo "\n\t  <table class=\"table table-condensed table-bordered table-hover\">\n            <tr>\n\t\t\t\t<th>ID</th>\n\t\t\t\t<th>Model</th>\n\t\t\t\t<th>Version</th>\n\t\t\t\t<th>Code</th>\n\t\t\t\t<th>Hits</th>\n\t\t\t\t<th>Login Date</th>\n\t\t\t\t<th>Options</th>\n\t\t\t\t\n\t    </tr>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "<tr>\n\t\t\t\t\t<td class=\"center\">" . $m_id . "</td>\n\t\t\t\t\t<td class=\"center\">" . $m_name . "</td>\n\t\t\t\t\t<td class=\"center\">" . $m_ver . "</td>\n                     <td class=\"center\">" . $code . "</th>\n                     <td class=\"center\">" . $hits . "</th>\n                     <td class=\"center\">" . $lastdate . "</th>\n                        \n                     <td>-</th>     \n\t\t </tr>";
        }
        echo '</table>';
        $order = str_replace(' desc', '_desc', $order);
        $order = str_replace(' asc', '_asc', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411(_obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?order=' . $order, $totalrows, $rows_per_page, $page));
    }
    public function Protocols()
    {
        global $intro;
        global $array;
        $this->nav();
        $reset = intval($intro->input->get('reset'));
        if( $reset != 0 ) 
        {
            $sql = $intro->db->query('UPDATE ' . PREFIX . '_codes ' . (' SET mac2=\'\',mac=\'reset_me\',serial=\'reset_me\' WHERE protocol=' . $reset . ' AND inputBy=0 AND is_mag=0;'));
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h3>Reset Success. Don't reset again. \n\t\t\t\tTotal reset codes (" . $intro->db->affected_rows . ')</h3>', 'success');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<span class=\'icon-list\'></span> By Protocols', 'primary');
        echo "\n\t\t<table class=\"table table-condensed table-bordered table-hover\">\n\t\t<tr>\n\t\t\t<th>#</th>\n\t\t\t<th>Protocol</th>\n\t\t\t<th>Active Devices</th>\n\t\t\t<th>Options</th>\n\t\t</tr>";
        $i = 0;
        foreach( $intro->protocol as $protocolID => $name ) 
        {
            $i++;
            $totalrows = 0;
            $protocolID = intval($protocolID);
            $sql = $intro->db->query('SELECT id from ' . PREFIX . '_codes ' . (' where protocol=' . $protocolID . ';'));
            $totalrows = $intro->db->returned_rows;
            if( in_array($protocolID, [
                33, 
                44, 
                55, 
                66, 
                77
            ]) ) 
            {
                $link = '<a OnClick="return confirm(\'Are sure?\');" href="' . $this->base . '/Protocols/?reset=' . $protocolID . '" class="btn btn-default icon-edit">Reset MAC & SN</a>';
                if( $reset == $protocolID ) 
                {
                    $link = '<span class=\'label label-success\'>Reset Success.</span>';
                }
            }
            else
            {
                $link = '-';
            }
            echo "\n\t\t\t<tr>\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td class=\"center\">Protocol: V" . substr($protocolID, 0, 1) . (' ' . $name . "</td>\n\t\t\t\t<td class=\"center\">" . $totalrows . "</td>\n\t\t\t\t<td>" . $link . "</td>     \n\t\t\t</tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
