<?php 
class Streams_bulk_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $qry = '';
    public $admin = [];
    public $adminRow = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data($this->admin['adminid']);
        if( $this->admin['level'] != 1 && $this->adminRow['manage_streams'] != 1 ) 
        {
            exit( 'error: no perms' );
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-building\">Streams Bulk Commands</icon></a> \n\t\t\n\t\t\n\t\t</div>");
    }
    public function getBq($bouqet_id)
    {
        global $intro;
        $sql2 = $intro->db->query('SELECT bouquet_channels FROM bouquets WHERE id=' . $bouqet_id . ';');
        $row2 = $intro->db->fetch_assoc($sql2);
        $bouquet_channels = json_decode($row2['bouquet_channels'], true);
        if( is_array($bouquet_channels) && count($bouquet_channels) > 0 ) 
        {
            return implode(',', $bouquet_channels);
        }
        return '';
    }
    public function syncCategoriesFromRemote()
    {
        global $intro;
        require_once(dirname(__FILE__) . '/../includes/AdminStreams.php');
        $adminStreams = new AdminStreams();

        // Get all categories from remote panel (type=0 for Live TV)
        $remote_cats_result = $adminStreams->remoteDbExecute("SELECT id, name FROM categories WHERE type = 0 ORDER BY name ASC;");

        if(empty($remote_cats_result)) {
            error_log("syncCategoriesFromRemote: No categories found on remote panel");
            return;
        }

        $remote_cats = explode("\n", trim($remote_cats_result));
        $synced = 0;
        $deleted = 0;
        $remote_cat_names = [];

        // First pass: collect remote category names and add new ones
        foreach($remote_cats as $line) {
            if(empty(trim($line))) continue;

            $parts = explode("\t", $line);
            if(count($parts) < 2) continue;

            $remote_id = intval($parts[0]);
            $cat_name = trim($parts[1]);
            $remote_cat_names[] = addslashes($cat_name);

            // Check if category exists locally
            $local_check = $intro->db->query("SELECT id FROM stream_categories WHERE category_name = '" . addslashes($cat_name) . "' AND category_type = 'live'");

            if($intro->db->returned_rows == 0) {
                // Insert new category
                $intro->db->query("INSERT INTO stream_categories (category_name, category_type) VALUES ('" . addslashes($cat_name) . "', 'live')");
                $synced++;
                error_log("syncCategoriesFromRemote: Added category '$cat_name'");
            }
        }

        // Second pass: delete local categories that don't exist on remote
        if(count($remote_cat_names) > 0) {
            $remote_names_str = "'" . implode("','", $remote_cat_names) . "'";

            // Get categories to delete
            $delete_result = $intro->db->query("SELECT id, category_name FROM stream_categories WHERE category_type = 'live' AND category_name NOT IN ($remote_names_str)");

            while($del_row = $intro->db->fetch_assoc($delete_result)) {
                $del_id = $del_row['id'];
                $del_name = $del_row['category_name'];

                // Delete the category
                $intro->db->query("DELETE FROM stream_categories WHERE id = $del_id");
                $deleted++;
                error_log("syncCategoriesFromRemote: Deleted category '$del_name' (not found on remote)");
            }
        }

        error_log("syncCategoriesFromRemote: Synced $synced new categories, deleted $deleted old categories");
        return ['synced' => $synced, 'deleted' => $deleted];
    }

    public function syncBouquetsFromRemote()
    {
        global $intro;
        require_once(dirname(__FILE__) . '/../includes/AdminStreams.php');
        $adminStreams = new AdminStreams();

        // Get all bouquets from remote panel
        $remote_bouquets_result = $adminStreams->remoteDbExecute("SELECT id, name FROM bouquets ORDER BY name ASC;");

        if(empty($remote_bouquets_result)) {
            error_log("syncBouquetsFromRemote: No bouquets found on remote panel");
            return;
        }

        $remote_bouquets = explode("\n", trim($remote_bouquets_result));
        $synced = 0;
        $deleted = 0;
        $remote_bouquet_names = [];

        // First pass: collect remote bouquet names and add new ones
        foreach($remote_bouquets as $line) {
            if(empty(trim($line))) continue;

            $parts = explode("\t", $line);
            if(count($parts) < 2) continue;

            $remote_id = intval($parts[0]);
            $bouquet_name = trim($parts[1]);
            $remote_bouquet_names[] = addslashes($bouquet_name);

            // Check if bouquet exists locally
            $local_check = $intro->db->query("SELECT id FROM bouquets WHERE bouquet_name = '" . addslashes($bouquet_name) . "'");

            if($intro->db->returned_rows == 0) {
                // Insert new bouquet with default values
                $intro->db->query("INSERT INTO bouquets (bouquet_name, bouquet_channels, bouquet_status) VALUES ('" . addslashes($bouquet_name) . "', '[]', 1)");
                $synced++;
                error_log("syncBouquetsFromRemote: Added bouquet '$bouquet_name'");
            }
        }

        // Second pass: delete local bouquets that don't exist on remote
        if(count($remote_bouquet_names) > 0) {
            $remote_names_str = "'" . implode("','", $remote_bouquet_names) . "'";

            // Get bouquets to delete
            $delete_result = $intro->db->query("SELECT id, bouquet_name FROM bouquets WHERE bouquet_name NOT IN ($remote_names_str)");

            while($del_row = $intro->db->fetch_assoc($delete_result)) {
                $del_id = $del_row['id'];
                $del_name = $del_row['bouquet_name'];

                // Delete the bouquet
                $intro->db->query("DELETE FROM bouquets WHERE id = $del_id");
                $deleted++;
                error_log("syncBouquetsFromRemote: Deleted bouquet '$del_name' (not found on remote)");
            }
        }

        error_log("syncBouquetsFromRemote: Synced $synced new bouquets, deleted $deleted old bouquets");
        return ['synced' => $synced, 'deleted' => $deleted];
    }

    public function index()
    {
        global $intro;
        global $array;

        // Sync categories and bouquets from remote panel automatically
        $this->syncCategoriesFromRemote();
        $this->syncBouquetsFromRemote();

        $this->nav();
        $cid = intval($intro->input->get_post('cid'));
        $bid = intval($intro->input->get_post('bid'));
        $serv = intval($intro->input->get_post('serv'));
        if( $cid != 0 ) 
        {
            $this->qry = ' AND category_id=' . $cid;
        }
        if( $serv != 0 ) 
        {
            $this->qry = ' AND id IN (SELECT stream_id FROM streams_sys WHERE server_id=' . $serv . ')';
        }
        if( $bid != 0 ) 
        {
            $rep = $this->getBq($bid);
            if( $rep != '' ) 
            {
                $this->qry = ' AND id IN (' . $rep . ') ';
            }
        }
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo '<link rel="stylesheet" href="' . admin_path . 'style/css/streams-bulk-enhanced.css">';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h3 style="color:#2196F3;"><i class="icon-cog"></i> Bulk Streams Management</h3>');
        echo "\n\t\t<form method=\"GET\" name=\"srch_streams\" action=\"" . $this->base . "/index\">\n\t\t\n\t\t<table class=\"table table-hover table-bordered\" id=\"table_codes\">\n\t\t\t<tbody>\n\t\t\t\t<tr>\n\t\t\t\t\t<td style=\"width:280px;\">Search by Category:</td>\n\t\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('cid', 'Don\'t Search', 'stream_categories', $cid, 'id', 'category_name', 'where category_type=\'live\'', 'order by category_name ASC', 'chosen') . "</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>Search by Bouquets:</td>\n\t\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('bid', 'Don\'t Search', 'bouquets', $bid, 'id', 'bouquet_name', 'bouquet_status', 'where bouquet_status=1', 'order by bouquet_name asc', 'chosen') . "</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>Search by Servers:</td>\n\t\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('serv', 'Don\'t Search', 'streaming_servers', $serv, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc', 'chosen') . ("</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td><input class='btn btn-default' type=\"submit\" value=\" Search \">\t</td>\n\t\t\t\t</tr>\n\t\t\t</tbody>\n\t\t</table>\n\t\t</form>\n\t\t\n\t\t<form method=\"POST\" name=\"form_bulk_streams\" id=\"form_bulk_streams\" action=\"" . $this->base . "/SaveBulk\">\n\t\t\n\t\t<table class=\"table table-hover table-bordered\" id=\"table_codes\">\n\t\t\t<tbody>\n\t\t\t\t<tr>\n\t\t\t\t\t<td style=\"width:280px;\">Streams:</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t<input type=\"text\" placeholder=\"Search..\" id=\"strmSearch\" onkeyup=\"filterFunction()\" style=\"width: 400px;\">");
        echo "\n\t\t\t\t\t<div id=\"allStreams\" style=\"width: 400px; height: 300px; overflow-y: auto;border:1px solid #777777;padding:5px; \">";
        $this->dropdown();
        echo "\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class='btn-group-custom'>\n\t\t\t\t\t\t<button type=\"button\" class=\"btn-select\" id=\"strmCheckALL\"><i class=\"icon-ok\"></i> Select All</button>\n\t\t\t\t\t\t<button type=\"button\" class=\"btn-select\" id=\"strmUnCheckALL\"><i class=\"icon-cancel\"></i> Deselect All</button>\n\t\t\t\t\t\t<span class='total-selected' id='strmBulkTotSel'><i class=\"icon-ok-circled\"></i> Total: 0</span>\n\t\t\t\t\t</div>";
        echo "</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>Restart Streams After Editing:</td>\n\t\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('restart', 1, 1, 'Yes', 'No', $onStyle = '', $offStyle = '') . "</td>\n\t\t\t\t</tr>\n\t\t\t\t\n\t\t\t\t<tr id='TR_cat'>\n\t\t\t\t\t<td>Change Category  :</td>\n\t\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('category_id', 'Don\'t Change Category', 'stream_categories', 0, 'id', 'category_name', 'where category_type=\'live\'', 'order by category_name ASC') . "</td>\n\t\t\t\t</tr>\n\t\t\t\t\n\t\t\t\t<tr id='TR_ondem'>\n\t\t\t\t\t<td>OnDemand:</td>\n\t\t\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('on_demand', [
            'on' => 'Make streams OnDemand on selected servers',
            'live_ondemand' => 'Live mode with OnDemand (Auto-start + OnDemand)',
            'off' => 'Remove OnDemand (Live mode only)'
        ], '', 'Don\'t Change') . "</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr id='TR_lb'>\n\t\t\t\t\t<td colspan='2'>\n\t\t\t\t\t\t<div class='lb-server-section'>\n\t\t\t\t\t\t\t<div class='bulk-section-title'>\n\t\t\t\t\t\t\t\t<i class='icon-server'></i> LOAD BALANCE SERVER CONFIGURATION\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t<div class='lb-config-wrapper'>\n\t\t\t\t\t\t\t\t<div class='lb-type-selector'>\n\t\t\t\t\t\t\t\t\t<label class='control-label'><i class='icon-fork'></i> BALANCING TYPE:</label>\n\t\t\t\t\t\t\t\t\t" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('lb_tree_type', [
            'normal' => 'Normal Load Balancing',
            'tree' => 'Tree Mode'
        ], '', 'Choose Balancing Type') . "\n\t\t\t\t\t\t\t\t\t<div id='balanceTypeTXT' class='balance-info-box'></div>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t<div class='lb-servers-wrapper'>\n\t\t\t\t\t\t\t\t\t<label class='control-label'>\n\t\t\t\t\t\t\t\t\t\t<i class='icon-hdd'></i> SELECT SERVERS:\n\t\t\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t\t\t\t<div style='background: linear-gradient(135deg, #fff9c4 0%, #fff59d 100%); padding: 14px 20px; border-radius: 10px; border: 3px solid #fbc02d; margin-bottom: 18px; box-shadow: 0 2px 8px rgba(251, 192, 45, 0.3);'>\n\t\t\t\t\t\t\t\t\t\t<span style='color: #f57f17; font-weight: 700; font-size: 16px; display: block;'>\n\t\t\t\t\t\t\t\t\t\t\t<i class='icon-info-circled' style='font-size: 20px; margin-right: 10px; vertical-align: middle;'></i>\n\t\t\t\t\t\t\t\t\t\t\tChoose one or more servers for load balancing\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t\t<span style='color: #e65100; font-size: 14px; font-weight: 600; display: block; margin-top: 6px; margin-left: 30px;'>\n\t\t\t\t\t\t\t\t\t\t\t📌 Leave empty to keep current servers unchanged\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<div id=\"sortable\" class=\"server-checkbox-group\">";
        echo $this->selServ();
        echo '				</div>
							</div>
						</div>
					</div>
				</td>
			</tr>
            <tr>
                <td colspan="2" style="text-align:center; padding: 25px;">
                    <button type="submit" class="save-btn-bulk" id="btn_save_strm">
                        <i class="icon-floppy"></i> SAVE CHANGES
                    </button>
                </td>
            </tr>
            </tbody>
        </table>
        </form>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        $max_input_vars = @ini_get('max_input_vars');
        $max_input_vars = intval($max_input_vars) - 100;
        $max = 0;
        if( $max_input_vars > 50 ) 
        {
            $max = $max_input_vars;
        }
        echo "\n\t\t<script>\n\t\t\$(document).ready(function() {\n\t\t\t\n\t\t\t \$(\"#sortable\").sortable({\n\t\t\t\t/*revert: true*/\n\t\t\t}); \n\t\t\t\n\t\t\t\$( \"#form_bulk_streams\" ).submit(function( event ) {\n\t\t\t\tvar restart = \$('#restart').prop('checked');\n\t\t\t\tif(restart == true){\n\t\t\t\tif(!confirm('This will restart all selected streams?'))\n\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t});\n\t\t\t\n\t\t\t\$('#delallStrm').on('click', function(){\n\t\t\t\tif (this.checked)\n\t\t\t\t{\t\n\t\t\t\t\talert('Danger! Danger! Daner! This will delete all selected streams!!!');\n\t\t\t\t\t\$('#delallStrmTxt').html('<span class=\"label label-danger\" style=\"font-size:16px\">Danger! You choose to delete selected streams. You should backup first.</span><br/><br/>');\n\t\t\t\t\t\$('#TR_ondem,#TR_lb').hide();\n\t\t\t\t\t\$('#btn_save_strm').val(' Delete All Selected Streams ').removeClass( \"label-success\" ).addClass( \"label-danger\" );\n\t\t\t\t}else{\n\t\t\t\t\t\$('#delallStrmTxt').html('');\n\t\t\t\t\t\$('#TR_ondem,#TR_lb').show();\n\t\t\t\t\t\$('#btn_save_strm').val(' Save ').removeClass( \"label-danger\" ).addClass( \"label-success\" );\n\t\t\t\t}\n\t\t\t});\n\t\t\t\n\t\t\t\$('#strmCheckALL').on('click', function(){\n\t\t\t\t\t\n\t\t\t\t\$(\"#allStreams input:checkbox\").each(function() {\n\t\t\t\t\tif (\$(this).parent(\"li:visible\").length == 1) {\n \n\t\t\t\t\t\tthis.checked=true;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\tupdateChecked();\n\t\t\t});\n\t\t\t\n\t\t\t\$('select[name=\"lb_tree_type\"]').on('change', function(){\n\t\t\t\tvar type = \$(this).val();\n\t\t\t\t\n\t\t\t\tif(type == 'tree'){\n\t\t\t\t\t \$(\"#sortable label\").css(\"display\", \"block\");\n\t\t\t\t\t \$(\"#balanceTypeTXT\").html(\"<span style='color:#238c00'>First server on the list will host stream source and below LBs will use it.<br/>Drag by mouse servers to sort them.</span>\");\n\t\t\t\t\t \n\t\t\t\t}else{\n\t\t\t\t\t\$(\"#sortable label\").css(\"display\", \"inline\");\n\t\t\t\t\t\$(\"#balanceTypeTXT\").html(\"<span style='color:#d93600;font-size:12px;'>This will create as many connections to source as the number of LB you select.\"\n\t\t\t\t\t\t+\"<br/>If you choose 1 LB, it will use 1 conection on source. If you add more LB it will create more connections to source.\");\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t\n\t\t\t});\n\t\t\t\$('select[name=\"category_id\"]').on('change', function(){\n\t\t\t\tvar catid = \$(this).val();\n\t\t\t\t\n\t\t\t\tif(catid > 0){\n\t\t\t\t\t \$(\"#restart\").prop('checked', false).change();\n\t\t\t\t\t /*.bootstrapToggle('on')*/\n\t\t\t\t}else{\n\t\t\t\t\t\$(\"#restart\").prop('checked', true).change();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t});\n\n\t\t\t\n\t\t\t\$('#strmUnCheckALL').on('click', function(){\n\t\t\t\t\t\n\t\t\t\t\$(\"#allStreams input:checkbox\").each(function() {\n\t\t\t\t\tthis.checked=false;\n\t\t\t\t});\n\t\t\t\tupdateChecked();\n\t\t\t});\n\t\t\t\n\t\t\t\$('.allStreams').on('click', function(){\n\t\t\t\t\t\n\t\t\t\tupdateChecked();\n\t\t\t});\n\t\t\t\n\t\t\tfunction updateChecked(){\n\t\t\t\tvar total = \$('input[name=\"allStreams[]\"]:checked').length;\n\t\t\t\tvar max = " . $max . ";\n\t\t\t\t\n\t\t\t\tif(total > max && max != 0){\n\t\t\t\t\talert(\"Error: you can only select (" . $max . ") Streams.\");\n\t\t\t\t}\n\t\t\t\t\$('#strmBulkTotSel').html( \"<b>Total: \" + total +'</b>');\n\t\t\t}\n\n\t\t\t\n\t\t});\n\t\t</script>";
        echo "\n\t\t<script>\n\n\t\t\tfunction filterFunction() {\n\t\t\t\t\n\t\t\t  var input, filter, ul, li, a, i;\n\t\t\t  input = document.getElementById(\"strmSearch\");\n\t\t\t  filter = input.value.toUpperCase();\n\t\t\t  div = document.getElementById(\"allStreams\");\n\t\t\t  a = div.getElementsByTagName(\"li\");\n\t\t\t  for (i = 0; i < a.length; i++) {\n\t\t\t\t  \n\t\t\t\ttxtValue = a[i].textContent || a[i].innerText;\n\t\t\t\tif (txtValue.toUpperCase().indexOf(filter) > -1) {\n\t\t\t\t  a[i].style.display = \"\";\n\t\t\t\t} else {\n\t\t\t\t  a[i].style.display = \"none\";\n\t\t\t\t}\n\t\t\t  }\n\t\t\t} \n\n\t\t</script>";
    }
    public function dropdown()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streams` WHERE type=1 ' . $this->qry . ' order by `order` ASC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<li> <input type="checkbox" class="allStreams" name="allStreams[]" value="' . $id . '"> ' . $stream_display_name . ' </li>';
        }
    }
    public function selServ()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streaming_servers` ORDER BY id ASC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo "<label class=\"checkbox-inline\" class=\"ui-state-default\">\n\t\t\t\t<span class='btn btn-success'><input class='bigCheck' type=\"checkbox\" name=\"allServers[]\" value=\"" . $id . '"> ' . $server_name . ' </label> </span> ';
        }
    }
    public function SaveBulk()
    {
        global $intro;
        global $array;
        $allStreams = (isset($_POST['allStreams']) ? $_POST['allStreams'] : []);
        $allServers = (isset($_POST['allServers']) ? $_POST['allServers'] : []);
        $on_demand = trim($intro->input->post('on_demand'));
        $lb_tree_type = trim($intro->input->post('lb_tree_type'));
        $delete = intval($intro->input->post('delete'));
        $restart = intval($intro->input->post('restart'));
        $category_id = intval($intro->input->post('category_id'));
        $probesize_ondemand = intval($intro->input->post('probesize_ondemand'));
        if( $probesize_ondemand < 400000 )
        {
            $probesize_ondemand = 512000;
        }
        if( !is_array($allStreams) )
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(_obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please select streams.', 'danger'));
            $this->index();
            exit();
        }
        if( is_array($allStreams) && count($allStreams) <= 0 )
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(_obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please select streams.', 'danger'));
            $this->index();
            exit();
        }

        // Load AdminStreams for remote sync methods
        require_once(dirname(__FILE__) . '/../includes/AdminStreams.php');
        $adminStreams = new AdminStreams();

        // Debug logging
        error_log("=== SaveBulk START ===");
        error_log("SaveBulk - on_demand: " . var_export($on_demand, true));
        error_log("SaveBulk - allServers: " . var_export($allServers, true));
        error_log("SaveBulk - allStreams: " . var_export($allStreams, true));
        error_log("SaveBulk - probesize_ondemand: " . $probesize_ondemand);
        error_log("SaveBulk - restart: " . $restart);

        if( $delete == 1 )
        {
            // Stop streams via API before deleting
            foreach($allStreams as $stream_id) {
                $adminStreams->stopStreamViaApi($stream_id);
            }
            $aff = 0;
            foreach( $allStreams as $id ) 
            {
                $intro->db->query_fast('DELETE FROM streams WHERE id=\'' . $id . '\';');
                $aff += $intro->db->affected_rows;
                $intro->db->query_fast('DELETE FROM streams_sys WHERE stream_id=\'' . $id . '\';');
            }
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(' All selected streams <stron>(' . $aff . ')</strong> deleted Successfully!', 'success');
            $intro->redirect($this->appname);
            exit();
        }
        $ids = implode(',', $allStreams);
        $aff = 0;
        $servers_flag = 0;
        if( isset($allServers[0]) && intval($allServers[0]) > 0 )
        {
            // Stop streams via API before changing servers
            foreach($allStreams as $stream_id) {
                $adminStreams->stopStreamViaApi($stream_id);
            }
            $sql = $intro->db->query('DELETE FROM streams_sys WHERE stream_id IN (' . $ids . ');');
            $servers_flag = 1;
            $parent_id = 0;
            $i = 0;
            foreach( $allServers as $server_id ) 
            {
                $i++;
                if( $i == 1 && $lb_tree_type == 'tree' ) 
                {
                    $parent_id = $server_id;
                }
                foreach( $allStreams as $stream_id )
                {
                    $j++;
                    $data2 = [];
                    $data2['server_id'] = $server_id;
                    $data2['stream_id'] = $stream_id;
                    if( $on_demand == 'on' )
                    {
                        $data2['on_demand'] = 1;
                    }
                    if( $on_demand == 'live_ondemand' )
                    {
                        $data2['on_demand'] = 1;
                    }
                    if( $on_demand == 'off' )
                    {
                        $data2['on_demand'] = 0;
                    }
                    if( $restart == 1 )
                    {
                        $data2['pid'] = -1;
                        $data2['monitor_pid'] = -1;
                    }
                    if( $parent_id > 0 && $i >= 2 )
                    {
                        $data2['parent_id'] = $parent_id;
                    }
                    $intro->db->insert('streams_sys', $data2);
                }
            }

            // Sync with remote server
            error_log("SaveBulk - Checking sync condition: on_demand='$on_demand'");
            if($on_demand == 'on' || $on_demand == 'live_ondemand' || $on_demand == 'off') {
                error_log("SaveBulk - Entering sync block for " . count($allStreams) . " streams");
                foreach( $allStreams as $stream_id ) {
                    $stream_sql = $intro->db->query("SELECT stream_display_name FROM streams WHERE id = $stream_id");
                    $stream_row = $intro->db->fetch_assoc($stream_sql);
                    if($stream_row) {
                        $stream_name = $stream_row['stream_display_name'];
                        $remote_on_demand = ($on_demand == 'on' || $on_demand == 'live_ondemand') ? 1 : 0;

                        error_log("Bulk: Syncing stream '$stream_name' (ID: $stream_id) - mode: $on_demand, remote_on_demand: $remote_on_demand, servers: " . json_encode($allServers) . ", probesize: $probesize_ondemand");

                        // Sync mode to remote with selected servers and probesize
                        $result = $adminStreams->setStreamModeOnRemote($stream_name, $remote_on_demand, $allServers, $probesize_ondemand);
                        error_log("Bulk: Remote sync result for '$stream_name': $result");

                        // Update direct_source based on mode
                        if($on_demand == 'live_ondemand') {
                            // Live + OnDemand: direct_source=1 (auto-start enabled)
                            $intro->db->query_fast("UPDATE streams SET direct_source=1 WHERE id=$stream_id");
                        } else if($on_demand == 'on') {
                            // OnDemand only: direct_source=0 (manual start)
                            $intro->db->query_fast("UPDATE streams SET direct_source=0 WHERE id=$stream_id");
                        } else if($on_demand == 'off') {
                            // Live only: direct_source=1, on_demand=0
                            $intro->db->query_fast("UPDATE streams SET direct_source=1 WHERE id=$stream_id");
                        }
                    }
                }
            }

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(' All completed Successfully!', 'success');
        }
        else if( $on_demand == 'on' || $on_demand == 'live_ondemand' || $on_demand == 'off' )
        {
            error_log("SaveBulk - ELSE block: Changing OnDemand without server changes");
            error_log("SaveBulk - ELSE block: on_demand='$on_demand'");
            if( $on_demand == 'on' || $on_demand == 'live_ondemand' )
            {
                $demand = 1;
            }
            if( $on_demand == 'off' )
            {
                $demand = 0;
            }
            foreach( $allStreams as $stream_id )
            {
                $intro->db->query_fast('UPDATE `streams_sys` SET `on_demand`=' . $demand . ' WHERE `stream_id`=' . $stream_id . ';');

                // Sync with remote server
                error_log("SaveBulk - ELSE block: Syncing stream ID $stream_id");
                $stream_sql = $intro->db->query("SELECT stream_display_name FROM streams WHERE id = $stream_id");
                $stream_row = $intro->db->fetch_assoc($stream_sql);
                if($stream_row) {
                    $stream_name = $stream_row['stream_display_name'];
                    $remote_on_demand = ($on_demand == 'on' || $on_demand == 'live_ondemand') ? 1 : 0;

                    // Get current servers for this stream
                    $servers_sql = $intro->db->query("SELECT server_id FROM streams_sys WHERE stream_id = $stream_id");
                    $current_servers = [];
                    while($srv = $intro->db->fetch_assoc($servers_sql)) {
                        $current_servers[] = $srv['server_id'];
                    }

                    error_log("SaveBulk - ELSE: Stream '$stream_name' (ID: $stream_id) - remote_on_demand: $remote_on_demand, servers: " . json_encode($current_servers) . ", probesize: $probesize_ondemand");

                    // Sync mode to remote
                    $result = $adminStreams->setStreamModeOnRemote($stream_name, $remote_on_demand, $current_servers, $probesize_ondemand);
                    error_log("SaveBulk - ELSE: Remote sync result for '$stream_name': $result");

                    // Update direct_source based on mode
                    if($on_demand == 'live_ondemand') {
                        // Live + OnDemand: direct_source=1 (auto-start enabled)
                        $intro->db->query_fast("UPDATE streams SET direct_source=1 WHERE id=$stream_id");
                    } else if($on_demand == 'on') {
                        // OnDemand only: direct_source=0 (manual start)
                        $intro->db->query_fast("UPDATE streams SET direct_source=0 WHERE id=$stream_id");
                    } else if($on_demand == 'off') {
                        // Live only: direct_source=1, on_demand=0
                        $intro->db->query_fast("UPDATE streams SET direct_source=1 WHERE id=$stream_id");
                    }
                }
            }
        }
        if( $category_id > 0 )
        {
            $intro->db->query_fast('UPDATE streams SET category_id=' . $category_id . ' WHERE id IN (' . $ids . ');');
            $aff = $intro->db->affected_rows;

            // Sync category to remote panel for all selected streams
            foreach( $allStreams as $stream_id ) {
                $adminStreams->syncCategoryToRemote($stream_id, $category_id);
            }

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(' Change Category Success! Affected rows (<stron>' . $aff . '</strong>)', 'success');
        }
        if( $probesize_ondemand > 100000 ) 
        {
            $intro->db->query_fast('UPDATE `streams` SET `probesize_ondemand`=' . $probesize_ondemand . ' WHERE `id` IN (' . $ids . ');');
            $aff = $intro->db->affected_rows;
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011(' Change Probesize On-Demand Success! Affected rows (<stron>' . $aff . '</strong>)', 'success');
        }
        foreach( $allStreams as $stream_id ) 
        {
            if( isset($_POST['is_user_agent']) && strlen($_POST['user_agent']) > 0 ) 
            {
                $intro->db->query_fast('DELETE FROM `streams_options` WHERE `stream_id` = ' . $stream_id . ' AND `argument_id` = 1;');
                $intro->db->query_fast('INSERT INTO `streams_options` (`stream_id`, `argument_id`, `value`) ' . (' VALUES(' . $stream_id . ', 1, \'') . $intro->db->escape($_POST['user_agent']) . '\');');
                $aff += $intro->db->affected_rows;
            }
            if( isset($_POST['is_icon']) && strlen($_POST['icon']) > 0 ) 
            {
                $intro->db->query_fast('UPDATE `streams` SET `stream_icon`=\'' . $intro->db->escape($_POST['icon']) . ('\' WHERE `id` = ' . $stream_id . ';'));
                $aff += $intro->db->affected_rows;
            }
            if( isset($_POST['is_dns']) && strlen($_POST['is_dns']) > 0 ) 
            {
                $old_host = trim($_POST['old_host']);
                $new_host = trim($_POST['new_host']);
                $sql = $intro->db->query('select id,stream_source from `streams` where id= ' . $stream_id . ';');
                if( $intro->db->returned_rows > 0 ) 
                {
                    $row = $intro->db->fetch_assoc($sql);
                    $id = intval($row['id']);
                    $stream_source = $row['stream_source'];
                    $new = [];
                    $src = json_decode($stream_source, true);
                    foreach( $src as $url ) 
                    {
                        $new[] = str_replace($old_host, $new_host, $url);
                    }
                    if( count($new) >= 1 ) 
                    {
                        $new_source = json_encode($new);
                        $intro->db->query('UPDATE `streams` SET stream_source=\'' . $new_source . '\' WHERE id = ' . $id . ';');
                        $aff += $intro->db->affected_rows;
                    }
                }
            }
        }
        if( isset($_POST['is_user_agent']) || isset($_POST['is_icon']) || isset($_POST['is_dns']) ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Success! Affected rows (<stron>' . $aff . '</strong>)', 'success');
        }
        if( $restart == 1 )
        {
            $success_count = 0;
            $fail_count = 0;

            foreach($allStreams as $stream_id) {
                // Stop then start each stream via API
                $stop_result = $adminStreams->stopStreamViaApi($stream_id);
                sleep(2);
                $start_result = $adminStreams->startStreamViaApi($stream_id);

                $start_data = json_decode($start_result, true);
                if(isset($start_data['result']) && $start_data['result'] === true) {
                    $success_count++;
                } else {
                    $fail_count++;
                }
            }

            $msg = '<h3>';
            if($servers_flag == 1) {
                $msg .= 'All completed Successfully! ';
            }
            $msg .= 'Restart Results: <span class="text-success">' . $success_count . ' succeeded</span>';
            if($fail_count > 0) {
                $msg .= ', <span class="text-danger">' . $fail_count . ' failed</span>';
            }
            $msg .= '</h3>';

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'success');
        }
        $intro->redirect($this->appname);
    }
    public function InsertUpdateArguments($stream_id, $arguments, $type = 'insert')
    {
        global $intro;
        global $error;
        $stream_id = intval($stream_id);
        if( is_array($arguments) && count($arguments) > 0 ) 
        {
            foreach( $arguments as $argument_id => $value ) 
            {
                if( $value != '' ) 
                {
                    $arg = [];
                    $arg['stream_id'] = $stream_id;
                    $arg['argument_id'] = $argument_id;
                    $arg['value'] = $value;
                    if( $type == 'insert' ) 
                    {
                        $intro->db->insert('streams_options', $arg);
                    }
                    if( $type == 'update' ) 
                    {
                        $sql7 = $intro->db->query_fast('select id,value from `streams_options` ' . (' WHERE argument_id=' . $argument_id . ' AND stream_id=' . $stream_id));
                        if( $intro->db->returned_rows == 0 ) 
                        {
                            $intro->db->insert('streams_options', $arg);
                        }
                        else
                        {
                            $intro->db->update('streams_options', $arg, 'argument_id=' . $argument_id . ' AND stream_id=' . $stream_id);
                        }
                    }
                }
                else
                {
                    $intro->db->delete('streams_options', 'argument_id=' . $argument_id . ' AND stream_id=' . $stream_id);
                }
            }
        }
    }
}
