<?php
class Sync_remote_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $admin = [];

    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->admin = $intro->auth->sess_admin();

        if($this->admin['level'] != 1) {
            exit('Error: Admin access required');
        }
    }

    public function nav()
    {
        echo "<div class=\"app_nav\">
                <a class=\"btn btn-info\" href=\"" . $this->base . "/index\">
                    <i class=\"icon-refresh\"></i> Sync Streams from Remote
                </a>
              </div>";
    }

    public function index()
    {
        global $intro;

        $this->nav();

        echo "<div class=\"panel panel-default\">
                <div class=\"panel-heading\">
                    <h3><i class=\"icon-refresh\"></i> Auto-Sync Configuration</h3>
                </div>
                <div class=\"panel-body\">";

        // Check if sync should run
        $run_sync = isset($_GET['run']) && $_GET['run'] == '1';

        if($run_sync) {
            echo "<h4>Running sync...</h4>";
            $this->doSync();
        } else {
            echo "<p>This page allows you to sync streams from the remote panel (204.188.233.170) to this local panel.</p>";

            echo "<div class=\"alert alert-info\">
                    <strong>Note:</strong> The remote MySQL server must allow external connections for auto-sync to work.
                    If you see connection errors, you need to configure the remote MySQL server to allow connections from this IP.
                  </div>";

            // Test connection
            echo "<h4>Testing Remote Connection</h4>";

            $remote_host = "204.188.233.170";
            $remote_user = "root";
            $remote_pass = "R7nMi4KCzZv920pG";
            $remote_db = "midnight_iptv";

            $remote_conn = @new mysqli($remote_host, $remote_user, $remote_pass, $remote_db);

            if($remote_conn->connect_error) {
                echo "<div class=\"alert alert-danger\">
                        <strong>Connection Failed:</strong> " . $remote_conn->connect_error . "
                        <br><br>
                        <strong>Solution:</strong> On the remote server (204.188.233.170), run these commands:
                        <pre style=\"background:#000;color:#0f0;padding:10px;margin-top:10px;\">
# Edit MySQL config to allow external connections
sudo nano /etc/mysql/mysql.conf.d/mysqld.cnf

# Change bind-address from 127.0.0.1 to 0.0.0.0
# Then restart MySQL
sudo systemctl restart mysql

# Grant access to this server
mysql -u root -p
GRANT ALL ON midnight_iptv.* TO 'root'@'" . $_SERVER['SERVER_ADDR'] . "' IDENTIFIED BY 'R7nMi4KCzZv920pG';
FLUSH PRIVILEGES;
                        </pre>
                      </div>";
            } else {
                echo "<div class=\"alert alert-success\">
                        <strong>Connection Successful!</strong> Remote database is accessible.
                      </div>";

                // Get remote streams count
                $result = $remote_conn->query("SELECT COUNT(*) as total FROM streams WHERE type=0");
                $row = $result->fetch_assoc();
                $remote_count = $row['total'];

                $remote_conn->close();

                // Get local streams count
                $local_count = $intro->db->dcount('id', 'streams', 'type=1');

                echo "<table class=\"table table-bordered\">
                        <tr>
                            <th>Remote Streams (type=0)</th>
                            <td><strong>" . $remote_count . "</strong></td>
                        </tr>
                        <tr>
                            <th>Local Streams (type=1)</th>
                            <td><strong>" . $local_count . "</strong></td>
                        </tr>
                      </table>";

                echo "<a href=\"" . $this->base . "/index?run=1\" class=\"btn btn-success btn-lg\">
                        <i class=\"icon-refresh\"></i> Run Sync Now
                      </a>";
            }
        }

        echo "</div></div>";
    }

    public function doSync()
    {
        global $intro;

        $remote_host = "204.188.233.170";
        $remote_user = "root";
        $remote_pass = "R7nMi4KCzZv920pG";
        $remote_db = "midnight_iptv";

        $remote_conn = @new mysqli($remote_host, $remote_user, $remote_pass, $remote_db);

        if($remote_conn->connect_error) {
            echo "<div class=\"alert alert-danger\">Failed to connect to remote: " . $remote_conn->connect_error . "</div>";
            return;
        }

        // Fetch all streams from remote
        $query = "SELECT id, name, logo_image, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id";
        $result = $remote_conn->query($query);

        if(!$result) {
            echo "<div class=\"alert alert-danger\">Query failed: " . $remote_conn->error . "</div>";
            return;
        }

        $updated = 0;
        $inserted = 0;
        $errors = 0;

        echo "<div style=\"max-height:400px;overflow-y:auto;border:1px solid #ccc;padding:10px;background:#f9f9f9;\">";

        while($stream = $result->fetch_assoc()) {
            $id = intval($stream['id']);
            $name = $intro->db->escape($stream['name']);
            $logo_image = $stream['logo_image'];
            $disabled = intval($stream['disabled']);
            $on_demand = intval($stream['direct_streaming_on_demand']);

            // Check if exists locally
            $check = $intro->db->query("SELECT id, name, logo_image FROM streams WHERE id = $id");

            if($intro->db->returned_rows > 0) {
                // Update
                $local_row = $intro->db->fetch_assoc($check);
                $update_fields = [];

                if($local_row['name'] != $stream['name']) {
                    $update_fields[] = "name = '$name'";
                }

                if(!empty($logo_image) && $logo_image != 'NULL' && $local_row['logo_image'] != $logo_image) {
                    $logo_escaped = $intro->db->escape($logo_image);
                    $update_fields[] = "logo_image = '$logo_escaped'";
                }

                if(count($update_fields) > 0) {
                    $intro->db->query("UPDATE streams SET " . implode(', ', $update_fields) . " WHERE id = $id");
                    $updated++;
                    echo "<span style='color:blue'>Updated: $name</span><br>";
                }
            } else {
                // Insert
                $logo_val = empty($logo_image) || $logo_image == 'NULL' ? 'NULL' : "'" . $intro->db->escape($logo_image) . "'";

                $intro->db->query("INSERT INTO streams (id, type, name, logo_image, disabled, direct_streaming_on_demand, added_time)
                                   VALUES ($id, 1, '$name', $logo_val, $disabled, $on_demand, " . time() . ")");

                if($intro->db->affected_rows > 0) {
                    $inserted++;
                    echo "<span style='color:green'>Inserted: $name</span><br>";
                } else {
                    $errors++;
                    echo "<span style='color:red'>Error inserting: $name</span><br>";
                }
            }

            // Update streams_sys
            $check_sys = $intro->db->query("SELECT stream_id FROM streams_sys WHERE stream_id = $id AND server_id = 1");
            if($intro->db->returned_rows > 0) {
                $intro->db->query("UPDATE streams_sys SET on_demand = $on_demand WHERE stream_id = $id AND server_id = 1");
            } else {
                $intro->db->query("INSERT INTO streams_sys (stream_id, server_id, on_demand) VALUES ($id, 1, $on_demand)");
            }
        }

        echo "</div>";

        echo "<div class=\"alert alert-success\" style=\"margin-top:20px;\">
                <h4>Sync Complete!</h4>
                <p>Updated: <strong>$updated</strong> streams</p>
                <p>Inserted: <strong>$inserted</strong> new streams</p>
                <p>Errors: <strong>$errors</strong></p>
              </div>";

        echo "<a href=\"" . admin_path . "index.php/streams/index\" class=\"btn btn-primary\">View Streams</a> ";
        echo "<a href=\"" . $this->base . "/index\" class=\"btn btn-default\">Back</a>";

        $remote_conn->close();
    }
}
?>
