<?php
/**
 * Build EPG Mapping from Database via SSH
 * Maps stream_id to epg_channel_id (tvg-id)
 */

echo "Fetching streams with EPG mapping via SSH...\n";

// Get data via SSH
$command = "sshpass -p 'R7nMi4KCzZv920pG' ssh -o StrictHostKeyChecking=no root@204.188.233.170 " .
           "'mysql midnight_iptv -N -e \"SELECT id, epg_channel_id FROM streams WHERE epg_channel_id IS NOT NULL AND epg_channel_id != \\\"\\\";\"'";

$output = shell_exec($command);

if (empty($output)) {
    die("Failed to fetch data from database\n");
}

// Parse output
$mapping = [];
$lines = explode("\n", trim($output));
foreach ($lines as $line) {
    $parts = explode("\t", $line);
    if (count($parts) == 2) {
        $mapping[$parts[0]] = $parts[1];
    }
}

// Save mapping
$cache_dir = __DIR__ . '/cache';
if (!is_dir($cache_dir)) {
    mkdir($cache_dir, 0755, true);
}

$mapping_file = $cache_dir . '/epg_mapping.json';
file_put_contents($mapping_file, json_encode($mapping, JSON_UNESCAPED_UNICODE));

echo "\n✓ EPG mapping built successfully!\n";
echo "Total streams with EPG: " . count($mapping) . "\n";
echo "Mapping saved to: $mapping_file\n";

// Show sample
echo "\nSample mappings:\n";
$sample = array_slice($mapping, 0, 10, true);
foreach ($sample as $stream_id => $tvg_id) {
    echo "  Stream $stream_id => $tvg_id\n";
}
?>
