<?php
require_once('/var/www/html/iptv/includes/Config.php');

$db = new mysqli(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

$sql = "SELECT s.id, s.stream_display_name, s.status, s.direct_source, sys.on_demand
        FROM streams s
        LEFT JOIN streams_sys sys ON s.id=sys.stream_id
        WHERE s.id IN (3,4,5,6,7,8,9,18)
        ORDER BY s.id";

$result = $db->query($sql);

echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr style='background: #4CAF50; color: white;'>";
echo "<th>ID</th><th>Name</th><th>status (local)</th><th>direct_source</th><th>on_demand (sys)</th><th>Display Text</th><th>Expected</th><th>Match?</th>";
echo "</tr>";

while($row = $result->fetch_assoc()) {
    $id = $row['id'];
    $name = $row['stream_display_name'];
    $status = $row['status'];
    $direct_source = $row['direct_source'];
    $on_demand = $row['on_demand'];

    // This is the logic from StreamsEdit.php line 199
    $display_text = ($on_demand == 1 ? 'OnDemand' : 'Live');

    // Expected based on remote panel
    $expected = '';
    if($id == 3) $expected = 'Live'; // AlKuwait News is Live
    else $expected = 'OnDemand'; // Others are OnDemand

    $match = ($display_text == $expected) ? '✓ OK' : '✗ ERROR';
    $color = ($display_text == $expected) ? 'green' : 'red';

    echo "<tr>";
    echo "<td>$id</td>";
    echo "<td>$name</td>";
    echo "<td>$status</td>";
    echo "<td>$direct_source</td>";
    echo "<td>$on_demand</td>";
    echo "<td style='font-weight: bold; color: $color;'>$display_text</td>";
    echo "<td>$expected</td>";
    echo "<td style='color: $color;'>$match</td>";
    echo "</tr>";
}

echo "</table>";

echo "<br><br><strong>Conclusion:</strong><br>";
echo "If all rows show '✓ OK', then the display logic is correct and the problem is just a browser cache issue.<br>";
echo "If any row shows '✗ ERROR', then there is a real logic problem.";
?>
