<!DOCTYPE html>
<html>
<head>
    <title>Bulk Actions Debugger</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body { font-family: Arial; padding: 20px; }
        .success { color: green; padding: 10px; background: #e8f5e9; margin: 10px 0; }
        .error { color: red; padding: 10px; background: #ffebee; margin: 10px 0; }
        .info { color: blue; padding: 10px; background: #e3f2fd; margin: 10px 0; }
        button { padding: 10px 20px; margin: 5px; cursor: pointer; }
        #console { background: #000; color: #0f0; padding: 10px; font-family: monospace; height: 300px; overflow-y: auto; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>🔧 Bulk Actions Debugger</h1>

    <div class="info">
        <strong>Instructions:</strong><br>
        1. Click each test button below<br>
        2. Watch the console output<br>
        3. Check for errors
    </div>

    <h2>Test Buttons:</h2>
    <button id="testDelete">Test Delete (IDs: 999998, 999999)</button>
    <button id="testRestart">Test Restart (ID: 999999)</button>
    <button id="testStop">Test Stop (ID: 999999)</button>
    <button id="testDisable">Test Disable (ID: 999999)</button>
    <button id="clearConsole">Clear Console</button>

    <h2>Console Output:</h2>
    <div id="console"></div>

    <h2>Result:</h2>
    <div id="result"></div>

    <script>
        function log(msg) {
            var time = new Date().toLocaleTimeString();
            $('#console').append('[' + time + '] ' + msg + '\n');
            $('#console').scrollTop($('#console')[0].scrollHeight);
            console.log(msg);
        }

        $('#clearConsole').click(function() {
            $('#console').html('');
            $('#result').html('');
        });

        $('#testDelete').click(function() {
            log('=== Testing DELETE ===');
            log('URL: /iptv/apps/streams_bulk_actions.php?action=BulkDelete');
            log('Data: {ids: [999998, 999999]}');

            $.ajax({
                url: '/iptv/apps/streams_bulk_actions.php?action=BulkDelete',
                type: 'POST',
                data: {ids: [999998, 999999]},
                success: function(data) {
                    log('✓ SUCCESS: ' + data);
                    $('#result').html('<div class="success">Delete Response: ' + data + '</div>');
                },
                error: function(xhr, status, error) {
                    log('✗ ERROR: ' + status + ' - ' + error);
                    log('Response: ' + xhr.responseText);
                    $('#result').html('<div class="error">Error: ' + status + '<br>Message: ' + error + '<br>Response: ' + xhr.responseText + '</div>');
                }
            });
        });

        $('#testRestart').click(function() {
            log('=== Testing RESTART ===');
            log('URL: /iptv/apps/streams_bulk_actions.php?action=BulkRestart');
            log('Data: {ids: [999999]}');

            $.ajax({
                url: '/iptv/apps/streams_bulk_actions.php?action=BulkRestart',
                type: 'POST',
                data: {ids: [999999]},
                success: function(data) {
                    log('✓ SUCCESS: ' + data);
                    $('#result').html('<div class="success">Restart Response: ' + data + '</div>');
                },
                error: function(xhr, status, error) {
                    log('✗ ERROR: ' + status + ' - ' + error);
                    log('Response: ' + xhr.responseText);
                    $('#result').html('<div class="error">Error: ' + status + '<br>Message: ' + error + '<br>Response: ' + xhr.responseText + '</div>');
                }
            });
        });

        $('#testStop').click(function() {
            log('=== Testing STOP ===');
            log('URL: /iptv/apps/streams_bulk_actions.php?action=BulkStop');
            log('Data: {ids: [999999]}');

            $.ajax({
                url: '/iptv/apps/streams_bulk_actions.php?action=BulkStop',
                type: 'POST',
                data: {ids: [999999]},
                success: function(data) {
                    log('✓ SUCCESS: ' + data);
                    $('#result').html('<div class="success">Stop Response: ' + data + '</div>');
                },
                error: function(xhr, status, error) {
                    log('✗ ERROR: ' + status + ' - ' + error);
                    log('Response: ' + xhr.responseText);
                    $('#result').html('<div class="error">Error: ' + status + '<br>Message: ' + error + '<br>Response: ' + xhr.responseText + '</div>');
                }
            });
        });

        $('#testDisable').click(function() {
            log('=== Testing DISABLE ===');
            log('URL: /iptv/apps/streams_bulk_actions.php?action=BulkDisable');
            log('Data: {ids: [999999]}');

            $.ajax({
                url: '/iptv/apps/streams_bulk_actions.php?action=BulkDisable',
                type: 'POST',
                data: {ids: [999999]},
                success: function(data) {
                    log('✓ SUCCESS: ' + data);
                    $('#result').html('<div class="success">Disable Response: ' + data + '</div>');
                },
                error: function(xhr, status, error) {
                    log('✗ ERROR: ' + status + ' - ' + error);
                    log('Response: ' + xhr.responseText);
                    $('#result').html('<div class="error">Error: ' + status + '<br>Message: ' + error + '<br>Response: ' + xhr.responseText + '</div>');
                }
            });
        });

        log('Debugger ready. Click test buttons above.');
    </script>
</body>
</html>
