<?php
/**
 * EPG JSON Endpoint for V6 APK
 * Returns EPG data for a specific stream by parsing XMLTV
 *
 * Usage: /epg/STREAM_ID.json?user=USER&pass=PASS
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

// Get stream_id from URL
$request_uri = $_SERVER['REQUEST_URI'];
preg_match('/\/epg\/(\d+)\.json/', $request_uri, $matches);
$stream_id = isset($matches[1]) ? $matches[1] : null;

if (!$stream_id) {
    echo json_encode(['epg_listings' => []]);
    exit;
}

// Load config
require_once dirname(__DIR__) . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Use external panel directly
    $host = 'flix-panel.xyz';
    $port = '2087';
    $source_user = '1231231';
    $source_pass = '1231231';

    // Cache directory
    $cache_dir = dirname(__DIR__) . '/cache';
    @mkdir($cache_dir, 0755, true);

    // Step 1: Get epg_channel_id from remote database
    require_once dirname(__DIR__) . '/V6APK/api_cfg_v6.php';

    $ssh_cmd = "sshpass -p '{$_CFG['remote_ssh_pass']}' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 {$_CFG['remote_ssh_user']}@{$_CFG['remote_host']} 'mysql {$_CFG['remote_db_name']} -N -e \"SELECT epg_channel_id FROM streams WHERE id = {$stream_id};\"'";
    $tvg_id = trim(shell_exec($ssh_cmd));

    if (empty($tvg_id)) {
        echo json_encode(['epg_listings' => []]);
        exit;
    }

    // Step 2: Get EPG from XMLTV (cached)
    $epg_file = $cache_dir . '/epg.xml';

    if (!file_exists($epg_file) || (time() - filemtime($epg_file)) > 3600) {
        $xmltv_url = 'https://' . $host . ':' . $port . '/xmltv.php?username=' . urlencode($source_user)
                   . '&password=' . urlencode($source_pass);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $xmltv_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 120,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $xml = curl_exec($ch);
        curl_close($ch);

        if ($xml) {
            file_put_contents($epg_file, $xml);
        }
    }

    $xml_content = file_exists($epg_file) ? file_get_contents($epg_file) : '';

    if (empty($xml_content)) {
        echo json_encode(['epg_listings' => []]);
        exit;
    }

    // Step 3: Parse EPG for this channel
    $epg_listings = [];
    $now = time();

    // Find programmes for this tvg-id
    preg_match_all('/<programme[^>]*channel="' . preg_quote($tvg_id, '/') . '"[^>]*>.*?<\/programme>/s', $xml_content, $programmes);

    foreach ($programmes[0] as $prog) {
        // Extract start/stop times
        preg_match('/start="(\d{14})/', $prog, $start_match);
        preg_match('/stop="(\d{14})/', $prog, $stop_match);

        if (!$start_match || !$stop_match) continue;

        $start_str = $start_match[1];
        $stop_str = $stop_match[1];

        $start_time = mktime(
            (int)substr($start_str, 8, 2),
            (int)substr($start_str, 10, 2),
            (int)substr($start_str, 12, 2),
            (int)substr($start_str, 4, 2),
            (int)substr($start_str, 6, 2),
            (int)substr($start_str, 0, 4)
        );

        $stop_time = mktime(
            (int)substr($stop_str, 8, 2),
            (int)substr($stop_str, 10, 2),
            (int)substr($stop_str, 12, 2),
            (int)substr($stop_str, 4, 2),
            (int)substr($stop_str, 6, 2),
            (int)substr($stop_str, 0, 4)
        );

        // Only current and next 24h
        if ($stop_time < $now || $start_time > ($now + 86400)) continue;

        // Extract title and description
        preg_match('/<title[^>]*>([^<]*)<\/title>/', $prog, $title_match);
        preg_match('/<desc[^>]*>([^<]*)<\/desc>/', $prog, $desc_match);

        $title = $title_match[1] ?? '';
        $desc = $desc_match[1] ?? '';

        $epg_listings[] = [
            'id' => md5($tvg_id . $start_time),
            'epg_id' => $tvg_id,
            'title' => base64_encode($title),
            'lang' => 'en',
            'start' => date('Y-m-d H:i:s', $start_time),
            'end' => date('Y-m-d H:i:s', $stop_time),
            'description' => base64_encode($desc),
            'channel_id' => $tvg_id,
            'start_timestamp' => $start_time,
            'stop_timestamp' => $stop_time,
            'now_playing' => ($now >= $start_time && $now < $stop_time) ? 1 : 0,
            'has_archive' => 0
        ];

        if (count($epg_listings) >= 10) break;
    }

    echo json_encode(['epg_listings' => $epg_listings]);

} catch (Exception $e) {
    echo json_encode(['epg_listings' => [], 'error' => $e->getMessage()]);
}
?>
