<?php
header('Content-Type: application/json');

$status = [
    'epg_xml' => [
        'file' => '/var/www/html/iptv/cache/epg.xml',
        'exists' => file_exists('/var/www/html/iptv/cache/epg.xml'),
        'size' => file_exists('/var/www/html/iptv/cache/epg.xml') ? filesize('/var/www/html/iptv/cache/epg.xml') : 0,
        'modified' => file_exists('/var/www/html/iptv/cache/epg.xml') ? date('Y-m-d H:i:s', filemtime('/var/www/html/iptv/cache/epg.xml')) : 'N/A',
        'age_minutes' => file_exists('/var/www/html/iptv/cache/epg.xml') ? round((time() - filemtime('/var/www/html/iptv/cache/epg.xml')) / 60) : 0
    ],
    'epg_mapping' => [
        'file' => '/var/www/html/iptv/cache/epg_mapping.json',
        'exists' => file_exists('/var/www/html/iptv/cache/epg_mapping.json'),
        'streams_count' => 0
    ],
    'current_time' => date('Y-m-d H:i:s'),
    'server_timezone' => date_default_timezone_get()
];

if (file_exists('/var/www/html/iptv/cache/epg_mapping.json')) {
    $mapping = json_decode(file_get_contents('/var/www/html/iptv/cache/epg_mapping.json'), true);
    $status['epg_mapping']['streams_count'] = is_array($mapping) ? count($mapping) : 0;
}

// Test ESPN EPG
$test_url = 'http://localhost/iptv/api/player/epg.php?stream_id=1085&limit=1';
$test_result = @file_get_contents($test_url);
$test_data = json_decode($test_result, true);

$status['test_espn'] = [
    'url' => $test_url,
    'working' => !empty($test_data) && count($test_data) > 0,
    'programs_found' => is_array($test_data) ? count($test_data) : 0
];

echo json_encode($status, JSON_PRETTY_PRINT);
?>
