<?php
/**
 * Custom M3U Generator for Remote Bouquets - Auto Mode
 * Automatically queries remote database via SSH and includes ALL bouquet streams
 *
 * Usage: get_bouquet.php?username=USER&password=PASS&type=m3u_plus&output=ts
 */

// Get request parameters
$username = isset($_GET['username']) ? trim($_GET['username']) : '';
$password = isset($_GET['password']) ? trim($_GET['password']) : '';
$type = isset($_GET['type']) ? $_GET['type'] : 'm3u_plus';
$output = isset($_GET['output']) ? $_GET['output'] : 'ts';

// Remote server credentials
$remote_host = '204.188.233.170';
$remote_pass = 'R7nMi4KCzZv920pG';
$remote_db = 'midnight_iptv';

// Log the request
error_log("get_bouquet.php: AUTO MODE - Request from username=$username");

// Helper function to execute remote MySQL query via SSH
function remoteQuery($sql) {
    global $remote_host, $remote_pass, $remote_db;
    $cmd = "sshpass -p '$remote_pass' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 root@$remote_host " .
           "\"mysql $remote_db -N -e \\\"$sql\\\"\" 2>&1";
    $result = shell_exec($cmd);
    return trim($result);
}

try {
    if (empty($username) || empty($password)) {
        header('HTTP/1.1 400 Bad Request');
        echo "Missing username or password";
        exit;
    }

    // Verify user credentials in remote database
    $sql = "SELECT id, username, expire_date, bouquets FROM \\\\\\`lines\\\\\\` " .
           "WHERE username='" . addslashes($username) . "' AND password='" . addslashes($password) . "' LIMIT 1";
    $user_data = remoteQuery($sql);

    if (empty($user_data)) {
        error_log("get_bouquet.php: Invalid credentials for username=$username");
        header('HTTP/1.1 403 Forbidden');
        echo "Invalid credentials";
        exit;
    }

    // Parse user data (id, username, expire_date, bouquets)
    $user_fields = explode("\t", $user_data);
    error_log("get_bouquet.php: User data fields count=" . count($user_fields) . ", data='$user_data'");

    if (count($user_fields) < 3) {
        error_log("get_bouquet.php: Invalid user data format - expected at least 3 fields");
        header('HTTP/1.1 500 Internal Server Error');
        echo "Invalid user data";
        exit;
    }

    $user_id = $user_fields[0];
    $expire_date = isset($user_fields[2]) ? $user_fields[2] : null;
    $bouquet_id = isset($user_fields[3]) ? $user_fields[3] : null;

    // Check if expired
    if (!empty($expire_date) && is_numeric($expire_date) && $expire_date < time()) {
        error_log("get_bouquet.php: Expired account for username=$username (expires: $expire_date)");
        header('HTTP/1.1 403 Forbidden');
        echo "Account expired";
        exit;
    }

    // Handle NULL or empty bouquet_id
    if (empty($bouquet_id) || $bouquet_id == 'NULL' || !is_numeric($bouquet_id)) {
        error_log("get_bouquet.php: No bouquet assigned for username=$username (bouquet_id='$bouquet_id')");
        header('HTTP/1.1 404 Not Found');
        echo "No bouquet assigned to user";
        exit;
    }

    $bouquet_id = intval($bouquet_id);

    error_log("get_bouquet.php: User authenticated - ID=$user_id, Bouquet=$bouquet_id");

    // Get bouquet name
    $sql = "SELECT name FROM bouquets WHERE id=$bouquet_id LIMIT 1";
    $bouquet_name = remoteQuery($sql);

    if (empty($bouquet_name)) {
        error_log("get_bouquet.php: Bouquet not found: id=$bouquet_id");
        header('HTTP/1.1 404 Not Found');
        echo "Bouquet not found";
        exit;
    }

    error_log("get_bouquet.php: Bouquet='$bouquet_name' (ID=$bouquet_id)");

    // Get ALL stream IDs in this bouquet from bouquets_sids
    $sql = "SELECT sid FROM bouquets_sids WHERE bid=$bouquet_id ORDER BY ordering";
    $sids_result = remoteQuery($sql);

    if (empty($sids_result)) {
        error_log("get_bouquet.php: No streams in bouquet $bouquet_id");
        header('HTTP/1.1 404 Not Found');
        echo "No streams in bouquet";
        exit;
    }

    $stream_ids = array_filter(explode("\n", $sids_result));
    error_log("get_bouquet.php: Found " . count($stream_ids) . " streams in bouquet $bouquet_id");

    // Get details for ALL streams
    $ids_list = implode(',', $stream_ids);
    $sql = "SELECT id, name, type, logo_image, container_format FROM streams " .
           "WHERE id IN ($ids_list) ORDER BY FIELD(id, $ids_list)";
    $streams_result = remoteQuery($sql);

    if (empty($streams_result)) {
        error_log("get_bouquet.php: Failed to get stream details");
        header('HTTP/1.1 500 Internal Server Error');
        echo "Failed to get stream details";
        exit;
    }

    $streams_lines = array_filter(explode("\n", $streams_result));

    // Server URL
    $server_url = 'http://flix-panel.xyz:2087';

    // Generate M3U content
    $m3u_content = "#EXTM3U\n";
    $stream_count = 0;

    foreach ($streams_lines as $stream_line) {
        $fields = explode("\t", $stream_line);
        if (count($fields) < 5) continue;

        $stream_id = $fields[0];
        $stream_name = $fields[1];
        $stream_type = $fields[2];
        $logo = $fields[3];
        $container = $fields[4];

        // Determine logo URL
        $logo_url = '';
        if (!empty($logo) && $logo != 'photo' && $logo != 'NULL') {
            if (strpos($logo, 'http') === 0) {
                $logo_url = $logo;
            } else {
                $logo_url = "$server_url/download/logo/$username/$password/$stream_id";
            }
        }

        // Determine stream URL based on type
        $stream_url = '';
        $extension = $output; // ts, m3u8, etc.

        if ($stream_type == '0') {
            // Live TV
            $stream_url = "$server_url/live/$username/$password/$stream_id.$extension";
        } elseif ($stream_type == '1') {
            // Movie/OnDemand
            if (empty($container) || $container == 'NULL') {
                $container = 'mp4';
            }
            $stream_url = "$server_url/live/$username/$password/$stream_id.$container";
        } elseif ($stream_type == '2') {
            // Radio
            $stream_url = "$server_url/live/$username/$password/$stream_id.$extension";
        } else {
            // Default
            $stream_url = "$server_url/live/$username/$password/$stream_id.$extension";
        }

        // Build EXTINF line
        $tvg_id = $stream_id . '.msx';
        $group_title = $bouquet_name;

        $m3u_content .= "#EXTINF:-1 tvg-id=\"$tvg_id\" tvg-name=\"$stream_name\" tvg-logo=\"$logo_url\" group-title=\"$group_title\",$stream_name\n";
        $m3u_content .= "$stream_url\n";
        $stream_count++;
    }

    // Set headers
    header('Content-Type: audio/mpegurl');
    header('Content-Disposition: attachment; filename="' . $username . '_bouquet.m3u"');
    header('Access-Control-Allow-Origin: *');

    error_log("get_bouquet.php: SUCCESS - Generated M3U with $stream_count streams for bouquet '$bouquet_name'");

    echo $m3u_content;

} catch (Exception $e) {
    error_log("get_bouquet.php: Error - " . $e->getMessage());
    header('HTTP/1.1 500 Internal Server Error');
    echo "Error: " . $e->getMessage();
}
?>
