<?php
/**
 * Script to activate a code and get a valid token
 * Usage: php get_valid_token.php <code>
 */

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Get code from command line or use default
$code = $argv[1] ?? '426687097695';
$mac = $argv[2] ?? '8c:fd:f0:00:7f:13';

echo "Activating code: $code\n";
echo str_repeat("=", 50) . "\n\n";

// Activate code
$activation_request = [
    'code' => $code,
    'mac' => $mac,
    'sn' => $mac,
    'model' => 'SM-N975F',
    'group' => 1,
    'mode' => 'active'
];

$encrypted = xor_encrypt($activation_request, $XOR_KEY);
$response = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted),
        'ignore_errors' => true
    ]
]));

if (!$response) {
    die("Error: No response from server\n");
}

$activation_data = json_decode(xor_decrypt($response, $XOR_KEY), true);

if (!$activation_data || !isset($activation_data['status'])) {
    die("Error: Invalid response\n");
}

if ($activation_data['status'] != 100) {
    echo "Status: " . $activation_data['status'] . "\n";
    echo "Message: " . ($activation_data['message'] ?? 'Unknown error') . "\n";
    exit(1);
}

echo "✅ Activation Successful!\n\n";
echo "Account Details:\n";
echo "  Username: " . $activation_data['username'] . "\n";
echo "  Password: " . $activation_data['password'] . "\n";
echo "  Expires: " . $activation_data['expire'] . "\n";
echo "  Max Connections: " . $activation_data['max_connections'] . "\n\n";

echo "Server Info:\n";
echo "  Host: " . $activation_data['host'] . "\n";
echo "  Player API: " . $activation_data['player_api'] . "\n\n";

echo "✅ Valid Token:\n";
echo str_repeat("-", 50) . "\n";
echo $activation_data['token'] . "\n";
echo str_repeat("-", 50) . "\n\n";

// Test the token
echo "Testing token...\n";
$test_request = [
    'mode' => 'packages',
    'token' => $activation_data['token']
];

$encrypted2 = xor_encrypt($test_request, $XOR_KEY);
$response2 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted2)
    ]
]));

if ($response2) {
    $test_data = xor_decrypt($response2, $XOR_KEY);
    if (strpos($test_data, 'error') === false) {
        echo "✅ Token is working correctly!\n";
    } else {
        echo "⚠️  Token test failed: $test_data\n";
    }
} else {
    echo "⚠️  Could not test token\n";
}

// Save to database
@require_once('/var/www/html/iptv/includes/Config.php');
$link = mysqli_connect(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if ($link) {
    $token = mysqli_real_escape_string($link, $activation_data['token']);
    $check = mysqli_query($link, "SELECT id FROM user_tokens WHERE token = '$token'");

    if ($check && mysqli_num_rows($check) > 0) {
        echo "\n📝 Token already exists in database\n";
    } else {
        echo "\n✅ Token saved to local database\n";
    }

    mysqli_close($link);
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "✅ Done! Use this token in your app.\n";
