<?php 
// set_include_path("includes/tmdb/");
include("includes/tmdb/tmdb-api.php");
class IntroTmdb
{
    public $json = [];
    public function __construct($tmdb_id, $tmdb_lang = '', $_SER = 0)
    {
        $_SET = _obf_0D16342C3B25040E30351911133C313C1B1D23050B1B11();
        $cnf = [];
        $cnf['apikey'] = $_SET['tmdb_api_key'];
        $cnf['lang'] = $_SET['tmdb_default'];
        $cnf['timezone'] = $_SET['default_timezone'];
        if( strlen($cnf['apikey']) <= 10 ) 
        {
            $json['error'] = 'Please set TMDB API Key in Tools-> General Settings.';
            exit( json_encode($json) );
        }
        if( $tmdb_lang != '' ) 
        {
            $cnf['lang'] = $tmdb_lang;
        }
        if( $cnf['lang'] == '' ) 
        {
            $cnf['lang'] = 'en';
        }
        $MatchID = 0;
        $TMDB = new TMDB($cnf);
        if( is_numeric($tmdb_id) ) 
        {
            $MatchID = $tmdb_id;
        }
        else
        {
            $_Title = urldecode($tmdb_id);
            if( $_SER == 1 ) 
            {
                $_RESULTS = $TMDB->searchTVShow($_Title);
            }
            else
            {
                $_RESULTS = $TMDB->searchMovie($_Title);
            }
            foreach( $_RESULTS as $arResult ) 
            {
                similar_text(strtoupper($_Title), strtoupper((($arResult->get('title') ?: $arResult->get('name')) ?: $arResult->get('name'))), $MatchPercentage);
                if( $MatchPercentage >= 90 ) 
                {
                    $MatchID = $arResult->get('id');
                    break;
                }
                similar_text(strtoupper($_Title), strtoupper($arResult->get('original_name')), $MatchPercentage);
                if( $MatchPercentage >= 90 ) 
                {
                    $MatchID = $arResult->get('id');
                    break;
                }
            }
            if( $MatchID == 0 ) 
            {
                $json['error'] = 'Movie not found, or unable to fetch from TMDB.';
                exit( json_encode($json) );
            }
        }
        if( $_SER == 1 ) 
        {
            $MovieInfo = $TMDB->getTVShow($MatchID);
        }
        else
        {
            $MovieInfo = $TMDB->getMovie($MatchID);
        }
        $MovieData = json_decode($MovieInfo->getJSON(), true);
        if( count($MovieData) < 10 ) 
        {
            $json['error'] = 'No movie data from TMDB.';
            exit( json_encode($json) );
        }
        $mpaa = '';
        if( isset($MovieData['release_dates']['results']) ) 
        {
            foreach( $MovieData['release_dates']['results'] as $k => $v ) 
            {
                if( isset($v['iso_3166_1']) && $v['iso_3166_1'] == 'US' ) 
                {
                    if( isset($v['release_dates'][0]['certification']) ) 
                    {
                        $mpaa = $v['release_dates'][0]['certification'];
                    }
                    break;
                }
            }
        }
        $rCast = [];
        foreach( $MovieData['credits']['cast'] as $rMember ) 
        {
            if( count($rCast) < 5 ) 
            {
                $rCast[] = $rMember['name'];
            }
        }
        $rDirectors = [];
        foreach( $MovieData['credits']['crew'] as $rMember ) 
        {
            if( count($rDirectors) < 2 && $rMember['department'] == 'Directing' ) 
            {
                $rDirectors[] = $rMember['name'];
            }
        }
        $rCountry = '';
        if( isset($MovieData['production_countries'][0]['name']) ) 
        {
            $rCountry = $MovieData['production_countries'][0]['name'];
        }
        $rGenres = [];
        foreach( $MovieData['genres'] as $rGenre ) 
        {
            if( count($rGenres) < 3 ) 
            {
                $rGenres[] = $rGenre['name'];
            }
        }
        if( $_SER == 1 ) 
        {
            $rSeconds = 0;
            $MovieData['release_date'] = $MovieData['first_air_date'];
        }
        else
        {
            $rSeconds = intval($MovieData['runtime']) * 60;
        }
        if( $MovieData['backdrop_path'] == '' ) 
        {
            $MovieData['backdrop_path'] = $MovieData['poster_path'];
        }
        $json['tmdb_id'] = $MovieData['id'];
        $json['stream_display_name'] = ($_SER == 1 ? $MovieData['name'] : $MovieData['title']);
        $json['o_name'] = ($_SER == 1 ? '' : $MovieData['original_title']);
        $json['actors'] = join(', ', $rCast);
        $json['cast'] = $json['actors'];
        $json['cover_big'] = 'https://image.tmdb.org/t/p/w600_and_h900_bestv2' . $MovieData['poster_path'];
        $json['cover'] = $json['cover_big'];
        $json['movie_image'] = $json['cover'];
        $json['backdrop_path'] = ['https://image.tmdb.org/t/p/w1280' . $MovieData['backdrop_path']];
        $json['rating'] = $MovieData['vote_average'];
        $json['plot'] = $MovieData['overview'];
        $json['genre'] = join(', ', $rGenres);
        $json['mpaa'] = $mpaa;
        $json['year'] = ($MovieData['release_date'] != '' ? date('Y', strtotime($MovieData['release_date'])) : '');
        $json['country'] = $rCountry;
        $json['director'] = join(', ', $rDirectors);
        $json['duration'] = sprintf('%02d:%02d:%02d', $rSeconds / 3600, ($rSeconds / 60) % 60, $rSeconds % 60);
        $json['duration_secs'] = $rSeconds;
        $json['episode_run_time'] = ($_SER == 1 ? intval($MovieData['episode_run_time'][0]) : 0);
        $json['releasedate'] = $MovieData['release_date'];
        if( $_SER == 1 ) 
        {
            $json['youtube_trailer'] = $TMDB->getSeriesTrailer($MatchID);
        }
        else
        {
            $json['youtube_trailer'] = $MovieInfo->getTrailer();
        }
        if( $json['youtube_trailer'] == '' ) 
        {
            $json['youtube_trailer'] = $this->youtube($json['stream_display_name'], $json['year'], 'return');
        }
        $this->json = $json;
    }
    public function youtube($movie = '', $year = '', $return = 'echo')
    {
        global $intro;
        if( $movie == '' ) 
        {
            $movie = trim(urldecode($intro->input->get_post('movie')));
        }
        if( $year == '' ) 
        {
            $year = trim($intro->input->get_post('year'));
        }
        $movieName = str_replace(' ', '+', $movie);
        $movieName = str_replace('.', '+', $movieName);
        $movieYear = $year;
        $url = 'http://www.youtube.com/results?search_query=' . $movieName . '+' . $movieYear . '+trailer&aq=1&hl=en';
        $page = file_get_contents($url);
        if( $page != '' && preg_match('~"url":"/watch\?v=(.*?)","webPageType"~s', $page, $matches) ) 
        {
            if( $return == 'echo' ) 
            {
                echo $matches[1];
            }
            else
            {
                return $matches[1];
            }
        }
    }
}
