<?php 
class StreamsEdit
{
    public $base = '';
    public $servers = [];
    public $seen_id = 0;
    public $type = 0;
    public function __construct($base, $type = 0)
    {
        $this->base = $base;
        $this->type = $type;
    }

    // Update stream name on remote server
    protected function updateStreamNameOnRemote($old_name, $new_name)
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        $old_name_esc = addslashes($old_name);
        $new_name_esc = addslashes($new_name);

        $sql = "UPDATE streams SET name='$new_name_esc' WHERE name='$old_name_esc';";

        $tmp_file = '/tmp/remote_rename_' . uniqid() . '.sql';
        file_put_contents($tmp_file, $sql);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N\" < " . escapeshellarg($tmp_file) . " 2>&1";

        $result = shell_exec($cmd);
        @unlink($tmp_file);

        error_log("Remote Stream Rename: $old_name -> $new_name - Result: $result");
        return $result;
    }

    public function Restart()
    {
        global $intro;
        global $sess_admin;
        $streams = $streams = intval($intro->input->get_post('id'));
        $mode = trim($intro->input->get_post('mode'));
        $x = new XtreamApi('EmptyFunc');
        if( $mode == '' ) 
        {
            $x->Restart($streams);
        }
        else
        {
            $x->StopOrStart($streams, $mode);
        }
    }
    public function getStreamStatus()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $cur_host = [];
        $cur_host['host'] = '-';
        $elapsed_time = $cur_host['host'];
        $result = $intro->db->query('SELECT * from streams s  LEFT OUTER JOIN `streams_sys` sys ON s.id=sys.stream_id ' . ('  WHERE s.type IN (1,3) AND s.id=' . $id));
        $row = $intro->db->fetch_assoc($result);
        @extract($row);
        if( $current_source !== '' && $current_source !== null )
        {
            // Check if current_source is numeric (index) or a URL string
            if( is_numeric($current_source) )
            {
                // current_source is an index, get URL from stream_source array
                $sources = json_decode($stream_source, true);
                if( is_array($sources) && isset($sources[intval($current_source)]) )
                {
                    $cur_host = parse_url($sources[intval($current_source)]);
                }
            }
            else
            {
                // current_source is a URL string (old format)
                $cur_host = parse_url($current_source);
            }
        }
        if( $stream_info != '' ) 
        {
            $stream_info = json_decode($stream_info);
            $start_time = round($stream_info->codecs->video->start_time, 2);
            if( $stream_status == 0 ) 
            {
                $txt_status = '<icon class=icon-globe style=color:green></icon>';
                $elapsed_time = _obf_0D10361F073B102D294032060E21400727331210083132($stream_started);
            }
            else if( $stream_status == 1 ) 
            {
                $txt_status = '<icon class=icon-globe style=color:#a8a8b7></icon>';
            }
            else
            {
                $txt_status = 'ERROR';
            }
        }
        $ar = [];
        $ar['cur_host_' . $id] = $cur_host['host'];

        // Determine mode display with status
        $mode_text = '';
        if($on_demand == 1) {
            $mode_text = 'OnDemand';
        } else {
            if($stream_status == 0) {
                $mode_text = 'Live';
            } else {
                $mode_text = 'Live'; // Keep as Live but icon will show stopped
            }
        }

        $ar['live_' . $id] = $mode_text . (' ' . $txt_status);
        $ar['elapsed_time_' . $id] = $elapsed_time;
        header('Content-Type: application/json');
        echo json_encode($ar);
    }
    public function TableStart($params = '')
    {
        global $intro;
        global $array;
        echo "\n\t\t<table class=\"DataTables table table-bordered table-hover table-striped table-condensed\" id='table-1'>\n        <thead>\n\t    <tr>\n\t\t\t<th style=\"text-align:center;\"><input type=\"checkbox\" id=\"select_all_streams\" title=\"Select All\"><br><small>Select</small></th>\n\t\t\t<th>#</th>\n\t\t\t<th>Status</th>\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index', $params) . "</th>\n\t\t\t<th>Channel Name</th>\n\t\t\t<th>Logo</th>\n\t\t\t<th>Uptime</th>\n\t\t\t<th>Server</th>\n\t\t\t<th>Current Source</th>\n\t\t\t<th>Users</th>\n\t\t\t<th>Mode</th>\n\t\t\t<th>Codec</th>\n\t\t\t<th>Actions</th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
    }
    public function getCurSourceNum($stream_source, $cur)
    {
        $stream_source = json_decode($stream_source, true);

        // If $cur is numeric, it's an index - just return it
        if( is_numeric($cur) )
        {
            return '[' . (intval($cur) + 1) . ']';
        }

        // Otherwise, $cur is a URL - find its position in the array
        $i = 0;
        foreach( $stream_source as $src )
        {
            $i++;
            if( $cur == $src )
            {
                return '[' . $i . ']';
            }
        }
    }
    public function Row($row, $i)
    {
        global $intro;
        global $array;
        global $sess_admin;
        global $options;
        $cur_host = [];
        $cur_host['host'] = '-';
        $elapsed_time = $cur_host['host'];
        $txt_status = '<icon class="icon-cancel-circled" style=\'color:red;\'></icon>';
        if( !is_array($row) ) 
        {
            return 'error stream not found!';
        }
        extract($row);
        $id = intval($row['id']);
        $tot = (isset($row['tot']) ? $row['tot'] : '');
        $stream_display_name = trim($row['stream_display_name']);

        // Debug: Log values for mode display logic
        error_log("StreamsEdit Row() - Stream ID=$id: status=" . (isset($status) ? $status : 'NOT SET') . ", redirect_stream=" . (isset($redirect_stream) ? $redirect_stream : 'NOT SET') . ", on_demand=" . (isset($on_demand) ? $on_demand : 'NOT SET') . ", stream_status=" . (isset($stream_status) ? $stream_status : 'NOT SET'));
        if( $current_source !== '' && $current_source !== null )
        {
            // Check if current_source is numeric (index) or a URL string
            if( is_numeric($current_source) )
            {
                // current_source is an index, get URL from stream_source array
                $sources = json_decode($stream_source, true);
                if( is_array($sources) && isset($sources[intval($current_source)]) )
                {
                    $cur_host = parse_url($sources[intval($current_source)]);
                }
            }
            else
            {
                // current_source is a URL string (old format)
                $cur_host = parse_url($current_source);
            }
        }
        $stream_info = json_decode($stream_info, true);
        if( isset($stream_info['codecs']['video']['start_time']) ) 
        {
            $start_time = round($stream_info['codecs']['video']['start_time'], 2);
        }
        if( !isset($stream_info['codecs']['video']['codec_name']) ) 
        {
            $stream_info['codecs']['video']['codec_name'] = '-';
        }
        if( !isset($stream_info['codecs']['audio']['codec_name']) ) 
        {
            $stream_info['codecs']['audio']['codec_name'] = '-';
        }
        if( !isset($stream_info['codecs']['video']['width']) ) 
        {
            $stream_info['codecs']['video']['width'] = '-';
        }
        if( !isset($stream_info['codecs']['video']['height']) ) 
        {
            $stream_info['codecs']['video']['height'] = '-';
        }
        $wh = $stream_info['codecs']['video']['width'] . ' X ' . $stream_info['codecs']['video']['height'];
        $codec = ($bitrate != '' ? '<div>' . $bitrate . ' K</div>' : '');
        $codec .= ('<div style=\'color:#888;\' title="' . $wh . '">' . $stream_info['codecs']['video']['codec_name'] . '/' . $stream_info['codecs']['audio']['codec_name'] . '</div>');

        if( $stream_status == 0 )
        {
            $txt_status = '<icon class="icon-globe" style=\'color:green;\'></icon>';
            $elapsed_time = ($stream_started != '' ? _obf_0D10361F073B102D294032060E21400727331210083132($stream_started) : '-');
        }
        else if( $stream_status == 1 && $on_demand == 0 )
        {
            $txt_status = '<icon class="icon-cancel-circled" style=\'color:#d90000;\'></icon>';
        }
        else
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#a8a8b7;\'></icon>';
        }
        if( $on_demand == 1 )
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#ff8000;\'></icon>';
        }
        if( $on_demand == 1 && $stream_status == 0 )
        {
            $txt_status = '<icon class="icon-globe" style=\'color:#86b300;\'></icon>';
        }
        $sql2 = $intro->db->query('SELECT id,value from streams_options where argument_id=1 AND stream_id=' . $id . ';');
        $row2 = $intro->db->fetch_assoc($sql2);
        $streams_options_value = trim($row2['value']);
        $streams_options_id = intval($row2['id']);
        $edit_page = 'streams';
        if( $this->type == 3 )
        {
            $edit_page = 'streams_created';
        }
        // Stream API Status Badge (First - at top)
        $api_status_badge = '';
        if($status == 1) {
            $api_status_badge = '<div><span class="label label-success" style="font-size:9px;padding:2px 5px;"><i class="icon-ok-circled"></i> API Active</span></div>';
        } else {
            $api_status_badge = '<div><span class="label label-danger" style="font-size:9px;padding:2px 5px;"><i class="icon-ban-circled"></i> API Disabled</span></div>';
        }

        // Append Token Badge (Second - below API Status)
        $append_token_badge = '';
        if(isset($redirect_stream) && $redirect_stream == 1 && isset($append_flussonic_token)) {
            if($append_flussonic_token == 1) {
                $append_token_badge = '<div style="margin-top:2px;"><span class="label label-info" style="font-size:8px;padding:2px 4px;background:#3498db;" title="Append Token to Redirected Response is Enabled"><i class="icon-key"></i> Token</span></div>';
            }
        }

        // Hide Uptime and Codec info if:
        // 1. Stream is disabled locally (status=0), OR
        // 2. Stream is in OnDemand mode (only shows info when user is watching)
        if((isset($status) && $status == 0) || (isset($on_demand) && $on_demand == 1)) {
            $elapsed_time = '-';
            $codec = '-';
        }

        echo "\n\t\t\t<tr id='ChannelDataRow" . $id . "'>\n\t\t\t\t<td class=\"center\"><input type=\"checkbox\" class=\"stream_checkbox\" data-id=\"" . $id . "\" value=\"" . $id . "\"></td>\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td class=\"center\">" . $api_status_badge . "\n\t\t\t\t\t" . $append_token_badge . "\n\t\t\t\t\t" . $txt_status . " \n\t\t\t\t\t" . (($enable_transcode == 1 && $type == 1 ? '<i class="icon-thermometer red" title="Transcode On"></i>' : '')) . "\n\t\t\t\t\t" . ((intval($tv_archive_duration) != 0 && $type == 1 ? '<i class="icon-hdd red" title="TV Archive for (' . $tv_archive_duration . ') Days(s) "></i>' : '')) . ("\n\t\t\t\t\t</td>\n\t\t\t\t<td class=\"center dragHandle\">" . $id . "</td>\n\t\t\t\t<td id='StrmName_" . $id . '\'>' . $stream_display_name . "\n\t\t\t\t<a href=\"") . $intro->app_url('streams', 'Play') . ('/?NH=1&id=' . $id . "\" target=\"_blank\" title=\"Play stream using user in Tools->Codes Options\" class=\"XAjaxModal btn btn-default btn-xs icon-play-circled\" style='float:right;'></a>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\"><img src=\"" . $stream_icon . "\" style=\"max-height:30px;\" alt=\"\" /></td>\n\t\t\t\t<td class=\"center\" id='elapsed_time_" . $id . '\'>' . $elapsed_time . "</td>\n\t\t\t\t<td class=\"center\">") . ((isset($array['servers'][$server_id]) ? $array['servers'][$server_id] : '-')) . ("\n\t\t\t\t<div style='font-size:8px;'>Pid:" . $pid . ' MPid:' . $monitor_pid . "</div>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\" id='cur_host_" . $id . "'>\n\t\t\t\t\t") . ((isset($cur_host['host']) ? $this->getCurSourceNum($stream_source, $current_source) . ' ' . $cur_host['host'] : '')) . ("\n\t\t\t\t\t<div style='font-size:8px;'>" . $streams_options_value . "</div>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">");
        if( $tot > 0 ) 
        {
            echo '<a title=\'total online users | Send message or Fingerprint\' class=\'AjaxModal icon-address-card-o\' href="' . $intro->app_url('streams', 'FingerPrint') . '?id=' . $id . '"> ' . $tot . '</a>';
        }
        else
        {
            echo '-';
        }
        // Determine display based on status (local API), on_demand, and stream_status
        $mode_display = '';

        // If stream is disabled locally (status=0), show Stopped regardless of other states
        if(isset($status) && $status == 0) {
            $mode_display = '<span class="btn btn-xs btn-danger" style="cursor:default;" title="Stream is stopped locally - Not available via API"><i class="icon-stop"></i> Stopped</span>';
            error_log("StreamsEdit Row() - Stream ID=$id: Mode set to STOPPED (status=0)");
        }
        // Check if redirect_stream mode
        else if($redirect_stream == 1) {
            // Redirect Stream mode - Brighter purple button with redirect icon
            $mode_display = '<span class="btn btn-xs btn-primary" style="background:#a569bd;border-color:#9b59b6;cursor:default;font-weight:bold;" title="Redirect Stream (Forwarding to another stream)"><i class="icon-forward"></i> Redirect</span>';
            error_log("StreamsEdit Row() - Stream ID=$id: Mode set to REDIRECT");
        }
        // OnDemand or Live mode (status is shown separately in Status column)
        else if($on_demand == 1) {
            // OnDemand mode - Brighter orange/yellow button with clock icon
            if($stream_status == 0) {
                // OnDemand and Running (user is watching) - Full opacity, brighter
                $mode_display = '<a href="' . $this->base . '/SetLive?NH=1&id=' . $id . '" title="OnDemand (Active) - Click to set Live" data-id="' . $id . '" class="btn btn-xs btn-warning SetStreamMode" style="opacity:1;background:#ff9800;border-color:#f57c00;font-weight:bold;"><i class="icon-clock"></i> OnDemand</a>';
                error_log("StreamsEdit Row() - Stream ID=$id: Mode set to ONDEMAND (Running)");
            } else {
                // OnDemand and Stopped - Higher opacity (0.85 instead of 0.6)
                $mode_display = '<a href="' . $this->base . '/SetLive?NH=1&id=' . $id . '" title="OnDemand (Inactive) - Click to set Live" data-id="' . $id . '" class="btn btn-xs btn-warning SetStreamMode" style="opacity:0.85;background:#ffb74d;border-color:#ffa726;font-weight:bold;"><i class="icon-clock"></i> OnDemand</a>';
                error_log("StreamsEdit Row() - Stream ID=$id: Mode set to ONDEMAND (Stopped)");
            }
        } else {
            // Live mode - Brighter green button with play icon
            if($stream_status == 0) {
                // Live and Running - Brighter green
                $mode_display = '<a href="' . $this->base . '/SetOnDemand?NH=1&id=' . $id . '" title="Live (Running) - Click to set OnDemand" data-id="' . $id . '" class="btn btn-xs btn-success SetStreamMode" style="background:#4caf50;border-color:#43a047;font-weight:bold;"><i class="icon-play"></i> Live</a>';
                error_log("StreamsEdit Row() - Stream ID=$id: Mode set to LIVE (Running)");
            } else {
                // Live but Stopped - Lighter grey with more visibility
                $mode_display = '<a href="' . $this->base . '/SetOnDemand?NH=1&id=' . $id . '" title="Live (Stopped) - Click to set OnDemand" data-id="' . $id . '" class="btn btn-xs btn-default SetStreamMode" style="border:2px solid #999;background:#e0e0e0;color:#555;font-weight:bold;"><i class="icon-play"></i> Live</a>';
                error_log("StreamsEdit Row() - Stream ID=$id: Mode set to LIVE (Stopped on external)");
            }
        }
        echo "</td>\n\t\t\t\t<td class=\"center\" id='live_" . $id . "'>" . $mode_display . ("</td>\n\t\t\t\t<td class=\"center\">" . $codec . "</td>\n\t\t\t\t<td class=\"actions-cell\">");
        if( $this->seen_id != $id )
        {
            echo '<div class="stream-actions">';

            // Edit button
            echo '<a href="' . $intro->app_url($edit_page, 'Form') . '?t=edit&id=' . $id . '" class="action-btn action-edit" title="Edit"><i class="icon-edit"></i></a>';

            // Quick Edit button
            echo '<a href="' . $this->base . '/EditChannel?NH=1&id=' . $id . '" data-id="' . $id . '" class="action-btn action-quick-edit EditStreamRow" title="Quick Edit"><i class="icon-code"></i></a>';

            // Start button
            echo '<a href="' . $this->base . '/Start?NH=1&id=' . $id . '" data-id="' . $id . '" class="action-btn action-start RestartStream" title="Start"><i class="icon-play"></i></a>';

            // Stop button
            echo '<a href="' . $this->base . '/Stop?NH=1&id=' . $id . '" data-id="' . $id . '" class="action-btn action-stop RestartStream" title="Stop"><i class="icon-stop"></i></a>';

            // Restart button
            echo '<a href="' . $this->base . '/Restart?NH=1&id=' . $id . '" data-id="' . $id . '" class="action-btn action-refresh RestartStream" title="Restart"><i class="icon-ccw"></i></a>';

            // Status Toggle - REMOVED: All streams must remain API enabled all the time
            // if( $status == 1 ) {
            //     echo '<a href="' . $this->base . '/ToggleStatus?NH=1&id=' . $id . '&status=0" data-id="' . $id . '" class="action-btn action-enabled ToggleStreamStatus" title="API Enabled"><i class="icon-ok-circled"></i></a>';
            // } else {
            //     echo '<a href="' . $this->base . '/ToggleStatus?NH=1&id=' . $id . '&status=1" data-id="' . $id . '" class="action-btn action-disabled ToggleStreamStatus" title="API Disabled"><i class="icon-ban-circled"></i></a>';
            // }

            // Delete button (Admin only)
            if( $sess_admin['level'] == 1 || $sess_admin['level'] == 8 )
            {
                echo '<a class="action-btn action-delete p_del intro_ui_del" href="' . $this->base . '/Del?id=' . $id . '" onclick="return false;" title="Delete"><i class="icon-trash"></i></a>';
            }

            echo '</div>';
        }
        echo "\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td colspan=\"10\" id='chRow" . $id . "'></td>\n\t\t\t</tr>";
        $this->seen_id = $id;
    }
    public function JavaScript()
    {
        global $intro;
        global $array;
        $add_type = intval($intro->input->get_post('add_type'));
        echo "\n\t\t<div class=\"alert alert-success\" style=\"display:none;\">\n                <span class=\"glyphicon glyphicon-ok\"></span> Drag row to change Order</div>\n\t\t<script>\n\t\t\n\t\tvar spin = \"<span class='icon-spin5 animate-spin'></span>\";\n\t\t\n\t\tfunction tblHTML(number){\n\n\t\t\treturn '<tr>'\n\t\t\t+'<td>'+number+'</td>'\n\t\t\t+'<td><input type=\"text\" name=\"stream_source[]\" value=\"\" class=\"form-control\"></td>'\n\t\t\t+'<td><button type=\"button\" class=\"btn btn-danger btnDelStreamRow\"><span class=\"icon-trash\"></span></button></td>'\n\t\t\t+'</tr>';\n\t\t}\n\t\t\$(document).on('click', '.RestartStreamSingle', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#span_single_status\");\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n        });\n\t\t\$(document).on('click', '.RestartStream', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#live_\" + id);\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n        });\n\t\t\$(document).on('click', '.GetStreamStatus', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar allDivZ = \$(\"#live_\" + id +\",#elapsed_time_\" + id+\",#cur_host_\" + id);\n\n\t\t\t\n\t\t\tallDivZ.html(spin);\n\t\t\n\t\t\t\$.get( url+ \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\t\n\t\t\t\t\$.each(data, function(key, value) {\n\t\t\t\t\t  \$(\"#\"+key).html(value);\n\t\t\t\t});\n\t\t\t});\n\n        });\n\t\t\n\t\t\$(document).on('click', '.EditStreamRow', function(e){\n            e.preventDefault();\n\t\t\t\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#chRow\" + id);\n\t\t\t\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\t\n\t\t\t\tresultDiv.html(data);\n\t\t\t});\n\t\n        });\n\t\t\n\t\t\$(document).on('click', '.btnAddNewStreamRowFirst', function(e){\n\t\t\t\n\t\t\tvar table = \$(\"#tblStream\"+\$(this).data('id'));\n\t\t\t\n\t\t\tvar rowCount = \$('#tblStream'+\$(this).data('id')+' >tbody >tr').length;\n\t\t\t\n\t\t\ttable.prepend(tblHTML(0));\n\t\t\t\n\t\t});\n\t\t\$(document).on('click', '.btnAddNewStreamRowLast', function(e){\n\t\t\t\n\t\t\tvar table = \$(\"#tblStream\"+\$(this).data('id'));\n\t\t\t\n\t\t\tvar rowCount = \$('#tblStream'+\$(this).data('id')+' >tbody >tr').length;\n\t\t\t\n\t\t\ttable.append(tblHTML(rowCount));\n\t\t\t\n\t\t});\n\t\t\n\t\t\$(document).on('click', '.btnCloseFrmChEdit', function(e){\n\t\t\t\$(\"#\"+\$(this).data('id')).html('');\n\t\t});\n\t\t\n\t\t\$(document).on('click', '.btnDelStreamRow', function(e){\n\t\t\t\n\t\t\tif( confirm(\"Delete this Stream Source?\") )\n\t\t\t{\n\t\t\t\t\$(this).closest(\"tr\").remove();\n\t\t\t}\n\t\t\t\n\t\t});\n\t\t\$(document).on('change', '#singleMulti', function(e){\n\t\t\t\n\t\t\tvar t = \$(this).val();\n\t\t\t\n\t\t\tshow_hide_add_stream(t);\n\t\t\t\n\t\t});\n\t\tfunction show_hide_add_stream(t){\n\t\t\tif(t == 1){\n\t\t\t\t\$('.singleTR').show();\n\t\t\t\t\$('#upload_m3u').hide();\n\t\t\t}else{\n\t\t\t\t\$('.singleTR').hide();\n\t\t\t\t\$('#upload_m3u').show();\n\t\t\t}\n\t\t}\n\t\t\$(document).on(\"submit\", \".frmSaveStream\", function (e) {\n\t\t\t/*\n\t\t\t\$(\".frmSaveStream :input\").each(function(){\n\t\t\t\tvar input = \$(this);\n\t\t\t\tvar str = input.val();\n\t\t\t\tinput.val(str.replace(/\\//g, '|'))\n\t\t\t});\n\t\t\t//str.replace(/\\//g, replacement);\n\t\t\t*/\n\t\t\t\n\t\t\t\n\t\t\tvar chID = \$(this).data('id');\n\t\n\t\t\tvar chName = \$(\"#stream_name_\" + chID).val();\n\t\t\tif(chName != \"\"){\n\t\t\t\t\$(\"#StrmName_\" + chID).html(chName);\n\t\t\t}\n\t\t\tvar spnResult = \$(\"#frmSpanResult\" + chID);\n\t\t\tspnResult.html(spin);\n\t\t\tvar jqxhr = \$.post( \$(this).attr('action') ,\$(this).serialize(),\n\t\t\t\tfunction(data){\n\t\t\t\t\tspnResult.html(data);\n\t\t\t\t\t/*\$(this).style(\"background-color: #5cb85c;border-color: #4cae4c;\");*/\n\t\t\t\t\t\$(\"#ChannelDataRow\" + chID).css(\"background-color\", \"#5cb85c\");\n\t\t\t\t}\n\t\t\t).fail(function() {\n\t\t\t\t\n\t\t\t\talert( \"error. faild to POST\" );\n\t\t\t\tspnResult.html('');\n\t\t\t});\n\t\t\treturn false;\n\t\t});\n\t\t\$(document).on('click', '.SetStreamMode', function(e){\n            e.preventDefault();\n\t\t\tvar id = \$(this).data('id');\n\t\t\tvar url = \$(this).attr('href');\n\t\t\tvar resultDiv = \$(\"#live_\" + id);\n\t\t\tresultDiv.html(spin);\n\t\t\t\$.get( url + \"&_dd=\" + \$.now(), function( data ) {\n\t\t\t\tlocation.reload();\n\t\t\t});\n        });\n\t\t
        // Select All functionality
        \$(document).on('click', '#select_all_streams', function(){
            \$('.stream_checkbox').prop('checked', this.checked);
        });

        \$(document).on('click', '.stream_checkbox', function(){
            if(\$('.stream_checkbox:checked').length == \$('.stream_checkbox').length){
                \$('#select_all_streams').prop('checked', true);
            } else {
                \$('#select_all_streams').prop('checked', false);
            }
        });

        // Bulk actions for selected streams
        function getSelectedStreamIds() {
            var ids = [];
            \$('.stream_checkbox:checked').each(function(){
                ids.push(\$(this).data('id'));
            });
            return ids;
        }

        function bulkStreamAction(action, ids) {
            if(ids.length === 0) {
                alert('Please select at least one stream');
                return;
            }

            console.log('bulkStreamAction called - action:', action, 'ids:', ids);

            var resultSpan = \$('#bulk_action_result');
            resultSpan.html(spin + ' Processing ' + ids.length + ' stream(s)...');

            var completed = 0;
            var failed = 0;
            var baseUrl = '" . $this->base . "';
            console.log('Base URL:', baseUrl);

            ids.forEach(function(id, index){
                var url = baseUrl + '/' + action + '?NH=1&id=' + id + '&_dd=' + \$.now();
                console.log('Calling URL:', url);

                \$.get(url, function(data){
                    completed++;
                    console.log('Success for ID', id, '- Response:', data);
                    if(completed + failed === ids.length) {
                        resultSpan.html('<span class=\"label label-success\">✓ Completed: ' + completed + ' | Failed: ' + failed + '</span>');
                        setTimeout(function(){ location.reload(); }, 2000);
                    }
                }).fail(function(xhr, status, error){
                    failed++;
                    console.error('Failed for ID', id, '- Status:', status, 'Error:', error);
                    if(completed + failed === ids.length) {
                        resultSpan.html('<span class=\"label label-warning\">✓ Completed: ' + completed + ' | Failed: ' + failed + '</span>');
                        setTimeout(function(){ location.reload(); }, 2000);
                    }
                });
            });
        }

        \$(document).on('click', '#start_selected_streams', function(){
            console.log('START SELECTED button clicked!');
            var ids = getSelectedStreamIds();
            console.log('Selected IDs for START:', ids);
            if(ids.length === 0) {
                alert('Please select at least one stream');
                return;
            }
            if(confirm('Start ' + ids.length + ' selected stream(s)?')) {
                bulkStreamAction('Start', ids);
            }
        });

        \$(document).on('click', '#stop_selected_streams', function(){
            console.log('STOP SELECTED button clicked!');
            var ids = getSelectedStreamIds();
            console.log('Selected IDs for STOP:', ids);
            if(ids.length === 0) {
                alert('Please select at least one stream');
                return;
            }
            if(confirm('Stop ' + ids.length + ' selected stream(s)?')) {
                bulkStreamAction('Stop', ids);
            }
        });

        \$(document).on('click', '#restart_selected_streams', function(){
            console.log('RESTART SELECTED button clicked!');
            var ids = getSelectedStreamIds();
            console.log('Selected IDs for RESTART:', ids);
            if(ids.length === 0) {
                alert('Please select at least one stream');
                return;
            }
            if(confirm('Restart ' + ids.length + ' selected stream(s)?')) {
                // First stop, then start
                bulkStreamAction('Stop', ids);
                setTimeout(function(){
                    bulkStreamAction('Start', ids);
                }, ids.length * 1000);
            }
        });

        $(document).on('click', '.ToggleStreamStatus', function(e){
            e.preventDefault();
            var id = $(this).data('id');
            var url = $(this).attr('href');
            var btn = $(this);
            btn.html('<i class=\"icon-spin5 animate-spin\"></i>');
            $.get( url + \"&_dd=\" + $.now(), function( data ) {
                location.reload();
            });
        });

        " . (($add_type > 0 ? 'show_hide_add_stream(' . $add_type . ')' : '')) . "\n\t\t</script>\n\t\t<style>\n\t\t/* Actions cell and container */\n\t\t.actions-cell {\n\t\t\tmin-width: 280px;\n\t\t\twhite-space: nowrap;\n\t\t}\n\t\t.stream-actions {\n\t\t\tdisplay: flex;\n\t\t\talign-items: center;\n\t\t\tgap: 3px;\n\t\t\tjustify-content: center;\n\t\t\tflex-wrap: wrap;\n\t\t}\n\t\t\n\t\t/* Action buttons base style */\n\t\t.action-btn {\n\t\t\tdisplay: inline-flex;\n\t\t\talign-items: center;\n\t\t\tjustify-content: center;\n\t\t\twidth: 32px;\n\t\t\theight: 32px;\n\t\t\tborder-radius: 4px;\n\t\t\tborder: 1px solid;\n\t\t\ttext-decoration: none;\n\t\t\ttransition: all 0.2s ease;\n\t\t\tcursor: pointer;\n\t\t\tfont-size: 14px;\n\t\t}\n\t\t.action-btn:hover {\n\t\t\ttransform: translateY(-2px);\n\t\t\tbox-shadow: 0 2px 4px rgba(0,0,0,0.2);\n\t\t}\n\t\t.action-btn:active {\n\t\t\ttransform: translateY(0);\n\t\t\tbox-shadow: none;\n\t\t}\n\t\t\n\t\t/* Edit - Green */\n\t\t.action-edit {\n\t\t\tbackground: #5cb85c;\n\t\t\tborder-color: #4cae4c;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-edit:hover {\n\t\t\tbackground: #449d44;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* Quick Edit - Orange */\n\t\t.action-quick-edit {\n\t\t\tbackground: #f0ad4e;\n\t\t\tborder-color: #eea236;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-quick-edit:hover {\n\t\t\tbackground: #ec971f;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* Start - Blue */\n\t\t.action-start {\n\t\t\tbackground: #5bc0de;\n\t\t\tborder-color: #46b8da;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-start:hover {\n\t\t\tbackground: #31b0d5;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* Stop - Grey */\n\t\t.action-stop {\n\t\t\tbackground: #777;\n\t\t\tborder-color: #666;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-stop:hover {\n\t\t\tbackground: #5a5a5a;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* Refresh - Light Blue */\n\t\t.action-refresh {\n\t\t\tbackground: #fff;\n\t\t\tborder-color: #ccc;\n\t\t\tcolor: #337ab7;\n\t\t}\n\t\t.action-refresh:hover {\n\t\t\tbackground: #e6e6e6;\n\t\t\tcolor: #23527c;\n\t\t}\n\t\t\n\t\t/* API Enabled - Green */\n\t\t.action-enabled {\n\t\t\tbackground: #27ae60;\n\t\t\tborder-color: #229954;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-enabled:hover {\n\t\t\tbackground: #1e8449;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* API Disabled - Red */\n\t\t.action-disabled {\n\t\t\tbackground: #e74c3c;\n\t\t\tborder-color: #c0392b;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-disabled:hover {\n\t\t\tbackground: #c0392b;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t\n\t\t/* Delete - Dark Red */\n\t\t.action-delete {\n\t\t\tbackground: #d9534f;\n\t\t\tborder-color: #d43f3a;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t.action-delete:hover {\n\t\t\tbackground: #c9302c;\n\t\t\tcolor: #fff;\n\t\t}\n\t\t</style>";
    }
    public function EditChannel()
    {
        global $intro;
        global $array;
        $qry = '';
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * from streams where id=' . $id);
        $row = $intro->db->fetch_assoc($sql);
        $stream_source = trim($row['stream_source']);
        $stream_icon = trim($row['stream_icon']);
        $stream_display_name = $row['stream_display_name'];
        $stream_source = json_decode($stream_source, true);
        $sql2 = $intro->db->query('SELECT id,value from streams_options where argument_id=1 AND stream_id=' . $id);
        $row2 = $intro->db->fetch_assoc($sql2);
        $streams_options_value = trim($row2['value']);
        $streams_options_id = intval($row2['id']);
        echo "\n\t\t<fieldset>\n\t\t<form action=\"" . $this->base . '/doEditChannel?NH=1" data-id="' . $id . "\" class=\"frmSaveStream\" method=\"post\">\n\t\t\t\n\t\t\t<input name=\"streams_options_id\" value=\"" . $streams_options_id . "\" type=\"hidden\">\n\t\t\t\n\t\t\t<table class='table table=striped table-condensed' id=\"tblStream" . $id . "\">\n\t\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<td style='width:70px'>Name:</td>\n\t\t\t\t<td><input type=\"text\" name=\"stream_display_name\" id=\"stream_name_" . $id . '" value="' . $stream_display_name . "\" class='form-control danger' style='background-color:#ffff4c;color:#000' placeholder='Stream Name' required=''></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>Logo:</td>\n\t\t\t\t<td><input type=\"text\" name=\"stream_icon\" value=\"" . $stream_icon . "\" class='form-control danger' style='background-color:#ffffbf;;color:#000' placeholder='Stream Icon'></td>\n\t\t\t\t<td><img src=\"" . $stream_icon . "\" style=\"max-height:60px;\" alt=\"\" /></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>UserAgent:</td>\n\t\t\t\t<td><input type=\"text\" name=\"streams_options_value\" value=\"" . $streams_options_value . "\" class='form-control danger' style='background-color:#dfffbf;color:#000' placeholder='Useragent'></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t</thead>\n\t\t\t<tbody>";
        $i = 0;
        foreach( $stream_source as $val ) 
        {
            $i++;
            echo "\n\t\t\t\t<tr>\n\t\t\t\t\t<td>" . $i . "</td>\n\t\t\t\t\t<td><input type=\"text\" name=\"stream_source[]\" value=\"" . $val . "\" class='form-control'></td>\n\t\t\t\t\t<td><button type=\"button\" class='btn btn-danger btnDelStreamRow'><span class='icon-trash'></span></button></td>\n\t\t\t\t</tr>";
        }
        echo "\n\t\t\t\t</tbody>\n\t\t\t\t<tfooter>\n\t\t\t\t<tr>\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td><label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"restart\" value=\"1\">Restart Stream?</label></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<input name=\"chID\" value=\"" . $id . "\" type=\"hidden\">\n\t\t\t\t\t\t<button type=\"submit\" class='btn btn-success'><span class='icon-floppy'></span>Save</button>\n\t\t\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowFirst'><span class='icon-plus-squared'></span>First</button>\n\t\t\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowLast'><span class='icon-plus-squared'></span>Last</button>\n\t\t\t\t\t\t<button data-id=\"chRow" . $id . "\" type=\"button\" class='btn btn-default btnCloseFrmChEdit'><span class='icon-cancel-circled'></span>Close</button>\n\t\t\t\t\t\t<span id=\"frmSpanResult" . $id . "\"></span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t</tfooter>\n\t\t\t</table>\n\t\t\t\n\t\t\t\n\t\t\t\n\t\t</form>\n\t\t<!--\n\t\t<input id='urlOfStremCPY' type=\"text\" value=\"/" . $id . ".ts\" size=50>\n\t\t\t<button id='copy_btn'>Copy</button>\n\t\t\t-->\n\t\t</fieldset>";
        echo "<script>\n\t\tfunction clickListener() {\n\t\t  document.getElementById('urlOfStremCPY').select();\n\t\t  document.execCommand('copy');\n\t\t}\n\t\tdocument.getElementById('copy_btn').addEventListener('click', clickListener);\n\t\t</script>";
    }
    public function doEditChannel()
    {
        global $intro;
        global $array;
        $affected_rows = 0;
        $chID = intval($intro->input->post('chID'));
        $stream_source = $intro->input->post('stream_source');
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $stream_icon = trim($intro->input->post('stream_icon'));
        $streams_options_id = intval($intro->input->post('streams_options_id'));
        $streams_options_value = trim($intro->input->post('streams_options_value'));
        $error = '<span class=\'label label-danger\'>Error: nothing to save!!!.</span>';
        $error2 = '<span class=\'label label-danger\'>Error: Stream Name is Empty!!!.</span>';
        if( !isset($stream_source[0]) ) 
        {
            exit( ' ' . $error );
        }
        if( $stream_display_name == '' ) 
        {
            exit( ' ' . $error2 );
        }
        if( $streams_options_id == 0 && $streams_options_value != '' ) 
        {
            $data = [];
            $data['argument_id'] = 1;
            $data['stream_id'] = $chID;
            $data['value'] = $streams_options_value;
            $intro->db->insert('streams_options', $data);
            $affected_rows = $intro->db->affected_rows;
        }
        else if( $streams_options_id > 0 && $streams_options_value != '' ) 
        {
            $intro->db->update('streams_options', ['value' => $streams_options_value], 'id=' . $streams_options_id);
            $affected_rows = $intro->db->affected_rows;
        }
        else if( $streams_options_value == '' ) 
        {
            $intro->db->query('DELETE FROM streams_options WHERE argument_id=1 AND stream_id=' . $chID);
            $affected_rows = $intro->db->affected_rows;
        }
        $source = array_map('trim', $stream_source);
        $source = array_filter($source);
        if( is_array($source) )
        {
            // Get old name before update
            $old_sql = $intro->db->query("SELECT stream_display_name FROM streams WHERE id = $chID");
            $old_row = $intro->db->fetch_assoc($old_sql);
            $old_name = $old_row['stream_display_name'];

            $data = [];
            $data['stream_source'] = json_encode($source);
            $data['stream_display_name'] = $stream_display_name;
            $data['stream_icon'] = $stream_icon;
            $intro->db->update('streams', $data, 'id=' . $chID);
            if( $intro->db->affected_rows > 0 )
            {
                $affected_rows = $intro->db->affected_rows;

                // Sync name change to remote server if name changed
                if($old_name != $stream_display_name) {
                    $this->updateStreamNameOnRemote($old_name, $stream_display_name);
                }
            }
        }
        if( $affected_rows > 0 ) 
        {
            echo '<span class=\'label label-success\'>Update Success!</span>';
        }
        else
        {
            echo '<span class=\'label label-warning\'>Nothing has changed.</span>';
        }
        if( intval($intro->input->post('restart')) == 1 ) 
        {
            $x = new XtreamApi('EmptyFunc');
            $x->Restart($chID);
        }
    }
}
