<?php
/**
 * XCIPTV Portal API
 * Allows XCIPTV to authenticate users against external panel
 *
 * URL to use in XCIPTV: https://chatti.tmaxhosting.com
 * Username: 1231231 (from external panel)
 * Password: 1231231 (from external panel)
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle PATH_INFO (when XCIPTV adds /player_api.php)
$path_info = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';
$request_uri = $_SERVER['REQUEST_URI'];

// Get request parameters
$username = isset($_GET['username']) ? $_GET['username'] : '';
$password = isset($_GET['password']) ? $_GET['password'] : '';
$action = isset($_GET['action']) ? $_GET['action'] : '';

// External panel configuration
$external_panel_url = 'https://flix-panel.xyz:2087';
$external_host = 'flix-panel.xyz';
$external_port = '2087';

// Local server info
$local_protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$local_host = $_SERVER['HTTP_HOST'];
$local_base_url = $local_protocol . '://' . $local_host;

/**
 * Make request to external panel
 */
function makeExternalRequest($url, $username, $password, $action = '') {
    $api_url = $url . '/player_api.php?username=' . urlencode($username) . '&password=' . urlencode($password);

    if ($action) {
        $api_url .= '&action=' . urlencode($action);
    }

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'XCIPTV-Portal'
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }

    return null;
}

/**
 * Convert external URLs to local proxy URLs
 */
function convertToLocalUrls($data, $username, $password, $local_base_url) {
    if (!$data) return $data;

    // Convert live streams
    if (isset($data['live_streams']) && is_array($data['live_streams'])) {
        foreach ($data['live_streams'] as &$stream) {
            if (isset($stream['stream_id'])) {
                $stream_id = $stream['stream_id'];
                // Point to local proxy
                $stream['stream_url'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';

                // IMPORTANT: Remove or replace direct_source to force using our proxy
                if (isset($stream['direct_source'])) {
                    $stream['direct_source'] = $local_base_url . '/live/' . $username . '/' . $password . '/' . $stream_id . '.ts';
                }
            }
        }
        unset($stream);
    }

    // Convert VOD streams
    if (isset($data['vod_streams']) && is_array($data['vod_streams'])) {
        foreach ($data['vod_streams'] as &$stream) {
            if (isset($stream['stream_id'])) {
                $stream_id = $stream['stream_id'];
                $stream['stream_url'] = $local_base_url . '/movie/' . $username . '/' . $password . '/' . $stream_id . '.mp4';
            }
        }
        unset($stream);
    }

    // Convert series
    if (isset($data['series']) && is_array($data['series'])) {
        foreach ($data['series'] as &$serie) {
            if (isset($serie['series_id'])) {
                $series_id = $serie['series_id'];
                // Keep series info as is
            }
        }
        unset($serie);
    }

    return $data;
}

// Handle different actions
$response = null;

switch ($action) {
    case 'get_live_categories':
    case 'get_live_streams':
    case 'get_vod_categories':
    case 'get_vod_streams':
    case 'get_series_categories':
    case 'get_series':
    case 'get_vod_info':
    case 'get_series_info':
    case 'get_short_epg':
    case 'get_simple_data_table':
        // Forward request to external panel
        $response = makeExternalRequest($external_panel_url, $username, $password, $action);

        // Convert URLs to local proxy
        $response = convertToLocalUrls($response, $username, $password, $local_base_url);
        break;

    default:
        // Authentication request
        $external_response = makeExternalRequest($external_panel_url, $username, $password);

        if ($external_response && isset($external_response['user_info'])) {
            // User authenticated successfully on external panel
            $response = [
                'user_info' => [
                    'username' => $username,
                    'password' => $password,
                    'message' => '',
                    'auth' => 1,
                    'status' => $external_response['user_info']['status'] ?? 'Active',
                    'exp_date' => $external_response['user_info']['exp_date'] ?? null,
                    'is_trial' => $external_response['user_info']['is_trial'] ?? '0',
                    'active_cons' => $external_response['user_info']['active_cons'] ?? '0',
                    'created_at' => $external_response['user_info']['created_at'] ?? time(),
                    'max_connections' => $external_response['user_info']['max_connections'] ?? '1',
                    'allowed_output_formats' => ['m3u8', 'ts', 'rtmp']
                ],
                'server_info' => [
                    'url' => $local_host,
                    'port' => $local_protocol === 'https' ? '443' : '80',
                    'https_port' => '443',
                    'server_protocol' => $local_protocol,
                    'rtmp_port' => '1935',
                    'timezone' => 'UTC',
                    'timestamp_now' => time(),
                    'time_now' => date('Y-m-d H:i:s')
                ]
            ];
        } else {
            // Authentication failed
            $response = [
                'user_info' => [
                    'auth' => 0,
                    'status' => 'Disabled',
                    'message' => 'Invalid credentials or external panel is down'
                ]
            ];
        }
        break;
}

// Output response
echo json_encode($response ?? ['error' => 'No data'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>
