<?php
/**
 * EPG Endpoint compatible with Xtream Codes API
 * Handles: action=get_short_epg&stream_id=X
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$action = $_GET['action'] ?? '';
$stream_id = $_GET['stream_id'] ?? '';
$limit = $_GET['limit'] ?? 10;

// Only handle get_short_epg action
if ($action !== 'get_short_epg' || empty($stream_id)) {
    echo json_encode(['epg_listings' => []]);
    exit;
}

try {
    // Load config
    require_once __DIR__ . '/includes/Config.php';

    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );

    // Get epg_channel_id from remote database via SSH
    require_once __DIR__ . '/V6APK/api_cfg_v6.php';

    $ssh_cmd = "sshpass -p '{$_CFG['remote_ssh_pass']}' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 {$_CFG['remote_ssh_user']}@{$_CFG['remote_host']} 'mysql {$_CFG['remote_db_name']} -N -e \"SELECT epg_channel_id FROM streams WHERE id = {$stream_id};\"'";
    $epg_channel_id = trim(shell_exec($ssh_cmd));

    if (empty($epg_channel_id)) {
        echo json_encode(['epg_listings' => []]);
        exit;
    }

    // Get EPG from cached XMLTV
    $cache_dir = __DIR__ . '/cache';
    $epg_file = $cache_dir . '/epg.xml';

    // Update cache if older than 1 hour
    if (!file_exists($epg_file) || (time() - filemtime($epg_file)) > 3600) {
        $xmltv_url = 'https://flix-panel.xyz:2087/xmltv.php?username=1231231&password=1231231';

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $xmltv_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 120,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $xml = curl_exec($ch);
        curl_close($ch);

        if ($xml) {
            @mkdir($cache_dir, 0755, true);
            file_put_contents($epg_file, $xml);
        }
    }

    $xml_content = file_exists($epg_file) ? file_get_contents($epg_file) : '';

    if (empty($xml_content)) {
        echo json_encode(['epg_listings' => []]);
        exit;
    }

    // Parse EPG for this channel
    $epg_listings = [];
    $now = time();

    // Find programmes for this epg_channel_id
    preg_match_all('/<programme[^>]*channel="' . preg_quote($epg_channel_id, '/') . '"[^>]*>.*?<\/programme>/s', $xml_content, $programmes);

    $count = 0;
    foreach ($programmes[0] as $prog) {
        if ($count >= $limit) break;

        // Extract start/stop times
        preg_match('/start="(\d{14})/', $prog, $start_match);
        preg_match('/stop="(\d{14})/', $prog, $stop_match);

        if (!$start_match || !$stop_match) continue;

        $start_str = $start_match[1];
        $stop_str = $stop_match[1];

        $start_time = mktime(
            (int)substr($start_str, 8, 2),
            (int)substr($start_str, 10, 2),
            (int)substr($start_str, 12, 2),
            (int)substr($start_str, 4, 2),
            (int)substr($start_str, 6, 2),
            (int)substr($start_str, 0, 4)
        );

        $stop_time = mktime(
            (int)substr($stop_str, 8, 2),
            (int)substr($stop_str, 10, 2),
            (int)substr($stop_str, 12, 2),
            (int)substr($stop_str, 4, 2),
            (int)substr($stop_str, 6, 2),
            (int)substr($stop_str, 0, 4)
        );

        // Only current and next 24h
        if ($stop_time < $now || $start_time > ($now + 86400)) continue;

        // Extract title and description
        preg_match('/<title[^>]*>([^<]*)<\/title>/', $prog, $title_match);
        preg_match('/<desc[^>]*>([^<]*)<\/desc>/', $prog, $desc_match);

        $title = $title_match[1] ?? '';
        $desc = $desc_match[1] ?? '';

        $epg_listings[] = [
            'id' => (string)($stream_id . '_' . $start_time),
            'epg_id' => $epg_channel_id,
            'title' => $title,
            'lang' => 'en',
            'start' => date('Y-m-d H:i:s', $start_time),
            'end' => date('Y-m-d H:i:s', $stop_time),
            'description' => $desc,
            'channel_id' => $epg_channel_id,
            'start_timestamp' => (string)$start_time,
            'stop_timestamp' => (string)$stop_time,
            'now_playing' => ($now >= $start_time && $now < $stop_time) ? 1 : 0,
            'has_archive' => 0
        ];

        $count++;
    }

    echo json_encode(['epg_listings' => $epg_listings]);

} catch (Exception $e) {
    echo json_encode(['epg_listings' => [], 'error' => $e->getMessage()]);
}
?>
