#!/usr/bin/php
<?php
// Simple standalone sync script
// Run with: php /var/www/html/iptv/simple_sync.php

// Load config
require_once('/var/www/html/iptv/includes/Config.php');

// Remote and local connection details
$remote_host = "204.188.233.170";
$remote_port = 7999;
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

$local_host = $config['db']['hostname'];
$local_user = $config['db']['username'];
$local_pass = $config['db']['password'];
$local_db = $config['db']['database'];

echo "=== IPTV Stream Sync ===\n";
echo date('Y-m-d H:i:s') . "\n\n";

// Connect to local database
echo "Connecting to local database... ";
$local_conn = @new mysqli($local_host, $local_user, $local_pass, $local_db);
if($local_conn->connect_error) {
    die("FAILED: " . $local_conn->connect_error . "\n");
}
echo "OK\n";

// Try to connect to remote database
echo "Connecting to remote database... ";
$remote_conn = @new mysqli($remote_host, $remote_user, $remote_pass, $remote_db, $remote_port);
if($remote_conn->connect_error) {
    echo "FAILED: " . $remote_conn->connect_error . "\n";
    echo "Remote MySQL connection not available.\n";
    echo "Note: Streams can only be synced if remote MySQL allows external connections.\n";
    $local_conn->close();
    exit(1);
}
echo "OK\n\n";

// Fetch streams from remote
echo "Fetching streams from remote (type=0 = live channels)... ";
// Remote uses 'name' column, local uses 'stream_display_name'
$query = "SELECT id, name, logo_image, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id";
$result = $remote_conn->query($query);

if(!$result) {
    die("FAILED: " . $remote_conn->error . "\n");
}

$remote_streams = [];
while($row = $result->fetch_assoc()) {
    $remote_streams[] = $row;
}
echo count($remote_streams) . " streams found\n\n";

// Sync streams
echo "Syncing streams...\n";
$updated = 0;
$inserted = 0;
$errors = 0;

foreach($remote_streams as $stream) {
    $id = intval($stream['id']);
    $name = $local_conn->real_escape_string($stream['name']);
    $logo_image = $stream['logo_image'];
    $disabled = intval($stream['disabled']);
    $on_demand = intval($stream['direct_streaming_on_demand']);

    // Check if stream exists locally
    // Column mapping: remote 'name' -> local 'stream_display_name', remote 'logo_image' -> local 'stream_icon'
    $check = $local_conn->query("SELECT id, stream_display_name, stream_icon FROM streams WHERE id = $id");

    if($check && $check->num_rows > 0) {
        // Update existing stream
        $local_row = $check->fetch_assoc();

        $update_fields = [];

        if($local_row['stream_display_name'] != $stream['name']) {
            $update_fields[] = "stream_display_name = '$name'";
        }

        if(!empty($logo_image) && $logo_image != 'NULL' && $local_row['stream_icon'] != $logo_image) {
            $logo_escaped = $local_conn->real_escape_string($logo_image);
            $update_fields[] = "stream_icon = '$logo_escaped'";
        }

        if(count($update_fields) > 0) {
            $update_sql = "UPDATE streams SET " . implode(', ', $update_fields) . " WHERE id = $id";
            if($local_conn->query($update_sql)) {
                $updated++;
                echo "  Updated: " . $stream['name'] . "\n";
            } else {
                $errors++;
                echo "  ERROR updating $id: " . $local_conn->error . "\n";
            }
        }
    } else {
        // Insert new stream (type=1 locally for live channels)
        // Column mapping: remote 'logo_image' -> local 'stream_icon'
        $logo_val = empty($logo_image) || $logo_image == 'NULL' ? "''" : "'" . $local_conn->real_escape_string($logo_image) . "'";

        $insert_sql = "INSERT INTO streams (id, type, stream_display_name, stream_icon, added)
                       VALUES ($id, 1, '$name', $logo_val, " . time() . ")";

        if($local_conn->query($insert_sql)) {
            $inserted++;
            echo "  Inserted: " . $stream['name'] . "\n";
        } else {
            $errors++;
            echo "  ERROR inserting $id: " . $local_conn->error . "\n";
        }
    }

    // Update streams_sys table
    $check_sys = $local_conn->query("SELECT stream_id FROM streams_sys WHERE stream_id = $id AND server_id = 1");

    if($check_sys && $check_sys->num_rows > 0) {
        $local_conn->query("UPDATE streams_sys SET on_demand = $on_demand WHERE stream_id = $id AND server_id = 1");
    } else {
        $local_conn->query("INSERT INTO streams_sys (stream_id, server_id, on_demand) VALUES ($id, 1, $on_demand)");
    }
}

echo "\n=== Sync Complete ===\n";
echo "Updated: $updated\n";
echo "Inserted: $inserted\n";
echo "Errors: $errors\n";

$remote_conn->close();
$local_conn->close();
?>
