<?php
/**
 * Manual Stream Starter for MidnightStreamer
 * Usage: php start_stream.php <stream_id>
 * Or via web: start_stream.php?id=<stream_id>
 */

$stream_id = isset($argv[1]) ? intval($argv[1]) : (isset($_GET['id']) ? intval($_GET['id']) : 0);

if($stream_id <= 0) {
    die("Usage: php start_stream.php <stream_id> or ?id=<stream_id>\n");
}

// Remote server credentials
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

function remoteQuery($sql) {
    global $remote_host, $remote_user, $remote_pass, $remote_db;
    $cmd = "sshpass -p '$remote_pass' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 $remote_user@$remote_host \"mysql $remote_db -N -e \\\"$sql\\\"\" 2>&1";
    return trim(shell_exec($cmd));
}

function remoteExec($cmd) {
    global $remote_host, $remote_user, $remote_pass;
    $ssh_cmd = "sshpass -p '$remote_pass' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=30 $remote_user@$remote_host \"$cmd\" 2>&1";
    return shell_exec($ssh_cmd);
}

echo "Starting stream $stream_id...\n";

// 1. Get stream info
$stream_info = remoteQuery("SELECT name, urls, direct_streaming_on_demand FROM streams WHERE id=$stream_id");
if(empty($stream_info)) {
    die("Stream $stream_id not found!\n");
}

$parts = explode("\t", $stream_info);
$name = $parts[0];
$urls_json = $parts[1];
$on_demand = $parts[2];

echo "Stream: $name\n";

// 2. Set to Live mode if needed
if($on_demand == '1') {
    echo "Changing to Live mode...\n";
    remoteQuery("UPDATE streams SET direct_streaming_on_demand=0, on_demand_servers=NULL WHERE id=$stream_id");
}

// 3. Parse URL
$urls = json_decode($urls_json, true);
if(empty($urls)) {
    $urls = json_decode(stripslashes($urls_json), true);
}
if(empty($urls) || !is_array($urls)) {
    die("Could not parse URLs: $urls_json\n");
}

$url = $urls[0];
// Clean escaped slashes
$url = stripslashes($url);
$url = str_replace('\/', '/', $url);
$url = str_replace('https://', 'http://', $url);
echo "URL: $url\n";

// 4. Clean old pids entry
remoteQuery("DELETE FROM pids WHERE sid=$stream_id");

// 5. Insert new pids entry
$url_esc = addslashes($url);
remoteQuery("INSERT INTO pids (sid, server_id, ppid, url_num, url_num2, adaptive_level, url, start_time, watchdog) VALUES ($stream_id, 1, 0, 1, 1, 0, '$url_esc', UNIX_TIMESTAMP(), UNIX_TIMESTAMP())");
echo "PIDs entry created\n";

// 6. Start ffmpeg using 'at' command (works better over SSH)
$ffmpeg_cmd = "/home/midnightstreamer/iptv_midnight_streamer/bin/ffmpeg " .
    "-progress /home/midnightstreamer/iptv_midnight_streamer/streams/{$stream_id}_1_.progress " .
    "-y -nostats -nostdin -hide_banner -loglevel error " .
    "-i '$url' -c copy -f hls -hls_time 10 -hls_list_size 6 " .
    "-hls_flags delete_segments " .
    "-hls_segment_filename /home/midnightstreamer/iptv_midnight_streamer/streams/{$stream_id}_1_%d.ts " .
    "/home/midnightstreamer/iptv_midnight_streamer/streams/{$stream_id}_1_.m3u8";

// Use 'at now' to run in background properly
remoteExec("echo \"$ffmpeg_cmd\" | at now 2>/dev/null");
echo "FFmpeg started\n";

// 7. Wait and verify
echo "Waiting for stream to start...\n";
sleep(10);

$result = remoteQuery("SELECT pid, speed FROM pids WHERE sid=$stream_id");
if(!empty($result)) {
    $parts = explode("\t", $result);
    if(!empty($parts[0]) && $parts[0] != 'NULL') {
        echo "SUCCESS! Stream $name is running (PID: {$parts[0]}, Speed: {$parts[1]})\n";
    } else {
        echo "Stream started but waiting for watchdog to register PID...\n";
    }
} else {
    echo "Warning: Could not verify stream status\n";
}
