// Force override bulk actions - load this AFTER page loads
console.log('=== FORCE BULK FIX LOADED ===');

// Wait for page to fully load
$(document).ready(function() {
    console.log('Document ready - attaching handlers');

    // Remove ALL existing handlers
    $('#bulkDelete, #bulkRestart, #bulkStop, #bulkDisable').off();

    function getSelectedStreams() {
        var ids = [];
        $('.stream_checkbox:checked').each(function() {
            ids.push($(this).val());
        });
        console.log('getSelectedStreams() returned:', ids);
        return ids;
    }

    // DELETE
    $(document).on('click', '#bulkDelete', function(e) {
        e.preventDefault();
        var ids = getSelectedStreams();
        console.log('[DELETE] Selected:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Delete ' + ids.length + ' stream(s)?')) return false;

        console.log('[DELETE] Sending request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Deleting...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkDelete',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('[DELETE] Success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() { location.reload(); }, 1500);
            },
            error: function(xhr, status, error) {
                console.error('[DELETE] Error:', status, error, xhr.responseText);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + status + '</span>');
            }
        });

        return false;
    });

    // RESTART
    $(document).on('click', '#bulkRestart', function(e) {
        e.preventDefault();
        var ids = getSelectedStreams();
        console.log('[RESTART] Selected:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Restart ' + ids.length + ' stream(s)?')) return false;

        console.log('[RESTART] Sending request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Restarting...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkRestart',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('[RESTART] Success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() { location.reload(); }, 2000);
            },
            error: function(xhr, status, error) {
                console.error('[RESTART] Error:', status, error, xhr.responseText);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + status + '</span>');
            }
        });

        return false;
    });

    // STOP
    $(document).on('click', '#bulkStop', function(e) {
        e.preventDefault();
        var ids = getSelectedStreams();
        console.log('[STOP] Selected:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Stop ' + ids.length + ' stream(s)?')) return false;

        console.log('[STOP] Sending request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Stopping...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkStop',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('[STOP] Success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() { location.reload(); }, 2000);
            },
            error: function(xhr, status, error) {
                console.error('[STOP] Error:', status, error, xhr.responseText);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + status + '</span>');
            }
        });

        return false;
    });

    // DISABLE
    $(document).on('click', '#bulkDisable', function(e) {
        e.preventDefault();
        var ids = getSelectedStreams();
        console.log('[DISABLE] Selected:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Disable ' + ids.length + ' stream(s)?')) return false;

        console.log('[DISABLE] Sending request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Disabling...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkDisable',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('[DISABLE] Success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() { location.reload(); }, 1500);
            },
            error: function(xhr, status, error) {
                console.error('[DISABLE] Error:', status, error, xhr.responseText);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + status + '</span>');
            }
        });

        return false;
    });

    console.log('=== ALL HANDLERS ATTACHED ===');
    console.log('Buttons found:', {
        delete: $('#bulkDelete').length,
        restart: $('#bulkRestart').length,
        stop: $('#bulkStop').length,
        disable: $('#bulkDisable').length
    });
});
