/**
 * Bulk Actions Fix for Streams
 * This file fixes the bulk actions buttons without modifying original code
 */

// Use setTimeout to ensure DOM is fully loaded and original handlers are attached
setTimeout(function() {
    console.log('=== Bulk Actions Fix: Starting ===');

    // Check if buttons exist
    if($('#bulkDelete').length) console.log('✓ bulkDelete button found');
    if($('#bulkRestart').length) console.log('✓ bulkRestart button found');
    if($('#bulkStop').length) console.log('✓ bulkStop button found');
    if($('#bulkDisable').length) console.log('✓ bulkDisable button found');

    // Function to get selected streams
    function getSelectedStreams() {
        var ids = [];
        $('.stream_checkbox:checked').each(function() {
            ids.push($(this).val());
        });
        return ids;
    }

    // Clone and replace buttons to remove ALL event handlers
    var $oldDelete = $('#bulkDelete');
    var $newDelete = $oldDelete.clone(false);
    $oldDelete.replaceWith($newDelete);

    var $oldRestart = $('#bulkRestart');
    var $newRestart = $oldRestart.clone(false);
    $oldRestart.replaceWith($newRestart);

    var $oldStop = $('#bulkStop');
    var $newStop = $oldStop.clone(false);
    $oldStop.replaceWith($newStop);

    var $oldDisable = $('#bulkDisable');
    var $newDisable = $oldDisable.clone(false);
    $oldDisable.replaceWith($newDisable);

    console.log('✓ Buttons cloned and replaced');

    // Attach new handlers
    $('#bulkDelete').on('click', function(e) {
        console.log('DELETE clicked');
        e.preventDefault();
        e.stopPropagation();

        var ids = getSelectedStreams();
        console.log('Selected IDs:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Delete ' + ids.length + ' stream(s)? This action cannot be undone!')) {
            return false;
        }

        console.log('Sending DELETE request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Deleting...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkDelete',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('DELETE success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr, status, error) {
                console.error('DELETE error:', error);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + error + '</span>');
            }
        });

        return false;
    });

    $('#bulkRestart').on('click', function(e) {
        console.log('RESTART clicked');
        e.preventDefault();
        e.stopPropagation();

        var ids = getSelectedStreams();
        console.log('Selected IDs:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Restart ' + ids.length + ' stream(s)?')) {
            return false;
        }

        console.log('Sending RESTART request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Restarting...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkRestart',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('RESTART success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() {
                    location.reload();
                }, 2000);
            },
            error: function(xhr, status, error) {
                console.error('RESTART error:', error);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + error + '</span>');
            }
        });

        return false;
    });

    $('#bulkStop').on('click', function(e) {
        console.log('STOP clicked');
        e.preventDefault();
        e.stopPropagation();

        var ids = getSelectedStreams();
        console.log('Selected IDs:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Stop ' + ids.length + ' stream(s)?')) {
            return false;
        }

        console.log('Sending STOP request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Stopping...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkStop',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('STOP success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() {
                    location.reload();
                }, 2000);
            },
            error: function(xhr, status, error) {
                console.error('STOP error:', error);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + error + '</span>');
            }
        });

        return false;
    });

    $('#bulkDisable').on('click', function(e) {
        console.log('DISABLE clicked');
        e.preventDefault();
        e.stopPropagation();

        var ids = getSelectedStreams();
        console.log('Selected IDs:', ids);

        if(ids.length == 0) {
            alert('Please select at least one stream');
            return false;
        }

        if(!confirm('Disable ' + ids.length + ' stream(s)?')) {
            return false;
        }

        console.log('Sending DISABLE request...');
        $('#bulkActionResult').html('<span class="icon-spin5 animate-spin"></span> Disabling...');

        $.ajax({
            url: '/iptv/apps/streams_bulk_actions.php?action=BulkDisable',
            type: 'POST',
            data: {ids: ids},
            success: function(data) {
                console.log('DISABLE success:', data);
                $('#bulkActionResult').html(data);
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr, status, error) {
                console.error('DISABLE error:', error);
                $('#bulkActionResult').html('<span class="text-danger">Error: ' + error + '</span>');
            }
        });

        return false;
    });

    console.log('=== Bulk Actions Fix: Complete ===');

}, 2000); // Wait 2 seconds after page load
