<?php
if( isset($intro->option['hide_introtech_copy']) && $intro->option['hide_introtech_copy'] == 1 )
{
    $copyright = '';
}
else
{
    $copyright = _intro_ver;
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<meta charset="utf-8" />
<title><?php echo $intro->option['site_name']; ?> | <?php echo $copyright; ?></title>
<link rel="stylesheet" href="style/css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="style/css/login.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<style>
body {
		background: #1a1a27;
		font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
		margin: 0;
		padding: 0;
		overflow-x: hidden;
	}
#login-background {
		position: fixed;
		top: 0;
		left: 0;
		width: 100%;
		height: 100%;
		background: linear-gradient(135deg, #1a1a27 0%, #2d2d44 100%);
		z-index: 0;
	}
#login-background canvas {
		position: absolute !important;
		top: 0;
		left: 0;
		width: 100%;
		height: 100%;
	}
.account-wall {
		background: linear-gradient(135deg, rgba(13, 27, 42, 0.9) 0%, rgba(27, 38, 59, 0.85) 100%) !important;
		backdrop-filter: blur(20px);
		-webkit-backdrop-filter: blur(20px);
		border: 1px solid rgba(255, 255, 255, 0.15);
		border-radius: 20px;
		box-shadow: 0 20px 60px rgba(0, 0, 0, 0.6), 0 0 1px rgba(255, 255, 255, 0.2) inset !important;
		padding: 50px 40px !important;
	}
.login-title {
		color: #fff !important;
		text-shadow: 0 2px 10px rgba(0, 0, 0, 0.8);
		font-size: 24px !important;
		font-weight: 600 !important;
		margin-bottom: 30px !important;
	}
.form-control {
		background: rgba(255, 255, 255, 0.08) !important;
		border: 2px solid rgba(255, 255, 255, 0.15);
		color: #fff !important;
		font-size: 15px;
		padding: 14px 18px;
		border-radius: 10px;
		transition: all 0.3s ease;
	}
.form-control::placeholder {
		color: rgba(255, 255, 255, 0.5);
	}
.form-control:focus {
		background: rgba(255, 255, 255, 0.12) !important;
		border-color: rgba(79, 172, 254, 0.6);
		box-shadow: 0 0 20px rgba(79, 172, 254, 0.3);
		color: #fff !important;
		outline: none;
	}
.btn-primary {
		background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
		border: none;
		border-radius: 10px;
		padding: 14px;
		font-size: 16px;
		font-weight: 600;
		letter-spacing: 0.5px;
		box-shadow: 0 8px 25px rgba(79, 172, 254, 0.4);
		transition: all 0.4s ease;
		text-transform: uppercase;
	}
.btn-primary:hover {
		transform: translateY(-3px);
		box-shadow: 0 12px 35px rgba(79, 172, 254, 0.6);
		background: linear-gradient(135deg, #00f2fe 0%, #4facfe 100%);
	}
.checkbox, .need-help {
		color: rgba(255, 255, 255, 0.8) !important;
		text-shadow: 0 1px 3px rgba(0, 0, 0, 0.6);
		font-size: 13px;
	}
.need-help:hover {
		color: #4facfe !important;
		text-shadow: 0 0 10px rgba(79, 172, 254, 0.5);
	}
h3 {
		text-shadow: 0 3px 15px rgba(0, 0, 0, 0.8);
		color: #fff !important;
		font-weight: 600;
	}
img[alt=""] {
		filter: drop-shadow(0 5px 20px rgba(0, 0, 0, 0.7));
	}
.verify-container {
		margin: 20px 0;
		padding: 16px 20px;
		background: rgba(255, 255, 255, 0.06);
		border: 2px solid rgba(255, 255, 255, 0.12);
		border-radius: 12px;
		display: flex;
		align-items: center;
		cursor: pointer;
		transition: all 0.4s ease;
	}
.verify-container:hover {
		background: rgba(255, 255, 255, 0.1);
		border-color: rgba(79, 172, 254, 0.4);
		box-shadow: 0 4px 20px rgba(79, 172, 254, 0.2);
	}
.verify-container.verified {
		background: rgba(79, 172, 254, 0.15);
		border-color: rgba(79, 172, 254, 0.6);
		box-shadow: 0 6px 25px rgba(79, 172, 254, 0.3);
	}
.verify-checkbox {
		width: 26px;
		height: 26px;
		border: 2px solid rgba(255, 255, 255, 0.4);
		border-radius: 6px;
		margin-right: 14px;
		display: flex;
		align-items: center;
		justify-content: center;
		background: rgba(255, 255, 255, 0.08);
		transition: all 0.4s ease;
	}
.verify-container.verified .verify-checkbox {
		background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
		border-color: #4facfe;
		box-shadow: 0 4px 15px rgba(79, 172, 254, 0.4);
	}
.verify-checkbox::after {
		content: '✓';
		color: white;
		font-size: 18px;
		font-weight: bold;
		display: none;
	}
.verify-container.verified .verify-checkbox::after {
		display: block;
		animation: checkPop 0.3s ease;
	}
@keyframes checkPop {
		0% { transform: scale(0); }
		50% { transform: scale(1.2); }
		100% { transform: scale(1); }
	}
.verify-text {
		color: rgba(255, 255, 255, 0.9);
		font-size: 14px;
		font-weight: 500;
		text-shadow: 0 1px 3px rgba(0, 0, 0, 0.6);
	}
.container {
		position: relative;
		z-index: 100;
	}
.password-reveal-btn {
		position: absolute;
		right: 15px;
		top: 50%;
		transform: translateY(-50%);
		background: transparent;
		border: none;
		color: rgba(255, 255, 255, 0.6);
		cursor: pointer;
		font-size: 16px;
		padding: 8px;
		transition: all 0.3s ease;
	}
.password-reveal-btn:hover {
		color: #4facfe;
	}
.password-wrapper {
		position: relative;
	}
.version-label {
		position: fixed;
		bottom: 20px;
		right: 20px;
		background: rgba(255, 255, 255, 0.1);
		backdrop-filter: blur(10px);
		padding: 8px 16px;
		border-radius: 20px;
		color: rgba(255, 255, 255, 0.7);
		font-size: 11px;
		z-index: 200;
	}
</style>
</head>

<body>
<div id="login-background"></div>


<div class="container">
	<div class="row">
		<div class="col-sm-6 col-md-4 col-md-offset-4">
			<h1 class="text-center login-title">Login in</h1>
			<div class="account-wall">
				<div class="row">
					<div class="col-sm-12 col-md-12 text-center">
					<?php
					if( isset($intro->option['hide_login_logo']) && $intro->option['hide_login_logo'] == 1 ) {
						echo '<h3 style=\'color:#4d4cff\'>control panel</h3>';
					} else {
						echo '<img src="style/img/logo.png" alt="" style="max-width:450px;">';
					}
					?>
					</div>
				</div>
				<form class="form-signin" method="POST" id="login-form">
					<div style="margin-bottom: 15px;">
						<input type="text" name="<?php echo $name1; ?>" value="<?php echo $username; ?>" class="form-control" placeholder="Email/Username" required autofocus>
					</div>
					<div class="password-wrapper" style="margin-bottom: 15px;">
						<input type="password" name="<?php echo $name2; ?>" id="password-field" value="<?php echo $password; ?>" class="form-control" placeholder="Password" required autocomplete="current-password">
						<button type="button" class="password-reveal-btn" onclick="togglePassword()">
							<i class="far fa-eye" id="password-icon"></i>
						</button>
					</div>

					<div class="verify-container" id="verify-container" onclick="toggleVerify()">
					<div class="verify-checkbox"></div>
					<span class="verify-text">Click to verify you are human</span>
				</div>
				<input type="hidden" name="verify_human" id="verify_human" value="0">

					<div style="width:500px;margin:auto;color:red;font-weight:bold;"><?php echo (isset($this->error['msg']) ? $this->error['msg'] : ''); ?></div>
					<button class="btn btn-lg btn-primary btn-block" type="submit">Login</button>
					<label class="checkbox pull-left">
						<input type="checkbox" value="remember-me"> Remember me
					</label>
					<a href="#" class="pull-right need-help">Forgot password? </a><span class="clearfix"></span>
					<input type="hidden" name="maa" value="do_login" />
				</form>
			</div>

		</div>
	</div>
</div>
<?php
if( isset($intro->option['hide_introtech_copy']) && $intro->option['hide_introtech_copy'] == 1 ) {
	if( isset($intro->option['copyright']) && $intro->option['copyright'] != '' ) {
		echo "\n\t\t\t<div class=\"row text-center\"><br/>\n\t\t\t\t" . $intro->option['copyright'] . "\n\t\t\t</div>";
	}
} else {
	echo "<center>\n\t<h5 class='center'><a href='http://intro.ps/' target=_blank>" . _intro_ver . "</a></h5>\n\t</center>";
}
?>
<div class="version-label">
	v2.0.0
</div>

<script src="https://cdn.jsdelivr.net/npm/particlesjs@2.2.3/dist/particles.min.js"></script>
<script>
// Initialize particle background
window.onload = function() {
	Particles.init({
		selector: '#login-background',
		color: ['#4facfe', '#00f2fe', '#667eea'],
		connectParticles: true,
		responsive: [
			{
				breakpoint: 768,
				options: {
					maxParticles: 50,
					connectParticles: false
				}
			}
		],
		maxParticles: 80,
		sizeVariations: 4,
		speed: 0.5
	});
};

function togglePassword() {
	var passwordField = document.getElementById('password-field');
	var passwordIcon = document.getElementById('password-icon');

	if (passwordField.type === 'password') {
		passwordField.type = 'text';
		passwordIcon.classList.remove('fa-eye');
		passwordIcon.classList.add('fa-eye-slash');
	} else {
		passwordField.type = 'password';
		passwordIcon.classList.remove('fa-eye-slash');
		passwordIcon.classList.add('fa-eye');
	}
}

function toggleVerify() {
	var container = document.getElementById('verify-container');
	var input = document.getElementById('verify_human');

	if (container.classList.contains('verified')) {
		container.classList.remove('verified');
		input.value = '0';
	} else {
		container.classList.add('verified');
		input.value = '1';
	}
}

document.getElementById('login-form').addEventListener('submit', function(event) {
	var verified = document.getElementById('verify_human').value;

	if (verified !== '1') {
		event.preventDefault();
		alert('Please verify you are human by clicking the checkbox');
		return false;
	}

	return true;
});
</script>
</body>
</html>
