<?php
// Collapsible Sidebar Menu - Option 1
?>
<!DOCTYPE html>
<html dir="<?php echo $intro->lang['dir']; ?>">
<head>
	<meta charset="utf-8">
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo admin_path; ?>style/favicon.ico" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<title><?php echo ' ' . $app_name . ' | ' . $intro->option['site_name'] . ' - ' . $copyright; ?></title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width">

	<link rel="stylesheet" href="<?php echo admin_path; ?>style/css/css.php?v=235">
	<link rel="stylesheet" href="<?php echo admin_path; ?>style/css/modern-dashboard.css?v=1">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
	<script src="<?php echo admin_path; ?>style/js.php?v=233"></script>

	<script>
	var lang_del = '<?php echo $intro->lang['del']; ?>';
	var lang_cancel = '<?php echo $intro->lang['cancel']; ?>';
	var admin_folder = '<?php echo admin_path; ?>';

	</script>

	<script src="<?php echo admin_path; ?>style/js/main.js?v=33"></script>

	<meta name="viewport" content="width=750">

	<style>
	/* Sidebar Styles */
	* {
		box-sizing: border-box;
	}

	body {
		margin: 0;
		padding: 0;
		font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
		background: #f5f7fa;
		overflow-x: hidden;
	}

	.sidebar {
		width: 260px;
		background: #1e1e2d;
		color: #fff;
		position: fixed;
		height: 100vh;
		overflow-y: auto;
		overflow-x: hidden;
		transition: all 0.3s ease;
		z-index: 1000;
		box-shadow: 0 0 50px rgba(0,0,0,0.3);
		left: 0;
		top: 0;
		bottom: 0;
		border-right: 1px solid rgba(255,255,255,0.05);
		display: flex;
		flex-direction: column;
	}

	.sidebar.collapsed {
		width: 70px;
		overflow: hidden;
	}

	/* Auto-expand on hover */
	.sidebar.collapsed:hover {
		width: 260px;
		overflow: visible;
	}

	.sidebar.collapsed:hover .menu-text {
		display: inline-block;
		animation: fadeInText 0.3s ease;
	}

	.sidebar.collapsed:hover .caret {
		display: inline-block;
		animation: fadeInText 0.3s ease;
	}

	@keyframes fadeInText {
		from {
			opacity: 0;
			transform: translateX(-10px);
		}
		to {
			opacity: 1;
			transform: translateX(0);
		}
	}

	.sidebar.collapsed ~ .main-content {
		margin-left: 70px;
	}

	.sidebar.collapsed .menu-text {
		display: none;
	}

	.sidebar.collapsed .caret {
		display: none;
	}

	.sidebar-header {
		padding: 20px 20px;
		background: #1a1a27;
		display: flex;
		align-items: center;
		justify-content: center;
		border-bottom: 1px solid rgba(255,255,255,0.08);
		min-height: 70px;
	}

	.sidebar-header .logo {
		display: flex;
		align-items: center;
		justify-content: center;
	}

	.sidebar-header .logo img {
		max-height: 40px;
		transition: all 0.3s;
	}

	.sidebar.collapsed .sidebar-header .logo img {
		max-height: 30px;
		transition: max-height 0.3s ease;
	}

	.sidebar.collapsed:hover .sidebar-header .logo img {
		max-height: 40px;
	}

	.sidebar-toggle {
		position: fixed;
		left: 220px;
		top: 18px;
		background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
		border: none;
		color: #fff;
		font-size: 18px;
		cursor: pointer;
		padding: 0;
		border-radius: 8px;
		transition: all 0.3s ease;
		width: 38px;
		height: 38px;
		display: flex;
		align-items: center;
		justify-content: center;
		box-shadow: 0 3px 12px rgba(102, 126, 234, 0.4);
		z-index: 10001;
		outline: none;
	}

	.sidebar-toggle i {
		font-size: 18px;
		transition: transform 0.3s ease;
	}

	.sidebar-toggle:hover {
		background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
		transform: translateY(-2px);
		box-shadow: 0 5px 18px rgba(102, 126, 234, 0.6);
	}

	.sidebar-toggle:active {
		transform: scale(0.95);
	}

	.sidebar.collapsed .sidebar-toggle {
		left: 28px;
	}

	/* Move toggle button when hovering over collapsed sidebar */
	.sidebar.collapsed:hover .sidebar-toggle {
		left: 220px;
	}

	.sidebar.collapsed .sidebar-toggle i {
		transform: rotate(0deg);
	}


	.sidebar-menu {
		list-style: none;
		padding: 0;
		margin: 0;
		flex: 1;
		overflow-y: auto;
		overflow-x: hidden;
	}

	.sidebar-menu > li {
		border-bottom: 1px solid rgba(255,255,255,0.05);
	}

	/* Logout button - sticky at bottom */
	.sidebar-menu > li:last-child {
		position: sticky;
		bottom: 0;
		background: #1a1a27;
		border-top: 2px solid rgba(54, 153, 255, 0.3);
		border-bottom: none;
		margin-top: auto;
		z-index: 10;
	}

	.sidebar-menu > li:last-child > a {
		background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
		color: white;
		font-weight: 600;
		padding: 14px 20px;
	}

	.sidebar-menu > li:last-child > a:hover {
		background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
		transform: translateX(5px);
	}

	.sidebar.collapsed .sidebar-menu > li:last-child > a {
		background: #dc3545;
		padding: 16px 0;
		justify-content: center;
	}

	.sidebar.collapsed:hover .sidebar-menu > li:last-child > a {
		background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
		padding: 14px 20px;
		justify-content: flex-start;
	}

	.sidebar-menu > li > a {
		display: flex;
		align-items: center;
		padding: 13px 20px;
		color: #a2a3b7;
		text-decoration: none;
		transition: all 0.25s ease;
		position: relative;
		font-size: 13px;
		font-weight: 500;
		border-left: 3px solid transparent;
		cursor: pointer;
	}

	.sidebar-menu > li > a:hover {
		background: rgba(54, 153, 255, 0.1);
		color: #3699ff;
		border-left-color: rgba(54, 153, 255, 0.5);
		padding-left: 25px;
	}

	.sidebar-menu > li.active > a {
		background: linear-gradient(90deg, rgba(54, 153, 255, 0.15) 0%, rgba(54, 153, 255, 0.05) 100%);
		color: #3699ff;
		border-left: 3px solid #3699ff;
		font-weight: 600;
	}

	.sidebar-menu > li.active > a:hover {
		background: linear-gradient(90deg, rgba(54, 153, 255, 0.2) 0%, rgba(54, 153, 255, 0.08) 100%);
	}

	.sidebar-menu > li > a i {
		font-size: 18px;
		min-width: 32px;
		margin-right: 12px;
		text-align: center;
	}

	.sidebar.collapsed .sidebar-menu > li > a {
		justify-content: center;
		padding: 16px 0;
		position: relative;
		overflow: visible;
		border-left: 0 !important;
	}

	/* When hovering, align items to left */
	.sidebar.collapsed:hover .sidebar-menu > li > a {
		justify-content: flex-start;
		padding: 12px 20px;
	}

	.sidebar.collapsed .sidebar-menu > li > a i {
		margin-right: 0;
		font-size: 22px;
		transition: all 0.3s ease;
	}

	/* When hovering over collapsed sidebar, adjust icon size smoothly */
	.sidebar.collapsed:hover .sidebar-menu > li > a i {
		margin-right: 15px;
		font-size: 18px;
	}

	.sidebar.collapsed .sidebar-menu > li.active > a {
		background: rgba(54, 153, 255, 0.2);
		border-left: 0;
	}

	.sidebar.collapsed .sidebar-menu > li > a:hover {
		background: rgba(54, 153, 255, 0.15);
	}

	/* Tooltip on hover when collapsed */
	/* Tooltips only show when sidebar is collapsed AND not being hovered */
	.sidebar.collapsed:not(:hover) .sidebar-menu > li > a:hover::after {
		content: attr(data-title);
		position: absolute;
		left: 90px;
		top: 50%;
		transform: translateY(-50%);
		background: #2c3e50;
		color: #fff;
		padding: 10px 16px;
		border-radius: 8px;
		white-space: nowrap;
		z-index: 10001;
		font-size: 13px;
		font-weight: 500;
		box-shadow: 0 8px 20px rgba(0,0,0,0.4);
		border: 1px solid rgba(54, 153, 255, 0.3);
		animation: tooltipSlide 0.25s ease;
	}

	.sidebar.collapsed:not(:hover) .sidebar-menu > li > a:hover::before {
		content: '';
		position: absolute;
		left: 80px;
		top: 50%;
		transform: translateY(-50%);
		width: 0;
		height: 0;
		border-top: 6px solid transparent;
		border-bottom: 6px solid transparent;
		border-right: 8px solid #2c3e50;
		z-index: 10001;
		animation: tooltipSlide 0.25s ease;
	}

	@keyframes tooltipSlide {
		from {
			opacity: 0;
			transform: translateY(-50%) translateX(-10px);
		}
		to {
			opacity: 1;
			transform: translateY(-50%) translateX(0);
		}
	}

	.sidebar-menu .submenu {
		list-style: none;
		padding: 8px 0;
		margin: 0;
		max-height: 0;
		overflow: hidden;
		transition: max-height 0.35s ease-in-out, opacity 0.25s ease;
		background: #15151f;
		opacity: 0;
		border-left: 3px solid #007bff;
		box-shadow: inset 0 0 10px rgba(0,0,0,0.2);
	}

	.sidebar-menu li.active > .submenu {
		max-height: 2000px;
		opacity: 1;
		animation: slideDown 0.3s ease;
	}

	@keyframes slideDown {
		from {
			opacity: 0;
			transform: translateY(-10px);
		}
		to {
			opacity: 1;
			transform: translateY(0);
		}
	}

	/* Show submenu on hover when sidebar is expanded via hover */
	.sidebar.collapsed:hover .sidebar-menu li:hover > .submenu {
		max-height: 2000px;
		opacity: 1;
	}

	.sidebar-menu .submenu li a {
		display: flex;
		align-items: center;
		padding: 10px 20px 10px 52px;
		color: #7e8299;
		text-decoration: none;
		transition: all 0.2s;
		font-size: 12px;
		position: relative;
	}

	.sidebar-menu .submenu li a::before {
		content: '−';
		position: absolute;
		left: 35px;
		color: #565674;
		font-size: 12px;
		font-weight: bold;
	}

	.sidebar.collapsed .sidebar-menu .submenu {
		display: none;
	}

	/* Show submenu when sidebar is expanded via hover */
	.sidebar.collapsed:hover .sidebar-menu .submenu {
		display: block;
	}

	.sidebar-menu .submenu li a:hover {
		background: rgba(54, 153, 255, 0.06);
		color: #3699ff;
	}

	.sidebar-menu > li > a .caret {
		margin-left: auto;
		border: 4px solid transparent;
		border-top-color: rgba(255,255,255,0.6);
		border-bottom: 0;
		transition: transform 0.3s;
	}

	.sidebar-menu li.active > a .caret {
		transform: rotate(180deg);
	}

	.main-content {
		margin-left: 260px;
		min-height: 100vh;
		transition: all 0.3s ease;
		background: #f5f7fa;
		position: relative;
	}

	.top-header {
		background: #fff;
		padding: 16px 30px;
		box-shadow: 0 1px 0 rgba(0,0,0,0.05);
		display: flex;
		justify-content: space-between;
		align-items: center;
		position: sticky;
		top: 0;
		z-index: 100;
		border-bottom: 1px solid #eff2f5;
	}

	.user-info {
		display: flex;
		align-items: center;
		gap: 15px;
		color: #3f4254;
		font-size: 14px;
		font-weight: 500;
	}

	.user-info a {
		color: #3699ff;
		margin-left: 8px;
	}

	.credit-badge {
		background: #f3f6f9;
		color: #3f4254;
		padding: 8px 18px;
		border-radius: 6px;
		font-weight: 600;
		font-size: 13px;
		border: 1px solid #e4e6ef;
	}

	.credit-badge span {
		color: #3699ff;
		margin-left: 5px;
	}

	.content-area {
		padding: 25px 30px;
		width: 100%;
		box-sizing: border-box;
		min-height: 100vh;
		overflow-x: auto;
	}

	/* Fix for tables and content */
	#Contents {
		width: 100%;
		overflow-x: auto;
		overflow-y: visible;
		box-sizing: border-box;
	}

	/* Fix for wide content and forms */
	.content-area .panel,
	.content-area .panel-body,
	.content-area form {
		overflow-x: auto;
	}

	/* Ensure all content is visible */
	.main-content {
		overflow: visible !important;
		width: 100%;
	}

	#Contents > * {
		max-width: 100%;
		box-sizing: border-box;
	}

	/* Fix for collapsible panels/accordions */
	.panel-collapse {
		overflow: visible;
	}

	.panel-collapse.in {
		display: block;
		height: auto;
	}

	.panel-collapse.collapse {
		display: none;
	}

	.panel-collapse.collapse.in {
		display: block;
	}

	/* Fix for panel headers with toggle */
	.panel-heading {
		cursor: pointer;
	}

	.panel-heading[data-toggle="collapse"] {
		position: relative;
	}

	.panel-heading[data-toggle="collapse"]:hover {
		background: #f8f9fa;
	}

	/* Make sure panel body is visible */
	.panel-body {
		width: 100%;
		overflow-x: auto;
	}

	.table-responsive {
		overflow-x: auto;
		-webkit-overflow-scrolling: touch;
		width: 100%;
	}

	table {
		width: 100% !important;
		table-layout: auto;
	}

	.app_nav {
		margin-bottom: 20px;
		display: flex;
		flex-wrap: wrap;
		gap: 8px;
	}

	.app_nav .btn {
		margin-bottom: 0;
		white-space: nowrap;
	}

	/* Fix for forms and inputs */
	.form-control,
	input,
	select,
	textarea {
		max-width: 100%;
		box-sizing: border-box;
	}

	/* Fix for rows and columns */
	.row {
		margin-left: -15px;
		margin-right: -15px;
		width: 100%;
		overflow: visible;
	}

	.col-md-12,
	.col-md-6,
	.col-md-4,
	.col-md-3 {
		padding-left: 15px;
		padding-right: 15px;
		box-sizing: border-box;
	}

	/* Fix for panels and content overflow */
	.panel {
		width: 100%;
		overflow: visible;
	}

	.panel-body {
		overflow-x: auto;
		overflow-y: visible;
	}

	/* Ensure wide tables can scroll horizontally */
	.panel-body > table,
	.content-area > table {
		min-width: 100%;
	}

	/* Fix for container-fluid */
	.container-fluid {
		width: 100%;
		max-width: 100%;
		overflow: visible;
	}

	/* Scrollbar */
	.sidebar::-webkit-scrollbar {
		width: 6px;
	}

	.sidebar::-webkit-scrollbar-track {
		background: rgba(255,255,255,0.05);
	}

	.sidebar::-webkit-scrollbar-thumb {
		background: rgba(255,255,255,0.2);
		border-radius: 3px;
	}

	.sidebar::-webkit-scrollbar-thumb:hover {
		background: rgba(255,255,255,0.3);
	}

	/* Mobile Responsive */
	@media (max-width: 768px) {
		.sidebar {
			transform: translateX(-100%);
		}

		.sidebar.mobile-open {
			transform: translateX(0);
		}

		.main-content {
			margin-left: 0 !important;
			width: 100% !important;
		}

		.content-area {
			padding: 15px;
		}

		.top-header {
			padding: 12px 15px;
		}
	}

	/* Print Mode */
	@media print {
		.sidebar {
			display: none !important;
		}

		.main-content {
			margin-left: 0 !important;
			width: 100% !important;
		}

		.top-header {
			display: none !important;
		}

		.content-area {
			padding: 0;
		}
	}

	/* Smooth animations */
	.sidebar, .sidebar * {
		-webkit-font-smoothing: antialiased;
		-moz-osx-font-smoothing: grayscale;
	}

	/* Better scrolling on mobile */
	.sidebar {
		-webkit-overflow-scrolling: touch;
	}

	/* Focus states for accessibility */
	.sidebar-menu a:focus {
		outline: 2px solid #667eea;
		outline-offset: -2px;
	}
	</style>

</head>
<body>

<div class="sidebar-container">
	<!-- Sidebar -->
	<aside class="sidebar" id="sidebar">
		<div class="sidebar-header">
			<button class="sidebar-toggle" onclick="toggleSidebar()" title="Toggle Sidebar">
				<i class="fas fa-bars"></i>
			</button>
			<span class="logo">
				<a href="<?php echo $intro->app_url('home'); ?>">
					<img src="<?php echo $logo; ?>" alt="Logo"/>
				</a>
			</span>
		</div>

		<ul class="sidebar-menu">
			<!-- Dashboard -->
			<li>
				<a href="<?php echo $intro->app_url('home', 'index'); ?>" data-title="Dashboard">
					<i class="fas fa-th"></i>
					<span class="menu-text">Dashboard</span>
				</a>
			</li>

			<?php
			// Map menu icons to Font Awesome
			$icon_map = array(
				'icon-user' => 'fas fa-users',
				'icon-users' => 'fas fa-users',
				'icon-calendar' => 'fas fa-calendar-alt',
				'icon-video' => 'fas fa-play-circle',
				'icon-list' => 'fas fa-list',
				'icon-cog' => 'fas fa-cogs',
				'icon-chart' => 'fas fa-chart-bar',
				'icon-monitor' => 'fas fa-desktop',
				'icon-globe' => 'fas fa-globe',
				'icon-database' => 'fas fa-database',
				'icon-credit-card' => 'fas fa-credit-card',
				'icon-bell' => 'fas fa-bell',
				'icon-wrench' => 'fas fa-wrench',
				'icon-folder' => 'fas fa-folder',
				'icon-file' => 'fas fa-file',
				'icon-layers' => 'fas fa-layer-group',
				'icon-wifi' => 'fas fa-wifi'
			);

			// Replace icons in menu
			$menu_enhanced = $menu;
			foreach($icon_map as $old_icon => $new_icon) {
				$menu_enhanced = str_replace('<i class="' . $old_icon . '">', '<i class="' . $new_icon . '">', $menu_enhanced);
			}

			// Add data-title attributes and convert dropdowns
			$menu_enhanced = preg_replace('/<a\s+class="([^"]*)"/', '<a data-title="$1" class="$1"', $menu_enhanced);
			$menu_enhanced = str_replace('dropdown-toggle', '', str_replace('dropdown-menu', 'submenu', $menu_enhanced));
			echo $menu_enhanced;

			// Same for main menu
			$main_menu_enhanced = $main_menu;
			foreach($icon_map as $old_icon => $new_icon) {
				$main_menu_enhanced = str_replace('<i class="' . $old_icon . '">', '<i class="' . $new_icon . '">', $main_menu_enhanced);
			}
			$main_menu_enhanced = preg_replace('/<a\s+class="([^"]*)"/', '<a data-title="$1" class="$1"', $main_menu_enhanced);
			$main_menu_enhanced = str_replace('dropdown-toggle', '', str_replace('dropdown-menu', 'submenu', $main_menu_enhanced));
			echo $main_menu_enhanced;
			?>

			<!-- Logout -->
			<li>
				<a href="<?php echo admin_path; ?>login.php?maa=Logout" data-title="Logout">
					<i class="fas fa-sign-out-alt"></i>
					<span class="menu-text"><?php echo $intro->lang['logout']; ?></span>
				</a>
			</li>
		</ul>
	</aside>

	<!-- Main Content -->
	<div class="main-content">
		<header class="top-header">
			<div class="user-info">
				<span><?php echo $admin_welcome; ?></span>
				<a href="<?php echo $intro->app_url('myaccount', 'index'); ?>" class="icon-info" title="My Account"></a>
			</div>
			<div class="credit-badge">
				Credit: <span><?php echo floatval($balance); ?></span>
			</div>
		</header>

		<div class="content-area" id="Contents">

