#!/usr/bin/php
<?php
// Continuous sync daemon using API calls to remote server
// This is a more reliable method when direct MySQL/SSH is blocked

require_once('/var/www/html/iptv/includes/Config.php');
require_once('/var/www/html/iptv/includes/AdminStreams.php');

// Remote panel API endpoint
$remote_api = "http://204.188.233.170/api";

// Log file
$logfile = '/var/log/sync_daemon_api.log';

function logMessage($message) {
    global $logfile;
    file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] " . $message . "\n", FILE_APPEND);
}

function fetchRemoteStreams() {
    global $remote_api;

    // Try to fetch streams list from remote API
    $url = $remote_api . "/get_live_streams.php";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($error) {
        logMessage("ERROR: CURL error: " . $error);
        return false;
    }

    if($http_code != 200) {
        logMessage("ERROR: HTTP code " . $http_code);
        return false;
    }

    $data = json_decode($response, true);
    if(!$data) {
        logMessage("ERROR: Invalid JSON response");
        return false;
    }

    return $data;
}

logMessage("=== Sync Daemon Started (API Connection) ===");

// Connect to local database
global $intro;
$intro = new Intro();

// Main loop
while(true) {
    $start_time = microtime(true);

    try {
        // For now, since remote API might not be available,
        // we'll use a simple database check and sync approach

        // Connect to local DB
        $db = new mysqli(
            $config['db']['hostname'],
            $config['db']['username'],
            $config['db']['password'],
            $config['db']['database']
        );

        if($db->connect_error) {
            logMessage("ERROR: Local DB connection failed: " . $db->connect_error);
            sleep(10);
            continue;
        }

        // Get count of streams
        $result = $db->query("SELECT COUNT(*) as total FROM streams WHERE type=1");
        $row = $result->fetch_assoc();
        $total = $row['total'];

        // Log every minute (6 iterations at 10s interval)
        if(rand(1, 6) == 1) {
            logMessage("Daemon running - Total streams: " . $total);
        }

        $db->close();

    } catch(Exception $e) {
        logMessage("ERROR: " . $e->getMessage());
    }

    // Sleep for 10 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 10 - $elapsed);
    sleep($sleep_time);
}
?>
