#!/usr/bin/php
<?php
// Daemon to sync stream status every 3 seconds
// Run this in background: php sync_stream_status_daemon.php &

require_once('/var/www/html/iptv/includes/Config.php');

// Log file
$logfile = '/var/log/sync_stream_daemon.log';

// Write startup message
file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] Stream sync daemon started\n", FILE_APPEND);

// Connect to local database
function getDbConnection($config) {
    $db = new mysqli(
        $config['db']['hostname'],
        $config['db']['username'],
        $config['db']['password'],
        $config['db']['database']
    );

    if($db->connect_error) {
        file_put_contents($GLOBALS['logfile'], "[" . date('Y-m-d H:i:s') . "] ERROR: Could not connect to local database: " . $db->connect_error . "\n", FILE_APPEND);
        return null;
    }

    return $db;
}

// Remote panel credentials
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Main loop - run forever
while(true) {
    $start_time = microtime(true);

    // Get database connection
    $db = getDbConnection($config);

    if($db) {
        // Get stream status from remote
        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
               escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
               " \"mysql " . $remote_db . " -N -e 'SELECT id, disabled, direct_streaming_on_demand FROM streams WHERE type=0;'\" 2>&1";

        $result = shell_exec($cmd);

        if(!empty($result) && strpos($result, 'ERROR') === false) {
            $lines = explode("\n", trim($result));
            $updated = 0;

            foreach($lines as $line) {
                if(empty($line)) continue;

                $parts = explode("\t", $line);
                if(count($parts) < 3) continue;

                $id = intval($parts[0]);
                $disabled = intval($parts[1]);
                $on_demand = intval($parts[2]);

                // Convert remote status to local status
                $local_status = $disabled == 0 ? 1 : 0;
                $direct_source = $on_demand == 0 ? 1 : 0;

                // Update local streams table
                $update_streams = "UPDATE streams SET
                                   status = $local_status,
                                   direct_source = $direct_source
                                   WHERE id = $id";

                if($db->query($update_streams)) {
                    $updated++;
                }

                // Update streams_sys table
                $check_sys = "SELECT stream_id FROM streams_sys WHERE stream_id = $id";
                $result_sys = $db->query($check_sys);

                if($result_sys && $result_sys->num_rows > 0) {
                    $update_sys = "UPDATE streams_sys SET on_demand = $on_demand WHERE stream_id = $id";
                    $db->query($update_sys);
                } else {
                    $insert_sys = "INSERT INTO streams_sys (stream_id, on_demand) VALUES ($id, $on_demand)";
                    $db->query($insert_sys);
                }
            }

            // Log only every 20 iterations (every minute) to avoid filling logs
            if(rand(1, 20) == 1) {
                file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] Synced $updated streams\n", FILE_APPEND);
            }
        }

        $db->close();
    }

    // Sleep for 3 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 3 - $elapsed);
    usleep($sleep_time * 1000000);
}
?>
