#!/usr/bin/php
<?php
// Enhanced daemon to sync COMPLETE stream status every 3 seconds
// Syncs: disabled, ondemand, PID, uptime, bitrate, stream_status

require_once('/var/www/html/iptv/includes/Config.php');

// Log file
$logfile = '/var/log/sync_stream_daemon.log';

// Write startup message
file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] Enhanced stream sync daemon started\n", FILE_APPEND);

// Connect to local database
function getDbConnection($config) {
    $db = new mysqli(
        $config['db']['hostname'],
        $config['db']['username'],
        $config['db']['password'],
        $config['db']['database']
    );

    if($db->connect_error) {
        file_put_contents($GLOBALS['logfile'], "[" . date('Y-m-d H:i:s') . "] ERROR: Could not connect to local database: " . $db->connect_error . "\n", FILE_APPEND);
        return null;
    }

    return $db;
}

// Remote panel credentials
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Main loop - run forever
while(true) {
    $start_time = microtime(true);

    // Get database connection
    $db = getDbConnection($config);

    if($db) {
        // Get stream basic info from remote
        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
               escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
               " \"mysql " . $remote_db . " -N -e 'SELECT id, disabled, direct_streaming_on_demand FROM streams WHERE type=0;'\" 2>&1";

        $result = shell_exec($cmd);

        // Get PIDs and uptime for running streams
        $pid_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
                   " \"ps -eo pid,etime,args | grep 'ffmpeg.*streams/[0-9]*_' | grep -v grep | grep -v sudo\" 2>&1";
        $pid_result = shell_exec($pid_cmd);

        // Parse PIDs and uptimes
        $stream_info = array();
        if(!empty($pid_result)) {
            $pid_lines = explode("\n", trim($pid_result));
            foreach($pid_lines as $pid_line) {
                if(preg_match('/^\s*(\d+)\s+([\d:]+).*streams\/(\d+)_/', $pid_line, $matches)) {
                    $pid = intval($matches[1]);
                    $etime = trim($matches[2]);
                    $stream_id = intval($matches[3]);

                    // Convert etime to seconds
                    $parts = explode(':', $etime);
                    if(count($parts) == 2) {
                        // MM:SS
                        $seconds = intval($parts[0]) * 60 + intval($parts[1]);
                    } elseif(count($parts) == 3) {
                        // HH:MM:SS
                        $seconds = intval($parts[0]) * 3600 + intval($parts[1]) * 60 + intval($parts[2]);
                    } else {
                        // D-HH:MM:SS or just seconds
                        $seconds = 0;
                    }

                    $stream_started = time() - $seconds;

                    $stream_info[$stream_id] = array(
                        'pid' => $pid,
                        'stream_started' => $stream_started
                    );
                }
            }
        }

        if(!empty($result) && strpos($result, 'ERROR') === false) {
            $lines = explode("\n", trim($result));
            $updated = 0;

            foreach($lines as $line) {
                if(empty($line)) continue;

                $parts = explode("\t", $line);
                if(count($parts) < 3) continue;

                $id = intval($parts[0]);
                $disabled = intval($parts[1]);
                $on_demand = intval($parts[2]);

                // Convert remote status to local status
                // NOTE: DO NOT sync status and direct_source from remote - these are controlled locally only
                // $local_status = $disabled == 0 ? 1 : 0;
                // $direct_source = $on_demand == 0 ? 1 : 0;

                // Determine stream_status based on PID
                // stream_status: 0 = running, 1 = stopped
                $has_pid = isset($stream_info[$id]);
                $stream_status = $has_pid ? 0 : 1;
                $pid = $has_pid ? $stream_info[$id]['pid'] : null;
                $stream_started = $has_pid ? $stream_info[$id]['stream_started'] : null;

                // Update local streams table
                // NOTE: Removed status and direct_source from sync - these fields are local-only now
                // Only track streams that exist locally - don't modify their status or direct_source
                $check_exists = "SELECT id FROM streams WHERE id = $id";
                $exists = $db->query($check_exists);

                if($exists && $exists->num_rows > 0) {
                    // Stream exists - just count it, don't update status/direct_source
                    $updated++;
                }

                // Update streams_sys table with full status
                $check_sys = "SELECT stream_id FROM streams_sys WHERE stream_id = $id AND server_id = 1";
                $result_sys = $db->query($check_sys);

                if($result_sys && $result_sys->num_rows > 0) {
                    // Update existing record
                    $update_sys = "UPDATE streams_sys SET
                                   on_demand = $on_demand,
                                   stream_status = $stream_status,
                                   pid = " . ($pid ? $pid : 'NULL') . ",
                                   stream_started = " . ($stream_started ? $stream_started : 'NULL') . "
                                   WHERE stream_id = $id AND server_id = 1";
                    $db->query($update_sys);
                } else {
                    // Insert new record with server_id=1 to avoid duplicates
                    $insert_sys = "INSERT INTO streams_sys (
                                   stream_id, server_id, on_demand, stream_status, pid, stream_started
                                   ) VALUES (
                                   $id, 1, $on_demand, $stream_status,
                                   " . ($pid ? $pid : 'NULL') . ",
                                   " . ($stream_started ? $stream_started : 'NULL') . "
                                   )";
                    $db->query($insert_sys);
                }
            }

            // Log every 20 iterations (every minute)
            if(rand(1, 20) == 1) {
                file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] Synced $updated streams (" . count($stream_info) . " running)\n", FILE_APPEND);
            }
        }

        $db->close();
    }

    // Sleep for 3 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 3 - $elapsed);
    usleep($sleep_time * 1000000);
}
?>
