<?php
/**
 * Detailed API Test
 */

define('_CHECK_X_ME', true);
require_once(dirname(__FILE__) . '/load2.php');
require_once(dirname(__FILE__) . '/includes/AdminStreams.php');

$stream_id = isset($_GET['id']) ? intval($_GET['id']) : 44;
$action = isset($_GET['action']) ? $_GET['action'] : 'start';

echo "<!DOCTYPE html><html><head><title>API Test</title></head><body>";
echo "<h1>Testing External Panel API</h1>";
echo "<p>Stream ID: <strong>$stream_id</strong></p>";
echo "<p>Action: <strong>$action</strong></p>";

$admin = new AdminStreams();

echo "<h2>1. Checking Stream Info on Local DB:</h2>";
global $intro;
$sql = $intro->db->query("SELECT id, stream_display_name, type FROM streams WHERE id = $stream_id");
$row = $intro->db->fetch_assoc($sql);

if($row) {
    echo "<pre>";
    print_r($row);
    echo "</pre>";
} else {
    echo "<p style='color:red'>Stream not found in local DB!</p>";
}

echo "<h2>2. Checking Stream on Remote Panel:</h2>";
$ssh_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 root@45.154.207.117 \"mysql midnight_iptv -N -e 'SELECT id, name, type FROM streams WHERE id=$stream_id;'\"";
$remote_stream = shell_exec($ssh_cmd);
echo "<pre>Remote Stream: " . htmlspecialchars($remote_stream) . "</pre>";

echo "<h2>3. Calling API ($action):</h2>";

if($action == 'start') {
    $response = $admin->startStreamViaApi($stream_id);
} elseif($action == 'stop') {
    $response = $admin->stopStreamViaApi($stream_id);
} else {
    $response = $admin->restartStreamViaApi($stream_id);
}

echo "<h3>API Response:</h3>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

$result = json_decode($response, true);
if(isset($result['result'])) {
    if($result['result'] === true) {
        echo "<p style='color:green; font-size:20px'>✓ API returned TRUE</p>";
    } else {
        echo "<p style='color:red; font-size:20px'>✗ API returned FALSE</p>";
        if(isset($result['error'])) {
            echo "<p>Error: " . htmlspecialchars($result['error']) . "</p>";
        }
    }
}

echo "<h2>4. Checking Stream Status After API Call:</h2>";
sleep(2);

// Check pids table
$ssh_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 root@45.154.207.117 \"mysql midnight_iptv -N -e 'SELECT sid, pid, server_id FROM pids WHERE sid=$stream_id LIMIT 1;'\"";
$pid_info = shell_exec($ssh_cmd);
echo "<pre>PID Info: " . htmlspecialchars($pid_info) . "</pre>";

if(empty(trim($pid_info))) {
    echo "<p style='color:orange'>⚠ No PID found - stream may not be running</p>";
} else {
    echo "<p style='color:green'>✓ Stream has PID - appears to be running</p>";
}

// Check online streams
echo "<h3>Checking Online Streams API:</h3>";
$online_url = "http://45.154.207.117:8000/api/streams/online/eJIdy5sAgD";
$online_streams = file_get_contents($online_url);
$online_data = json_decode($online_streams, true);

if(in_array($stream_id, $online_data)) {
    echo "<p style='color:green; font-size:18px'>✓ Stream $stream_id is ONLINE</p>";
} else {
    echo "<p style='color:red; font-size:18px'>✗ Stream $stream_id is NOT in online list</p>";
}

echo "<h2>5. Diagnostic URLs:</h2>";
echo "<ul>";
echo "<li><a href='?id=$stream_id&action=start'>Start Stream $stream_id</a></li>";
echo "<li><a href='?id=$stream_id&action=stop'>Stop Stream $stream_id</a></li>";
echo "<li><a href='?id=$stream_id&action=restart'>Restart Stream $stream_id</a></li>";
echo "</ul>";

echo "<h2>6. Direct API URLs:</h2>";
echo "<ul>";
echo "<li><a href='http://45.154.207.117:8000/api/streams/start/eJIdy5sAgD/$stream_id' target='_blank'>Start (External Link)</a></li>";
echo "<li><a href='http://45.154.207.117:8000/api/streams/stop/eJIdy5sAgD/$stream_id' target='_blank'>Stop (External Link)</a></li>";
echo "<li><a href='http://45.154.207.117:8000/api/streams/online/eJIdy5sAgD' target='_blank'>Online Streams (External Link)</a></li>";
echo "</ul>";

echo "</body></html>";
