<?php
/**
 * Test Bouquet External Panel Sync
 * Tests if bouquet edits properly sync to external panel
 */

define('_CHECK_X_ME', true);
require(dirname(__FILE__) . '/load2.php');

echo "<h2>Bouquet External Panel Sync Test</h2>";
echo "<p>Testing bouquet synchronization with 45.154.207.117...</p>";

$bouquet_id = 14;
$bouquet_name = 'ok';

echo "<h3>Test Parameters:</h3>";
echo "<ul>";
echo "<li>Bouquet ID: $bouquet_id</li>";
echo "<li>Bouquet Name: $bouquet_name</li>";
echo "</ul>";

// Check LOCAL database
echo "<h3>Local Database (15.204.231.210):</h3>";
$local_sql = $intro->db->query("SELECT id, bouquet_name, bouquet_channels FROM bouquets WHERE id=$bouquet_id");
$local_data = $intro->db->fetch_assoc($local_sql);

if($local_data) {
    echo "<pre>";
    echo "ID: " . $local_data['id'] . "\n";
    echo "Name: " . $local_data['bouquet_name'] . "\n";
    echo "Channels (JSON): " . $local_data['bouquet_channels'] . "\n";

    $channels = json_decode($local_data['bouquet_channels'], true);
    if(is_array($channels)) {
        echo "Channels (Array): " . implode(', ', $channels) . "\n";
        echo "Total Channels: " . count($channels) . "\n";
    }
    echo "</pre>";
} else {
    echo "<p style='color:red;'>Bouquet not found in local database!</p>";
}

// Check REMOTE database
echo "<h3>Remote Database (45.154.207.117):</h3>";

// Get bouquet info
$remote_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT id, name FROM bouquets WHERE name='$bouquet_name';\\\"\"";
$remote_bouquet = shell_exec($remote_cmd);

echo "<h4>Bouquet Info:</h4>";
echo "<pre>$remote_bouquet</pre>";

// Get bouquet streams
$remote_streams_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT sid FROM bouquets_sids WHERE bid=$bouquet_id ORDER BY ordering;\\\"\"";
$remote_streams = shell_exec($remote_streams_cmd);

echo "<h4>Streams in Bouquet:</h4>";
echo "<pre>";
if(!empty($remote_streams)) {
    $stream_ids = explode("\n", trim($remote_streams));
    $stream_ids = array_filter($stream_ids);
    echo implode(', ', $stream_ids) . "\n";
    echo "Total Streams: " . count($stream_ids) . "\n";
} else {
    echo "<span style='color:red;'>No streams found!</span>\n";
}
echo "</pre>";

// Compare
echo "<h3>Comparison:</h3>";
if($local_data && is_array($channels)) {
    $local_channels = $channels;
    $remote_channels = !empty($remote_streams) ? array_filter(explode("\n", trim($remote_streams))) : [];

    echo "<ul>";
    echo "<li>Local Channels: " . count($local_channels) . "</li>";
    echo "<li>Remote Channels: " . count($remote_channels) . "</li>";

    if(count($local_channels) == count($remote_channels)) {
        // Check if arrays match
        $match = true;
        foreach($local_channels as $idx => $channel_id) {
            if(!isset($remote_channels[$idx]) || $remote_channels[$idx] != $channel_id) {
                $match = false;
                break;
            }
        }

        if($match) {
            echo "<li style='color:green; font-weight:bold;'>✅ SYNCED! Local and remote match perfectly!</li>";
        } else {
            echo "<li style='color:orange; font-weight:bold;'>⚠️ COUNT MATCHES but ORDER DIFFERS</li>";
            echo "<li>Local Order: " . implode(', ', $local_channels) . "</li>";
            echo "<li>Remote Order: " . implode(', ', $remote_channels) . "</li>";
        }
    } else {
        echo "<li style='color:red; font-weight:bold;'>❌ NOT SYNCED! Count mismatch!</li>";
        echo "<li>Local: " . implode(', ', $local_channels) . "</li>";
        echo "<li>Remote: " . implode(', ', $remote_channels) . "</li>";
    }
    echo "</ul>";
}

echo "<hr>";
echo "<h3>Test Sync Function:</h3>";
echo "<p>Click button below to manually trigger sync for this bouquet:</p>";

echo '<form method="post">';
echo '<input type="hidden" name="test_sync" value="1">';
echo '<button type="submit" style="padding:10px 20px; background:#007bff; color:white; border:none; border-radius:5px; cursor:pointer;">🔄 Trigger Sync Now</button>';
echo '</form>';

// Handle manual sync test
if(isset($_POST['test_sync']) && $local_data) {
    echo "<div style='background:#fff3cd; padding:15px; border:2px solid #ffc107; border-radius:5px; margin-top:20px;'>";
    echo "<h4>Triggering Sync...</h4>";

    require_once('apps/bouquets.php');
    $bouquet = new Bouquets_AppAdmin('bouquets', '/iptv/index.php/bouquets');

    // Get channels
    $channels = json_decode($local_data['bouquet_channels'], true);

    // Call private method using reflection
    $reflection = new ReflectionClass($bouquet);
    $method = $reflection->getMethod('syncBouquetStreamsToRemote');
    $method->setAccessible(true);

    echo "<p>Calling syncBouquetStreamsToRemote('{$local_data['bouquet_name']}', " . count($channels) . " streams)...</p>";
    $result = $method->invoke($bouquet, $local_data['bouquet_name'], $channels);

    echo "<p style='color:green; font-weight:bold;'>✅ Sync completed! Result: " . ($result ? 'Success' : 'Failed') . "</p>";
    echo "<p><a href='test_bouquet_sync.php'>Refresh to see results</a></p>";
    echo "</div>";
}

echo "<hr>";
echo "<p><a href='test_bouquet_sync.php'>🔄 Refresh Test</a> | ";
echo "<a href='index.php/bouquets/Form?t=edit&id=$bouquet_id'>✏️ Edit Bouquet</a> | ";
echo "<a href='index.php/bouquets/index'>📋 All Bouquets</a></p>";
