<?php
/**
 * Test Categories Sync - Compare Remote vs Local
 */

define('_CHECK_X_ME', true);
require(dirname(__FILE__) . '/load2.php');

echo "<h2>Categories Comparison: Remote vs Local</h2>";
echo "<style>
    table { border-collapse: collapse; width: 100%; margin: 20px 0; }
    th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
    th { background: #667eea; color: white; }
    .remote { background: #e3f2fd; }
    .local { background: #f3e5f5; }
    .match { background: #c8e6c9; }
    .missing { background: #ffcdd2; }
</style>";

// Get remote categories
echo "<h3>Remote Categories (45.154.207.117):</h3>";
$remote_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT id, name, type, parent, ordering FROM categories ORDER BY type, id;\\\"\"";
$remote_result = shell_exec($remote_cmd);

$remote_cats = [];
if(!empty($remote_result)) {
    $lines = explode("\n", trim($remote_result));
    foreach($lines as $line) {
        if(empty(trim($line))) continue;
        $parts = explode("\t", $line);
        if(count($parts) >= 3) {
            $type_map = ['0' => 'live', '1' => 'movie', '2' => 'series'];
            $remote_cats[] = [
                'id' => $parts[0],
                'name' => $parts[1],
                'type' => $type_map[$parts[2]] ?? 'live',
                'type_num' => $parts[2],
                'parent' => $parts[3] ?? '0',
                'ordering' => $parts[4] ?? '0'
            ];
        }
    }
}

// Get local categories
$local_sql = $intro->db->query("SELECT id, category_name, category_type, parent_id, cat_order FROM stream_categories ORDER BY category_type, id");
$local_cats = [];
while($row = $intro->db->fetch_assoc($local_sql)) {
    $local_cats[] = [
        'id' => $row['id'],
        'name' => $row['category_name'],
        'type' => $row['category_type'],
        'parent' => $row['parent_id'],
        'ordering' => $row['cat_order']
    ];
}

// Display comparison
echo "<table>";
echo "<tr>
    <th colspan='6' style='background:#667eea;'>Remote Categories (" . count($remote_cats) . ")</th>
    <th colspan='5' style='background:#764ba2;'>Local Categories (" . count($local_cats) . ")</th>
</tr>";
echo "<tr>
    <th>ID</th><th>Name</th><th>Type</th><th>Parent</th><th>Order</th><th>Status</th>
    <th>ID</th><th>Name</th><th>Type</th><th>Parent</th><th>Order</th>
</tr>";

$max_rows = max(count($remote_cats), count($local_cats));
for($i = 0; $i < $max_rows; $i++) {
    $remote = isset($remote_cats[$i]) ? $remote_cats[$i] : null;
    $local = isset($local_cats[$i]) ? $local_cats[$i] : null;

    $status = '';
    if($remote && $local && $remote['id'] == $local['id']) {
        $status = '✅ Match';
        $row_class = 'match';
    } elseif($remote && !$local) {
        $status = '⚠️ Only Remote';
        $row_class = 'remote';
    } elseif(!$remote && $local) {
        $status = '⚠️ Only Local';
        $row_class = 'local';
    } else {
        $status = '❌ Different';
        $row_class = '';
    }

    echo "<tr class='$row_class'>";

    // Remote columns
    if($remote) {
        echo "<td>{$remote['id']}</td>";
        echo "<td>{$remote['name']}</td>";
        echo "<td>{$remote['type']}</td>";
        echo "<td>{$remote['parent']}</td>";
        echo "<td>{$remote['ordering']}</td>";
        echo "<td><strong>$status</strong></td>";
    } else {
        echo "<td colspan='6' class='missing'>-</td>";
    }

    // Local columns
    if($local) {
        echo "<td>{$local['id']}</td>";
        echo "<td>{$local['name']}</td>";
        echo "<td>{$local['type']}</td>";
        echo "<td>{$local['parent']}</td>";
        echo "<td>{$local['ordering']}</td>";
    } else {
        echo "<td colspan='5' class='missing'>-</td>";
    }

    echo "</tr>";
}
echo "</table>";

// Summary by type
echo "<h3>Summary by Type:</h3>";
echo "<table style='width:500px;'>";
echo "<tr><th>Type</th><th>Remote</th><th>Local</th><th>Status</th></tr>";

$types = ['live', 'movie', 'series'];
foreach($types as $type) {
    $remote_count = count(array_filter($remote_cats, function($c) use ($type) { return $c['type'] == $type; }));
    $local_count = count(array_filter($local_cats, function($c) use ($type) { return $c['type'] == $type; }));
    $status_icon = ($remote_count == $local_count) ? '✅' : '⚠️';

    echo "<tr>";
    echo "<td><strong>" . ucfirst($type) . "</strong></td>";
    echo "<td>$remote_count</td>";
    echo "<td>$local_count</td>";
    echo "<td>$status_icon</td>";
    echo "</tr>";
}
echo "</table>";

echo "<hr>";
echo "<p><a href='test_categories.php'>🔄 Refresh</a> | ";
echo "<a href='index.php/categories/index?category_type=live'>📋 Live Categories</a> | ";
echo "<a href='index.php/categories/index?category_type=movie'>📋 Movie Categories</a> | ";
echo "<a href='index.php/categories/index?category_type=series'>📋 Series Categories</a></p>";
