<?php
/**
 * Direct test of setStreamModeOnRemote function
 * This bypasses the web interface to test the sync directly
 */

define('_CHECK_X_ME', true);
require(dirname(__FILE__) . '/load2.php');

echo "<h2>Direct Sync Test</h2>";
echo "<p>Testing setStreamModeOnRemote function directly...</p>";

// Include AdminStreams
require_once('includes/AdminStreams.php');

// Create instance
$adminStreams = new AdminStreams();

// Test parameters
$stream_id = 3;
$stream_name = 'AlKuwait News';
$on_demand_mode = 'live_ondemand';
$servers = [1];
$probesize = 512000;

// Calculate remote_on_demand
$remote_on_demand = ($on_demand_mode == 'on' || $on_demand_mode == 'live_ondemand') ? 1 : 0;

echo "<h3>Test Parameters:</h3>";
echo "<ul>";
echo "<li>Stream ID: $stream_id</li>";
echo "<li>Stream Name: $stream_name</li>";
echo "<li>OnDemand Mode: $on_demand_mode</li>";
echo "<li>Remote OnDemand Value: $remote_on_demand</li>";
echo "<li>Servers: " . json_encode($servers) . "</li>";
echo "<li>Probesize: $probesize</li>";
echo "</ul>";

// Check BEFORE
echo "<h3>Remote DB BEFORE:</h3>";
$before_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT id, name, direct_streaming_on_demand, on_demand_servers FROM streams WHERE id=3;\\\"\"";
$before = shell_exec($before_cmd);
echo "<pre>$before</pre>";

// Call the sync function
echo "<h3>Calling setStreamModeOnRemote...</h3>";
$result = $adminStreams->setStreamModeOnRemote($stream_name, $remote_on_demand, $servers, $probesize);
echo "<p>Result: " . htmlspecialchars($result ? $result : 'NULL/Empty') . "</p>";

// Wait
echo "<p>Waiting 2 seconds...</p>";
flush();
sleep(2);

// Check AFTER
echo "<h3>Remote DB AFTER:</h3>";
$after = shell_exec($before_cmd);
echo "<pre>$after</pre>";

// Compare
$before_parts = preg_split('/\s+/', trim($before));
$after_parts = preg_split('/\s+/', trim($after));

echo "<h3>Comparison:</h3>";
if(count($before_parts) >= 4 && count($after_parts) >= 4) {
    echo "<ul>";
    echo "<li>direct_streaming_on_demand: {$before_parts[2]} → {$after_parts[2]}</li>";
    echo "<li>on_demand_servers: {$before_parts[3]} → {$after_parts[3]}</li>";
    echo "</ul>";

    if($after_parts[2] == '1' && strpos($after_parts[3], '["1"]') !== false) {
        echo "<p style='color:green; font-weight:bold;'>✅ SUCCESS! Remote database updated correctly!</p>";
    } else {
        echo "<p style='color:red; font-weight:bold;'>❌ FAILED! Remote database not updated!</p>";
        echo "<p>Expected: direct_streaming_on_demand=1, on_demand_servers=[\"1\"]</p>";
        echo "<p>Got: direct_streaming_on_demand={$after_parts[2]}, on_demand_servers={$after_parts[3]}</p>";
    }
}

echo "<hr>";
echo "<p><a href='test_direct_sync.php'>Run Test Again</a></p>";
