<?php
// Test all EPG endpoints

header('Content-Type: application/json');

$tests = [];

// Test 1: EPG API
$epg_url = 'http://localhost/iptv/api/player/epg.php?stream_id=1085&limit=1';
$epg_result = @file_get_contents($epg_url);
$epg_data = json_decode($epg_result, true);

$tests['epg_api'] = [
    'url' => $epg_url,
    'working' => !empty($epg_data) && is_array($epg_data),
    'count' => is_array($epg_data) ? count($epg_data) : 0,
    'first_title' => isset($epg_data[0]['title']) ? base64_decode($epg_data[0]['title']) : 'N/A'
];

// Test 2: XMLTV
$xmltv_url = 'http://localhost/iptv/xmltv.php?username=test&password=test';
$xmltv_result = @file_get_contents($xmltv_url);
$tests['xmltv'] = [
    'url' => $xmltv_url,
    'working' => !empty($xmltv_result) && strpos($xmltv_result, '<?xml') !== false,
    'size' => strlen($xmltv_result),
    'has_espn' => strpos($xmltv_result, 'espn.us') !== false
];

// Test 3: Player API EPG
$player_url = 'http://localhost/player_api.php?action=get_short_epg&stream_id=1085&username=test&password=test&limit=1';
$player_result = @file_get_contents($player_url);
$player_data = json_decode($player_result, true);

$tests['player_api'] = [
    'url' => $player_url,
    'working' => isset($player_data['epg_listings']) && !empty($player_data['epg_listings']),
    'count' => isset($player_data['epg_listings']) ? count($player_data['epg_listings']) : 0
];

// Test 4: Check activate response
$tests['activate_urls'] = [
    'epg_api' => 'https://chatti.tmaxhosting.com/iptv/api/player/{user}/{pass}/epg/short/{stream_id}',
    'xmltv_api' => 'https://chatti.tmaxhosting.com/iptv/xmltv.php?username={user}&password={pass}'
];

echo json_encode($tests, JSON_PRETTY_PRINT);
?>
