<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>اختبار إعدادات السرفر الخارجي</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
            border-bottom: 3px solid #3498db;
            padding-bottom: 10px;
        }
        .test-section {
            margin: 25px 0;
            padding: 20px;
            background: #ecf0f1;
            border-radius: 5px;
        }
        .success {
            color: #27ae60;
            font-weight: bold;
        }
        .error {
            color: #e74c3c;
            font-weight: bold;
        }
        .warning {
            color: #f39c12;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }
        table td {
            padding: 10px;
            border: 1px solid #bdc3c7;
        }
        table td:first-child {
            background: #34495e;
            color: white;
            font-weight: bold;
            width: 30%;
        }
        .icon {
            font-size: 20px;
            margin-left: 10px;
        }
    </style>
</head>
<body>

<div class="container">
    <h1><span class="icon">🔧</span> اختبار إعدادات السرفر الخارجي</h1>

    <?php
    require_once('includes/RemotePanelConfig.php');

    echo '<div class="test-section">';
    echo '<h2>📋 الإعدادات الحالية</h2>';
    echo '<table>';

    $settings = RemotePanelConfig::getSettings();
    foreach($settings as $key => $value) {
        if($key === 'pass') {
            $value = str_repeat('*', strlen($value));
        }
        echo '<tr><td>' . htmlspecialchars($key) . '</td><td>' . htmlspecialchars($value) . '</td></tr>';
    }

    echo '</table>';
    echo '</div>';

    // Test 1: Database Connection
    echo '<div class="test-section">';
    echo '<h2>🔌 اختبار 1: الاتصال بقاعدة البيانات</h2>';

    $conn = RemotePanelConfig::getConnection();
    if($conn) {
        echo '<p class="success">✅ الاتصال بقاعدة البيانات ناجح!</p>';

        // Get stream count
        $result = $conn->query("SELECT COUNT(*) as count FROM streams");
        if($result) {
            $row = $result->fetch_assoc();
            echo '<p>عدد القنوات في السرفر الخارجي: <strong>' . $row['count'] . '</strong></p>';
        }

        $conn->close();
    } else {
        echo '<p class="error">❌ فشل الاتصال بقاعدة البيانات</p>';
    }

    echo '</div>';

    // Test 2: SSH Connection
    echo '<div class="test-section">';
    echo '<h2>🖥️ اختبار 2: الاتصال عبر SSH</h2>';

    $result = RemotePanelConfig::sshExecute('echo "SSH OK"');
    if(trim($result) === 'SSH OK') {
        echo '<p class="success">✅ الاتصال عبر SSH ناجح!</p>';

        // Get system info
        $uptime = RemotePanelConfig::sshExecute('uptime');
        echo '<p>معلومات النظام: <code>' . htmlspecialchars(trim($uptime)) . '</code></p>';
    } else {
        echo '<p class="error">❌ فشل الاتصال عبر SSH</p>';
        echo '<p>النتيجة: <code>' . htmlspecialchars($result) . '</code></p>';
    }

    echo '</div>';

    // Test 3: API Connection
    echo '<div class="test-section">';
    echo '<h2>🌐 اختبار 3: الاتصال بواجهة API</h2>';

    $api_url = RemotePanelConfig::getApiUrl();
    echo '<p>رابط API: <code>' . htmlspecialchars($api_url) . '</code></p>';

    $ch = curl_init($api_url . '/test');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($http_code > 0) {
        echo '<p class="success">✅ API يستجيب (رمز: ' . $http_code . ')</p>';
    } else {
        echo '<p class="warning">⚠️ API غير متاح (قد يكون هذا طبيعياً إذا كان API يتطلب مصادقة)</p>';
    }

    echo '</div>';

    // Test 4: Daemon Status
    echo '<div class="test-section">';
    echo '<h2>⚙️ اختبار 4: حالة Daemons</h2>';

    exec('ps aux | grep -E "auto_sync_daemon|sync_online_users" | grep -v grep', $output);
    if(count($output) >= 2) {
        echo '<p class="success">✅ جميع Daemons تعمل بشكل صحيح (' . count($output) . ' عملية)</p>';
        foreach($output as $line) {
            echo '<p style="font-size:11px;"><code>' . htmlspecialchars($line) . '</code></p>';
        }
    } else {
        echo '<p class="error">❌ بعض Daemons غير نشطة</p>';
    }

    echo '</div>';

    // Test 5: Recent Sync Activity
    echo '<div class="test-section">';
    echo '<h2>📊 اختبار 5: نشاط المزامنة الأخير</h2>';

    if(file_exists('/var/log/auto_sync_daemon.log')) {
        $log_lines = file('/var/log/auto_sync_daemon.log');
        $recent_lines = array_slice($log_lines, -5);

        echo '<p>آخر 5 سطور من سجل المزامنة:</p>';
        echo '<div style="background:#2c3e50;color:#ecf0f1;padding:15px;border-radius:5px;font-family:monospace;font-size:12px;">';
        foreach($recent_lines as $line) {
            echo htmlspecialchars($line) . '<br>';
        }
        echo '</div>';
    } else {
        echo '<p class="warning">⚠️ ملف السجل غير موجود</p>';
    }

    echo '</div>';
    ?>

    <div class="test-section">
        <h2>✅ الخلاصة</h2>
        <p>جميع الاختبارات اكتملت! يمكنك الآن تعديل إعدادات السرفر الخارجي من خلال:</p>
        <p><strong>Settings → API V6 Settings → Remote Panels Configuration</strong></p>
    </div>

</div>

</body>
</html>
