<?php
/**
 * Test Script for Stream Fix System
 * يختبر النظام الجديد لإصلاح مشكلة القنوات
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>اختبار نظام إصلاح القنوات</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            direction: rtl;
        }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .info { color: blue; }
        .test-section {
            background: #f5f5f5;
            padding: 15px;
            margin: 10px 0;
            border-radius: 5px;
        }
        pre {
            background: #333;
            color: #0f0;
            padding: 10px;
            border-radius: 5px;
            overflow-x: auto;
        }
    </style>
</head>
<body>
    <h1>🔧 اختبار نظام إصلاح القنوات</h1>

<?php
require_once __DIR__ . '/includes/Config.php';

try {
    $pdo = new PDO(
        "mysql:host={$config['db']['hostname']};dbname={$config['db']['database']};charset=utf8",
        $config['db']['username'],
        $config['db']['password']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo '<div class="test-section">';
    echo '<h2>✓ الاتصال بقاعدة البيانات</h2>';
    echo '<p class="success">تم الاتصال بقاعدة البيانات بنجاح</p>';
    echo '</div>';

    // Test 1: Check live directory
    echo '<div class="test-section">';
    echo '<h2>1. فحص مجلد البث المباشر</h2>';
    if (file_exists(__DIR__ . '/live/index.php')) {
        echo '<p class="success">✓ ملف /live/index.php موجود</p>';
    } else {
        echo '<p class="error">✗ ملف /live/index.php غير موجود</p>';
    }

    if (file_exists(__DIR__ . '/live/.htaccess')) {
        echo '<p class="success">✓ ملف /live/.htaccess موجود</p>';
    } else {
        echo '<p class="error">✗ ملف /live/.htaccess غير موجود</p>';
    }
    echo '</div>';

    // Test 2: Check database
    echo '<div class="test-section">';
    echo '<h2>2. فحص قاعدة البيانات</h2>';

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM streams WHERE type = 1");
    $result = $stmt->fetch();
    echo "<p class="info">عدد القنوات المباشرة: <strong>{$result['total']}</strong></p>";

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM streams WHERE type = 1 AND status = 1");
    $result = $stmt->fetch();
    echo "<p class="success">عدد القنوات النشطة: <strong>{$result['total']}</strong></p>";

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM streams WHERE type = 1 AND status = 0");
    $result = $stmt->fetch();
    echo "<p class="error">عدد القنوات المعطلة: <strong>{$result['total']}</strong></p>";
    echo '</div>';

    // Test 3: Sample streams
    echo '<div class="test-section">';
    echo '<h2>3. عينة من القنوات</h2>';
    $stmt = $pdo->query("SELECT id, stream_display_name, stream_source, status FROM streams WHERE type = 1 ORDER BY RAND() LIMIT 5");
    echo '<table border="1" cellpadding="5" style="width:100%; border-collapse: collapse;">';
    echo '<tr><th>ID</th><th>الاسم</th><th>عدد الروابط</th><th>الحالة</th><th>رابط الاختبار</th></tr>';

    while ($row = $stmt->fetch()) {
        $sources = json_decode($row['stream_source'], true);
        $source_count = is_array($sources) ? count($sources) : 0;
        $status = $row['status'] == 1 ? '<span class="success">نشط</span>' : '<span class="error">معطل</span>';

        // Get first user for testing
        $user_stmt = $pdo->query("SELECT username, password FROM users LIMIT 1");
        $user = $user_stmt->fetch();

        $test_url = '';
        if ($user) {
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'];
            $test_url = $protocol . '://' . $host . '/iptv/live/' . $user['username'] . '/' . $user['password'] . '/' . $row['id'] . '.ts';
            $test_link = '<a href="' . htmlspecialchars($test_url) . '" target="_blank">اختبر</a>';
        } else {
            $test_link = '<span class="error">لا يوجد مستخدمين</span>';
        }

        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . htmlspecialchars($row['stream_display_name']) . '</td>';
        echo '<td>' . $source_count . '</td>';
        echo '<td>' . $status . '</td>';
        echo '<td>' . $test_link . '</td>';
        echo '</tr>';
    }
    echo '</table>';
    echo '</div>';

    // Test 4: Check Apache mod_rewrite
    echo '<div class="test-section">';
    echo '<h2>4. فحص Apache</h2>';

    if (function_exists('apache_get_modules')) {
        $modules = apache_get_modules();
        if (in_array('mod_rewrite', $modules)) {
            echo '<p class="success">✓ mod_rewrite مفعل</p>';
        } else {
            echo '<p class="error">✗ mod_rewrite غير مفعل - يجب تفعيله!</p>';
            echo '<pre>sudo a2enmod rewrite<br>sudo systemctl restart apache2</pre>';
        }
    } else {
        echo '<p class="info">⚠ لا يمكن التحقق من mod_rewrite (استخدم CLI للفحص)</p>';
    }
    echo '</div>';

    // Test 5: Stream checker script
    echo '<div class="test-section">';
    echo '<h2>5. سكربت فحص القنوات</h2>';
    if (file_exists(__DIR__ . '/check_and_fix_streams.php')) {
        echo '<p class="success">✓ السكربت موجود</p>';

        // Get the secret key
        $content = file_get_contents(__DIR__ . '/check_and_fix_streams.php');
        if (preg_match('/\$SECRET_KEY = [\'"]([^\'"]+)[\'"]/', $content, $matches)) {
            $key = $matches[1];
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'];
            $check_url = $protocol . '://' . $host . '/iptv/check_and_fix_streams.php?key=' . urlencode($key);

            echo '<p class="info">لتشغيل السكربت عبر المتصفح:</p>';
            echo '<pre>' . htmlspecialchars($check_url) . '</pre>';
            echo '<p><a href="' . htmlspecialchars($check_url) . '" target="_blank" class="success">اضغط هنا لتشغيل فحص القنوات</a></p>';
        }

        echo '<p class="info">لتشغيل السكربت عبر SSH:</p>';
        echo '<pre>cd /var/www/html/iptv<br>php check_and_fix_streams.php</pre>';
    } else {
        echo '<p class="error">✗ السكربت غير موجود</p>';
    }
    echo '</div>';

    // Test 6: Instructions
    echo '<div class="test-section">';
    echo '<h2>6. التعليمات</h2>';
    echo '<p><strong>لإصلاح مشكلة "Unable to Play":</strong></p>';
    echo '<ol>';
    echo '<li>قم بتشغيل سكربت فحص القنوات أعلاه</li>';
    echo '<li>سيقوم السكربت بفحص جميع القنوات وحذف الروابط المعطلة</li>';
    echo '<li>القنوات التي لا تعمل سيتم تعطيلها تلقائياً</li>';
    echo '<li>يمكنك جدولة السكربت ليعمل تلقائياً كل 6 ساعات باستخدام cron</li>';
    echo '</ol>';

    echo '<p><strong>رابط الـ M3U للتطبيق:</strong></p>';
    $user_stmt = $pdo->query("SELECT username, password FROM users LIMIT 1");
    $user = $user_stmt->fetch();
    if ($user) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        $m3u_url = $protocol . '://' . $host . '/iptv/get.php?username=' . $user['username'] . '&password=' . $user['password'] . '&type=m3u_plus&output=ts';
        echo '<pre>' . htmlspecialchars($m3u_url) . '</pre>';
    }
    echo '</div>';

} catch (Exception $e) {
    echo '<div class="test-section">';
    echo '<p class="error">خطأ: ' . $e->getMessage() . '</p>';
    echo '</div>';
}
?>

</body>
</html>
