# TiatroTV 2026 VIP - Media3 Version

## Project Overview
Complete rebuild of TiatroTV with AndroidX Media3 player instead of ExoPlayer2.

### Features
✅ AndroidX Media3 ExoPlayer (latest)
✅ HLS (m3u8) support
✅ DASH support
✅ MP4 support
✅ TS streams support
✅ Live TV playback
✅ VOD playback
✅ Series playback
✅ Subtitles support
✅ Quality selection
✅ Playback speed control
✅ Fullscreen toggle
✅ Auto reconnect for unstable streams
✅ Improved buffering
✅ Background/Foreground handling

### API Integration
- API URL: `http://tmaxhosting.com/iptv/V6APK/API-V6APK.php`
- XOR Encryption Key: `KvuZRm365wk5Sz&Xy.Zx`
- Protocol: V6APK with XOR encryption

### Build Requirements
- Android Studio Hedgehog | 2023.1.1 or newer
- JDK 17
- Android SDK 34
- Gradle 8.2+
- Kotlin 1.9+

### Build Instructions

1. **Open in Android Studio:**
   ```bash
   File > Open > Select /tmp/NewTiatroApp
   ```

2. **Sync Gradle:**
   ```bash
   File > Sync Project with Gradle Files
   ```

3. **Build APK:**
   ```bash
   Build > Build Bundle(s) / APK(s) > Build APK(s)
   ```

4. **Or via command line:**
   ```bash
   ./gradlew assembleRelease
   ```

### Package Info
- **Package Name:** com.mbm_soft.tiatropro
- **Min SDK:** 21 (Android 5.0)
- **Target SDK:** 34 (Android 14)
- **Version:** 2026.1

### Directory Structure
```
NewTiatroApp/
├── src/main/
│   ├── java/com/mbm_soft/tiatropro/
│   │   ├── api/          # API classes
│   │   ├── player/       # Media3 player
│   │   ├── ui/           # All activities
│   │   └── utils/        # Utilities
│   ├── res/              # All resources from original
│   └── AndroidManifest.xml
├── build.gradle
└── README.md
```

### Next Steps
1. Copy this folder to machine with Android Studio
2. Open project
3. Build APK
4. Test on device

### Original App Resources
✅ All icons extracted
✅ All layouts extracted
✅ All strings extracted
✅ All drawables extracted
✅ Same design preserved
