<?php 
$time_start = microtime(true);
error_reporting(1);
ob_start('ob_gzhandler');
@date_default_timezone_set('Asia/Gaza');
include('./api_cfg_v6.php');
include('./API6Core.php');
if( isset($_CFG['debug']) && $_CFG['debug'] ) 
{
    $data = "------------POST-----------------\n";
    foreach( $_POST as $key => $val ) 
    {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "------------_REQUEST-----------------\n";
    foreach( $_REQUEST as $key => $val ) 
    {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= ('------------PHP/INPUT=' . file_get_contents('php://input') . "\n");
    $data .= "------------END--POST-----------------\n";
    $data .= "---------SERVER------------\n";
    foreach( $_SERVER as $key => $val ) 
    {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "========END========REQUEST========\n\n";
    @file_put_contents('./logs/' . $_SERVER['REMOTE_ADDR'] . '_.log', $data, FILE_APPEND | LOCK_EX);
}
class APIv6 extends API6Core
{
    public function __construct()
    {
        global $_CFG;
        if( !isset($_POST) ) 
        {
            parse_str(file_get_contents('php://input'), $_POST);
            if( isset($_CFG['debug_post']) && $_CFG['debug_post'] ) 
            {
                @file_put_contents('./logs/post_is_empty.log', @$this->ip() . ' | ' . ' new post = ' . @var_export($_POST, true) . "\n", FILE_APPEND | LOCK_EX);
            }
        }
        if( !isset($_POST['json']) ) 
        {
            $input = @file_get_contents('php://input');
            if( preg_match('/json/', $input) ) 
            {
                $_POST['json'] = str_replace('json=', '', $input);
                if( isset($_CFG['debug_post']) && $_CFG['debug_post'] ) 
                {
                    @file_put_contents('./logs/post_not_set_json.log', @$this->ip() . ' = ' . $input . "\n", FILE_APPEND | LOCK_EX);
                }
            }
            else
            {
                if( isset($_CFG['debug_post']) && $_CFG['debug_post'] ) 
                {
                    @file_put_contents('./logs/post_is_vital.log', @$this->ip() . ' = ' . $input . "\n", FILE_APPEND | LOCK_EX);
                }
                $this->_die('error: you seems did not send the POSTFIELDS: json=base64(xor_data)');
            }
        }
        $base64 = str_replace(' ', '+', urldecode($_POST['json']));
        $base64 = base64_decode($base64);
        $jsonRow = $this->runXOR($base64);
        $json = json_decode($jsonRow, true);
        if( !is_array($json) ) 
        {
            $this->_die('error: converting json data. Data you sent is: ' . $jsonRow . " \n\r");
        }
        if( !isset($json['mode']) ) 
        {
            $this->_die('error: no mode');
        }
        if( !isset($json['code']) ) 
        {
            $this->_die('error: no code');
        }
        if( !isset($json['mac']) ) 
        {
            $this->_die('error: no mac');
        }
        if( !isset($json['sn']) ) 
        {
            $this->_die('error: no serial');
        }
        if( isset($json['model']) ) 
        {
            $this->model = $json['model'];
        }
        if( isset($json['chipid']) ) 
        {
            $this->chipid = $json['chipid'];
        }
        if( isset($json['firmware_ver']) ) 
        {
            $this->firmware_ver = $json['firmware_ver'];
        }
        if( isset($json['catid']) ) 
        {
            $this->catid = $json['catid'];
        }
        if( isset($json['movie_id']) ) 
        {
            $this->movie_id = $json['movie_id'];
        }
        if( isset($json['series_id']) ) 
        {
            $this->series_id = intval($json['series_id']);
        }
        if( isset($json['code_id']) ) 
        {
            $this->code_id = $json['code_id'];
        }
        if( isset($json['read']) ) 
        {
            $this->read = $json['read'];
        }
        if( isset($json['reply']) ) 
        {
            $this->reply = $json['reply'];
        }
        if( isset($json['osd_test']) ) 
        {
            $this->osd = $json['osd_test'];
        }
        if( isset($json['pkg_id']) ) 
        {
            $this->pkg_id = intval($json['pkg_id']);
        }
        if( isset($json['limit']) ) 
        {
            $this->limit = intval($json['limit']);
        }
        if( $this->limit > 0 ) 
        {
            $this->limit_qry = ' LIMIT 0,' . $this->limit;
        }
        $_POST['data'] = $json;
        $_POST['mode'] = $json['mode'];
        $this->mac_enable = true;
        $this->connect();
        $this->config();
        $this->code = mysqli_real_escape_string($this->link, $json['code']);
        $this->mac = mysqli_real_escape_string($this->link, $json['mac']);
        $this->sn = mysqli_real_escape_string($this->link, $json['sn']);
        $this->chipid = mysqli_real_escape_string($this->link, $this->chipid);
        $this->model = mysqli_real_escape_string($this->link, $this->model);
        $this->firmware_ver = mysqli_real_escape_string($this->link, $this->firmware_ver);
        $this->ip = $this->ip();
        $this->get_free_codes();
        $this->getMasterCodes();
        $this->capture();
        $this->iptv_stream_host = trim($this->conf['iptv_host']);
        if( !is_dir('./cache/') ) 
        {
            $this->cache = false;
        }
    }
    public function active()
    {
        $this->ProccessActivation($this->code, $this->sn, $this->mac, $this->ip);
    }
    public function ProccessActivation($code, $sn, $mac, $ip)
    {
        global $GROUP;
        global $_CFG;
        if( in_array($code, $this->free_codes) ) 
        {
            $this->proccess_free_code($code, $sn, $mac, $ip);
        }
        $why_worng_code = '';
        $qry = $sql_grp = '';
        $txt = 'byCode';
        $codeMacQry = 'c.userid=u.id';
        if( isset($this->MasterCodes[$code]) ) 
        {
            if( $this->MasterCodes[$code] == 1 ) 
            {
                $qry = ' AND mac=\'' . $this->mac . '\'';
                $txt = 'byMAC';
                $codeMacQry = 'c.userid=u.id';
            }
            else if( $this->MasterCodes[$code] == 2 ) 
            {
                $qry = ' AND serial=\'' . $this->sn . '\'';
                $txt = 'bySerial';
                $codeMacQry = 'c.userid=u.id';
            }
        }
        if( isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes' ) 
        {
            $sql_grp = ',(SELECT group_id from solus_admin adm where adm.adminid=cod.adminid) AS groupID';
        }
        $sql_code = $this->query('SELECT * ' . (' ' . $sql_grp . ' ') . ' from ' . PREFIX . ('_codes cod where cod.code=\'' . $code . '\' ' . $qry . ';'));
        if( mysqli_num_rows($sql_code) == 1 ) 
        {
            $row_code = mysqli_fetch_array($sql_code);
            $code_status = $row_code['status'];
            $code_replaced = $row_code['code_replaced'];
            $groupID = intval($row_code['groupID']);
            if( $groupID != 0 && isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes' && intval($GROUP) != 0 && $groupID != $GROUP ) 
            {
                $this->reply(119, 'This code is not for this Brand.', '@CodeNotForBrand');
            }
            if( $code_status == 1 ) 
            {
                if( $this->mac != $row_code['mac'] ) 
                {
                    $why_worng_code = ' MAC not match ';
                }
                if( $this->sn != $row_code['serial'] ) 
                {
                    $why_worng_code .= ' SN not match ';
                }
            }
            if( $row_code['inputBy'] == 0 ) 
            {
                if( $row_code['mac'] == 'reset_me' && $row_code['serial'] == 'reset_me' ) 
                {
                    $this->query('update ' . PREFIX . ('_codes set mac=\'' . $mac . '\',serial=\'' . $sn . '\' where id=\'' . $row_code['id'] . '\';'));
                }
                if( $code_replaced != '' && $code_status == 5 ) 
                {
                    $this->reply(115, 'Code is replaced. Please use this code: ' . $code_replaced, '@Replaced');
                }
            }
            if( $code_status == 0 ) 
            {
                $this->activate_new_code($row_code);
                exit();
            }
            else if( $code_status == 2 ) 
            {
                $this->reply(102, 'The Code is suspended', '@Suspended ' . $txt);
            }
            else if( $code_status == 3 ) 
            {
                $this->reply(103, 'The Code is Deleted!', '@Deleted ' . $txt);
            }
        }
        else
        {
            $this->insertIP('notfound');
            $this->reply(103, 'The Code is not Found!', '@Wrong ' . $txt);
        }
        $qry = '';
        $qry = 'SELECT c.id,c.code,c.userid,c.date_expire,c.status,c.osd_msg,u.username, u.password  FROM solus_codes c, users u ' . (' WHERE c.userid=u.id AND c.code = \'' . $code . '\' AND c.mac=\'' . $this->mac . '\' AND c.serial=\'' . $this->sn . '\';');
        $result = $this->query($qry);
        if( mysqli_num_rows($result) == 0 ) 
        {
            $this->reply(103, 'The Code is Not valid for this device.', '@NotValidForDevice ' . $txt . ' ' . $why_worng_code);
        }
        $row = mysqli_fetch_array($result);
        $username = $row['username'];
        $password = $row['password'];
        $this->user = $row['username'];
        $this->pass = $row['password'];
        $this->code_id = $row['id'];
        $userid = intval($row['userid']);
        $status = intval($row['status']);
        $expire = date('Y-m-d', $row['date_expire']);
        if( $expire < date('Y-m-d') ) 
        {
            $status = 4;
        }
        switch( $status ) 
        {
            case 1:
                if( isset($_CFG['update_password']) && $_CFG['update_password'] == 'yes' ) 
                {
                    $password = $this->generateRandomString(10);
                    $this->query('UPDATE `users` set `password`=\'' . $password . '\' where `id`=' . $userid . ';');
                }
                $this->query('UPDATE solus_codes set protocol=6 where id=' . $this->code_id . ';');
                if( $this->osd == '' ) 
                {
                    $this->osd = (string)$row['osd_msg'];
                }
                $array = [
                    'status' => 100, 
                    'message' => 'The Code is active', 
                    'osd' => $this->osd . ' ', 
                    'expire' => $this->expire_date($row['date_expire']), 
                    'user_agent' => trim($this->conf['user_agent']), 
                    'code_id' => $this->code_id
                ];
                $this->insertModel();
                $this->msg($array, 'ReActivation');
                break;
            case 2:
                $this->reply(102, 'The Code is suspended', '@Suspended');
                break;
            case 3:
                $this->reply(103, 'The Code is Deleted', '@Deleted Code');
                break;
            case 4:
                $this->reply(104, 'The Code is Expired', '@Expired Code');
                break;
        }
    }
    public function activate_new_code($row)
    {
        if( $this->conf['multi_code'] == 1 ) 
        {
            $this->activate_new_code_on_same_box($row);
        }
        $days = intval($row['days']);
        $period = intval($row['period']);
        $free_days = intval($row['free_days']);
        $code = trim($row['code']);
        $fullname = trim($row['fullname']);
        $forced_country = trim($row['forced_country']);
        $codeID = intval($row['id']);
        if( in_array($period, $this->free) ) 
        {
            $dd = $period - 100;
            $exp_date = strtotime('+' . $dd . ' days');
        }
        else
        {
            $exp_date = strtotime('+' . $period . ' month');
            if( $free_days > 0 ) 
            {
                $exp_date = strtotime('+' . $free_days . ' days', $exp_date);
            }
        }
        if( $row['inputBy'] == 0 ) 
        {
            $username = $code;
        }
        else
        {
            $username = trim($row['username']);
        }
        $data['member_id'] = 1;
        $data['username'] = $username;
        $data['password'] = rand() . uniqid();
        $data['exp_date'] = $exp_date;
        $data['admin_notes'] = (string)$fullname . ((($row['inputBy'] == 1 ? ' MAC' : $row['inputBy'] == 2) ? ' SN' : ''));
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        $data['bouquet'] = '[' . $row['bouquets'] . ']';
        $data['max_connections'] = 1;
        $data['created_at'] = time();
        $data['created_by'] = 1;
        $data['forced_country'] = $forced_country;
        if( $row['allowed_uagent'] != '' ) 
        {
            $data['allowed_ua'] = $row['allowed_uagent'];
        }
        $sql = $this->query('SELECT id,username from users where username = \'' . $username . '\' LIMIT 1;');
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $xtID = $this->insert('users', $data);
            $this->insert('user_output', [
                'user_id' => $xtID, 
                'access_output_id' => 2
            ]);
        }
        else
        {
            $xrow = mysqli_fetch_array($sql);
            $xtID = $xrow['id'];
        }
        if( $row['inputBy'] == 0 ) 
        {
            $whatToUpdate = 'mac=\'' . $this->mac . '\',serial=\'' . $this->sn . '\'';
            $txt = 'Code';
        }
        else if( $row['inputBy'] == 1 ) 
        {
            $whatToUpdate = 'serial=\'' . $this->sn . '\'';
            $txt = 'MAC';
        }
        else if( $row['inputBy'] == 2 ) 
        {
            $whatToUpdate = 'mac=\'' . $this->mac . '\'';
            $txt = 'Serial';
        }
        $now = time();
        $up = $this->query('update solus_codes set ' . (' status=1,' . $whatToUpdate . ',date_start=\'' . $now . '\',date_expire=\'' . $exp_date . '\',userid=\'' . $xtID . '\',protocol=6,model=\'' . $this->model . '\' ') . (' where id=' . $codeID . ';'));
        if( $this->link->error != '' ) 
        {
            $this->reply(112, 'Error With Database, Please contact admin. ' . $this->link->error, '@Database Error = ' . $this->link->error);
        }
        $this->log('Activate By ' . $txt . ' |expire = ' . date('Y-m-d H:i:s', $exp_date));
        $array = [
            'status' => 100, 
            'message' => 'The Code has been activated successfully', 
            'osd' => (string)$this->osd, 
            'expire' => $this->expire_date($exp_date), 
            'user_agent' => trim($this->conf['user_agent']), 
            'code_id' => $codeID
        ];
        $this->code_id = $codeID;
        $this->insertModel();
        $this->msg($array, 'Success ' . $txt);
    }
    public function boolVerifyUser($func = '')
    {
        $sql = 'SELECT c.code,c.adminid,c.transid,c.date_expire,c.status,c.bouquets,c.output,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.userid=u.id AND c.code = \'' . $this->code . '\' AND c.mac=\'' . $this->mac . '\' AND c.serial=\'' . $this->sn . '\' LIMIT 1;');
        $result = $this->query($sql);
        $num = mysqli_num_rows($result);
        if( $num == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $this->adminid = intval($row['adminid']);
            $this->transid = intval($row['transid']);
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = trim($row['output']);
            if( $row['bouquets'] != '' ) 
            {
                $this->bouquets = $row['bouquets'];
            }
            return true;
        }
        $this->error('Error: Something Wrong with code. check MAC/Serial.', 'Code Not found in boolVerifyUser() from : ' . $func);
    }
    public function packages()
    {
        $CacheFile = '';
        $this->boolVerifyUser('packages');
        if( $this->bouquets == '' ) 
        {
            $this->error('Error: no Packages for this code.', 'Err Packages is Empty');
        }
        if( $this->cache ) 
        {
            $CacheFile = 'pkgs_' . $this->output . '_' . sha1(str_replace(',', '_', $this->bouquets)) . '.txt';
            $this->cache_display($CacheFile, true);
        }
        $ar = [];
        $bq = explode(',', $this->bouquets);
        if( strlen($this->conf['exclude_movies_pkg']) >= 1 ) 
        {
            $ex = explode(',', $this->conf['exclude_movies_pkg']);
            $bq = array_diff($bq, $ex);
        }
        if( is_array($bq) ) 
        {
            $qry = 'SELECT SQL_CACHE * FROM bouquets  WHERE ' . ((strlen($this->bouquets) == 1 && $this->bouquets == 1 ? 'id!=1' : 'id IN (' . implode(',', $bq) . ')')) . ' order by view_order asc;';
            $sql = $this->query($qry);
            $i = 0;
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                $icon = (trim($row['bouquet_icon']) == '' ? 'http://intro.ps/uploads/logo/tv.png' : trim($row['bouquet_icon']));
                $ar[] = [
                    'pkg_id' => $row['id'], 
                    'pkg_name' => $row['bouquet_name'], 
                    'pkg_type' => 0, 
                    'pkg_icon' => $icon, 
                    'pkg_order' => $row['view_order'], 
                    'pkg_parent' => 0, 
                    'pkg_channels' => $this->channels($row['bouquet_channels'], $row['id'])
                ];
            }
            $this->msg(['packages' => $ar], '', $CacheFile);
        }
    }
    public function lite_packages()
    {
        $CacheFile = '';
        $this->boolVerifyUser('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_pkgs_' . sha1(str_replace(',', '_', $this->bouquets)) . '.txt';
            $this->cache_display($CacheFile);
        }
        $ar = [];
        $bq = explode(',', $this->bouquets);
        if( is_array($bq) ) 
        {
            if( strlen($this->conf['exclude_movies_pkg']) > 1 ) 
            {
                $ex = explode(',', $this->conf['exclude_movies_pkg']);
                $bq = array_diff($bq, $ex);
            }
            $qry = 'SELECT SQL_CACHE * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;';
            $sql = mysqli_query($this->link, $qry);
            $i = 0;
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                $bouquet_channels = @json_decode($row['bouquet_channels'], true);
                $ch_count = @count($bouquet_channels);
                $ar[] = [
                    'pkg_id' => $row['id'], 
                    'pkg_name' => $row['bouquet_name'], 
                    'pkg_icon' => trim($row['bouquet_icon'])
                ];
            }
            $this->msg($ar, '', $CacheFile);
        }
    }
    public function lite_channels()
    {
        $CacheFile = '';
        $ar = [];
        $pkg_id = $this->pkg_id;
        if( $pkg_id == 0 ) 
        {
            $ar[] = [
                'stream_id' => 0, 
                'stream_name' => 'error: Package ID is 0', 
                'stream_pkg_id' => 0, 
                'stream_icon' => '', 
                'stream_order' => 0, 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        $this->boolVerifyUser('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_chans_' . $pkg_id . '.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT SQL_CACHE * FROM bouquets WHERE id=' . $pkg_id . ';');
        $row = mysqli_fetch_array($sql);
        $ar = $this->channels($row['bouquet_channels'], $row['id']);
        $this->msg($ar, '', $CacheFile);
    }
    public function sat2iptv()
    {
        $ar = [];
        $qry = '';
        $this->isSatToIPTV = true;
        if( intval($this->conf['enable_sat2iptv']) == 0 ) 
        {
            exit();
        }
        $this->boolVerifyUser('sat2ip');
        if( isset($this->stb_groups) && count($this->stb_groups) >= 1 ) 
        {
            $qry = ' WHERE stb_group IN (' . implode(',', $this->stb_groups) . ') ';
        }
        if( $this->cache ) 
        {
            $CacheFile = 'sat2iptv.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT SQL_CACHE * FROM ' . PREFIX . ('_stb_to_iptv stb ' . $qry . ' order by angle asc, stb_ch_name ASC;'));
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $stream = str_replace([
                '{type}', 
                '{user}', 
                '{pass}', 
                '{ch}'
            ],

			[
                'live', 
                $this->user, 
                $this->pass, 
                $row['ch_id']
            ], trim($this->conf['iptv_host']));
            $ar[] = [
                'channel_name' => $row['stb_ch_name'], 
                'angle' => $row['angle'], 
                'tp' => $row['tp'], 
                'pol' => $row['pol'], 
                'sid' => $row['sid'], 
                'stream_url' => $stream
            ];
        }
        $this->msg($ar, '', $CacheFile);
    }
    public function channels($data, $bq_id)
    {
        global $_CFG;
        $ar = [];
        $data = json_decode($data, true);
        $i = 0;
        foreach( $data as $ch ) 
        {
            $i++;
            $ch = intval($ch);
            $sql_ch = $this->query('SELECT SQL_CACHE id, stream_display_name,stream_source,  stream_icon, streams.`order` as view_order,movie_subtitles,notes FROM streams ' . (' WHERE `type`!=2 AND id=' . $ch . ' AND stream_display_name NOT LIKE \'%*%\' ') . ' AND stream_display_name NOT LIKE \'%===%\';');
            $row = mysqli_fetch_array($sql_ch);
            if( $row['id'] != '' ) 
            {
                if( $this->output == '' ) 
                {
                    $this->output = 'ts';
                }
                if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' ) 
                {
                    $stream = json_decode($row['stream_source'], true);
                    if( is_array($stream) ) 
                    {
                        $stream = $stream[0];
                    }
                    if( $stream == '' ) 
                    {
                        $stream = trim($row['stream_source']);
                    }
                }
                else
                {
                    $stream = str_replace([
                        '{type}', 
                        '{user}', 
                        '{pass}', 
                        '{ch}', 
                        '.ts'
                    ], [
                        'live', 
                        $this->user, 
                        $this->pass, 
                        $row['id'], 
                        '.' . $this->output
                    ], trim($this->conf['iptv_host']));
                }
                if( isset($_CFG['user_stream_source']) && $_CFG['user_stream_source'] == 'Yes' ) 
                {
                    $stream = json_decode($row['stream_source'], true);
                    if( is_array($stream) ) 
                    {
                        $stream = $stream[0];
                    }
                    if( $stream == '' ) 
                    {
                        $stream = trim($row['stream_source']);
                    }
                }
                $stream_display_name = str_replace([
                    '{', 
                    '}'
                ], ' ', $row['stream_display_name']);
                $icon = trim($row['stream_icon']);
                if( preg_match('/base64/', $icon) ) 
                {
                    $icon = '';
                }
                if( isset($_CFG['strm_url_rep']) && isset($_CFG['strm_url_with']) ) 
                {
                    $stream = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $stream);
                }
							
                $ar[] = [
                    'stream_id' => $ch, 
                    'stream_name' => $stream_display_name, 
                    'stream_pkg_id' => $bq_id, 
                    'stream_icon' => $icon, 
                    'stream_order' => $i, 
					'stream_epg' => 'http://lynxiptv.com/player_api.php?username='.$this->user.'&password='.$this->pass.'&action=get_short_epg&stream_id='.$ch.'',
                    'stream_url' => $stream
                ];
                if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' ) 
                {
                    $ar[count($ar) - 1]['subtitle'] = trim($row['movie_subtitles']);
                    $ar[count($ar) - 1]['color'] = $row['notes'];
                }
            }
        }
        return $ar;
    }
    public function series_cat()
    {
        global $_CFG;
        if( isset($_CFG['UseIntroSeries']) && $_CFG['UseIntroSeries'] == 'Yes' ) 
        {
            $this->IntroSeriesCat();
            exit();
        }
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $this->boolVerifyUser('series_cat');
            $mv = new Movies($this, 'series_cat');
            exit();
        }
        $this->movies_cat('series');
    }
    public function movies_kids()
    {
        $ex1 = explode(',', $this->conf['vod_kids']);
        $em = implode(',', $ex1);
        $this->movies_cat('movie', ' AND id IN (' . $em . ') ');
    }
    public function movies_netflix()
    {
        $ex1 = explode(',', $this->conf['vod_netflix']);
        $em = implode(',', $ex1);
        $this->movies_cat('movie', ' AND id IN (' . $em . ') ');
    }
    public function music()
    {
        $ex1 = explode(',', $this->conf['vod_music']);
        $ids = implode(',', $ex1);
        if( $ids == '' ) 
        {
            $ids = 0;
        }
        $this->boolVerifyUser('music');
        $qry = $parent = '';
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT SQL_CACHE * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id IN (' . $ids . ') ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'music_files' => $this->getMusicFiles($row['id'], $row, $icon)
            ];
        }
        $this->msg($ar);
    }
    public function getMusicFiles($catid, $rowFather, $icon)
    {
        $ar = [];
        $sql = $this->query('SELECT SQL_CACHE id, stream_display_name,stream_source,  stream_icon, streams.`order` as view_order,target_container FROM streams ' . (' WHERE category_id=' . $catid . ' AND stream_display_name NOT LIKE \'%*%\' ') . ' AND stream_display_name NOT LIKE \'%===%\' ORDER BY id DESC;');
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            $stream = str_replace([
                '{type}', 
                '{user}', 
                '{pass}', 
                '{ch}', 
                '.ts', 
                '.m3u8', 
                '.{container}'
            ], [
                'movie', 
                $this->user, 
                $this->pass, 
                $row['id'], 
                $target_container, 
                $target_container, 
                $target_container
            ], trim($this->conf['iptv_host_vod']));
            $ar[] = [
                'id' => $row['id'], 
                'title' => $row['stream_display_name'], 
                'catid' => (string)$catid, 
                'icon' => trim($row['stream_icon']), 
                'stream_url' => $stream
            ];
        }
        return $ar;
    }
    public function lite_vod_cat($category_type = 'movie')
    {
        $this->boolVerifyUser('movies_cat');
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT SQL_CACHE * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ORDER BY ' . $this->CatOrder . ' LIMIT 50');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'cat_view_order' => $i
            ];
        }
        $this->msg($ar);
    }
    public function movies_cat($category_type = 'movie', $qryVod = '')
    {
        $this->boolVerifyUser('movies_cat');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 && $category_type == 'movie' ) 
        {
            $mv = new Movies($this, 'movies_cat');
            exit();
        }
        $qry = $parent = '';
        if( $qryVod == '' && isset($this->conf['remote_movies_use']) && $this->conf['remote_movies_use'] == 1 ) 
        {
            $ex1 = explode(',', $this->conf['vod_kids']);
            $ex2 = explode(',', $this->conf['vod_series']);
            $ex3 = explode(',', $this->conf['vod_netflix']);
            $excludeIds = array_merge($ex1, $ex2, $ex3);
            if( count($excludeIds) >= 1 ) 
            {
                $ids = implode(',', $excludeIds);
                if( $ids != '' ) 
                {
                    $qryVod = ' AND id NOT IN (' . $ids . ')  ';
                }
            }
        }
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $catsBouqts = '';
        if( isset($_CFG['CatFromBouquets']) && $_CFG['CatFromBouquets'] == 'Yes' ) 
        {
            $bq = explode(',', $this->bouquets);
            $sqlB = $this->query('SELECT SQL_CACHE * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;');
            $chans = [];
            while( $rowB = mysqli_fetch_array($sqlB) ) 
            {
                $bouquet_channels = @json_decode($rowB['bouquet_channels'], true);
                foreach( $bouquet_channels as $ch ) 
                {
                    $chans[] = $ch;
                }
            }
            $catsBouqts = ' AND id in (select category_id from streams where id IN(' . implode(',', $chans) . '))';
        }
        $ar = [];
        $qry = 'SELECT SQL_CACHE * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ' . $qryVod . ' ' . $catsBouqts . ' ORDER BY ' . $this->CatOrder);
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'cat_view_order' => ($row['cat_order'] == 0 ? $i : $row['cat_order']), 
                'sub_cats' => $this->subMoviesCat($row['id'], $row, $icon)
            ];
        }
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar[] = [
                'cat_id' => 0, 
                'cat_name' => 'error no-series-cat', 
                'cat_icon' => (string)$qry, 
                'cat_view_order' => 0, 
                'sub_cats' => []
            ];
        }
        $this->msg($ar);
    }
    public function subMoviesCat($parent, $rowFather, $iconFather)
    {
        $parent = intval($parent);
        $ar = [];
        $qry = 'SELECT SQL_CACHE * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id=' . $parent . ' ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'sub_id' => $row['id'], 
                'sub_name' => $row['category_name'], 
                'sub_icon' => $icon, 
                'sub_view_order' => ($row['cat_order'] == 0 ? $i : $row['cat_order'])
            ];
        }
        if( $i == 0 ) 
        {
            $ar[] = [
                'sub_id' => $rowFather['id'], 
                'sub_name' => $rowFather['category_name'], 
                'sub_icon' => $iconFather, 
                'sub_view_order' => ($rowFather['cat_order'] == 0 ? $i : $rowFather['cat_order'])
            ];
        }
        return $ar;
    }
    public function movies_list()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUser('movies_list');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'movies_list');
            exit();
        }
        $qry = '';
        if( $this->catid == 'all' ) 
        {
        }
        else
        {
            $qry = 'AND category_id=' . intval($this->catid);
        }
        if( intval($this->catid) == 0 && $this->catid != 'all' ) 
        {
            $ar[] = [
                'id' => '', 
                'title' => 'Error: you must pass (catid) in url.', 
                'catid' => '', 
                'icon' => '', 
                'view_order' => '', 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        if( isset($this->conf['MoviesOrder']) && $this->conf['MoviesOrder'] != '' ) 
        {
            $movies_order = $this->conf['MoviesOrder'];
        }
        else
        {
            $movies_order = 'streams.`order` ASC';
        }
        $this->SetLimitForBadBox('bad_stb_tot_vod');
        $sql_ch = $this->query('SELECT id, stream_display_name,category_id,stream_source,  stream_icon, streams.`order` as view_order,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 ' . $qry . ' ORDER BY ' . $movies_order . ' ' . $this->limit_qry . ';'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            $i++;
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' ) 
            {
                $stream = json_decode($row['stream_source'], true);
                if( is_array($stream) ) 
                {
                    $stream = $stream[0];
                }
                if( $stream == '' ) 
                {
                    $stream = trim($row['stream_source']);
                }
            }
            else
            {
                $stream = str_replace([
                    '{type}', 
                    '{user}', 
                    '{pass}', 
                    '{ch}', 
                    '.ts', 
                    '.m3u8', 
                    '.{container}'
                ], [
                    'movie', 
                    $this->user, 
                    $this->pass, 
                    $row['id'], 
                    $target_container, 
                    $target_container, 
                    $target_container
                ], trim($this->conf['iptv_host_vod']));
            }
            if( isset($_CFG['strm_url_rep']) && isset($_CFG['strm_url_with']) ) 
            {
                $stream = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $stream);
            }
            $movie_propeties = json_decode($row['movie_propeties'], true);
            if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' ) 
            {
                $stream_icon = trim($movie_propeties['movie_image']);
            }
            else
            {
                $stream_icon = trim($row['stream_icon']);
            }
            $ar[] = [
                'id' => $row['id'], 
                'title' => $row['stream_display_name'], 
                'catid' => $row['category_id'], 
                'icon' => $stream_icon, 
                'view_order' => $i, 
                'stream_url' => $stream
            ];
        }
        if( $i == 0 ) 
        {
            $ar[] = [
                'id' => 0, 
                'title' => 'empty category: this is sample', 
                'catid' => 0, 
                'icon' => 'https://www.sample-videos.com/images/imgw.png', 
                'view_order' => 0, 
                'stream_url' => 'https://www.sample-videos.com/video/mp4/720/big_buck_bunny_720p_5mb.mp4'
            ];
        }
        $this->msg($ar);
    }
    public function series_latest()
    {
        $this->boolVerifyUser('series_latest');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'series_latest');
            exit();
        }
    }
    public function series_details()
    {
        $this->boolVerifyUser('series_details');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'series_details');
            exit();
        }
    }
    public function episode_info()
    {
        $this->boolVerifyUser('episode_info');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'episode_info');
            exit();
        }
    }
    public function movies_info()
    {
        $this->boolVerifyUser('movies_info');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'movies_info');
            exit();
        }
        $qry = '';
        $id = intval($this->movie_id);
        $sql = $this->query('SELECT SQL_CACHE id, stream_display_name,category_id,  stream_icon,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 AND id=' . $id . ';'));
        $row = mysqli_fetch_array($sql);
        $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
        $stream = str_replace([
            '{type}', 
            '{user}', 
            '{pass}', 
            '{ch}', 
            '.ts', 
            '.m3u8', 
            '.{container}'
        ], [
            'movie', 
            $this->user, 
            $this->pass, 
            $row['id'], 
            $target_container, 
            $target_container, 
            $target_container
        ], trim($this->conf['iptv_host_vod']));
        $movie_propeties = json_decode($row['movie_propeties'], true);
        if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' ) 
        {
            $stream_icon = trim($movie_propeties['movie_image']);
        }
        else
        {
            $stream_icon = trim($row['stream_icon']);
        }
        $genre = (trim($movie_propeties['genre']) == '' ? 'Genre: N/A' : $movie_propeties['genre']);
        $plot = (trim($movie_propeties['plot']) == '' ? 'Plot: N/A' : $movie_propeties['plot']);
        $cast = (trim($movie_propeties['cast']) == '' ? 'Cast: N/A' : $movie_propeties['cast']);
        $duration = (isset($movie_propeties['duration']) && trim($movie_propeties['duration']) != '' ? $movie_propeties['duration'] : 'N/A');
        $bitrate = (trim($movie_propeties['bitrate']) == '' ? 'N/A' : $movie_propeties['bitrate']);
        $rating = (trim($movie_propeties['rating']) == '' ? 'N/A' : $movie_propeties['rating']);
        $ar[] = [
            'id' => $row['id'], 
            'stream_display_name' => $row['stream_display_name'], 
            'category_id' => intval($row['category_id']), 
            'stream_icon' => $stream_icon, 
            'stream_url' => $stream, 
            'movie_image' => $movie_propeties['movie_image'], 
            'genre' => $genre, 
            'plot' => $plot, 
            'cast' => substr($cast, 0, 250), 
            'duration' => $duration, 
            'bitrate' => $bitrate, 
            'rate' => $rating, 
            'rating' => $rating
        ];
        $this->msg($ar);
    }
    public function series_netflix()
    {
        $catids = $this->conf['vod_series'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function series_cartoon()
    {
        $catids = $this->conf['vod_kids'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function SetLimitForBadBox($bad_stb_tot)
    {
        if( isset($this->conf['bad_stb_limit_trans']) && trim($this->conf['bad_stb_limit_trans']) != '' && isset($this->conf[$bad_stb_tot]) ) 
        {
            $trans = explode(',', $this->conf['bad_stb_limit_trans']);
            if( in_array($this->transid, $trans) ) 
            {
                $this->limit_qry = ' LIMIT ' . intval($this->conf[$bad_stb_tot]);
            }
        }
    }
    public function series_list()
    {
        global $_CFG;
        $this->boolVerifyUser('series_list');
        if( isset($_CFG['UseIntroSeries']) && $_CFG['UseIntroSeries'] == 'Yes' ) 
        {
            $this->IntroSeriesList();
            exit();
        }
        $err = '';
        $ar = [];
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'seriesForBOX');
            exit();
        }
        $this->SetLimitForBadBox('bad_stb_tot_series');
        $qry = '';
        if( $this->catid == 'all' ) 
        {
            $qry = '';
        }
        else if( intval($this->catid) > 0 ) 
        {
            $catID = intval($this->catid);
            $qry = ' AND category_id=' . $catID . ' ';
        }
        else
        {
            $err = ' Error: you must pass the catid like: "catid":"xx" or "catid":"all" ';
        }
        $sql_ch = $this->query('SELECT * FROM `series` ' . (' WHERE TRUE ' . $qry . ' ORDER BY category_id ASC,id DESC ' . $this->limit_qry . ';'));
        $genre = '';
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            extract($row);
            $ar[] = [
                'id' => $id, 
                'title' => $title, 
                'icon' => $cover, 
                'catid' => $category_id, 
                'icon_big' => $cover_big, 
                'genre' => $genre, 
                'plot' => $plot, 
                'cast' => $cast, 
                'rating' => $rating, 
                'director' => $director, 
                'releaseDate' => $releaseDate
            ];
        }
        if( mysqli_num_rows($sql_ch) == 0 ) 
        {
            $ar[] = [
                'id' => 0, 
                'title' => ($err != '' ? $err : 'No Series'), 
                'icon' => '', 
                'catid' => '', 
                'icon_big' => '', 
                'genre' => '', 
                'plot' => '', 
                'cast' => '', 
                'rating' => '', 
                'director' => '', 
                'releaseDate' => ''
            ];
        }
        $this->msg($ar);
    }
    public function series_info()
    {
        $this->series_episodes();
    }
    public function series_episodes()
    {
        global $_CFG;
        $this->boolVerifyUser('series_episodes');
        if( isset($_CFG['UseIntroSeries']) && $_CFG['UseIntroSeries'] == 'Yes' ) 
        {
            $this->IntroSeriesGetDetails();
            exit();
        }
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'series_details');
            exit();
        }
        $err = '';
        $ar = [];
        $qry = '';
        $series_id = intval($this->series_id);
        if( $series_id == 0 ) 
        {
            $err = ' Error: you must pass the series_id=xx';
        }
        $sql_ch = $this->query('SELECT s.id, s.stream_display_name,s.stream_source,s.redirect_stream  ,s.stream_icon,s.movie_propeties,s.target_container,ep.season_num FROM `streams` s ,`series_episodes` ep WHERE s.id=ep.stream_id /*AND s.`type`=5*/ ' . (' AND  ep.series_id=' . $series_id . ' ORDER BY season_num ASC, ep.`sort` ASC;'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            $i++;
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if( $row['redirect_stream'] == 1 ) 
            {
                $stream = json_decode($row['stream_source'], true);
                if( is_array($stream) ) 
                {
                    $stream = $stream[0];
                }
            }
            else
            {
                $stream = str_replace([
                    '{type}', 
                    '{user}', 
                    '{pass}', 
                    '{ch}', 
                    '.{container}'
                ], [
                    'series', 
                    $this->user, 
                    $this->pass, 
                    $row['id'], 
                    $target_container
                ], trim($this->conf['iptv_host_vod']));
            }
            if( isset($_CFG['strm_url_rep']) && isset($_CFG['strm_url_with']) ) 
            {
                $stream = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $stream);
            }
            $ar[] = [
                'season_num' => $row['season_num'], 
                'episode_num' => $i, 
                'episode_name' => $row['stream_display_name'], 
                'stream_url' => $stream, 
                'stream_icon' => $row['stream_icon']
            ];
        }
        if( mysqli_num_rows($sql_ch) == 0 ) 
        {
            $ar[] = [
                'season_num' => 0, 
                'episode_num' => 0, 
                'episode_name' => ($err != '' ? $err : 'No Episodes'), 
                'stream_url' => '', 
                'stream_icon' => $row['stream_icon']
            ];
        }
        $this->msg($ar);
    }
    public function getList()
    {
        $this->boolVerifyUser('getList');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'getList');
            exit();
        }
    }
    public function myQuran($for = 'Quran')
    {
        $this->boolVerifyUser($for);
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, $for);
            exit();
        }
    }
    public function myRadio()
    {
        $this->myQuran('Radio');
    }
    public function myKids()
    {
        $this->myQuran('Kids');
    }
    public function myMusic()
    {
        $this->myQuran('Music');
    }
    public function myClip()
    {
        $this->myQuran('Clip');
    }
    public function restore()
    {
        if( strtolower($this->sn) == 'null' || strtolower($this->mac) == 'null' || strtolower($this->mac) == '02:00:00:00:00:00' || strtolower($this->mac) == 'nu:ll:00:00:00:00' || strlen($this->mac) < 10 || strlen($this->sn) < 10 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2001: We can\'t restore your code. Your Device is not Readable. Please contact Reseller.', 
                'code' => ''
            ]);
            exit();
        }
        $qry = 'SELECT code FROM solus_codes WHERE serial=\'' . $this->sn . '\' AND mac=\'' . $this->mac . '\';';
        $result = $this->query($qry);
        $found = intval(mysqli_num_rows($result));
        if( $found == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $code = trim($row['code']);
            $this->msg([
                'status' => 100, 
                'message' => 'success', 
                'code' => $code
            ]);
        }
        else if( $found == 0 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2002: Your device is not found!', 
                'code' => ''
            ]);
        }
        else if( $found > 1 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2003: we found many devices like yours!', 
                'code' => ''
            ]);
        }
    }
    public function __destruct()
    {
        global $time_start;
        if( is_resource($this->link) ) 
        {
            mysqli_close($this->link);
        }
    }
    public function IntroSeriesCat()
    {
        $qry = $parent = '';
        $ar = [];
        $sql = 'SELECT * from ' . PREFIX . '_series_cat where true order by w asc ';
        $sql = $this->query($sql);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $catimage != '' ) 
            {
                $catimage = (string)$catimage;
            }
            else
            {
                $catimage = 'http://intro.ps/uploads/logo/movie.png';
            }
            $ar[] = [
                'cat_id' => $catid, 
                'cat_name' => $catname, 
                'cat_icon' => $catimage, 
                'cat_view_order' => $w
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesList()
    {
        $qry = '';
        if( $this->catid == 'all' ) 
        {
            $qry = '';
        }
        else
        {
            $qry = ' WHERE `catid`=' . intval($this->catid);
        }
        $ar = [];
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series ' . $qry . ' order by catid asc, sid desc'));
        $genre = '';
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $s_photo != '' ) 
            {
                $s_photo = (string)$s_photo;
            }
            else
            {
                $s_photo = 'http://intro.ps/uploads/logo/movie.png';
            }
            $JSON = json_decode($s_jsondata, true);
            $plot = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
            $cast = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
            $rating = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
            $date = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
            $ar[] = [
                'id' => $sid, 
                'title' => $s_title, 
                'icon' => $s_photo, 
                'icon_big' => $s_photo, 
                'catid' => $catid, 
                'genre' => $genre, 
                'plot' => $plot, 
                'cast' => $cast, 
                'rating' => $rating, 
                'director' => 'n/a', 
                'releaseDate' => $date
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesGetDetails()
    {
        $qry = $parent = '';
        $sid = intval($this->series_id);
        $this->query('update ' . PREFIX . ('_series set hits=hits+1 where sid=' . $sid . ';'));
        $sqlSeries = $this->query('SELECT *   FROM ' . PREFIX . ('_series se where sid=' . $sid . ';'));
        $row = mysqli_fetch_array($sqlSeries);
        extract($row);
        $JSON = json_decode($s_jsondata, true);
        if( $s_photo != '' ) 
        {
            $s_photo = (string)$s_photo;
        }
        else
        {
            $s_photo = 'http://intro.ps/uploads/logo/movie.png';
        }
        $ar = [];
        $ar['id'] = $sid;
        $ar['title'] = $s_title;
        $ar['trailer'] = $trailer;
        $ar['user_rating'] = 0;
        $ar['likes'] = $likes;
        $ar['dislikes'] = $dislikes;
        $ar['icon'] = $s_photo;
        $ar['plot'] = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
        $ar['cast'] = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
        $ar['rate'] = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
        $ar['date'] = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series_seasons where seriesid=' . $sid . ' order by s_num asc;'));
        $i = 0;
        $arSeasons = [];
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
        }
        else
        {
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                extract($row);
                $arSeasons[] = [
                    'id' => $seasonid, 
                    'title' => $season_name, 
                    'episodes' => $this->IntroSeriesGetEpisodes(intval($row['seasonid']))
                ];
            }
        }
        $ar['seasons'] = $arSeasons;
        $this->msg($ar);
    }
    public function IntroSeriesGetEpisodes($seasonid)
    {
        $seasonid = intval($seasonid);
        $ar = [];
        $qry = ' SELECT * from ' . PREFIX . ('_seriesepisodes where seasonid=' . $seasonid . '  order by epnum ASC;');
        $sql = $this->query($qry);
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar = [];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            return $ar;
        }
    }
}
$class = new APIv6();
$mode = get_post('mode');
if( $mode != '' && method_exists($class, $mode) ) 
{
    $class->$mode();
}
else
{
    $class->_die('Error: mode (' . $mode . ') not defined.');
    exit();
}
function get_post($index = '')
{
    if( !isset($_POST[$index]) ) 
    {
        return $_GET[$index];
    }
    else
    {
        return $_POST[$index];
    }
}